// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/metastore/v1alpha/metastore.proto

package metastore

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the metastore service.
type Service_State int32

const (
	// The state of the metastore service is unknown.
	Service_STATE_UNSPECIFIED Service_State = 0
	// The metastore service is in the process of being created.
	Service_CREATING Service_State = 1
	// The metastore service is running and ready to serve queries.
	Service_ACTIVE Service_State = 2
	// The metastore service is entering suspension. Its query-serving
	// availability may cease unexpectedly.
	Service_SUSPENDING Service_State = 3
	// The metastore service is suspended and unable to serve queries.
	Service_SUSPENDED Service_State = 4
	// The metastore service is being updated. It remains usable but cannot
	// accept additional update requests or be deleted at this time.
	Service_UPDATING Service_State = 5
	// The metastore service is undergoing deletion. It cannot be used.
	Service_DELETING Service_State = 6
	// The metastore service has encountered an error and cannot be used. The
	// metastore service should be deleted.
	Service_ERROR Service_State = 7
)

// Enum value maps for Service_State.
var (
	Service_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "SUSPENDING",
		4: "SUSPENDED",
		5: "UPDATING",
		6: "DELETING",
		7: "ERROR",
	}
	Service_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"SUSPENDING":        3,
		"SUSPENDED":         4,
		"UPDATING":          5,
		"DELETING":          6,
		"ERROR":             7,
	}
)

func (x Service_State) Enum() *Service_State {
	p := new(Service_State)
	*p = x
	return p
}

func (x Service_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[0].Descriptor()
}

func (Service_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[0]
}

func (x Service_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_State.Descriptor instead.
func (Service_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{0, 0}
}

// Available service tiers.
type Service_Tier int32

const (
	// The tier is not set.
	Service_TIER_UNSPECIFIED Service_Tier = 0
	// The developer tier provides limited scalability and no fault tolerance.
	// Good for low-cost proof-of-concept.
	Service_DEVELOPER Service_Tier = 1
	// The enterprise tier provides multi-zone high availability, and sufficient
	// scalability for enterprise-level Dataproc Metastore workloads.
	Service_ENTERPRISE Service_Tier = 3
)

// Enum value maps for Service_Tier.
var (
	Service_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "DEVELOPER",
		3: "ENTERPRISE",
	}
	Service_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"DEVELOPER":        1,
		"ENTERPRISE":       3,
	}
)

func (x Service_Tier) Enum() *Service_Tier {
	p := new(Service_Tier)
	*p = x
	return p
}

func (x Service_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[1].Descriptor()
}

func (Service_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[1]
}

func (x Service_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Tier.Descriptor instead.
func (Service_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{0, 1}
}

// Release channels bundle features of varying levels of stability. Newer
// features may be introduced initially into less stable release channels and
// can be automatically promoted into more stable release channels.
type Service_ReleaseChannel int32

const (
	// Release channel is not specified.
	Service_RELEASE_CHANNEL_UNSPECIFIED Service_ReleaseChannel = 0
	// The `CANARY` release channel contains the newest features, which may be
	// unstable and subject to unresolved issues with no known workarounds.
	// Services using the `CANARY` release channel are not subject to any SLAs.
	Service_CANARY Service_ReleaseChannel = 1
	// The `STABLE` release channel contains features that are considered stable
	// and have been validated for production use.
	Service_STABLE Service_ReleaseChannel = 2
)

// Enum value maps for Service_ReleaseChannel.
var (
	Service_ReleaseChannel_name = map[int32]string{
		0: "RELEASE_CHANNEL_UNSPECIFIED",
		1: "CANARY",
		2: "STABLE",
	}
	Service_ReleaseChannel_value = map[string]int32{
		"RELEASE_CHANNEL_UNSPECIFIED": 0,
		"CANARY":                      1,
		"STABLE":                      2,
	}
)

func (x Service_ReleaseChannel) Enum() *Service_ReleaseChannel {
	p := new(Service_ReleaseChannel)
	*p = x
	return p
}

func (x Service_ReleaseChannel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_ReleaseChannel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[2].Descriptor()
}

func (Service_ReleaseChannel) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[2]
}

func (x Service_ReleaseChannel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_ReleaseChannel.Descriptor instead.
func (Service_ReleaseChannel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{0, 2}
}

// The current state of the metadata import.
type MetadataImport_State int32

const (
	// The state of the metadata import is unknown.
	MetadataImport_STATE_UNSPECIFIED MetadataImport_State = 0
	// The metadata import is running.
	MetadataImport_RUNNING MetadataImport_State = 1
	// The metadata import completed successfully.
	MetadataImport_SUCCEEDED MetadataImport_State = 2
	// The metadata import is being updated.
	MetadataImport_UPDATING MetadataImport_State = 3
	// The metadata import failed, and attempted metadata changes were rolled
	// back.
	MetadataImport_FAILED MetadataImport_State = 4
)

// Enum value maps for MetadataImport_State.
var (
	MetadataImport_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "UPDATING",
		4: "FAILED",
	}
	MetadataImport_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"UPDATING":          3,
		"FAILED":            4,
	}
)

func (x MetadataImport_State) Enum() *MetadataImport_State {
	p := new(MetadataImport_State)
	*p = x
	return p
}

func (x MetadataImport_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataImport_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[3].Descriptor()
}

func (MetadataImport_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[3]
}

func (x MetadataImport_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataImport_State.Descriptor instead.
func (MetadataImport_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{8, 0}
}

// The type of the database.
type MetadataImport_DatabaseDump_DatabaseType int32

const (
	// The type of the source database is unknown.
	MetadataImport_DatabaseDump_DATABASE_TYPE_UNSPECIFIED MetadataImport_DatabaseDump_DatabaseType = 0
	// The type of the source database is MySQL.
	MetadataImport_DatabaseDump_MYSQL MetadataImport_DatabaseDump_DatabaseType = 1
)

// Enum value maps for MetadataImport_DatabaseDump_DatabaseType.
var (
	MetadataImport_DatabaseDump_DatabaseType_name = map[int32]string{
		0: "DATABASE_TYPE_UNSPECIFIED",
		1: "MYSQL",
	}
	MetadataImport_DatabaseDump_DatabaseType_value = map[string]int32{
		"DATABASE_TYPE_UNSPECIFIED": 0,
		"MYSQL":                     1,
	}
)

func (x MetadataImport_DatabaseDump_DatabaseType) Enum() *MetadataImport_DatabaseDump_DatabaseType {
	p := new(MetadataImport_DatabaseDump_DatabaseType)
	*p = x
	return p
}

func (x MetadataImport_DatabaseDump_DatabaseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataImport_DatabaseDump_DatabaseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[4].Descriptor()
}

func (MetadataImport_DatabaseDump_DatabaseType) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[4]
}

func (x MetadataImport_DatabaseDump_DatabaseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataImport_DatabaseDump_DatabaseType.Descriptor instead.
func (MetadataImport_DatabaseDump_DatabaseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{8, 0, 0}
}

// The current state of the metadata export.
type MetadataExport_State int32

const (
	// The state of the metadata export is unknown.
	MetadataExport_STATE_UNSPECIFIED MetadataExport_State = 0
	// The metadata export is running.
	MetadataExport_RUNNING MetadataExport_State = 1
	// The metadata export completed successfully.
	MetadataExport_SUCCEEDED MetadataExport_State = 2
	// The metadata export failed.
	MetadataExport_FAILED MetadataExport_State = 3
	// The metadata export is cancelled.
	MetadataExport_CANCELLED MetadataExport_State = 4
)

// Enum value maps for MetadataExport_State.
var (
	MetadataExport_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLED",
	}
	MetadataExport_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLED":         4,
	}
)

func (x MetadataExport_State) Enum() *MetadataExport_State {
	p := new(MetadataExport_State)
	*p = x
	return p
}

func (x MetadataExport_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataExport_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[5].Descriptor()
}

func (MetadataExport_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[5]
}

func (x MetadataExport_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataExport_State.Descriptor instead.
func (MetadataExport_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{9, 0}
}

// The current state of the backup.
type Backup_State int32

const (
	// The state of the backup is unknown.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The backup is being created.
	Backup_CREATING Backup_State = 1
	// The backup is being deleted.
	Backup_DELETING Backup_State = 2
	// The backup is active and ready to use.
	Backup_ACTIVE Backup_State = 3
	// The backup failed.
	Backup_FAILED Backup_State = 4
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "DELETING",
		3: "ACTIVE",
		4: "FAILED",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"DELETING":          2,
		"ACTIVE":            3,
		"FAILED":            4,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[6].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[6]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{10, 0}
}

// The current state of the restore.
type Restore_State int32

const (
	// The state of the metadata restore is unknown.
	Restore_STATE_UNSPECIFIED Restore_State = 0
	// The metadata restore is running.
	Restore_RUNNING Restore_State = 1
	// The metadata restore completed successfully.
	Restore_SUCCEEDED Restore_State = 2
	// The metadata restore failed.
	Restore_FAILED Restore_State = 3
	// The metadata restore is cancelled.
	Restore_CANCELLED Restore_State = 4
)

// Enum value maps for Restore_State.
var (
	Restore_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLED",
	}
	Restore_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLED":         4,
	}
)

func (x Restore_State) Enum() *Restore_State {
	p := new(Restore_State)
	*p = x
	return p
}

func (x Restore_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Restore_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[7].Descriptor()
}

func (Restore_State) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[7]
}

func (x Restore_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Restore_State.Descriptor instead.
func (Restore_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{11, 0}
}

// The type of restore.
type Restore_RestoreType int32

const (
	// The restore type is unknown.
	Restore_RESTORE_TYPE_UNSPECIFIED Restore_RestoreType = 0
	// The service's metadata and configuration are restored.
	Restore_FULL Restore_RestoreType = 1
	// Only the service's metadata is restored.
	Restore_METADATA_ONLY Restore_RestoreType = 2
)

// Enum value maps for Restore_RestoreType.
var (
	Restore_RestoreType_name = map[int32]string{
		0: "RESTORE_TYPE_UNSPECIFIED",
		1: "FULL",
		2: "METADATA_ONLY",
	}
	Restore_RestoreType_value = map[string]int32{
		"RESTORE_TYPE_UNSPECIFIED": 0,
		"FULL":                     1,
		"METADATA_ONLY":            2,
	}
)

func (x Restore_RestoreType) Enum() *Restore_RestoreType {
	p := new(Restore_RestoreType)
	*p = x
	return p
}

func (x Restore_RestoreType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Restore_RestoreType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[8].Descriptor()
}

func (Restore_RestoreType) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[8]
}

func (x Restore_RestoreType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Restore_RestoreType.Descriptor instead.
func (Restore_RestoreType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{11, 1}
}

// The type of the database dump.
type DatabaseDumpSpec_Type int32

const (
	// The type of the database dump is unknown.
	DatabaseDumpSpec_TYPE_UNSPECIFIED DatabaseDumpSpec_Type = 0
	// Database dump is a MySQL dump file.
	DatabaseDumpSpec_MYSQL DatabaseDumpSpec_Type = 1
)

// Enum value maps for DatabaseDumpSpec_Type.
var (
	DatabaseDumpSpec_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MYSQL",
	}
	DatabaseDumpSpec_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MYSQL":            1,
	}
)

func (x DatabaseDumpSpec_Type) Enum() *DatabaseDumpSpec_Type {
	p := new(DatabaseDumpSpec_Type)
	*p = x
	return p
}

func (x DatabaseDumpSpec_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseDumpSpec_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[9].Descriptor()
}

func (DatabaseDumpSpec_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes[9]
}

func (x DatabaseDumpSpec_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseDumpSpec_Type.Descriptor instead.
func (DatabaseDumpSpec_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{32, 0}
}

// A managed metastore service that serves metadata queries.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration properties specific to the underlying metastore service
	// technology (the software that serves metastore queries).
	//
	// Types that are assignable to MetastoreConfig:
	//	*Service_HiveMetastoreConfig
	MetastoreConfig isService_MetastoreConfig `protobuf_oneof:"metastore_config"`
	// Immutable. The relative resource name of the metastore service, of the form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the metastore service was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the metastore service was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined labels for the metastore service.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Immutable. The relative resource name of the VPC network on which the instance can be
	// accessed. It is specified in the following form:
	//
	// `projects/{project_number}/global/networks/{network_id}`.
	Network string `protobuf:"bytes,7,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The URI of the endpoint used to access the metastore service.
	EndpointUri string `protobuf:"bytes,8,opt,name=endpoint_uri,json=endpointUri,proto3" json:"endpoint_uri,omitempty"`
	// The TCP port at which the metastore service is reached. Default: 9083.
	Port int32 `protobuf:"varint,9,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current state of the metastore service.
	State Service_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.Service_State" json:"state,omitempty"`
	// Output only. Additional information about the current state of the metastore service, if
	// available.
	StateMessage string `protobuf:"bytes,11,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. A Cloud Storage URI (starting with `gs://`) that specifies where artifacts
	// related to the metastore service are stored.
	ArtifactGcsUri string `protobuf:"bytes,12,opt,name=artifact_gcs_uri,json=artifactGcsUri,proto3" json:"artifact_gcs_uri,omitempty"`
	// The tier of the service.
	Tier Service_Tier `protobuf:"varint,13,opt,name=tier,proto3,enum=google.cloud.metastore.v1alpha.Service_Tier" json:"tier,omitempty"`
	// The setting that defines how metastore metadata should be integrated with
	// external services and systems.
	MetadataIntegration *MetadataIntegration `protobuf:"bytes,14,opt,name=metadata_integration,json=metadataIntegration,proto3" json:"metadata_integration,omitempty"`
	// The one hour maintenance window of the metastore service. This specifies
	// when the service can be restarted for maintenance purposes in UTC time.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,15,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Output only. The globally unique resource identifier of the metastore service.
	Uid string `protobuf:"bytes,16,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The metadata management activities of the metastore service.
	MetadataManagementActivity *MetadataManagementActivity `protobuf:"bytes,17,opt,name=metadata_management_activity,json=metadataManagementActivity,proto3" json:"metadata_management_activity,omitempty"`
	// Immutable. The release channel of the service.
	// If unspecified, defaults to `STABLE`.
	ReleaseChannel Service_ReleaseChannel `protobuf:"varint,19,opt,name=release_channel,json=releaseChannel,proto3,enum=google.cloud.metastore.v1alpha.Service_ReleaseChannel" json:"release_channel,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{0}
}

func (m *Service) GetMetastoreConfig() isService_MetastoreConfig {
	if m != nil {
		return m.MetastoreConfig
	}
	return nil
}

func (x *Service) GetHiveMetastoreConfig() *HiveMetastoreConfig {
	if x, ok := x.GetMetastoreConfig().(*Service_HiveMetastoreConfig); ok {
		return x.HiveMetastoreConfig
	}
	return nil
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Service) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Service) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Service) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Service) GetEndpointUri() string {
	if x != nil {
		return x.EndpointUri
	}
	return ""
}

func (x *Service) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *Service) GetState() Service_State {
	if x != nil {
		return x.State
	}
	return Service_STATE_UNSPECIFIED
}

func (x *Service) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *Service) GetArtifactGcsUri() string {
	if x != nil {
		return x.ArtifactGcsUri
	}
	return ""
}

func (x *Service) GetTier() Service_Tier {
	if x != nil {
		return x.Tier
	}
	return Service_TIER_UNSPECIFIED
}

func (x *Service) GetMetadataIntegration() *MetadataIntegration {
	if x != nil {
		return x.MetadataIntegration
	}
	return nil
}

func (x *Service) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Service) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Service) GetMetadataManagementActivity() *MetadataManagementActivity {
	if x != nil {
		return x.MetadataManagementActivity
	}
	return nil
}

func (x *Service) GetReleaseChannel() Service_ReleaseChannel {
	if x != nil {
		return x.ReleaseChannel
	}
	return Service_RELEASE_CHANNEL_UNSPECIFIED
}

type isService_MetastoreConfig interface {
	isService_MetastoreConfig()
}

type Service_HiveMetastoreConfig struct {
	// Configuration information specific to running Hive metastore
	// software as the metastore service.
	HiveMetastoreConfig *HiveMetastoreConfig `protobuf:"bytes,5,opt,name=hive_metastore_config,json=hiveMetastoreConfig,proto3,oneof"`
}

func (*Service_HiveMetastoreConfig) isService_MetastoreConfig() {}

// Specifies how metastore metadata should be integrated with external services.
type MetadataIntegration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The integration config for the Data Catalog service.
	DataCatalogConfig *DataCatalogConfig `protobuf:"bytes,1,opt,name=data_catalog_config,json=dataCatalogConfig,proto3" json:"data_catalog_config,omitempty"`
}

func (x *MetadataIntegration) Reset() {
	*x = MetadataIntegration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataIntegration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataIntegration) ProtoMessage() {}

func (x *MetadataIntegration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataIntegration.ProtoReflect.Descriptor instead.
func (*MetadataIntegration) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{1}
}

func (x *MetadataIntegration) GetDataCatalogConfig() *DataCatalogConfig {
	if x != nil {
		return x.DataCatalogConfig
	}
	return nil
}

// Specifies how metastore metadata should be integrated with the Data Catalog
// service.
type DataCatalogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the metastore metadata should be synced to Data Catalog.
	// The default value is to disable syncing metastore metadata to Data Catalog.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *DataCatalogConfig) Reset() {
	*x = DataCatalogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataCatalogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataCatalogConfig) ProtoMessage() {}

func (x *DataCatalogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataCatalogConfig.ProtoReflect.Descriptor instead.
func (*DataCatalogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{2}
}

func (x *DataCatalogConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Maintenance window. This specifies when Dataproc Metastore
// may perform system maintenance operation to the service.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hour of day (0-23) when the window starts.
	HourOfDay *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=hour_of_day,json=hourOfDay,proto3" json:"hour_of_day,omitempty"`
	// The day of week, when the window starts.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{3}
}

func (x *MaintenanceWindow) GetHourOfDay() *wrapperspb.Int32Value {
	if x != nil {
		return x.HourOfDay
	}
	return nil
}

func (x *MaintenanceWindow) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// Specifies configuration information specific to running Hive metastore
// software as the metastore service.
type HiveMetastoreConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The Hive metastore schema version.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// A mapping of Hive metastore configuration key-value pairs to apply to the
	// Hive metastore (configured in `hive-site.xml`). The mappings
	// override system defaults (some keys cannot be overridden).
	ConfigOverrides map[string]string `protobuf:"bytes,2,rep,name=config_overrides,json=configOverrides,proto3" json:"config_overrides,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Information used to configure the Hive metastore service as a service
	// principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
	// method and specify this field's path
	// (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
	// while omitting this field from the request's `service`.
	KerberosConfig *KerberosConfig `protobuf:"bytes,3,opt,name=kerberos_config,json=kerberosConfig,proto3" json:"kerberos_config,omitempty"`
}

func (x *HiveMetastoreConfig) Reset() {
	*x = HiveMetastoreConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HiveMetastoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HiveMetastoreConfig) ProtoMessage() {}

func (x *HiveMetastoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HiveMetastoreConfig.ProtoReflect.Descriptor instead.
func (*HiveMetastoreConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{4}
}

func (x *HiveMetastoreConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *HiveMetastoreConfig) GetConfigOverrides() map[string]string {
	if x != nil {
		return x.ConfigOverrides
	}
	return nil
}

func (x *HiveMetastoreConfig) GetKerberosConfig() *KerberosConfig {
	if x != nil {
		return x.KerberosConfig
	}
	return nil
}

// Configuration information for a Kerberos principal.
type KerberosConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Kerberos keytab file that can be used to authenticate a service principal
	// with a Kerberos Key Distribution Center (KDC).
	Keytab *Secret `protobuf:"bytes,1,opt,name=keytab,proto3" json:"keytab,omitempty"`
	// A Kerberos principal that exists in the both the keytab the KDC
	// to authenticate as. A typical principal is of the form
	// `primary/instance@REALM`, but there is no exact format.
	Principal string `protobuf:"bytes,2,opt,name=principal,proto3" json:"principal,omitempty"`
	// A Cloud Storage URI that specifies the path to a
	// krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf,
	// although the file does not need to be named krb5.conf explicitly.
	Krb5ConfigGcsUri string `protobuf:"bytes,3,opt,name=krb5_config_gcs_uri,json=krb5ConfigGcsUri,proto3" json:"krb5_config_gcs_uri,omitempty"`
}

func (x *KerberosConfig) Reset() {
	*x = KerberosConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KerberosConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KerberosConfig) ProtoMessage() {}

func (x *KerberosConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KerberosConfig.ProtoReflect.Descriptor instead.
func (*KerberosConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{5}
}

func (x *KerberosConfig) GetKeytab() *Secret {
	if x != nil {
		return x.Keytab
	}
	return nil
}

func (x *KerberosConfig) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *KerberosConfig) GetKrb5ConfigGcsUri() string {
	if x != nil {
		return x.Krb5ConfigGcsUri
	}
	return ""
}

// A securely stored value.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//	*Secret_CloudSecret
	Value isSecret_Value `protobuf_oneof:"value"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{6}
}

func (m *Secret) GetValue() isSecret_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Secret) GetCloudSecret() string {
	if x, ok := x.GetValue().(*Secret_CloudSecret); ok {
		return x.CloudSecret
	}
	return ""
}

type isSecret_Value interface {
	isSecret_Value()
}

type Secret_CloudSecret struct {
	// The relative resource name of a Secret Manager secret version, in the
	// following form:
	//
	// `projects/{project_number}/secrets/{secret_id}/versions/{version_id}`.
	CloudSecret string `protobuf:"bytes,2,opt,name=cloud_secret,json=cloudSecret,proto3,oneof"`
}

func (*Secret_CloudSecret) isSecret_Value() {}

// The metadata management activities of the metastore service.
type MetadataManagementActivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The latest metadata exports of the metastore service.
	MetadataExports []*MetadataExport `protobuf:"bytes,1,rep,name=metadata_exports,json=metadataExports,proto3" json:"metadata_exports,omitempty"`
	// Output only. The latest restores of the metastore service.
	Restores []*Restore `protobuf:"bytes,2,rep,name=restores,proto3" json:"restores,omitempty"`
}

func (x *MetadataManagementActivity) Reset() {
	*x = MetadataManagementActivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataManagementActivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataManagementActivity) ProtoMessage() {}

func (x *MetadataManagementActivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataManagementActivity.ProtoReflect.Descriptor instead.
func (*MetadataManagementActivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{7}
}

func (x *MetadataManagementActivity) GetMetadataExports() []*MetadataExport {
	if x != nil {
		return x.MetadataExports
	}
	return nil
}

func (x *MetadataManagementActivity) GetRestores() []*Restore {
	if x != nil {
		return x.Restores
	}
	return nil
}

// A metastore resource that imports metadata.
type MetadataImport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata to be imported.
	//
	// Types that are assignable to Metadata:
	//	*MetadataImport_DatabaseDump_
	Metadata isMetadataImport_Metadata `protobuf_oneof:"metadata"`
	// Immutable. The relative resource name of the metadata import, of the form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the metadata import.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time when the metadata import was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the metadata import was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of the metadata import.
	State MetadataImport_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.MetadataImport_State" json:"state,omitempty"`
}

func (x *MetadataImport) Reset() {
	*x = MetadataImport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataImport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataImport) ProtoMessage() {}

func (x *MetadataImport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataImport.ProtoReflect.Descriptor instead.
func (*MetadataImport) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{8}
}

func (m *MetadataImport) GetMetadata() isMetadataImport_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *MetadataImport) GetDatabaseDump() *MetadataImport_DatabaseDump {
	if x, ok := x.GetMetadata().(*MetadataImport_DatabaseDump_); ok {
		return x.DatabaseDump
	}
	return nil
}

func (x *MetadataImport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetadataImport) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MetadataImport) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MetadataImport) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MetadataImport) GetState() MetadataImport_State {
	if x != nil {
		return x.State
	}
	return MetadataImport_STATE_UNSPECIFIED
}

type isMetadataImport_Metadata interface {
	isMetadataImport_Metadata()
}

type MetadataImport_DatabaseDump_ struct {
	// Immutable. A database dump from a pre-existing metastore's database.
	DatabaseDump *MetadataImport_DatabaseDump `protobuf:"bytes,6,opt,name=database_dump,json=databaseDump,proto3,oneof"`
}

func (*MetadataImport_DatabaseDump_) isMetadataImport_Metadata() {}

// The details of a metadata export operation.
type MetadataExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//	*MetadataExport_DestinationGcsUri
	Destination isMetadataExport_Destination `protobuf_oneof:"destination"`
	// Output only. The time when the export started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the export ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The current state of the export.
	State MetadataExport_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.MetadataExport_State" json:"state,omitempty"`
	// Output only. The type of the database dump.
	DatabaseDumpType DatabaseDumpSpec_Type `protobuf:"varint,5,opt,name=database_dump_type,json=databaseDumpType,proto3,enum=google.cloud.metastore.v1alpha.DatabaseDumpSpec_Type" json:"database_dump_type,omitempty"`
}

func (x *MetadataExport) Reset() {
	*x = MetadataExport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataExport) ProtoMessage() {}

func (x *MetadataExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataExport.ProtoReflect.Descriptor instead.
func (*MetadataExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{9}
}

func (m *MetadataExport) GetDestination() isMetadataExport_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *MetadataExport) GetDestinationGcsUri() string {
	if x, ok := x.GetDestination().(*MetadataExport_DestinationGcsUri); ok {
		return x.DestinationGcsUri
	}
	return ""
}

func (x *MetadataExport) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *MetadataExport) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *MetadataExport) GetState() MetadataExport_State {
	if x != nil {
		return x.State
	}
	return MetadataExport_STATE_UNSPECIFIED
}

func (x *MetadataExport) GetDatabaseDumpType() DatabaseDumpSpec_Type {
	if x != nil {
		return x.DatabaseDumpType
	}
	return DatabaseDumpSpec_TYPE_UNSPECIFIED
}

type isMetadataExport_Destination interface {
	isMetadataExport_Destination()
}

type MetadataExport_DestinationGcsUri struct {
	// Output only. A Cloud Storage URI of a folder that metadata are exported to, in the
	// form of `gs://<bucket_name>/<path_inside_bucket>/<export_folder>`, where
	// `<export_folder>` is automatically generated.
	DestinationGcsUri string `protobuf:"bytes,4,opt,name=destination_gcs_uri,json=destinationGcsUri,proto3,oneof"`
}

func (*MetadataExport_DestinationGcsUri) isMetadataExport_Destination() {}

// The details of a backup resource.
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The relative resource name of the backup, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the backup was started.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the backup finished creating.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The current state of the backup.
	State Backup_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.Backup_State" json:"state,omitempty"`
	// Output only. The revision of the service at the time of backup.
	ServiceRevision *Service `protobuf:"bytes,5,opt,name=service_revision,json=serviceRevision,proto3" json:"service_revision,omitempty"`
	// The description of the backup.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{10}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetServiceRevision() *Service {
	if x != nil {
		return x.ServiceRevision
	}
	return nil
}

func (x *Backup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The details of a metadata restore operation.
type Restore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time when the restore started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the restore ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The current state of the restore.
	State Restore_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.metastore.v1alpha.Restore_State" json:"state,omitempty"`
	// Output only. The relative resource name of the metastore service backup to restore
	// from, in the following form:
	//
	// `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`
	Backup string `protobuf:"bytes,4,opt,name=backup,proto3" json:"backup,omitempty"`
	// Output only. The type of restore.
	Type Restore_RestoreType `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.metastore.v1alpha.Restore_RestoreType" json:"type,omitempty"`
	// Output only. The restore details containing the revision of the service to be restored
	// to, in format of JSON.
	Details string `protobuf:"bytes,6,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *Restore) Reset() {
	*x = Restore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Restore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Restore) ProtoMessage() {}

func (x *Restore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Restore.ProtoReflect.Descriptor instead.
func (*Restore) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{11}
}

func (x *Restore) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Restore) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Restore) GetState() Restore_State {
	if x != nil {
		return x.State
	}
	return Restore_STATE_UNSPECIFIED
}

func (x *Restore) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *Restore) GetType() Restore_RestoreType {
	if x != nil {
		return x.Type
	}
	return Restore_RESTORE_TYPE_UNSPECIFIED
}

func (x *Restore) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// Request message for [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices].
type ListServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the location of metastore services to
	// list, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of services to return. The response may contain less
	// than the maximum number. If unspecified, no more than 500 services are
	// returned. The maximum value is 1000; values above 1000 are changed to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices]
	// call. Provide this token to retrieve the subsequent page.
	//
	// To retrieve the first page, supply an empty page token.
	//
	// When paginating, other parameters provided to
	// [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices] must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify the ordering of results as described in [Sorting
	// Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	// If not specified, the results will be sorted in the default order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListServicesRequest) Reset() {
	*x = ListServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesRequest) ProtoMessage() {}

func (x *ListServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesRequest.ProtoReflect.Descriptor instead.
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{12}
}

func (x *ListServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServicesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListServicesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices].
type ListServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The services in the specified location.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListServicesResponse) Reset() {
	*x = ListServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesResponse) ProtoMessage() {}

func (x *ListServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesResponse.ProtoReflect.Descriptor instead.
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{13}
}

func (x *ListServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *ListServicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListServicesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [DataprocMetastore.GetService][google.cloud.metastore.v1alpha.DataprocMetastore.GetService].
type GetServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metastore service to retrieve, in the
	// following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceRequest) Reset() {
	*x = GetServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceRequest) ProtoMessage() {}

func (x *GetServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceRequest.ProtoReflect.Descriptor instead.
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{14}
}

func (x *GetServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [DataprocMetastore.CreateService][google.cloud.metastore.v1alpha.DataprocMetastore.CreateService].
type CreateServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the location in which to create a metastore
	// service, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the metastore service, which is used as the final
	// component of the metastore service's name.
	//
	// This value must be between 2 and 63 characters long inclusive, begin with a
	// letter, end with a letter or number, and consist of alpha-numeric
	// ASCII characters or hyphens.
	ServiceId string `protobuf:"bytes,2,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// Required. The Metastore service to create. The `name` field is
	// ignored. The ID of the created metastore service must be provided in
	// the request's `service_id` field.
	Service *Service `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateServiceRequest) Reset() {
	*x = CreateServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceRequest) ProtoMessage() {}

func (x *CreateServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{15}
}

func (x *CreateServiceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServiceRequest) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *CreateServiceRequest) GetService() *Service {
	if x != nil {
		return x.Service
	}
	return nil
}

func (x *CreateServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.UpdateService][google.cloud.metastore.v1alpha.DataprocMetastore.UpdateService].
type UpdateServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A field mask used to specify the fields to be overwritten in the
	// metastore service resource by the update.
	// Fields specified in the `update_mask` are relative to the resource (not
	// to the full request). A field is overwritten if it is in the mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The metastore service to update. The server only merges fields
	// in the service if they are specified in `update_mask`.
	//
	// The metastore service's `name` field is used to identify the metastore
	// service to be updated.
	Service *Service `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateServiceRequest) Reset() {
	*x = UpdateServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServiceRequest) ProtoMessage() {}

func (x *UpdateServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServiceRequest.ProtoReflect.Descriptor instead.
func (*UpdateServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateServiceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateServiceRequest) GetService() *Service {
	if x != nil {
		return x.Service
	}
	return nil
}

func (x *UpdateServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.DeleteService][google.cloud.metastore.v1alpha.DataprocMetastore.DeleteService].
type DeleteServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metastore service to delete, in the
	// following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteServiceRequest) Reset() {
	*x = DeleteServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceRequest) ProtoMessage() {}

func (x *DeleteServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.ListMetadataImports][google.cloud.metastore.v1alpha.DataprocMetastore.ListMetadataImports].
type ListMetadataImportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the service whose metadata imports to
	// list, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of imports to return. The response may contain less
	// than the maximum number. If unspecified, no more than 500 imports are
	// returned. The maximum value is 1000; values above 1000 are changed to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices]
	// call. Provide this token to retrieve the subsequent page.
	//
	// To retrieve the first page, supply an empty page token.
	//
	// When paginating, other parameters provided to
	// [DataprocMetastore.ListServices][google.cloud.metastore.v1alpha.DataprocMetastore.ListServices] must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify the ordering of results as described in [Sorting
	// Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	// If not specified, the results will be sorted in the default order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListMetadataImportsRequest) Reset() {
	*x = ListMetadataImportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetadataImportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataImportsRequest) ProtoMessage() {}

func (x *ListMetadataImportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataImportsRequest.ProtoReflect.Descriptor instead.
func (*ListMetadataImportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{18}
}

func (x *ListMetadataImportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetadataImportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMetadataImportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMetadataImportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMetadataImportsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [DataprocMetastore.ListMetadataImports][google.cloud.metastore.v1alpha.DataprocMetastore.ListMetadataImports].
type ListMetadataImportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The imports in the specified service.
	MetadataImports []*MetadataImport `protobuf:"bytes,1,rep,name=metadata_imports,json=metadataImports,proto3" json:"metadata_imports,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMetadataImportsResponse) Reset() {
	*x = ListMetadataImportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMetadataImportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataImportsResponse) ProtoMessage() {}

func (x *ListMetadataImportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataImportsResponse.ProtoReflect.Descriptor instead.
func (*ListMetadataImportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{19}
}

func (x *ListMetadataImportsResponse) GetMetadataImports() []*MetadataImport {
	if x != nil {
		return x.MetadataImports
	}
	return nil
}

func (x *ListMetadataImportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMetadataImportsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [DataprocMetastore.GetMetadataImport][google.cloud.metastore.v1alpha.DataprocMetastore.GetMetadataImport].
type GetMetadataImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metadata import to retrieve, in the
	// following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{import_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetadataImportRequest) Reset() {
	*x = GetMetadataImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMetadataImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadataImportRequest) ProtoMessage() {}

func (x *GetMetadataImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadataImportRequest.ProtoReflect.Descriptor instead.
func (*GetMetadataImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{20}
}

func (x *GetMetadataImportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [DataprocMetastore.CreateMetadataImport][google.cloud.metastore.v1alpha.DataprocMetastore.CreateMetadataImport].
type CreateMetadataImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the service in which to create a metastore
	// import, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the metadata import, which is used as the final component of the
	// metadata import's name.
	//
	// This value must be between 1 and 64 characters long, begin with a letter,
	// end with a letter or number, and consist of alpha-numeric ASCII characters
	// or hyphens.
	MetadataImportId string `protobuf:"bytes,2,opt,name=metadata_import_id,json=metadataImportId,proto3" json:"metadata_import_id,omitempty"`
	// Required. The metadata import to create. The `name` field is ignored. The ID of the
	// created metadata import must be provided in the request's
	// `metadata_import_id` field.
	MetadataImport *MetadataImport `protobuf:"bytes,3,opt,name=metadata_import,json=metadataImport,proto3" json:"metadata_import,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMetadataImportRequest) Reset() {
	*x = CreateMetadataImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMetadataImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetadataImportRequest) ProtoMessage() {}

func (x *CreateMetadataImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetadataImportRequest.ProtoReflect.Descriptor instead.
func (*CreateMetadataImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{21}
}

func (x *CreateMetadataImportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMetadataImportRequest) GetMetadataImportId() string {
	if x != nil {
		return x.MetadataImportId
	}
	return ""
}

func (x *CreateMetadataImportRequest) GetMetadataImport() *MetadataImport {
	if x != nil {
		return x.MetadataImport
	}
	return nil
}

func (x *CreateMetadataImportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.UpdateMetadataImport][google.cloud.metastore.v1alpha.DataprocMetastore.UpdateMetadataImport].
type UpdateMetadataImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A field mask used to specify the fields to be overwritten in the
	// metadata import resource by the update.
	// Fields specified in the `update_mask` are relative to the resource (not
	// to the full request). A field is overwritten if it is in the mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The metadata import to update. The server only merges fields
	// in the import if they are specified in `update_mask`.
	//
	// The metadata import's `name` field is used to identify the metastore
	// import to be updated.
	MetadataImport *MetadataImport `protobuf:"bytes,2,opt,name=metadata_import,json=metadataImport,proto3" json:"metadata_import,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateMetadataImportRequest) Reset() {
	*x = UpdateMetadataImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMetadataImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMetadataImportRequest) ProtoMessage() {}

func (x *UpdateMetadataImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMetadataImportRequest.ProtoReflect.Descriptor instead.
func (*UpdateMetadataImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateMetadataImportRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMetadataImportRequest) GetMetadataImport() *MetadataImport {
	if x != nil {
		return x.MetadataImport
	}
	return nil
}

func (x *UpdateMetadataImportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.ListBackups][google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups].
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the service whose backups to
	// list, in the following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/backups`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of backups to return. The response may contain less
	// than the maximum number. If unspecified, no more than 500 backups are
	// returned. The maximum value is 1000; values above 1000 are changed to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous [DataprocMetastore.ListBackups][google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups]
	// call. Provide this token to retrieve the subsequent page.
	//
	// To retrieve the first page, supply an empty page token.
	//
	// When paginating, other parameters provided to
	// [DataprocMetastore.ListBackups][google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups] must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify the ordering of results as described in [Sorting
	// Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	// If not specified, the results will be sorted in the default order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{23}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [DataprocMetastore.ListBackups][google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups].
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The backups of the specified service.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{24}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [DataprocMetastore.GetBackup][google.cloud.metastore.v1alpha.DataprocMetastore.GetBackup].
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the backup to retrieve, in the
	// following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{25}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [DataprocMetastore.CreateBackup][google.cloud.metastore.v1alpha.DataprocMetastore.CreateBackup].
type CreateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the service in which to create a backup
	// of the following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the backup, which is used as the final component of the
	// backup's name.
	//
	// This value must be between 1 and 64 characters long, begin with a letter,
	// end with a letter or number, and consist of alpha-numeric ASCII characters
	// or hyphens.
	BackupId string `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Required. The backup to create. The `name` field is ignored. The ID of the created
	// backup must be provided in the request's `backup_id` field.
	Backup *Backup `protobuf:"bytes,3,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateBackupRequest) Reset() {
	*x = CreateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupRequest) ProtoMessage() {}

func (x *CreateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{26}
}

func (x *CreateBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *CreateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *CreateBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.DeleteBackup][google.cloud.metastore.v1alpha.DataprocMetastore.DeleteBackup].
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the backup to delete, in the
	// following form:
	//
	// `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DataprocMetastore.ExportMetadata][google.cloud.metastore.v1alpha.DataprocMetastore.ExportMetadata].
type ExportMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Destination that metadata is exported to.
	//
	// Types that are assignable to Destination:
	//	*ExportMetadataRequest_DestinationGcsFolder
	Destination isExportMetadataRequest_Destination `protobuf_oneof:"destination"`
	// Required. The relative resource name of the metastore service to run export, in the
	// following form:
	//
	// `projects/{project_id}/locations/{location_id}/services/{service_id}`
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The type of the database dump. If unspecified, defaults to `MYSQL`.
	DatabaseDumpType DatabaseDumpSpec_Type `protobuf:"varint,4,opt,name=database_dump_type,json=databaseDumpType,proto3,enum=google.cloud.metastore.v1alpha.DatabaseDumpSpec_Type" json:"database_dump_type,omitempty"`
}

func (x *ExportMetadataRequest) Reset() {
	*x = ExportMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadataRequest) ProtoMessage() {}

func (x *ExportMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadataRequest.ProtoReflect.Descriptor instead.
func (*ExportMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{28}
}

func (m *ExportMetadataRequest) GetDestination() isExportMetadataRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportMetadataRequest) GetDestinationGcsFolder() string {
	if x, ok := x.GetDestination().(*ExportMetadataRequest_DestinationGcsFolder); ok {
		return x.DestinationGcsFolder
	}
	return ""
}

func (x *ExportMetadataRequest) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ExportMetadataRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ExportMetadataRequest) GetDatabaseDumpType() DatabaseDumpSpec_Type {
	if x != nil {
		return x.DatabaseDumpType
	}
	return DatabaseDumpSpec_TYPE_UNSPECIFIED
}

type isExportMetadataRequest_Destination interface {
	isExportMetadataRequest_Destination()
}

type ExportMetadataRequest_DestinationGcsFolder struct {
	// A Cloud Storage URI of a folder, in the format
	// `gs://<bucket_name>/<path_inside_bucket>`. A sub-folder
	// `<export_folder>` containing exported files will be created below it.
	DestinationGcsFolder string `protobuf:"bytes,2,opt,name=destination_gcs_folder,json=destinationGcsFolder,proto3,oneof"`
}

func (*ExportMetadataRequest_DestinationGcsFolder) isExportMetadataRequest_Destination() {}

// Request message for [DataprocMetastore.Restore][].
type RestoreServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the metastore service to run restore, in the
	// following form:
	//
	// `projects/{project_id}/locations/{location_id}/services/{service_id}`
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Required. The relative resource name of the metastore service backup to restore
	// from, in the following form:
	//
	// `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`
	Backup string `protobuf:"bytes,2,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
	RestoreType Restore_RestoreType `protobuf:"varint,3,opt,name=restore_type,json=restoreType,proto3,enum=google.cloud.metastore.v1alpha.Restore_RestoreType" json:"restore_type,omitempty"`
	// Optional. A request ID. Specify a unique request ID to allow the server to ignore the
	// request if it has completed. The server will ignore subsequent requests
	// that provide a duplicate request ID for at least 60 minutes after the first
	// request.
	//
	// For example, if an initial request times out, followed by another request
	// with the same request ID, the server ignores the second request to prevent
	// the creation of duplicate commitments.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
	// A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RestoreServiceRequest) Reset() {
	*x = RestoreServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreServiceRequest) ProtoMessage() {}

func (x *RestoreServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreServiceRequest.ProtoReflect.Descriptor instead.
func (*RestoreServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{29}
}

func (x *RestoreServiceRequest) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *RestoreServiceRequest) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *RestoreServiceRequest) GetRestoreType() Restore_RestoreType {
	if x != nil {
		return x.RestoreType
	}
	return Restore_RESTORE_TYPE_UNSPECIFIED
}

func (x *RestoreServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Represents the metadata of a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the caller has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{30}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Metadata about the service in a location.
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The versions of Hive Metastore that can be used when creating a new
	// metastore service in this location. The server guarantees that exactly one
	// `HiveMetastoreVersion` in the list will set `is_default`.
	SupportedHiveMetastoreVersions []*LocationMetadata_HiveMetastoreVersion `protobuf:"bytes,1,rep,name=supported_hive_metastore_versions,json=supportedHiveMetastoreVersions,proto3" json:"supported_hive_metastore_versions,omitempty"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{31}
}

func (x *LocationMetadata) GetSupportedHiveMetastoreVersions() []*LocationMetadata_HiveMetastoreVersion {
	if x != nil {
		return x.SupportedHiveMetastoreVersions
	}
	return nil
}

// The specification of database dump to import from or export to.
type DatabaseDumpSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DatabaseDumpSpec) Reset() {
	*x = DatabaseDumpSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseDumpSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseDumpSpec) ProtoMessage() {}

func (x *DatabaseDumpSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseDumpSpec.ProtoReflect.Descriptor instead.
func (*DatabaseDumpSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{32}
}

// A specification of the location of and metadata about a database dump from
// a relational database management system.
type MetadataImport_DatabaseDump struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the database.
	//
	// Deprecated: Do not use.
	DatabaseType MetadataImport_DatabaseDump_DatabaseType `protobuf:"varint,1,opt,name=database_type,json=databaseType,proto3,enum=google.cloud.metastore.v1alpha.MetadataImport_DatabaseDump_DatabaseType" json:"database_type,omitempty"`
	// A Cloud Storage object or folder URI that specifies the source from which
	// to import metadata. It must begin with `gs://`.
	GcsUri string `protobuf:"bytes,2,opt,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
	// The name of the source database.
	//
	// Deprecated: Do not use.
	SourceDatabase string `protobuf:"bytes,3,opt,name=source_database,json=sourceDatabase,proto3" json:"source_database,omitempty"`
	// Optional. The type of the database dump. If unspecified, defaults to `MYSQL`.
	Type DatabaseDumpSpec_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.metastore.v1alpha.DatabaseDumpSpec_Type" json:"type,omitempty"`
}

func (x *MetadataImport_DatabaseDump) Reset() {
	*x = MetadataImport_DatabaseDump{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataImport_DatabaseDump) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataImport_DatabaseDump) ProtoMessage() {}

func (x *MetadataImport_DatabaseDump) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataImport_DatabaseDump.ProtoReflect.Descriptor instead.
func (*MetadataImport_DatabaseDump) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{8, 0}
}

// Deprecated: Do not use.
func (x *MetadataImport_DatabaseDump) GetDatabaseType() MetadataImport_DatabaseDump_DatabaseType {
	if x != nil {
		return x.DatabaseType
	}
	return MetadataImport_DatabaseDump_DATABASE_TYPE_UNSPECIFIED
}

func (x *MetadataImport_DatabaseDump) GetGcsUri() string {
	if x != nil {
		return x.GcsUri
	}
	return ""
}

// Deprecated: Do not use.
func (x *MetadataImport_DatabaseDump) GetSourceDatabase() string {
	if x != nil {
		return x.SourceDatabase
	}
	return ""
}

func (x *MetadataImport_DatabaseDump) GetType() DatabaseDumpSpec_Type {
	if x != nil {
		return x.Type
	}
	return DatabaseDumpSpec_TYPE_UNSPECIFIED
}

// A specification of a supported version of the Hive Metastore software.
type LocationMetadata_HiveMetastoreVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The semantic version of the Hive Metastore software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Whether `version` will be chosen by the server if a metastore service is
	// created with a `HiveMetastoreConfig` that omits the `version`.
	IsDefault bool `protobuf:"varint,2,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
}

func (x *LocationMetadata_HiveMetastoreVersion) Reset() {
	*x = LocationMetadata_HiveMetastoreVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationMetadata_HiveMetastoreVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata_HiveMetastoreVersion) ProtoMessage() {}

func (x *LocationMetadata_HiveMetastoreVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata_HiveMetastoreVersion.ProtoReflect.Descriptor instead.
func (*LocationMetadata_HiveMetastoreVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP(), []int{31, 0}
}

func (x *LocationMetadata_HiveMetastoreVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LocationMetadata_HiveMetastoreVersion) GetIsDefault() bool {
	if x != nil {
		return x.IsDefault
	}
	return false
}

var File_google_cloud_metastore_v1alpha_metastore_proto protoreflect.FileDescriptor

var file_google_cloud_metastore_v1alpha_metastore_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65,
	0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6, 0x0c, 0x0a, 0x07, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x69, 0x0a, 0x15, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x48, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x13, 0x68, 0x69, 0x76, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x05, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x26, 0x0a, 0x0c, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x69,
	0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x14,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x13, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x81, 0x01,
	0x0a, 0x1c, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x12, 0x64, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x7e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a,
	0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x07, 0x22, 0x3b, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x03, 0x22,
	0x49, 0x0a, 0x0e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a,
	0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x42, 0x12, 0x0a,
	0x10, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x78, 0x0a, 0x13, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2d, 0x0a, 0x11, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x88, 0x01, 0x0a, 0x11, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x3b, 0x0a, 0x0b, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x09, 0x68, 0x6f, 0x75, 0x72, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x36, 0x0a,
	0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f,
	0x66, 0x57, 0x65, 0x65, 0x6b, 0x22, 0xc6, 0x02, 0x0a, 0x13, 0x48, 0x69, 0x76, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x48, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x12, 0x57, 0x0a, 0x0f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4b, 0x65, 0x72, 0x62,
	0x65, 0x72, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x6b, 0x65, 0x72, 0x62,
	0x65, 0x72, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x42, 0x0a, 0x14, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9d,
	0x01, 0x0a, 0x0e, 0x4b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3e, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x74, 0x61, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x74, 0x61,
	0x62, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12,
	0x2d, 0x0a, 0x13, 0x6b, 0x72, 0x62, 0x35, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6b, 0x72,
	0x62, 0x35, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x22, 0x36,
	0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x07, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x1a, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x5e, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x48, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x22,
	0xcd, 0x07, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x67, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64,
	0x75, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xd1, 0x02, 0x0a, 0x0c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x12, 0x71, 0x0a, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d,
	0x70, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x38, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x22,
	0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x8b, 0x01, 0xea, 0x41, 0x87, 0x01, 0x0a, 0x27, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x5c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xe4, 0x03, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x35, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x68, 0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x04, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x57, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04,
	0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x1f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x7d, 0x22, 0x9e, 0x04, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x4c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0x48, 0x0a, 0x0b, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53,
	0x54, 0x4f, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10,
	0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x02, 0x22, 0xdb, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xa5, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe9, 0x01,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x46, 0x0a,
	0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc4, 0x01, 0x0a, 0x14, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x46, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x78, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe1, 0x01, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc2,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59,
	0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x5f, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65,
	0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x0f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe1, 0x01, 0x0a, 0x1b,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5c, 0x0a,
	0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xd9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa1, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x4f, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xe2, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x06,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x76, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb0, 0x02,
	0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x63, 0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12,
	0x42, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d,
	0x70, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x9d, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3f,
	0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x5b, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70,
	0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf6, 0x01, 0x0a, 0x10, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x90, 0x01,
	0x0a, 0x21, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x69, 0x76, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x48, 0x69, 0x76, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x1e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x48, 0x69, 0x76, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x4f, 0x0a, 0x14, 0x48, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x22, 0x3b, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x75, 0x6d,
	0x70, 0x53, 0x70, 0x65, 0x63, 0x22, 0x27, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x32, 0x80,
	0x1b, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xaa, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22,
	0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xe3, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x22, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x3a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0xda, 0x41, 0x19, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe5, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0xda, 0x41, 0x13, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0xca, 0x41, 0x1c, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xd3, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd1, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x52, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xa3, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x43,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x3a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64,
	0xca, 0x41, 0x23, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa5, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb0, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x66, 0x32, 0x53, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0xda, 0x41, 0x1b, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdc,
	0x01, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22,
	0x43, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdf, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xc4, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb1, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x4a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe8, 0x01, 0x0a, 0x0c, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdb, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x1a, 0x4c, 0xca, 0x41, 0x18, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xd0, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0e, 0x4d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_metastore_v1alpha_metastore_proto_rawDescOnce sync.Once
	file_google_cloud_metastore_v1alpha_metastore_proto_rawDescData = file_google_cloud_metastore_v1alpha_metastore_proto_rawDesc
)

func file_google_cloud_metastore_v1alpha_metastore_proto_rawDescGZIP() []byte {
	file_google_cloud_metastore_v1alpha_metastore_proto_rawDescOnce.Do(func() {
		file_google_cloud_metastore_v1alpha_metastore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_metastore_v1alpha_metastore_proto_rawDescData)
	})
	return file_google_cloud_metastore_v1alpha_metastore_proto_rawDescData
}

var file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_cloud_metastore_v1alpha_metastore_proto_goTypes = []interface{}{
	(Service_State)(0),                            // 0: google.cloud.metastore.v1alpha.Service.State
	(Service_Tier)(0),                             // 1: google.cloud.metastore.v1alpha.Service.Tier
	(Service_ReleaseChannel)(0),                   // 2: google.cloud.metastore.v1alpha.Service.ReleaseChannel
	(MetadataImport_State)(0),                     // 3: google.cloud.metastore.v1alpha.MetadataImport.State
	(MetadataImport_DatabaseDump_DatabaseType)(0), // 4: google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump.DatabaseType
	(MetadataExport_State)(0),                     // 5: google.cloud.metastore.v1alpha.MetadataExport.State
	(Backup_State)(0),                             // 6: google.cloud.metastore.v1alpha.Backup.State
	(Restore_State)(0),                            // 7: google.cloud.metastore.v1alpha.Restore.State
	(Restore_RestoreType)(0),                      // 8: google.cloud.metastore.v1alpha.Restore.RestoreType
	(DatabaseDumpSpec_Type)(0),                    // 9: google.cloud.metastore.v1alpha.DatabaseDumpSpec.Type
	(*Service)(nil),                               // 10: google.cloud.metastore.v1alpha.Service
	(*MetadataIntegration)(nil),                   // 11: google.cloud.metastore.v1alpha.MetadataIntegration
	(*DataCatalogConfig)(nil),                     // 12: google.cloud.metastore.v1alpha.DataCatalogConfig
	(*MaintenanceWindow)(nil),                     // 13: google.cloud.metastore.v1alpha.MaintenanceWindow
	(*HiveMetastoreConfig)(nil),                   // 14: google.cloud.metastore.v1alpha.HiveMetastoreConfig
	(*KerberosConfig)(nil),                        // 15: google.cloud.metastore.v1alpha.KerberosConfig
	(*Secret)(nil),                                // 16: google.cloud.metastore.v1alpha.Secret
	(*MetadataManagementActivity)(nil),            // 17: google.cloud.metastore.v1alpha.MetadataManagementActivity
	(*MetadataImport)(nil),                        // 18: google.cloud.metastore.v1alpha.MetadataImport
	(*MetadataExport)(nil),                        // 19: google.cloud.metastore.v1alpha.MetadataExport
	(*Backup)(nil),                                // 20: google.cloud.metastore.v1alpha.Backup
	(*Restore)(nil),                               // 21: google.cloud.metastore.v1alpha.Restore
	(*ListServicesRequest)(nil),                   // 22: google.cloud.metastore.v1alpha.ListServicesRequest
	(*ListServicesResponse)(nil),                  // 23: google.cloud.metastore.v1alpha.ListServicesResponse
	(*GetServiceRequest)(nil),                     // 24: google.cloud.metastore.v1alpha.GetServiceRequest
	(*CreateServiceRequest)(nil),                  // 25: google.cloud.metastore.v1alpha.CreateServiceRequest
	(*UpdateServiceRequest)(nil),                  // 26: google.cloud.metastore.v1alpha.UpdateServiceRequest
	(*DeleteServiceRequest)(nil),                  // 27: google.cloud.metastore.v1alpha.DeleteServiceRequest
	(*ListMetadataImportsRequest)(nil),            // 28: google.cloud.metastore.v1alpha.ListMetadataImportsRequest
	(*ListMetadataImportsResponse)(nil),           // 29: google.cloud.metastore.v1alpha.ListMetadataImportsResponse
	(*GetMetadataImportRequest)(nil),              // 30: google.cloud.metastore.v1alpha.GetMetadataImportRequest
	(*CreateMetadataImportRequest)(nil),           // 31: google.cloud.metastore.v1alpha.CreateMetadataImportRequest
	(*UpdateMetadataImportRequest)(nil),           // 32: google.cloud.metastore.v1alpha.UpdateMetadataImportRequest
	(*ListBackupsRequest)(nil),                    // 33: google.cloud.metastore.v1alpha.ListBackupsRequest
	(*ListBackupsResponse)(nil),                   // 34: google.cloud.metastore.v1alpha.ListBackupsResponse
	(*GetBackupRequest)(nil),                      // 35: google.cloud.metastore.v1alpha.GetBackupRequest
	(*CreateBackupRequest)(nil),                   // 36: google.cloud.metastore.v1alpha.CreateBackupRequest
	(*DeleteBackupRequest)(nil),                   // 37: google.cloud.metastore.v1alpha.DeleteBackupRequest
	(*ExportMetadataRequest)(nil),                 // 38: google.cloud.metastore.v1alpha.ExportMetadataRequest
	(*RestoreServiceRequest)(nil),                 // 39: google.cloud.metastore.v1alpha.RestoreServiceRequest
	(*OperationMetadata)(nil),                     // 40: google.cloud.metastore.v1alpha.OperationMetadata
	(*LocationMetadata)(nil),                      // 41: google.cloud.metastore.v1alpha.LocationMetadata
	(*DatabaseDumpSpec)(nil),                      // 42: google.cloud.metastore.v1alpha.DatabaseDumpSpec
	nil,                                           // 43: google.cloud.metastore.v1alpha.Service.LabelsEntry
	nil,                                           // 44: google.cloud.metastore.v1alpha.HiveMetastoreConfig.ConfigOverridesEntry
	(*MetadataImport_DatabaseDump)(nil),           // 45: google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump
	(*LocationMetadata_HiveMetastoreVersion)(nil), // 46: google.cloud.metastore.v1alpha.LocationMetadata.HiveMetastoreVersion
	(*timestamppb.Timestamp)(nil),                 // 47: google.protobuf.Timestamp
	(*wrapperspb.Int32Value)(nil),                 // 48: google.protobuf.Int32Value
	(dayofweek.DayOfWeek)(0),                      // 49: google.type.DayOfWeek
	(*fieldmaskpb.FieldMask)(nil),                 // 50: google.protobuf.FieldMask
	(*longrunning.Operation)(nil),                 // 51: google.longrunning.Operation
}
var file_google_cloud_metastore_v1alpha_metastore_proto_depIdxs = []int32{
	14, // 0: google.cloud.metastore.v1alpha.Service.hive_metastore_config:type_name -> google.cloud.metastore.v1alpha.HiveMetastoreConfig
	47, // 1: google.cloud.metastore.v1alpha.Service.create_time:type_name -> google.protobuf.Timestamp
	47, // 2: google.cloud.metastore.v1alpha.Service.update_time:type_name -> google.protobuf.Timestamp
	43, // 3: google.cloud.metastore.v1alpha.Service.labels:type_name -> google.cloud.metastore.v1alpha.Service.LabelsEntry
	0,  // 4: google.cloud.metastore.v1alpha.Service.state:type_name -> google.cloud.metastore.v1alpha.Service.State
	1,  // 5: google.cloud.metastore.v1alpha.Service.tier:type_name -> google.cloud.metastore.v1alpha.Service.Tier
	11, // 6: google.cloud.metastore.v1alpha.Service.metadata_integration:type_name -> google.cloud.metastore.v1alpha.MetadataIntegration
	13, // 7: google.cloud.metastore.v1alpha.Service.maintenance_window:type_name -> google.cloud.metastore.v1alpha.MaintenanceWindow
	17, // 8: google.cloud.metastore.v1alpha.Service.metadata_management_activity:type_name -> google.cloud.metastore.v1alpha.MetadataManagementActivity
	2,  // 9: google.cloud.metastore.v1alpha.Service.release_channel:type_name -> google.cloud.metastore.v1alpha.Service.ReleaseChannel
	12, // 10: google.cloud.metastore.v1alpha.MetadataIntegration.data_catalog_config:type_name -> google.cloud.metastore.v1alpha.DataCatalogConfig
	48, // 11: google.cloud.metastore.v1alpha.MaintenanceWindow.hour_of_day:type_name -> google.protobuf.Int32Value
	49, // 12: google.cloud.metastore.v1alpha.MaintenanceWindow.day_of_week:type_name -> google.type.DayOfWeek
	44, // 13: google.cloud.metastore.v1alpha.HiveMetastoreConfig.config_overrides:type_name -> google.cloud.metastore.v1alpha.HiveMetastoreConfig.ConfigOverridesEntry
	15, // 14: google.cloud.metastore.v1alpha.HiveMetastoreConfig.kerberos_config:type_name -> google.cloud.metastore.v1alpha.KerberosConfig
	16, // 15: google.cloud.metastore.v1alpha.KerberosConfig.keytab:type_name -> google.cloud.metastore.v1alpha.Secret
	19, // 16: google.cloud.metastore.v1alpha.MetadataManagementActivity.metadata_exports:type_name -> google.cloud.metastore.v1alpha.MetadataExport
	21, // 17: google.cloud.metastore.v1alpha.MetadataManagementActivity.restores:type_name -> google.cloud.metastore.v1alpha.Restore
	45, // 18: google.cloud.metastore.v1alpha.MetadataImport.database_dump:type_name -> google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump
	47, // 19: google.cloud.metastore.v1alpha.MetadataImport.create_time:type_name -> google.protobuf.Timestamp
	47, // 20: google.cloud.metastore.v1alpha.MetadataImport.update_time:type_name -> google.protobuf.Timestamp
	3,  // 21: google.cloud.metastore.v1alpha.MetadataImport.state:type_name -> google.cloud.metastore.v1alpha.MetadataImport.State
	47, // 22: google.cloud.metastore.v1alpha.MetadataExport.start_time:type_name -> google.protobuf.Timestamp
	47, // 23: google.cloud.metastore.v1alpha.MetadataExport.end_time:type_name -> google.protobuf.Timestamp
	5,  // 24: google.cloud.metastore.v1alpha.MetadataExport.state:type_name -> google.cloud.metastore.v1alpha.MetadataExport.State
	9,  // 25: google.cloud.metastore.v1alpha.MetadataExport.database_dump_type:type_name -> google.cloud.metastore.v1alpha.DatabaseDumpSpec.Type
	47, // 26: google.cloud.metastore.v1alpha.Backup.create_time:type_name -> google.protobuf.Timestamp
	47, // 27: google.cloud.metastore.v1alpha.Backup.end_time:type_name -> google.protobuf.Timestamp
	6,  // 28: google.cloud.metastore.v1alpha.Backup.state:type_name -> google.cloud.metastore.v1alpha.Backup.State
	10, // 29: google.cloud.metastore.v1alpha.Backup.service_revision:type_name -> google.cloud.metastore.v1alpha.Service
	47, // 30: google.cloud.metastore.v1alpha.Restore.start_time:type_name -> google.protobuf.Timestamp
	47, // 31: google.cloud.metastore.v1alpha.Restore.end_time:type_name -> google.protobuf.Timestamp
	7,  // 32: google.cloud.metastore.v1alpha.Restore.state:type_name -> google.cloud.metastore.v1alpha.Restore.State
	8,  // 33: google.cloud.metastore.v1alpha.Restore.type:type_name -> google.cloud.metastore.v1alpha.Restore.RestoreType
	10, // 34: google.cloud.metastore.v1alpha.ListServicesResponse.services:type_name -> google.cloud.metastore.v1alpha.Service
	10, // 35: google.cloud.metastore.v1alpha.CreateServiceRequest.service:type_name -> google.cloud.metastore.v1alpha.Service
	50, // 36: google.cloud.metastore.v1alpha.UpdateServiceRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 37: google.cloud.metastore.v1alpha.UpdateServiceRequest.service:type_name -> google.cloud.metastore.v1alpha.Service
	18, // 38: google.cloud.metastore.v1alpha.ListMetadataImportsResponse.metadata_imports:type_name -> google.cloud.metastore.v1alpha.MetadataImport
	18, // 39: google.cloud.metastore.v1alpha.CreateMetadataImportRequest.metadata_import:type_name -> google.cloud.metastore.v1alpha.MetadataImport
	50, // 40: google.cloud.metastore.v1alpha.UpdateMetadataImportRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 41: google.cloud.metastore.v1alpha.UpdateMetadataImportRequest.metadata_import:type_name -> google.cloud.metastore.v1alpha.MetadataImport
	20, // 42: google.cloud.metastore.v1alpha.ListBackupsResponse.backups:type_name -> google.cloud.metastore.v1alpha.Backup
	20, // 43: google.cloud.metastore.v1alpha.CreateBackupRequest.backup:type_name -> google.cloud.metastore.v1alpha.Backup
	9,  // 44: google.cloud.metastore.v1alpha.ExportMetadataRequest.database_dump_type:type_name -> google.cloud.metastore.v1alpha.DatabaseDumpSpec.Type
	8,  // 45: google.cloud.metastore.v1alpha.RestoreServiceRequest.restore_type:type_name -> google.cloud.metastore.v1alpha.Restore.RestoreType
	47, // 46: google.cloud.metastore.v1alpha.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	47, // 47: google.cloud.metastore.v1alpha.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	46, // 48: google.cloud.metastore.v1alpha.LocationMetadata.supported_hive_metastore_versions:type_name -> google.cloud.metastore.v1alpha.LocationMetadata.HiveMetastoreVersion
	4,  // 49: google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump.database_type:type_name -> google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump.DatabaseType
	9,  // 50: google.cloud.metastore.v1alpha.MetadataImport.DatabaseDump.type:type_name -> google.cloud.metastore.v1alpha.DatabaseDumpSpec.Type
	22, // 51: google.cloud.metastore.v1alpha.DataprocMetastore.ListServices:input_type -> google.cloud.metastore.v1alpha.ListServicesRequest
	24, // 52: google.cloud.metastore.v1alpha.DataprocMetastore.GetService:input_type -> google.cloud.metastore.v1alpha.GetServiceRequest
	25, // 53: google.cloud.metastore.v1alpha.DataprocMetastore.CreateService:input_type -> google.cloud.metastore.v1alpha.CreateServiceRequest
	26, // 54: google.cloud.metastore.v1alpha.DataprocMetastore.UpdateService:input_type -> google.cloud.metastore.v1alpha.UpdateServiceRequest
	27, // 55: google.cloud.metastore.v1alpha.DataprocMetastore.DeleteService:input_type -> google.cloud.metastore.v1alpha.DeleteServiceRequest
	28, // 56: google.cloud.metastore.v1alpha.DataprocMetastore.ListMetadataImports:input_type -> google.cloud.metastore.v1alpha.ListMetadataImportsRequest
	30, // 57: google.cloud.metastore.v1alpha.DataprocMetastore.GetMetadataImport:input_type -> google.cloud.metastore.v1alpha.GetMetadataImportRequest
	31, // 58: google.cloud.metastore.v1alpha.DataprocMetastore.CreateMetadataImport:input_type -> google.cloud.metastore.v1alpha.CreateMetadataImportRequest
	32, // 59: google.cloud.metastore.v1alpha.DataprocMetastore.UpdateMetadataImport:input_type -> google.cloud.metastore.v1alpha.UpdateMetadataImportRequest
	38, // 60: google.cloud.metastore.v1alpha.DataprocMetastore.ExportMetadata:input_type -> google.cloud.metastore.v1alpha.ExportMetadataRequest
	39, // 61: google.cloud.metastore.v1alpha.DataprocMetastore.RestoreService:input_type -> google.cloud.metastore.v1alpha.RestoreServiceRequest
	33, // 62: google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups:input_type -> google.cloud.metastore.v1alpha.ListBackupsRequest
	35, // 63: google.cloud.metastore.v1alpha.DataprocMetastore.GetBackup:input_type -> google.cloud.metastore.v1alpha.GetBackupRequest
	36, // 64: google.cloud.metastore.v1alpha.DataprocMetastore.CreateBackup:input_type -> google.cloud.metastore.v1alpha.CreateBackupRequest
	37, // 65: google.cloud.metastore.v1alpha.DataprocMetastore.DeleteBackup:input_type -> google.cloud.metastore.v1alpha.DeleteBackupRequest
	23, // 66: google.cloud.metastore.v1alpha.DataprocMetastore.ListServices:output_type -> google.cloud.metastore.v1alpha.ListServicesResponse
	10, // 67: google.cloud.metastore.v1alpha.DataprocMetastore.GetService:output_type -> google.cloud.metastore.v1alpha.Service
	51, // 68: google.cloud.metastore.v1alpha.DataprocMetastore.CreateService:output_type -> google.longrunning.Operation
	51, // 69: google.cloud.metastore.v1alpha.DataprocMetastore.UpdateService:output_type -> google.longrunning.Operation
	51, // 70: google.cloud.metastore.v1alpha.DataprocMetastore.DeleteService:output_type -> google.longrunning.Operation
	29, // 71: google.cloud.metastore.v1alpha.DataprocMetastore.ListMetadataImports:output_type -> google.cloud.metastore.v1alpha.ListMetadataImportsResponse
	18, // 72: google.cloud.metastore.v1alpha.DataprocMetastore.GetMetadataImport:output_type -> google.cloud.metastore.v1alpha.MetadataImport
	51, // 73: google.cloud.metastore.v1alpha.DataprocMetastore.CreateMetadataImport:output_type -> google.longrunning.Operation
	51, // 74: google.cloud.metastore.v1alpha.DataprocMetastore.UpdateMetadataImport:output_type -> google.longrunning.Operation
	51, // 75: google.cloud.metastore.v1alpha.DataprocMetastore.ExportMetadata:output_type -> google.longrunning.Operation
	51, // 76: google.cloud.metastore.v1alpha.DataprocMetastore.RestoreService:output_type -> google.longrunning.Operation
	34, // 77: google.cloud.metastore.v1alpha.DataprocMetastore.ListBackups:output_type -> google.cloud.metastore.v1alpha.ListBackupsResponse
	20, // 78: google.cloud.metastore.v1alpha.DataprocMetastore.GetBackup:output_type -> google.cloud.metastore.v1alpha.Backup
	51, // 79: google.cloud.metastore.v1alpha.DataprocMetastore.CreateBackup:output_type -> google.longrunning.Operation
	51, // 80: google.cloud.metastore.v1alpha.DataprocMetastore.DeleteBackup:output_type -> google.longrunning.Operation
	66, // [66:81] is the sub-list for method output_type
	51, // [51:66] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_metastore_v1alpha_metastore_proto_init() }
func file_google_cloud_metastore_v1alpha_metastore_proto_init() {
	if File_google_cloud_metastore_v1alpha_metastore_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataIntegration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataCatalogConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HiveMetastoreConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KerberosConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataManagementActivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataImport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataExport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Backup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Restore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMetadataImportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMetadataImportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMetadataImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMetadataImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMetadataImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseDumpSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataImport_DatabaseDump); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationMetadata_HiveMetastoreVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Service_HiveMetastoreConfig)(nil),
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Secret_CloudSecret)(nil),
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*MetadataImport_DatabaseDump_)(nil),
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*MetadataExport_DestinationGcsUri)(nil),
	}
	file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*ExportMetadataRequest_DestinationGcsFolder)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_metastore_v1alpha_metastore_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_metastore_v1alpha_metastore_proto_goTypes,
		DependencyIndexes: file_google_cloud_metastore_v1alpha_metastore_proto_depIdxs,
		EnumInfos:         file_google_cloud_metastore_v1alpha_metastore_proto_enumTypes,
		MessageInfos:      file_google_cloud_metastore_v1alpha_metastore_proto_msgTypes,
	}.Build()
	File_google_cloud_metastore_v1alpha_metastore_proto = out.File
	file_google_cloud_metastore_v1alpha_metastore_proto_rawDesc = nil
	file_google_cloud_metastore_v1alpha_metastore_proto_goTypes = nil
	file_google_cloud_metastore_v1alpha_metastore_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataprocMetastoreClient is the client API for DataprocMetastore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataprocMetastoreClient interface {
	// Lists services in a project and location.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets the details of a single service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Creates a metastore service in a project and location.
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single service.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single service.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists imports in a service.
	ListMetadataImports(ctx context.Context, in *ListMetadataImportsRequest, opts ...grpc.CallOption) (*ListMetadataImportsResponse, error)
	// Gets details of a single import.
	GetMetadataImport(ctx context.Context, in *GetMetadataImportRequest, opts ...grpc.CallOption) (*MetadataImport, error)
	// Creates a new MetadataImport in a given project and location.
	CreateMetadataImport(ctx context.Context, in *CreateMetadataImportRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a single import.
	// Only the description field of MetadataImport is supported to be updated.
	UpdateMetadataImport(ctx context.Context, in *UpdateMetadataImportRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports metadata from a service.
	ExportMetadata(ctx context.Context, in *ExportMetadataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restores a service from a backup.
	RestoreService(ctx context.Context, in *RestoreServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists backups in a service.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets details of a single backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Creates a new Backup in a given project and location.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type dataprocMetastoreClient struct {
	cc grpc.ClientConnInterface
}

func NewDataprocMetastoreClient(cc grpc.ClientConnInterface) DataprocMetastoreClient {
	return &dataprocMetastoreClient{cc}
}

func (c *dataprocMetastoreClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/UpdateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/DeleteService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ListMetadataImports(ctx context.Context, in *ListMetadataImportsRequest, opts ...grpc.CallOption) (*ListMetadataImportsResponse, error) {
	out := new(ListMetadataImportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/ListMetadataImports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetMetadataImport(ctx context.Context, in *GetMetadataImportRequest, opts ...grpc.CallOption) (*MetadataImport, error) {
	out := new(MetadataImport)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/GetMetadataImport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateMetadataImport(ctx context.Context, in *CreateMetadataImportRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateMetadataImport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) UpdateMetadataImport(ctx context.Context, in *UpdateMetadataImportRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/UpdateMetadataImport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ExportMetadata(ctx context.Context, in *ExportMetadataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/ExportMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) RestoreService(ctx context.Context, in *RestoreServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/RestoreService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.metastore.v1alpha.DataprocMetastore/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataprocMetastoreServer is the server API for DataprocMetastore service.
type DataprocMetastoreServer interface {
	// Lists services in a project and location.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets the details of a single service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Creates a metastore service in a project and location.
	CreateService(context.Context, *CreateServiceRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single service.
	UpdateService(context.Context, *UpdateServiceRequest) (*longrunning.Operation, error)
	// Deletes a single service.
	DeleteService(context.Context, *DeleteServiceRequest) (*longrunning.Operation, error)
	// Lists imports in a service.
	ListMetadataImports(context.Context, *ListMetadataImportsRequest) (*ListMetadataImportsResponse, error)
	// Gets details of a single import.
	GetMetadataImport(context.Context, *GetMetadataImportRequest) (*MetadataImport, error)
	// Creates a new MetadataImport in a given project and location.
	CreateMetadataImport(context.Context, *CreateMetadataImportRequest) (*longrunning.Operation, error)
	// Updates a single import.
	// Only the description field of MetadataImport is supported to be updated.
	UpdateMetadataImport(context.Context, *UpdateMetadataImportRequest) (*longrunning.Operation, error)
	// Exports metadata from a service.
	ExportMetadata(context.Context, *ExportMetadataRequest) (*longrunning.Operation, error)
	// Restores a service from a backup.
	RestoreService(context.Context, *RestoreServiceRequest) (*longrunning.Operation, error)
	// Lists backups in a service.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets details of a single backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Creates a new Backup in a given project and location.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunning.Operation, error)
	// Deletes a single backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunning.Operation, error)
}

// UnimplementedDataprocMetastoreServer can be embedded to have forward compatible implementations.
type UnimplementedDataprocMetastoreServer struct {
}

func (*UnimplementedDataprocMetastoreServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedDataprocMetastoreServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (*UnimplementedDataprocMetastoreServer) CreateService(context.Context, *CreateServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateService not implemented")
}
func (*UnimplementedDataprocMetastoreServer) UpdateService(context.Context, *UpdateServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (*UnimplementedDataprocMetastoreServer) DeleteService(context.Context, *DeleteServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}
func (*UnimplementedDataprocMetastoreServer) ListMetadataImports(context.Context, *ListMetadataImportsRequest) (*ListMetadataImportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataImports not implemented")
}
func (*UnimplementedDataprocMetastoreServer) GetMetadataImport(context.Context, *GetMetadataImportRequest) (*MetadataImport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataImport not implemented")
}
func (*UnimplementedDataprocMetastoreServer) CreateMetadataImport(context.Context, *CreateMetadataImportRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataImport not implemented")
}
func (*UnimplementedDataprocMetastoreServer) UpdateMetadataImport(context.Context, *UpdateMetadataImportRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMetadataImport not implemented")
}
func (*UnimplementedDataprocMetastoreServer) ExportMetadata(context.Context, *ExportMetadataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportMetadata not implemented")
}
func (*UnimplementedDataprocMetastoreServer) RestoreService(context.Context, *RestoreServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreService not implemented")
}
func (*UnimplementedDataprocMetastoreServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedDataprocMetastoreServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (*UnimplementedDataprocMetastoreServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (*UnimplementedDataprocMetastoreServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}

func RegisterDataprocMetastoreServer(s *grpc.Server, srv DataprocMetastoreServer) {
	s.RegisterService(&_DataprocMetastore_serviceDesc, srv)
}

func _DataprocMetastore_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/UpdateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ListMetadataImports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataImportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListMetadataImports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/ListMetadataImports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListMetadataImports(ctx, req.(*ListMetadataImportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/GetMetadataImport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetMetadataImport(ctx, req.(*GetMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateMetadataImport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateMetadataImport(ctx, req.(*CreateMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_UpdateMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).UpdateMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/UpdateMetadataImport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).UpdateMetadataImport(ctx, req.(*UpdateMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ExportMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ExportMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/ExportMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ExportMetadata(ctx, req.(*ExportMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_RestoreService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).RestoreService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/RestoreService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).RestoreService(ctx, req.(*RestoreServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/CreateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.metastore.v1alpha.DataprocMetastore/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataprocMetastore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.metastore.v1alpha.DataprocMetastore",
	HandlerType: (*DataprocMetastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _DataprocMetastore_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _DataprocMetastore_GetService_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _DataprocMetastore_CreateService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _DataprocMetastore_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _DataprocMetastore_DeleteService_Handler,
		},
		{
			MethodName: "ListMetadataImports",
			Handler:    _DataprocMetastore_ListMetadataImports_Handler,
		},
		{
			MethodName: "GetMetadataImport",
			Handler:    _DataprocMetastore_GetMetadataImport_Handler,
		},
		{
			MethodName: "CreateMetadataImport",
			Handler:    _DataprocMetastore_CreateMetadataImport_Handler,
		},
		{
			MethodName: "UpdateMetadataImport",
			Handler:    _DataprocMetastore_UpdateMetadataImport_Handler,
		},
		{
			MethodName: "ExportMetadata",
			Handler:    _DataprocMetastore_ExportMetadata_Handler,
		},
		{
			MethodName: "RestoreService",
			Handler:    _DataprocMetastore_RestoreService_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _DataprocMetastore_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _DataprocMetastore_GetBackup_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _DataprocMetastore_CreateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _DataprocMetastore_DeleteBackup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/metastore/v1alpha/metastore.proto",
}
