
# Template App Remote Zabbix server

## Overview

For Zabbix version: 5.0 and higher  

## Setup

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ADDRESS} |<p>-</p> |`` |
|{$PORT} |<p>-</p> |`` |

## Template links

There are no template links in this template.

## Discovery rules


## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Zabbix_raw_items |Remote Zabbix server: Zabbix stats |<p>Zabbix server statistics master item.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT}] |
|Zabbix_server |Remote Zabbix server: Zabbix stats queue over 10m |<p>Number of monitored items in the queue which are delayed at least by 10 minutes</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue,10m]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix_server |Remote Zabbix server: Zabbix stats queue |<p>Number of monitored items in the queue which are delayed at least by 6 seconds</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of alert manager internal processes, in % |<p>Average percentage of time alert manager processes have been busy in the last minute</p> |DEPENDENT |process.alert_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alert manager not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of alert syncer internal processes, in % |<p>Average percentage of time alert syncer processes have been busy in the last minute</p> |DEPENDENT |process.alert_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alert syncer not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of alerter internal processes, in % |<p>Average percentage of time alerter processes have been busy in the last minute</p> |DEPENDENT |process.alerter.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alerter'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alerter not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of configuration syncer internal processes, in % |<p>Average percentage of time configuration syncer processes have been busy in the last minute</p> |DEPENDENT |process.configuration_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes configuration syncer not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of discoverer data collector processes, in % |<p>Average percentage of time discoverer processes have been busy in the last minute</p> |DEPENDENT |process.discoverer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['discoverer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes discoverer not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of escalator internal processes, in % |<p>Average percentage of time escalator processes have been busy in the last minute</p> |DEPENDENT |process.escalator.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['escalator'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes escalator not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of history syncer internal processes, in % |<p>Average percentage of time history syncer processes have been busy in the last minute</p> |DEPENDENT |process.history_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes history syncer not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of housekeeper internal processes, in % |<p>Average percentage of time housekeeper processes have been busy in the last minute</p> |DEPENDENT |process.housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes housekeeper not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of http poller data collector processes, in % |<p>Average percentage of time http poller processes have been busy in the last minute</p> |DEPENDENT |process.http_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['http poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes http poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of icmp pinger data collector processes, in % |<p>Average percentage of time icmp pinger processes have been busy in the last minute</p> |DEPENDENT |process.icmp_pinger.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes icmp pinger not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of ipmi manager internal processes, in % |<p>Average percentage of time ipmi manager processes have been busy in the last minute</p> |DEPENDENT |process.ipmi_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi manager not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of ipmi poller data collector processes, in % |<p>Average percentage of time ipmi poller processes have been busy in the last minute</p> |DEPENDENT |process.ipmi_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of java poller data collector processes, in % |<p>Average percentage of time java poller processes have been busy in the last minute</p> |DEPENDENT |process.java_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['java poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes java poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of LLD manager internal processes, in % |<p>Average percentage of time lld manager processes have been busy in the last minute</p> |DEPENDENT |process.lld_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes LLD manager not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of LLD worker internal processes, in % |<p>Average percentage of time lld worker processes have been busy in the last minute</p> |DEPENDENT |process.lld_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes LLD worker not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of poller data collector processes, in % |<p>Average percentage of time poller processes have been busy in the last minute</p> |DEPENDENT |process.poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of preprocessing worker internal processes, in % |<p>Average percentage of time preprocessing worker processes have been busy in the last minute</p> |DEPENDENT |process.preprocessing_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing worker not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of preprocessing manager internal processes, in % |<p>Average percentage of time preprocessing manager processes have been busy in the last minute</p> |DEPENDENT |process.preprocessing_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing manager not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of proxy poller data collector processes, in % |<p>Average percentage of time proxy poller processes have been busy in the last minute</p> |DEPENDENT |process.proxy_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes proxy poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of self-monitoring internal processes, in % |<p>Average percentage of time self-monitoring processes have been busy in the last minute</p> |DEPENDENT |process.self-monitoring.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes self-monitoring not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of snmp trapper data collector processes, in % |<p>Average percentage of time snmp trapper processes have been busy in the last minute</p> |DEPENDENT |process.snmp_trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes snmp trapper not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of task manager internal processes, in % |<p>Average percentage of time task manager processes have been busy in the last minute</p> |DEPENDENT |process.task_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['task manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes task manager not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of timer internal processes, in % |<p>Average percentage of time timer processes have been busy in the last minute</p> |DEPENDENT |process.timer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['timer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes timer not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of trapper data collector processes, in % |<p>Average percentage of time trapper processes have been busy in the last minute</p> |DEPENDENT |process.trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes trapper not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of unreachable poller data collector processes, in % |<p>Average percentage of time unreachable poller processes have been busy in the last minute</p> |DEPENDENT |process.unreachable_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes unreachable poller not started`</p> |
|Zabbix_server |Remote Zabbix server: Utilization of vmware data collector processes, in % |<p>Average percentage of time vmware collector processes have been busy in the last minute</p> |DEPENDENT |process.vmware_collector.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes vmware collector not started`</p> |
|Zabbix_server |Remote Zabbix server: Configuration cache, % used |<p>Availability statistics of Zabbix configuration cache. Percentage of used buffer</p> |DEPENDENT |rcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.rcache.pused`</p> |
|Zabbix_server |Remote Zabbix server: Value cache, % used |<p>Availability statistics of Zabbix value cache. Percentage of used buffer</p> |DEPENDENT |vcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.buffer.pused`</p> |
|Zabbix_server |Remote Zabbix server: Value cache hits |<p>Effectiveness statistics of Zabbix value cache. Number of cache hits (history values taken from the cache)</p> |DEPENDENT |vcache.cache.hits<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.hits`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Value cache misses |<p>Effectiveness statistics of Zabbix value cache. Number of cache misses (history values taken from the database)</p> |DEPENDENT |vcache.cache.misses<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.misses`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Value cache operating mode |<p>Value cache operating mode</p> |DEPENDENT |vcache.cache.mode<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.mode`</p> |
|Zabbix_server |Remote Zabbix server: Version |<p>Version of Zabbix server.</p> |DEPENDENT |version<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.version`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Zabbix_server |Remote Zabbix server: VMware cache, % used |<p>Availability statistics of Zabbix vmware cache. Percentage of used buffer</p> |DEPENDENT |vmware.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vmware.pused`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No vmware collector processes started`</p> |
|Zabbix_server |Remote Zabbix server: History write cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history buffer.</p><p>History cache is used to store item values. A high number indicates performance problems on the database side.</p> |DEPENDENT |wcache.history.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.history.pused`</p> |
|Zabbix_server |Remote Zabbix server: History index cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history index buffer.</p><p>History index cache is used to index values stored in history cache.</p> |DEPENDENT |wcache.index.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.index.pused`</p> |
|Zabbix_server |Remote Zabbix server: Trend write cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used trend buffer.</p><p>Trend cache stores aggregate for the current hour for all items that receive data.</p> |DEPENDENT |wcache.trend.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.trend.pused`</p> |
|Zabbix_server |Remote Zabbix server: Number of processed values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p> |DEPENDENT |wcache.values<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.all`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Number of processed numeric (float) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed float values.</p> |DEPENDENT |wcache.values.float<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.float`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Number of processed log values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed log values.</p> |DEPENDENT |wcache.values.log<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.log`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Number of processed not supported values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of times item processing resulted in item becoming unsupported or keeping that state.</p> |DEPENDENT |wcache.values.not_supported<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values['not supported']`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Number of processed character values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed character/string values.</p> |DEPENDENT |wcache.values.str<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.str`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: Number of processed text values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed text values.</p> |DEPENDENT |wcache.values.text<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.text`</p><p>- CHANGE_PER_SECOND |
|Zabbix_server |Remote Zabbix server: LLD queue |<p>Count of values enqueued in the low-level discovery processing queue.</p> |DEPENDENT |lld_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.lld_queue`</p> |
|Zabbix_server |Remote Zabbix server: Preprocessing queue |<p>Count of values enqueued in the preprocessing queue.</p> |DEPENDENT |preprocessing_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.preprocessing_queue`</p> |
|Zabbix_server |Remote Zabbix server: Number of processed numeric (unsigned) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed numeric (unsigned) values.</p> |DEPENDENT |wcache.values.uint<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.uint`</p><p>- CHANGE_PER_SECOND |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Remote Zabbix server: More than 100 items having missing data for more than 10 minutes |<p>zabbix[stats,{$IP},{$PORT},queue,10m] item is collecting data about how many items are missing data for more than 10 minutes</p> |`{TEMPLATE_NAME:zabbix[stats,{$ADDRESS},{$PORT},queue,10m].min(10m)}>100` |WARNING | |
|Remote Zabbix server: Utilization of alert manager processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.alert_manager.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.alert_manager.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alert syncer processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.alert_syncer.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.alert_syncer.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alerter processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.alerter.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.alerter.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of configuration syncer processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.configuration_syncer.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.configuration_syncer.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of discoverer processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.discoverer.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.discoverer.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of escalator processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.escalator.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.escalator.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of history syncer processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.history_syncer.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.history_syncer.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of housekeeper processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.housekeeper.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.housekeeper.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of http poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.http_poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.http_poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of icmp pinger processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.icmp_pinger.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.icmp_pinger.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi manager processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.ipmi_manager.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.ipmi_manager.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.ipmi_poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.ipmi_poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of java poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.java_poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.java_poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld manager processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.lld_manager.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.lld_manager.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld worker processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.lld_worker.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.lld_worker.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing worker processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.preprocessing_worker.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.preprocessing_worker.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing manager processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.preprocessing_manager.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.preprocessing_manager.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of proxy poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.proxy_poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.proxy_poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of self-monitoring processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.self-monitoring.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.self-monitoring.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of snmp trapper processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.snmp_trapper.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.snmp_trapper.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of task manager processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.task_manager.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.task_manager.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of timer processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.timer.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.timer.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of trapper processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.trapper.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.trapper.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of unreachable poller processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.unreachable_poller.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.unreachable_poller.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: Utilization of vmware collector processes over 75% |<p>-</p> |`{TEMPLATE_NAME:process.vmware_collector.avg.busy.avg(10m)}>75`<p>Recovery expression:</p>`{TEMPLATE_NAME:process.vmware_collector.avg.busy.avg(10m)}<65` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the configuration cache |<p>Consider increasing CacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:rcache.buffer.pused.max(10m)}>75` |AVERAGE | |
|Remote Zabbix server: More than 95% used in the value cache |<p>Consider increasing ValueCacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:vcache.buffer.pused.max(10m)}>95` |AVERAGE | |
|Remote Zabbix server: Zabbix value cache working in low memory mode |<p>Once the low memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p> |`{TEMPLATE_NAME:vcache.cache.mode.last()}=1` |HIGH | |
|Remote Zabbix server: Version has changed (new version: {ITEM.VALUE}) |<p>Remote Zabbix server version has changed. Ack to close.</p> |`{TEMPLATE_NAME:version.diff()}=1 and {TEMPLATE_NAME:version.strlen()}>0` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix server: More than 75% used in the vmware cache |<p>Consider increasing VMwareCacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:vmware.buffer.pused.max(10m)}>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history cache |<p>Consider increasing HistoryCacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:wcache.history.pused.max(10m)}>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history index cache |<p>Consider increasing HistoryIndexCacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:wcache.index.pused.max(10m)}>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the trends cache |<p>Consider increasing TrendCacheSize in the zabbix_server.conf configuration file</p> |`{TEMPLATE_NAME:wcache.trend.pused.max(10m)}>75` |AVERAGE | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

