// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/servicedirectory/v1beta1/registration_service.proto

package servicedirectory

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The request message for [RegistrationService.CreateNamespace][google.cloud.servicedirectory.v1beta1.RegistrationService.CreateNamespace].
type CreateNamespaceRequest struct {
	// Required. The resource name of the project and location the namespace
	// will be created in.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Resource ID must be 1-63 characters long, and comply with
	// <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters must
	// be a dash, lowercase letter, or digit, except the last character, which
	// cannot be a dash.
	NamespaceId string `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	// Required. A namespace with initial fields set.
	Namespace            *Namespace `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateNamespaceRequest) Reset()         { *m = CreateNamespaceRequest{} }
func (m *CreateNamespaceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNamespaceRequest) ProtoMessage()    {}
func (*CreateNamespaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{0}
}

func (m *CreateNamespaceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNamespaceRequest.Unmarshal(m, b)
}
func (m *CreateNamespaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNamespaceRequest.Marshal(b, m, deterministic)
}
func (m *CreateNamespaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNamespaceRequest.Merge(m, src)
}
func (m *CreateNamespaceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNamespaceRequest.Size(m)
}
func (m *CreateNamespaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNamespaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNamespaceRequest proto.InternalMessageInfo

func (m *CreateNamespaceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNamespaceRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *CreateNamespaceRequest) GetNamespace() *Namespace {
	if m != nil {
		return m.Namespace
	}
	return nil
}

// The request message for [RegistrationService.ListNamespaces][google.cloud.servicedirectory.v1beta1.RegistrationService.ListNamespaces].
type ListNamespacesRequest struct {
	// Required. The resource name of the project and location whose namespaces we'd like to
	// list.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to list result by.
	//
	// General filter string syntax:
	// <field> <operator> <value> (<logical connector>)
	// <field> can be "name", or "labels.<key>" for map field.
	// <operator> can be "<, >, <=, >=, !=, =, :". Of which ":" means HAS, and
	// is roughly the same as "=".
	// <value> must be the same data type as field.
	// <logical connector> can be "AND, OR, NOT".
	//
	// Examples of valid filters:
	// * "labels.owner" returns Namespaces that have a label with the key "owner"
	//   this is the same as "labels:owner".
	// * "labels.protocol=gRPC" returns Namespaces that have key/value
	//   "protocol=gRPC".
	// * "name>projects/my-project/locations/us-east/namespaces/namespace-c"
	//   returns Namespaces that have name that is alphabetically later than the
	//   string, so "namespace-e" will be returned but "namespace-a" will not be.
	// * "labels.owner!=sd AND labels.foo=bar" returns Namespaces that have
	//   "owner" in label key but value is not "sd" AND have key/value foo=bar.
	// * "doesnotexist.foo=bar" returns an empty list. Note that Namespace doesn't
	//   have a field called "doesnotexist". Since the filter does not match any
	//   Namespaces, it returns no results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The order to list result by.
	//
	// General order by string syntax:
	// <field> (<asc|desc>) (,)
	// <field> allows values {"name"}
	// <asc/desc> ascending or descending order by <field>. If this is left
	// blank, "asc" is used.
	// Note that an empty order_by string result in default order, which is order
	// by name in ascending order.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNamespacesRequest) Reset()         { *m = ListNamespacesRequest{} }
func (m *ListNamespacesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNamespacesRequest) ProtoMessage()    {}
func (*ListNamespacesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{1}
}

func (m *ListNamespacesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNamespacesRequest.Unmarshal(m, b)
}
func (m *ListNamespacesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNamespacesRequest.Marshal(b, m, deterministic)
}
func (m *ListNamespacesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNamespacesRequest.Merge(m, src)
}
func (m *ListNamespacesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNamespacesRequest.Size(m)
}
func (m *ListNamespacesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNamespacesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNamespacesRequest proto.InternalMessageInfo

func (m *ListNamespacesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNamespacesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNamespacesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNamespacesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNamespacesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// The response message for [RegistrationService.ListNamespaces][google.cloud.servicedirectory.v1beta1.RegistrationService.ListNamespaces].
type ListNamespacesResponse struct {
	// The list of namespaces.
	Namespaces []*Namespace `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNamespacesResponse) Reset()         { *m = ListNamespacesResponse{} }
func (m *ListNamespacesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNamespacesResponse) ProtoMessage()    {}
func (*ListNamespacesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{2}
}

func (m *ListNamespacesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNamespacesResponse.Unmarshal(m, b)
}
func (m *ListNamespacesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNamespacesResponse.Marshal(b, m, deterministic)
}
func (m *ListNamespacesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNamespacesResponse.Merge(m, src)
}
func (m *ListNamespacesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNamespacesResponse.Size(m)
}
func (m *ListNamespacesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNamespacesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNamespacesResponse proto.InternalMessageInfo

func (m *ListNamespacesResponse) GetNamespaces() []*Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *ListNamespacesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [RegistrationService.GetNamespace][google.cloud.servicedirectory.v1beta1.RegistrationService.GetNamespace].
type GetNamespaceRequest struct {
	// Required. The name of the namespace to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNamespaceRequest) Reset()         { *m = GetNamespaceRequest{} }
func (m *GetNamespaceRequest) String() string { return proto.CompactTextString(m) }
func (*GetNamespaceRequest) ProtoMessage()    {}
func (*GetNamespaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{3}
}

func (m *GetNamespaceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNamespaceRequest.Unmarshal(m, b)
}
func (m *GetNamespaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNamespaceRequest.Marshal(b, m, deterministic)
}
func (m *GetNamespaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceRequest.Merge(m, src)
}
func (m *GetNamespaceRequest) XXX_Size() int {
	return xxx_messageInfo_GetNamespaceRequest.Size(m)
}
func (m *GetNamespaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceRequest proto.InternalMessageInfo

func (m *GetNamespaceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [RegistrationService.UpdateNamespace][google.cloud.servicedirectory.v1beta1.RegistrationService.UpdateNamespace].
type UpdateNamespaceRequest struct {
	// Required. The updated namespace.
	Namespace *Namespace `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Required. List of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateNamespaceRequest) Reset()         { *m = UpdateNamespaceRequest{} }
func (m *UpdateNamespaceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNamespaceRequest) ProtoMessage()    {}
func (*UpdateNamespaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{4}
}

func (m *UpdateNamespaceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNamespaceRequest.Unmarshal(m, b)
}
func (m *UpdateNamespaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNamespaceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNamespaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNamespaceRequest.Merge(m, src)
}
func (m *UpdateNamespaceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNamespaceRequest.Size(m)
}
func (m *UpdateNamespaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNamespaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNamespaceRequest proto.InternalMessageInfo

func (m *UpdateNamespaceRequest) GetNamespace() *Namespace {
	if m != nil {
		return m.Namespace
	}
	return nil
}

func (m *UpdateNamespaceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [RegistrationService.DeleteNamespace][google.cloud.servicedirectory.v1beta1.RegistrationService.DeleteNamespace].
type DeleteNamespaceRequest struct {
	// Required. The name of the namespace to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNamespaceRequest) Reset()         { *m = DeleteNamespaceRequest{} }
func (m *DeleteNamespaceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNamespaceRequest) ProtoMessage()    {}
func (*DeleteNamespaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{5}
}

func (m *DeleteNamespaceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNamespaceRequest.Unmarshal(m, b)
}
func (m *DeleteNamespaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNamespaceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNamespaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNamespaceRequest.Merge(m, src)
}
func (m *DeleteNamespaceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNamespaceRequest.Size(m)
}
func (m *DeleteNamespaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNamespaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNamespaceRequest proto.InternalMessageInfo

func (m *DeleteNamespaceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [RegistrationService.CreateService][google.cloud.servicedirectory.v1beta1.RegistrationService.CreateService].
type CreateServiceRequest struct {
	// Required. The resource name of the namespace this service will belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Resource ID must be 1-63 characters long, and comply with
	// <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters must
	// be a dash, lowercase letter, or digit, except the last character, which
	// cannot be a dash.
	ServiceId string `protobuf:"bytes,2,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// Required. A service  with initial fields set.
	Service              *Service `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceRequest) Reset()         { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()    {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{6}
}

func (m *CreateServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceRequest.Unmarshal(m, b)
}
func (m *CreateServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceRequest.Merge(m, src)
}
func (m *CreateServiceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceRequest.Size(m)
}
func (m *CreateServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceRequest proto.InternalMessageInfo

func (m *CreateServiceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateServiceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *CreateServiceRequest) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

// The request message for [RegistrationService.ListServices][google.cloud.servicedirectory.v1beta1.RegistrationService.ListServices].
type ListServicesRequest struct {
	// Required. The resource name of the namespace whose services we'd
	// like to list.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to list result by.
	//
	// General filter string syntax:
	// <field> <operator> <value> (<logical connector>)
	// <field> can be "name", or "metadata.<key>" for map field.
	// <operator> can be "<, >, <=, >=, !=, =, :". Of which ":" means HAS, and
	// is roughly the same as "=".
	// <value> must be the same data type as field.
	// <logical connector> can be "AND, OR, NOT".
	//
	// Examples of valid filters:
	// * "metadata.owner" returns Services that have a label with the key "owner"
	//   this is the same as "metadata:owner".
	// * "metadata.protocol=gRPC" returns Services that have key/value
	//   "protocol=gRPC".
	// * "name>projects/my-project/locations/us-east/namespaces/my-namespace/services/service-c"
	//   returns Services that have name that is alphabetically later than the
	//   string, so "service-e" will be returned but "service-a" will not be.
	// * "metadata.owner!=sd AND metadata.foo=bar" returns Services that have
	//   "owner" in label key but value is not "sd" AND have key/value foo=bar.
	// * "doesnotexist.foo=bar" returns an empty list. Note that Service doesn't
	//   have a field called "doesnotexist". Since the filter does not match any
	//   Services, it returns no results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The order to list result by.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesRequest) Reset()         { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()    {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{7}
}

func (m *ListServicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesRequest.Unmarshal(m, b)
}
func (m *ListServicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesRequest.Marshal(b, m, deterministic)
}
func (m *ListServicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesRequest.Merge(m, src)
}
func (m *ListServicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListServicesRequest.Size(m)
}
func (m *ListServicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesRequest proto.InternalMessageInfo

func (m *ListServicesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListServicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServicesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListServicesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// The response message for [RegistrationService.ListServices][google.cloud.servicedirectory.v1beta1.RegistrationService.ListServices].
type ListServicesResponse struct {
	// The list of services.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesResponse) Reset()         { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()    {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{8}
}

func (m *ListServicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesResponse.Unmarshal(m, b)
}
func (m *ListServicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesResponse.Marshal(b, m, deterministic)
}
func (m *ListServicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesResponse.Merge(m, src)
}
func (m *ListServicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListServicesResponse.Size(m)
}
func (m *ListServicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesResponse proto.InternalMessageInfo

func (m *ListServicesResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ListServicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [RegistrationService.GetService][google.cloud.servicedirectory.v1beta1.RegistrationService.GetService].
// This should not be used for looking up a service. Insead, use the `resolve`
// method as it will contain all endpoints and associated metadata.
type GetServiceRequest struct {
	// Required. The name of the service to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceRequest) Reset()         { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()    {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{9}
}

func (m *GetServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceRequest.Unmarshal(m, b)
}
func (m *GetServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceRequest.Merge(m, src)
}
func (m *GetServiceRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceRequest.Size(m)
}
func (m *GetServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceRequest proto.InternalMessageInfo

func (m *GetServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [RegistrationService.UpdateService][google.cloud.servicedirectory.v1beta1.RegistrationService.UpdateService].
type UpdateServiceRequest struct {
	// Required. The updated service.
	Service *Service `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Required. List of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateServiceRequest) Reset()         { *m = UpdateServiceRequest{} }
func (m *UpdateServiceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceRequest) ProtoMessage()    {}
func (*UpdateServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{10}
}

func (m *UpdateServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceRequest.Unmarshal(m, b)
}
func (m *UpdateServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceRequest.Merge(m, src)
}
func (m *UpdateServiceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceRequest.Size(m)
}
func (m *UpdateServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceRequest proto.InternalMessageInfo

func (m *UpdateServiceRequest) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *UpdateServiceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [RegistrationService.DeleteService][google.cloud.servicedirectory.v1beta1.RegistrationService.DeleteService].
type DeleteServiceRequest struct {
	// Required. The name of the service to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceRequest) Reset()         { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()    {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{11}
}

func (m *DeleteServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceRequest.Unmarshal(m, b)
}
func (m *DeleteServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceRequest.Merge(m, src)
}
func (m *DeleteServiceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceRequest.Size(m)
}
func (m *DeleteServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceRequest proto.InternalMessageInfo

func (m *DeleteServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [RegistrationService.CreateEndpoint][google.cloud.servicedirectory.v1beta1.RegistrationService.CreateEndpoint].
type CreateEndpointRequest struct {
	// Required. The resource name of the service that this endpoint provides.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Resource ID must be 1-63 characters long, and comply with
	// <a href="https://www.ietf.org/rfc/rfc1035.txt" target="_blank">RFC1035</a>.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters must
	// be a dash, lowercase letter, or digit, except the last character, which
	// cannot be a dash.
	EndpointId string `protobuf:"bytes,2,opt,name=endpoint_id,json=endpointId,proto3" json:"endpoint_id,omitempty"`
	// Required. A endpoint with initial fields set.
	Endpoint             *Endpoint `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateEndpointRequest) Reset()         { *m = CreateEndpointRequest{} }
func (m *CreateEndpointRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEndpointRequest) ProtoMessage()    {}
func (*CreateEndpointRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{12}
}

func (m *CreateEndpointRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEndpointRequest.Unmarshal(m, b)
}
func (m *CreateEndpointRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEndpointRequest.Marshal(b, m, deterministic)
}
func (m *CreateEndpointRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEndpointRequest.Merge(m, src)
}
func (m *CreateEndpointRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEndpointRequest.Size(m)
}
func (m *CreateEndpointRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEndpointRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEndpointRequest proto.InternalMessageInfo

func (m *CreateEndpointRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEndpointRequest) GetEndpointId() string {
	if m != nil {
		return m.EndpointId
	}
	return ""
}

func (m *CreateEndpointRequest) GetEndpoint() *Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

// The request message for [RegistrationService.ListEndpoints][google.cloud.servicedirectory.v1beta1.RegistrationService.ListEndpoints].
type ListEndpointsRequest struct {
	// Required. The resource name of the service whose endpoints we'd like to
	// list.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to list result by.
	//
	// General filter string syntax:
	// <field> <operator> <value> (<logical connector>)
	// <field> can be "name", "address", "port" or "metadata.<key>" for map field.
	// <operator> can be "<, >, <=, >=, !=, =, :". Of which ":" means HAS, and
	// is roughly the same as "=".
	// <value> must be the same data type as field.
	// <logical connector> can be "AND, OR, NOT".
	//
	// Examples of valid filters:
	// * "metadata.owner" returns Endpoints that have a label with the key "owner"
	//   this is the same as "metadata:owner".
	// * "metadata.protocol=gRPC" returns Endpoints that have key/value
	//   "protocol=gRPC".
	// * "address=192.108.1.105" returns Endpoints that have this address.
	// * "port>8080" returns Endpoints that have port number larger than 8080.
	// * "name>projects/my-project/locations/us-east/namespaces/my-namespace/services/my-service/endpoints/endpoint-c"
	//   returns Endpoints that have name that is alphabetically later than the
	//   string, so "endpoint-e" will be returned but "endpoint-a" will not be.
	// * "metadata.owner!=sd AND metadata.foo=bar" returns Endpoints that have
	//   "owner" in label key but value is not "sd" AND have key/value foo=bar.
	// * "doesnotexist.foo=bar" returns an empty list. Note that Endpoint doesn't
	//   have a field called "doesnotexist". Since the filter does not match any
	//   Endpoints, it returns no results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The order to list result by.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEndpointsRequest) Reset()         { *m = ListEndpointsRequest{} }
func (m *ListEndpointsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEndpointsRequest) ProtoMessage()    {}
func (*ListEndpointsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{13}
}

func (m *ListEndpointsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEndpointsRequest.Unmarshal(m, b)
}
func (m *ListEndpointsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEndpointsRequest.Marshal(b, m, deterministic)
}
func (m *ListEndpointsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEndpointsRequest.Merge(m, src)
}
func (m *ListEndpointsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEndpointsRequest.Size(m)
}
func (m *ListEndpointsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEndpointsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEndpointsRequest proto.InternalMessageInfo

func (m *ListEndpointsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEndpointsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEndpointsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListEndpointsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListEndpointsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// The response message for [RegistrationService.ListEndpoints][google.cloud.servicedirectory.v1beta1.RegistrationService.ListEndpoints].
type ListEndpointsResponse struct {
	// The list of endpoints.
	Endpoints []*Endpoint `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEndpointsResponse) Reset()         { *m = ListEndpointsResponse{} }
func (m *ListEndpointsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEndpointsResponse) ProtoMessage()    {}
func (*ListEndpointsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{14}
}

func (m *ListEndpointsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEndpointsResponse.Unmarshal(m, b)
}
func (m *ListEndpointsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEndpointsResponse.Marshal(b, m, deterministic)
}
func (m *ListEndpointsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEndpointsResponse.Merge(m, src)
}
func (m *ListEndpointsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEndpointsResponse.Size(m)
}
func (m *ListEndpointsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEndpointsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEndpointsResponse proto.InternalMessageInfo

func (m *ListEndpointsResponse) GetEndpoints() []*Endpoint {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *ListEndpointsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [RegistrationService.GetEndpoint][google.cloud.servicedirectory.v1beta1.RegistrationService.GetEndpoint].
// This should not be used to lookup endpoints at runtime. Instead, use
// the `resolve` method.
type GetEndpointRequest struct {
	// Required. The name of the endpoint to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEndpointRequest) Reset()         { *m = GetEndpointRequest{} }
func (m *GetEndpointRequest) String() string { return proto.CompactTextString(m) }
func (*GetEndpointRequest) ProtoMessage()    {}
func (*GetEndpointRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{15}
}

func (m *GetEndpointRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEndpointRequest.Unmarshal(m, b)
}
func (m *GetEndpointRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEndpointRequest.Marshal(b, m, deterministic)
}
func (m *GetEndpointRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEndpointRequest.Merge(m, src)
}
func (m *GetEndpointRequest) XXX_Size() int {
	return xxx_messageInfo_GetEndpointRequest.Size(m)
}
func (m *GetEndpointRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEndpointRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEndpointRequest proto.InternalMessageInfo

func (m *GetEndpointRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [RegistrationService.UpdateEndpoint][google.cloud.servicedirectory.v1beta1.RegistrationService.UpdateEndpoint].
type UpdateEndpointRequest struct {
	// Required. The updated endpoint.
	Endpoint *Endpoint `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Required. List of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEndpointRequest) Reset()         { *m = UpdateEndpointRequest{} }
func (m *UpdateEndpointRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEndpointRequest) ProtoMessage()    {}
func (*UpdateEndpointRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{16}
}

func (m *UpdateEndpointRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEndpointRequest.Unmarshal(m, b)
}
func (m *UpdateEndpointRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEndpointRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEndpointRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEndpointRequest.Merge(m, src)
}
func (m *UpdateEndpointRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEndpointRequest.Size(m)
}
func (m *UpdateEndpointRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEndpointRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEndpointRequest proto.InternalMessageInfo

func (m *UpdateEndpointRequest) GetEndpoint() *Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *UpdateEndpointRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [RegistrationService.DeleteEndpoint][google.cloud.servicedirectory.v1beta1.RegistrationService.DeleteEndpoint].
type DeleteEndpointRequest struct {
	// Required. The name of the endpoint to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEndpointRequest) Reset()         { *m = DeleteEndpointRequest{} }
func (m *DeleteEndpointRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEndpointRequest) ProtoMessage()    {}
func (*DeleteEndpointRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df30e8cd406c05e7, []int{17}
}

func (m *DeleteEndpointRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEndpointRequest.Unmarshal(m, b)
}
func (m *DeleteEndpointRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEndpointRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEndpointRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEndpointRequest.Merge(m, src)
}
func (m *DeleteEndpointRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEndpointRequest.Size(m)
}
func (m *DeleteEndpointRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEndpointRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEndpointRequest proto.InternalMessageInfo

func (m *DeleteEndpointRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateNamespaceRequest)(nil), "google.cloud.servicedirectory.v1beta1.CreateNamespaceRequest")
	proto.RegisterType((*ListNamespacesRequest)(nil), "google.cloud.servicedirectory.v1beta1.ListNamespacesRequest")
	proto.RegisterType((*ListNamespacesResponse)(nil), "google.cloud.servicedirectory.v1beta1.ListNamespacesResponse")
	proto.RegisterType((*GetNamespaceRequest)(nil), "google.cloud.servicedirectory.v1beta1.GetNamespaceRequest")
	proto.RegisterType((*UpdateNamespaceRequest)(nil), "google.cloud.servicedirectory.v1beta1.UpdateNamespaceRequest")
	proto.RegisterType((*DeleteNamespaceRequest)(nil), "google.cloud.servicedirectory.v1beta1.DeleteNamespaceRequest")
	proto.RegisterType((*CreateServiceRequest)(nil), "google.cloud.servicedirectory.v1beta1.CreateServiceRequest")
	proto.RegisterType((*ListServicesRequest)(nil), "google.cloud.servicedirectory.v1beta1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.cloud.servicedirectory.v1beta1.ListServicesResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "google.cloud.servicedirectory.v1beta1.GetServiceRequest")
	proto.RegisterType((*UpdateServiceRequest)(nil), "google.cloud.servicedirectory.v1beta1.UpdateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.cloud.servicedirectory.v1beta1.DeleteServiceRequest")
	proto.RegisterType((*CreateEndpointRequest)(nil), "google.cloud.servicedirectory.v1beta1.CreateEndpointRequest")
	proto.RegisterType((*ListEndpointsRequest)(nil), "google.cloud.servicedirectory.v1beta1.ListEndpointsRequest")
	proto.RegisterType((*ListEndpointsResponse)(nil), "google.cloud.servicedirectory.v1beta1.ListEndpointsResponse")
	proto.RegisterType((*GetEndpointRequest)(nil), "google.cloud.servicedirectory.v1beta1.GetEndpointRequest")
	proto.RegisterType((*UpdateEndpointRequest)(nil), "google.cloud.servicedirectory.v1beta1.UpdateEndpointRequest")
	proto.RegisterType((*DeleteEndpointRequest)(nil), "google.cloud.servicedirectory.v1beta1.DeleteEndpointRequest")
}

func init() {
	proto.RegisterFile("google/cloud/servicedirectory/v1beta1/registration_service.proto", fileDescriptor_df30e8cd406c05e7)
}

var fileDescriptor_df30e8cd406c05e7 = []byte{
	// 1644 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xb8, 0x5f, 0xc9, 0x4b, 0x93, 0x88, 0xc9, 0x07, 0xee, 0x16, 0xda, 0xb0, 0xd0, 0x92,
	0x98, 0xe0, 0x6d, 0x52, 0x2a, 0x81, 0xdb, 0xa0, 0x6c, 0x9a, 0x36, 0x4a, 0xd5, 0xd0, 0x60, 0xb7,
	0x15, 0xa4, 0x41, 0xd6, 0xc6, 0x9e, 0x38, 0x4b, 0x6c, 0xef, 0xb2, 0xbb, 0x49, 0x49, 0xa1, 0x17,
	0x8e, 0x1c, 0x38, 0xc0, 0x15, 0xc1, 0x0d, 0x24, 0x8a, 0x84, 0x04, 0xff, 0x00, 0x1c, 0xb8, 0xf4,
	0x82, 0x44, 0x7b, 0xa8, 0x2c, 0x21, 0x55, 0x80, 0x84, 0x28, 0x9c, 0x38, 0x21, 0x10, 0x12, 0xda,
	0xf9, 0xd8, 0xaf, 0x6c, 0xc8, 0xda, 0x71, 0x50, 0x4f, 0xd6, 0xce, 0x7b, 0xf3, 0x66, 0x7e, 0x6f,
	0x7e, 0xef, 0xf9, 0x37, 0xbb, 0x30, 0x59, 0x31, 0x8c, 0x4a, 0x95, 0x28, 0xa5, 0xaa, 0xb1, 0x56,
	0x56, 0x6c, 0x62, 0xad, 0xeb, 0x25, 0x52, 0xd6, 0x2d, 0x52, 0x72, 0x0c, 0x6b, 0x43, 0x59, 0x1f,
	0x5b, 0x22, 0x8e, 0x36, 0xa6, 0x58, 0xa4, 0xa2, 0xdb, 0x8e, 0xa5, 0x39, 0xba, 0x51, 0x2f, 0x72,
	0xaf, 0xac, 0x69, 0x19, 0x8e, 0x81, 0x8f, 0xb1, 0x08, 0x59, 0x1a, 0x21, 0x1b, 0x8d, 0x90, 0xe5,
	0x11, 0xa4, 0xc7, 0xf8, 0x42, 0x9a, 0xa9, 0x2b, 0x5a, 0xbd, 0x6e, 0x38, 0x34, 0x96, 0xcd, 0x82,
	0x48, 0x8f, 0x06, 0xac, 0xa5, 0xaa, 0x4e, 0xea, 0x0e, 0x37, 0x1c, 0x0d, 0x18, 0x96, 0x75, 0x52,
	0x2d, 0x17, 0x97, 0xc8, 0x8a, 0xb6, 0xae, 0x1b, 0x16, 0x77, 0x38, 0x14, 0x70, 0xb0, 0x88, 0x6d,
	0xac, 0x59, 0x62, 0x67, 0xd2, 0x73, 0xc9, 0xb0, 0x91, 0x7a, 0xd9, 0x34, 0x74, 0x6f, 0xc5, 0x53,
	0xc9, 0x66, 0xd5, 0xb5, 0x1a, 0xb1, 0x4d, 0xcd, 0x5b, 0xec, 0x64, 0xb2, 0x69, 0xa1, 0xdc, 0x49,
	0x47, 0xf8, 0x24, 0x5d, 0xab, 0x29, 0xeb, 0x63, 0xee, 0x4f, 0xd1, 0x34, 0xaa, 0x7a, 0x69, 0x83,
	0xdb, 0xa5, 0xb0, 0x3d, 0x64, 0x3b, 0xcc, 0x6d, 0xf4, 0x69, 0x69, 0x6d, 0x59, 0x21, 0x35, 0xd3,
	0x11, 0xc6, 0xa1, 0xa8, 0x91, 0xe5, 0xae, 0xa6, 0xd9, 0xab, 0xcc, 0x43, 0xbe, 0x87, 0x60, 0xf0,
	0xac, 0x45, 0x34, 0x87, 0xbc, 0x24, 0x90, 0xe4, 0xc9, 0x1b, 0x6b, 0xc4, 0x76, 0xb0, 0x0a, 0xfb,
	0x4d, 0xcd, 0x22, 0x75, 0x27, 0x8d, 0x86, 0xd0, 0x70, 0xe7, 0xd4, 0xc8, 0x7d, 0x35, 0xf5, 0x97,
	0xfa, 0x24, 0x3c, 0x51, 0x35, 0x4a, 0xfc, 0xd4, 0x58, 0x78, 0xcd, 0xd4, 0xed, 0x6c, 0xc9, 0xa8,
	0x29, 0x17, 0xb9, 0x21, 0xcf, 0x27, 0xe2, 0xe3, 0x70, 0xd0, 0x4b, 0x50, 0x51, 0x2f, 0xa7, 0x53,
	0x34, 0xd0, 0x9e, 0xfb, 0x6a, 0x2a, 0xdf, 0xe5, 0x19, 0x66, 0xcb, 0xb8, 0x00, 0x9d, 0xde, 0x63,
	0x7a, 0xcf, 0x10, 0x1a, 0xee, 0x1a, 0x3f, 0x91, 0x4d, 0x44, 0xa8, 0xac, 0xb7, 0x6d, 0x16, 0xd6,
	0x8f, 0x23, 0xff, 0x80, 0x60, 0xe0, 0xa2, 0x6e, 0x3b, 0x9e, 0x87, 0xdd, 0x46, 0x64, 0x43, 0xd0,
	0x69, 0x6a, 0x15, 0x52, 0xb4, 0xf5, 0x1b, 0x84, 0xc2, 0xda, 0xe7, 0xae, 0x8f, 0xf2, 0x1d, 0xee,
	0x68, 0x41, 0xbf, 0x41, 0xb0, 0x0c, 0x40, 0x3d, 0x1c, 0x63, 0x95, 0xd4, 0x29, 0xa8, 0x4e, 0xe6,
	0x42, 0x27, 0x5e, 0x76, 0x47, 0xf1, 0x61, 0xd8, 0xbf, 0xac, 0x57, 0x1d, 0x62, 0xa5, 0xf7, 0xfa,
	0x76, 0x3e, 0x84, 0x8f, 0x40, 0x87, 0x61, 0x95, 0x89, 0x55, 0x5c, 0xda, 0x48, 0xef, 0xf3, 0xcd,
	0x07, 0xe8, 0xe0, 0xd4, 0x86, 0xfc, 0x3e, 0x82, 0xc1, 0x28, 0x3e, 0xdb, 0x34, 0xea, 0x36, 0xc1,
	0xf3, 0x00, 0x5e, 0x1e, 0xec, 0x34, 0x1a, 0xda, 0xd3, 0x4a, 0x42, 0xf3, 0x81, 0x18, 0xf8, 0x38,
	0xf4, 0xd6, 0xc9, 0x9b, 0x4e, 0x31, 0x00, 0x89, 0x1e, 0x66, 0xbe, 0xdb, 0x1d, 0x9e, 0x17, 0x88,
	0xe4, 0x45, 0xe8, 0x9b, 0x21, 0xce, 0x26, 0x2e, 0x9d, 0x83, 0xbd, 0x6e, 0x30, 0x9e, 0xef, 0x31,
	0x9a, 0xef, 0x67, 0x60, 0x64, 0xd3, 0x26, 0x22, 0x69, 0xf7, 0xe3, 0xd0, 0xe9, 0xf2, 0x17, 0x08,
	0x06, 0xaf, 0x98, 0xe5, 0x38, 0xb6, 0x86, 0x28, 0x84, 0xda, 0x43, 0x21, 0x3c, 0x09, 0x5d, 0x6b,
	0x74, 0x39, 0x5a, 0x32, 0x14, 0x71, 0xd7, 0xb8, 0x24, 0xc2, 0x8a, 0xaa, 0xca, 0x9e, 0x77, 0xab,
	0x6a, 0x4e, 0xb3, 0x57, 0x59, 0x00, 0x60, 0x73, 0xdc, 0x01, 0xb9, 0x08, 0x83, 0xd3, 0xa4, 0x4a,
	0x62, 0x36, 0xdc, 0xa6, 0x94, 0xdc, 0x45, 0xd0, 0xcf, 0x0a, 0xb8, 0xc0, 0x66, 0x8a, 0xf8, 0xb3,
	0x11, 0x92, 0xb7, 0xb0, 0x82, 0x20, 0xbb, 0x0c, 0xc0, 0x27, 0x45, 0x8a, 0xb8, 0x93, 0x0f, 0xcf,
	0x96, 0xf1, 0x1c, 0x1c, 0xe0, 0x0f, 0xbc, 0x80, 0xb3, 0x09, 0xb3, 0xcf, 0xb7, 0xcd, 0x02, 0x8a,
	0x18, 0xf2, 0x4f, 0x08, 0xfa, 0x5c, 0x72, 0x73, 0xab, 0xbd, 0x0b, 0xa8, 0x1e, 0x82, 0x12, 0x7e,
	0x17, 0x41, 0x7f, 0x18, 0x25, 0x2f, 0xe0, 0x0b, 0xd0, 0xc1, 0x01, 0x89, 0xf2, 0x6d, 0x32, 0x9d,
	0x79, 0x6f, 0x7e, 0xe2, 0xd2, 0x7d, 0x05, 0x1e, 0x99, 0x21, 0x4e, 0x84, 0x45, 0x67, 0x43, 0x2c,
	0x55, 0x68, 0xb6, 0x47, 0xe0, 0xe9, 0xed, 0xb2, 0x2d, 0xa2, 0x30, 0x8e, 0x7e, 0x8a, 0xa0, 0x9f,
	0x95, 0x6d, 0x24, 0x7a, 0x80, 0x34, 0x68, 0xe7, 0xa4, 0x69, 0x43, 0xb9, 0x5e, 0x83, 0x7e, 0x56,
	0xae, 0xbb, 0x91, 0x86, 0x7b, 0x08, 0x06, 0x58, 0xa9, 0x9e, 0xe3, 0x5a, 0x43, 0x84, 0x9f, 0x89,
	0xb0, 0xba, 0xe9, 0x05, 0x04, 0xa7, 0x9f, 0x82, 0x2e, 0xa1, 0x63, 0x22, 0xa5, 0x0a, 0x62, 0x7c,
	0xb6, 0x8c, 0xe7, 0xa1, 0x43, 0x3c, 0xf1, 0x62, 0x55, 0x12, 0xe6, 0x5d, 0x6c, 0x9c, 0xc5, 0xf4,
	0xa2, 0xc8, 0x3f, 0x72, 0x22, 0x0b, 0xbb, 0xdd, 0x76, 0x64, 0x0f, 0x41, 0xb5, 0xbe, 0xc7, 0x05,
	0x45, 0x00, 0x24, 0x2f, 0xd7, 0x39, 0xe8, 0x14, 0xa9, 0x10, 0xf5, 0xda, 0x6c, 0x46, 0xf3, 0x7e,
	0x84, 0xc4, 0x15, 0xbb, 0x00, 0x78, 0x86, 0x38, 0x51, 0x32, 0x4d, 0x87, 0xb8, 0x7a, 0x82, 0x26,
	0x3c, 0x03, 0xc3, 0xdb, 0x25, 0xdc, 0x0b, 0xc3, 0xc8, 0x7a, 0x0b, 0xc1, 0x00, 0xab, 0xd9, 0x68,
	0xfc, 0x20, 0x7b, 0x50, 0x3b, 0xd8, 0xd3, 0x86, 0xba, 0x7d, 0x0d, 0x06, 0x58, 0xdd, 0xee, 0x4a,
	0x32, 0xc6, 0xbf, 0x1b, 0x82, 0xbe, 0x7c, 0xe0, 0xee, 0xc3, 0xc9, 0x89, 0x1f, 0x20, 0xe8, 0x8d,
	0xa8, 0x67, 0x3c, 0x91, 0x30, 0x19, 0xf1, 0xaa, 0x5b, 0x6a, 0x5a, 0xb4, 0xc8, 0xcb, 0x0d, 0xf5,
	0x71, 0x56, 0x24, 0xa3, 0x9e, 0x72, 0x19, 0x0d, 0xca, 0xee, 0x77, 0xee, 0xfc, 0xfc, 0x41, 0x6a,
	0x52, 0x3e, 0xe9, 0xdd, 0x3e, 0xde, 0x62, 0xee, 0x13, 0xa6, 0x65, 0xbc, 0x4e, 0x4a, 0x8e, 0xad,
	0x64, 0x14, 0x4f, 0xf9, 0x2a, 0x99, 0x9b, 0xfe, 0xa5, 0xc6, 0xce, 0x05, 0xc4, 0xd0, 0x1d, 0x04,
	0x3d, 0x61, 0xbd, 0x89, 0xcf, 0x24, 0xdc, 0x6c, 0xac, 0x0c, 0x97, 0x26, 0x5a, 0x9c, 0xcd, 0x8a,
	0x4e, 0x9e, 0x6e, 0xa8, 0xbc, 0x39, 0x50, 0x80, 0xa7, 0x70, 0x2b, 0x00, 0xf1, 0xd7, 0x08, 0x0e,
	0x06, 0x15, 0x2b, 0xce, 0x25, 0xdc, 0x55, 0x8c, 0xcc, 0x6d, 0xe1, 0xf0, 0xa6, 0x1a, 0x2a, 0xa5,
	0xd8, 0x66, 0x08, 0xee, 0xe8, 0x16, 0x00, 0x02, 0xfb, 0x57, 0x32, 0x37, 0xf1, 0xef, 0x08, 0x7a,
	0x23, 0xaa, 0x38, 0x31, 0x0b, 0xe3, 0xd5, 0x74, 0x0b, 0x40, 0x56, 0x1a, 0xea, 0x80, 0x4f, 0xbf,
	0x40, 0x39, 0x53, 0x64, 0x17, 0xc6, 0x27, 0xc2, 0xc8, 0xd8, 0x9d, 0x39, 0x31, 0xc6, 0x20, 0x0f,
	0x3f, 0x47, 0xd0, 0x1b, 0xd1, 0xd4, 0x89, 0xe1, 0xc6, 0x6b, 0x71, 0x69, 0x70, 0x53, 0xaf, 0x39,
	0xe7, 0xde, 0xa2, 0x23, 0xa7, 0x93, 0x69, 0xe9, 0x74, 0x7e, 0x45, 0xd0, 0x1d, 0x12, 0xe8, 0xf8,
	0x74, 0x53, 0x1d, 0x22, 0xac, 0x44, 0xa4, 0x26, 0x15, 0x92, 0xbc, 0xda, 0x50, 0x0f, 0xf1, 0xee,
	0xc0, 0x7d, 0x47, 0x7d, 0x2d, 0x4f, 0x71, 0xcd, 0xca, 0x2f, 0x26, 0x2c, 0x9c, 0x30, 0x32, 0xf1,
	0x12, 0xc3, 0xce, 0x79, 0x02, 0xec, 0x1e, 0x82, 0x83, 0x41, 0x3d, 0x9b, 0xb8, 0x98, 0x62, 0xa4,
	0xbe, 0x74, 0xba, 0xa5, 0xb9, 0xbc, 0x39, 0x5c, 0x0a, 0x37, 0x87, 0x49, 0xbc, 0x43, 0x8c, 0xf8,
	0x5b, 0x04, 0xe0, 0xcb, 0x63, 0xfc, 0x7c, 0xf2, 0x2e, 0xb1, 0xc3, 0x03, 0x9c, 0x0b, 0x72, 0x30,
	0x84, 0x23, 0x29, 0x07, 0x3d, 0x10, 0x2e, 0x1d, 0x7f, 0x43, 0xd0, 0x1d, 0xd2, 0xe2, 0x89, 0xe9,
	0x18, 0xa7, 0xe0, 0x9b, 0x46, 0x53, 0x6b, 0xa8, 0x7d, 0x82, 0x87, 0xd1, 0x26, 0xf1, 0xf2, 0xf8,
	0x79, 0x1f, 0x9c, 0x78, 0x43, 0xd6, 0x0a, 0x48, 0x9f, 0x90, 0x5f, 0x21, 0xe8, 0x0e, 0x09, 0xfa,
	0xc4, 0x68, 0xe3, 0xae, 0x01, 0x5b, 0xf6, 0x89, 0xf0, 0x19, 0x65, 0x76, 0x7a, 0x46, 0x7f, 0x23,
	0xe8, 0x09, 0x5f, 0x14, 0x12, 0xff, 0xd3, 0xc6, 0xde, 0x2f, 0xa4, 0x66, 0x05, 0x9a, 0x7c, 0xa3,
	0xa1, 0x1e, 0xe6, 0x5d, 0x43, 0xa8, 0xb4, 0xd1, 0xc0, 0xc5, 0x82, 0xe2, 0xbc, 0x2a, 0x5f, 0x68,
	0xa5, 0xa6, 0x82, 0x48, 0xbd, 0x97, 0xae, 0x76, 0xce, 0x57, 0x83, 0xbf, 0x20, 0xe8, 0x0e, 0xc9,
	0x6c, 0xdc, 0x4c, 0x27, 0x88, 0xde, 0x40, 0xa4, 0x33, 0xad, 0x4d, 0xe6, 0x7d, 0xe4, 0x5a, 0xb8,
	0x8f, 0x5c, 0xc4, 0x6d, 0xc4, 0x8c, 0xef, 0x22, 0xe8, 0x0a, 0x08, 0x78, 0xfc, 0x42, 0xf2, 0xa6,
	0xb2, 0xe3, 0x13, 0x7e, 0x35, 0x48, 0xd9, 0x10, 0xac, 0x16, 0x28, 0xeb, 0x63, 0x72, 0xe9, 0xfb,
	0x0f, 0x82, 0x9e, 0xf0, 0xd5, 0x21, 0x31, 0x7d, 0x63, 0x6f, 0x1c, 0xcd, 0x83, 0x7b, 0xbb, 0xa1,
	0xf6, 0x7b, 0xbc, 0x8d, 0xb6, 0x99, 0xe2, 0x78, 0xc1, 0x07, 0xeb, 0xbd, 0xf5, 0xdf, 0x29, 0xea,
	0x00, 0x81, 0xbf, 0x41, 0xd0, 0x13, 0xbe, 0x8d, 0x24, 0xc6, 0x1f, 0x7b, 0x89, 0xd9, 0xb2, 0xed,
	0x84, 0xcf, 0x30, 0xd3, 0xce, 0x33, 0xfc, 0x83, 0xc9, 0xe2, 0x59, 0xad, 0x36, 0x4f, 0xbf, 0x36,
	0x60, 0x59, 0xec, 0x41, 0xd7, 0x6a, 0xd9, 0x75, 0xca, 0x41, 0xcf, 0x28, 0xf6, 0x39, 0x10, 0xf1,
	0x61, 0x56, 0xf9, 0x13, 0x44, 0x37, 0xf8, 0x31, 0x92, 0xa7, 0xfd, 0x1d, 0x8a, 0x8f, 0x34, 0xc9,
	0xe4, 0x5f, 0x25, 0xb0, 0x5a, 0x0e, 0x65, 0x16, 0x2e, 0xcb, 0x97, 0x5a, 0x0b, 0x15, 0xfa, 0x9b,
	0x88, 0x44, 0xa5, 0xa0, 0x0b, 0xff, 0x05, 0xba, 0xf0, 0xbf, 0x82, 0xb6, 0x77, 0x05, 0x74, 0x24,
	0x2a, 0xfe, 0x28, 0x05, 0xf8, 0x32, 0xb1, 0xe9, 0x20, 0xb1, 0x6a, 0xba, 0x6d, 0xbb, 0x11, 0xf0,
	0x70, 0x04, 0xd6, 0x66, 0x17, 0x91, 0x80, 0x91, 0x04, 0x9e, 0xbc, 0x9b, 0x7e, 0xc9, 0x92, 0x72,
	0x0b, 0x05, 0xff, 0x3a, 0x9a, 0x4b, 0x8a, 0xb3, 0x29, 0xba, 0x9b, 0x9a, 0x05, 0xf9, 0x4a, 0x1b,
	0x52, 0x13, 0x1b, 0x5b, 0x2a, 0xdc, 0x56, 0x8f, 0x6e, 0xf3, 0xbe, 0xe0, 0x7b, 0x35, 0xbb, 0xe2,
	0x38, 0xa6, 0x9d, 0x53, 0x94, 0xeb, 0xd7, 0xaf, 0x47, 0x5f, 0x26, 0x68, 0x6b, 0xce, 0x0a, 0xfb,
	0x20, 0xf8, 0xac, 0x59, 0xd5, 0x9c, 0x65, 0xc3, 0xaa, 0x4d, 0x7d, 0x98, 0x82, 0x91, 0x92, 0x51,
	0x4b, 0xd6, 0x16, 0xa6, 0xd2, 0x31, 0x2f, 0x1f, 0xe6, 0xdd, 0x5e, 0x30, 0x8f, 0x16, 0xae, 0xf0,
	0x10, 0x15, 0xa3, 0xaa, 0xd5, 0x2b, 0x59, 0xc3, 0xaa, 0x28, 0x15, 0x52, 0xa7, 0x9d, 0x42, 0xf1,
	0x37, 0xb2, 0xcd, 0x07, 0xc9, 0xd3, 0x51, 0xc3, 0x9f, 0x08, 0x7d, 0x96, 0x3a, 0x36, 0xc3, 0x42,
	0x9f, 0xa5, 0xbb, 0xe3, 0xeb, 0x4e, 0x7b, 0xbb, 0xbb, 0x3a, 0x36, 0xe5, 0xce, 0xbd, 0x2d, 0xfc,
	0x16, 0xa9, 0xdf, 0x62, 0xd4, 0x6f, 0xf1, 0x2a, 0x5b, 0xe3, 0x41, 0x6a, 0x98, 0xf9, 0xe5, 0x72,
	0xd4, 0x31, 0x97, 0x8b, 0x7a, 0xe6, 0x72, 0xdc, 0x75, 0x69, 0x3f, 0xdd, 0xff, 0xc9, 0x7f, 0x03,
	0x00, 0x00, 0xff, 0xff, 0xf9, 0x13, 0x2c, 0x69, 0x98, 0x1e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RegistrationServiceClient is the client API for RegistrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RegistrationServiceClient interface {
	// Creates a namespace, and returns the new Namespace.
	CreateNamespace(ctx context.Context, in *CreateNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error)
	// Lists all namespaces.
	ListNamespaces(ctx context.Context, in *ListNamespacesRequest, opts ...grpc.CallOption) (*ListNamespacesResponse, error)
	// Gets a namespace.
	GetNamespace(ctx context.Context, in *GetNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error)
	// Updates a namespace.
	UpdateNamespace(ctx context.Context, in *UpdateNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error)
	// Deletes a namespace. This also deletes all services and endpoints in
	// the namespace.
	DeleteNamespace(ctx context.Context, in *DeleteNamespaceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a service, and returns the new Service.
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Lists all services belonging to a namespace.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets a service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Updates a service.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Deletes a service. This also deletes all endpoints associated with
	// the service.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a endpoint, and returns the new Endpoint.
	CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Lists all endpoints.
	ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error)
	// Gets a endpoint.
	GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Updates a endpoint.
	UpdateEndpoint(ctx context.Context, in *UpdateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Deletes a endpoint.
	DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the IAM Policy for a resource (namespace or service only).
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the IAM Policy for a resource (namespace or service only).
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests IAM permissions for a resource (namespace or service only).
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type registrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRegistrationServiceClient(cc grpc.ClientConnInterface) RegistrationServiceClient {
	return &registrationServiceClient{cc}
}

func (c *registrationServiceClient) CreateNamespace(ctx context.Context, in *CreateNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error) {
	out := new(Namespace)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateNamespace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) ListNamespaces(ctx context.Context, in *ListNamespacesRequest, opts ...grpc.CallOption) (*ListNamespacesResponse, error) {
	out := new(ListNamespacesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListNamespaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) GetNamespace(ctx context.Context, in *GetNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error) {
	out := new(Namespace)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetNamespace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) UpdateNamespace(ctx context.Context, in *UpdateNamespaceRequest, opts ...grpc.CallOption) (*Namespace, error) {
	out := new(Namespace)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateNamespace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) DeleteNamespace(ctx context.Context, in *DeleteNamespaceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteNamespace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error) {
	out := new(ListEndpointsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListEndpoints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) UpdateEndpoint(ctx context.Context, in *UpdateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registrationServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicedirectory.v1beta1.RegistrationService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistrationServiceServer is the server API for RegistrationService service.
type RegistrationServiceServer interface {
	// Creates a namespace, and returns the new Namespace.
	CreateNamespace(context.Context, *CreateNamespaceRequest) (*Namespace, error)
	// Lists all namespaces.
	ListNamespaces(context.Context, *ListNamespacesRequest) (*ListNamespacesResponse, error)
	// Gets a namespace.
	GetNamespace(context.Context, *GetNamespaceRequest) (*Namespace, error)
	// Updates a namespace.
	UpdateNamespace(context.Context, *UpdateNamespaceRequest) (*Namespace, error)
	// Deletes a namespace. This also deletes all services and endpoints in
	// the namespace.
	DeleteNamespace(context.Context, *DeleteNamespaceRequest) (*empty.Empty, error)
	// Creates a service, and returns the new Service.
	CreateService(context.Context, *CreateServiceRequest) (*Service, error)
	// Lists all services belonging to a namespace.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets a service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Updates a service.
	UpdateService(context.Context, *UpdateServiceRequest) (*Service, error)
	// Deletes a service. This also deletes all endpoints associated with
	// the service.
	DeleteService(context.Context, *DeleteServiceRequest) (*empty.Empty, error)
	// Creates a endpoint, and returns the new Endpoint.
	CreateEndpoint(context.Context, *CreateEndpointRequest) (*Endpoint, error)
	// Lists all endpoints.
	ListEndpoints(context.Context, *ListEndpointsRequest) (*ListEndpointsResponse, error)
	// Gets a endpoint.
	GetEndpoint(context.Context, *GetEndpointRequest) (*Endpoint, error)
	// Updates a endpoint.
	UpdateEndpoint(context.Context, *UpdateEndpointRequest) (*Endpoint, error)
	// Deletes a endpoint.
	DeleteEndpoint(context.Context, *DeleteEndpointRequest) (*empty.Empty, error)
	// Gets the IAM Policy for a resource (namespace or service only).
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the IAM Policy for a resource (namespace or service only).
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests IAM permissions for a resource (namespace or service only).
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedRegistrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRegistrationServiceServer struct {
}

func (*UnimplementedRegistrationServiceServer) CreateNamespace(ctx context.Context, req *CreateNamespaceRequest) (*Namespace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNamespace not implemented")
}
func (*UnimplementedRegistrationServiceServer) ListNamespaces(ctx context.Context, req *ListNamespacesRequest) (*ListNamespacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNamespaces not implemented")
}
func (*UnimplementedRegistrationServiceServer) GetNamespace(ctx context.Context, req *GetNamespaceRequest) (*Namespace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespace not implemented")
}
func (*UnimplementedRegistrationServiceServer) UpdateNamespace(ctx context.Context, req *UpdateNamespaceRequest) (*Namespace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNamespace not implemented")
}
func (*UnimplementedRegistrationServiceServer) DeleteNamespace(ctx context.Context, req *DeleteNamespaceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNamespace not implemented")
}
func (*UnimplementedRegistrationServiceServer) CreateService(ctx context.Context, req *CreateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateService not implemented")
}
func (*UnimplementedRegistrationServiceServer) ListServices(ctx context.Context, req *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedRegistrationServiceServer) GetService(ctx context.Context, req *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (*UnimplementedRegistrationServiceServer) UpdateService(ctx context.Context, req *UpdateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (*UnimplementedRegistrationServiceServer) DeleteService(ctx context.Context, req *DeleteServiceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}
func (*UnimplementedRegistrationServiceServer) CreateEndpoint(ctx context.Context, req *CreateEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEndpoint not implemented")
}
func (*UnimplementedRegistrationServiceServer) ListEndpoints(ctx context.Context, req *ListEndpointsRequest) (*ListEndpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEndpoints not implemented")
}
func (*UnimplementedRegistrationServiceServer) GetEndpoint(ctx context.Context, req *GetEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEndpoint not implemented")
}
func (*UnimplementedRegistrationServiceServer) UpdateEndpoint(ctx context.Context, req *UpdateEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEndpoint not implemented")
}
func (*UnimplementedRegistrationServiceServer) DeleteEndpoint(ctx context.Context, req *DeleteEndpointRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEndpoint not implemented")
}
func (*UnimplementedRegistrationServiceServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedRegistrationServiceServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedRegistrationServiceServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterRegistrationServiceServer(s *grpc.Server, srv RegistrationServiceServer) {
	s.RegisterService(&_RegistrationService_serviceDesc, srv)
}

func _RegistrationService_CreateNamespace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNamespaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).CreateNamespace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateNamespace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).CreateNamespace(ctx, req.(*CreateNamespaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_ListNamespaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNamespacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).ListNamespaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListNamespaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).ListNamespaces(ctx, req.(*ListNamespacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_GetNamespace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNamespaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).GetNamespace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetNamespace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).GetNamespace(ctx, req.(*GetNamespaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_UpdateNamespace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNamespaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).UpdateNamespace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateNamespace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).UpdateNamespace(ctx, req.(*UpdateNamespaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_DeleteNamespace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNamespaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).DeleteNamespace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteNamespace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).DeleteNamespace(ctx, req.(*DeleteNamespaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_CreateEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).CreateEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/CreateEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).CreateEndpoint(ctx, req.(*CreateEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_ListEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).ListEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/ListEndpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).ListEndpoints(ctx, req.(*ListEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_GetEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).GetEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).GetEndpoint(ctx, req.(*GetEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_UpdateEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).UpdateEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/UpdateEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).UpdateEndpoint(ctx, req.(*UpdateEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_DeleteEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).DeleteEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/DeleteEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).DeleteEndpoint(ctx, req.(*DeleteEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistrationService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistrationServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicedirectory.v1beta1.RegistrationService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistrationServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RegistrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.servicedirectory.v1beta1.RegistrationService",
	HandlerType: (*RegistrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateNamespace",
			Handler:    _RegistrationService_CreateNamespace_Handler,
		},
		{
			MethodName: "ListNamespaces",
			Handler:    _RegistrationService_ListNamespaces_Handler,
		},
		{
			MethodName: "GetNamespace",
			Handler:    _RegistrationService_GetNamespace_Handler,
		},
		{
			MethodName: "UpdateNamespace",
			Handler:    _RegistrationService_UpdateNamespace_Handler,
		},
		{
			MethodName: "DeleteNamespace",
			Handler:    _RegistrationService_DeleteNamespace_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _RegistrationService_CreateService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _RegistrationService_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _RegistrationService_GetService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _RegistrationService_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _RegistrationService_DeleteService_Handler,
		},
		{
			MethodName: "CreateEndpoint",
			Handler:    _RegistrationService_CreateEndpoint_Handler,
		},
		{
			MethodName: "ListEndpoints",
			Handler:    _RegistrationService_ListEndpoints_Handler,
		},
		{
			MethodName: "GetEndpoint",
			Handler:    _RegistrationService_GetEndpoint_Handler,
		},
		{
			MethodName: "UpdateEndpoint",
			Handler:    _RegistrationService_UpdateEndpoint_Handler,
		},
		{
			MethodName: "DeleteEndpoint",
			Handler:    _RegistrationService_DeleteEndpoint_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _RegistrationService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _RegistrationService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _RegistrationService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/servicedirectory/v1beta1/registration_service.proto",
}
