/* SPDX-License-Identifier: GPL-2.0 */
/*
 * ZynqMP Display Controller Driver - Register Definitions
 *
 * Copyright (C) 2017 - 2020 Xilinx, Inc.
 *
 * Authors:
 * - Hyun Woo Kwon <hyun.kwon@xilinx.com>
 * - Laurent Pinchart <laurent.pinchart@ideasonboard.com>
 */

#ifndef _ZYNQMP_DISP_REGS_H_
#define _ZYNQMP_DISP_REGS_H_

#include <linux/bits.h>

/* Blender registers */
#define ZYNQMP_DISP_V_BLEND_BG_CLR_0			0x0
#define ZYNQMP_DISP_V_BLEND_BG_CLR_1			0x4
#define ZYNQMP_DISP_V_BLEND_BG_CLR_2			0x8
#define ZYNQMP_DISP_V_BLEND_BG_MAX			0xfff
#define ZYNQMP_DISP_V_BLEND_SET_GLOBAL_ALPHA		0xc
#define ZYNQMP_DISP_V_BLEND_SET_GLOBAL_ALPHA_VALUE(n)	((n) << 1)
#define ZYNQMP_DISP_V_BLEND_SET_GLOBAL_ALPHA_EN		BIT(0)
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT		0x14
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_RGB		0x0
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_YCBCR444	0x1
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_YCBCR422	0x2
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_YONLY	0x3
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_XVYCC	0x4
#define ZYNQMP_DISP_V_BLEND_OUTPUT_VID_FMT_EN_DOWNSAMPLE	BIT(4)
#define ZYNQMP_DISP_V_BLEND_LAYER_CONTROL(n)		(0x18 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_LAYER_CONTROL_EN_US		BIT(0)
#define ZYNQMP_DISP_V_BLEND_LAYER_CONTROL_RGB		BIT(1)
#define ZYNQMP_DISP_V_BLEND_LAYER_CONTROL_BYPASS	BIT(8)
#define ZYNQMP_DISP_V_BLEND_NUM_COEFF			9
#define ZYNQMP_DISP_V_BLEND_NUM_OFFSET			3
#define ZYNQMP_DISP_V_BLEND_RGB2YCBCR_COEFF(n)		(0x20 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_IN1CSC_COEFF(n)		(0x44 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_IN1CSC_OFFSET(n)		(0x68 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_OUTCSC_OFFSET(n)		(0x74 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_IN2CSC_COEFF(n)		(0x80 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_IN2CSC_OFFSET(n)		(0xa4 + ((n) * 4))
#define ZYNQMP_DISP_V_BLEND_CHROMA_KEY_ENABLE		0x1d0
#define ZYNQMP_DISP_V_BLEND_CHROMA_KEY_COMP1		0x1d4
#define ZYNQMP_DISP_V_BLEND_CHROMA_KEY_COMP2		0x1d8
#define ZYNQMP_DISP_V_BLEND_CHROMA_KEY_COMP3		0x1dc

/* AV buffer manager registers */
#define ZYNQMP_DISP_AV_BUF_FMT				0x0
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_SHIFT		0
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_MASK		(0x1f << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_UYVY		(0 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_VYUY		(1 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YVYU		(2 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YUYV		(3 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16		(4 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV24		(5 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI		(6 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_MONO		(7 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI2		(8 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YUV444		(9 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_RGB888		(10 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_RGBA8880		(11 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_RGB888_10		(12 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YUV444_10		(13 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI2_10	(14 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI_10		(15 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16_10		(16 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV24_10		(17 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YONLY_10		(18 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16_420		(19 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI_420	(20 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI2_420	(21 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16_420_10	(22 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI_420_10	(23 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_VID_YV16CI2_420_10	(24 << 0)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_SHIFT		8
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_MASK		(0xf << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_RGBA8888		(0 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_ABGR8888		(1 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_RGB888		(2 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_BGR888		(3 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_RGBA5551		(4 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_RGBA4444		(5 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_RGB565		(6 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_8BPP		(7 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_4BPP		(8 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_2BPP		(9 << 8)
#define ZYNQMP_DISP_AV_BUF_FMT_NL_GFX_1BPP		(10 << 8)
#define ZYNQMP_DISP_AV_BUF_NON_LIVE_LATENCY		0x8
#define ZYNQMP_DISP_AV_BUF_CHBUF(n)			(0x10 + ((n) * 4))
#define ZYNQMP_DISP_AV_BUF_CHBUF_EN			BIT(0)
#define ZYNQMP_DISP_AV_BUF_CHBUF_FLUSH			BIT(1)
#define ZYNQMP_DISP_AV_BUF_CHBUF_BURST_LEN_SHIFT	2
#define ZYNQMP_DISP_AV_BUF_CHBUF_BURST_LEN_MASK		(0xf << 2)
#define ZYNQMP_DISP_AV_BUF_CHBUF_BURST_LEN_MAX		0xf
#define ZYNQMP_DISP_AV_BUF_CHBUF_BURST_LEN_AUD_MAX	0x3
#define ZYNQMP_DISP_AV_BUF_STATUS			0x28
#define ZYNQMP_DISP_AV_BUF_STC_CTRL			0x2c
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EN			BIT(0)
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EVENT_SHIFT		1
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EVENT_EX_VSYNC	0
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EVENT_EX_VID	1
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EVENT_EX_AUD	2
#define ZYNQMP_DISP_AV_BUF_STC_CTRL_EVENT_INT_VSYNC	3
#define ZYNQMP_DISP_AV_BUF_STC_INIT_VALUE0		0x30
#define ZYNQMP_DISP_AV_BUF_STC_INIT_VALUE1		0x34
#define ZYNQMP_DISP_AV_BUF_STC_ADJ			0x38
#define ZYNQMP_DISP_AV_BUF_STC_VID_VSYNC_TS0		0x3c
#define ZYNQMP_DISP_AV_BUF_STC_VID_VSYNC_TS1		0x40
#define ZYNQMP_DISP_AV_BUF_STC_EXT_VSYNC_TS0		0x44
#define ZYNQMP_DISP_AV_BUF_STC_EXT_VSYNC_TS1		0x48
#define ZYNQMP_DISP_AV_BUF_STC_CUSTOM_EVENT_TS0		0x4c
#define ZYNQMP_DISP_AV_BUF_STC_CUSTOM_EVENT_TS1		0x50
#define ZYNQMP_DISP_AV_BUF_STC_CUSTOM_EVENT2_TS0	0x54
#define ZYNQMP_DISP_AV_BUF_STC_CUSTOM_EVENT2_TS1	0x58
#define ZYNQMP_DISP_AV_BUF_STC_SNAPSHOT0		0x60
#define ZYNQMP_DISP_AV_BUF_STC_SNAPSHOT1		0x64
#define ZYNQMP_DISP_AV_BUF_OUTPUT			0x70
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_SHIFT		0
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_MASK		(0x3 << 0)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_LIVE		(0 << 0)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_MEM		(1 << 0)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_PATTERN		(2 << 0)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID1_NONE		(3 << 0)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_SHIFT		2
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_MASK		(0x3 << 2)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_DISABLE		(0 << 2)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_MEM		(1 << 2)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_LIVE		(2 << 2)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_VID2_NONE		(3 << 2)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_SHIFT		4
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_MASK		(0x3 << 4)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_PL		(0 << 4)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_MEM		(1 << 4)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_PATTERN		(2 << 4)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD1_DISABLE		(3 << 4)
#define ZYNQMP_DISP_AV_BUF_OUTPUT_AUD2_EN		BIT(6)
#define ZYNQMP_DISP_AV_BUF_HCOUNT_VCOUNT_INT0		0x74
#define ZYNQMP_DISP_AV_BUF_HCOUNT_VCOUNT_INT1		0x78
#define ZYNQMP_DISP_AV_BUF_PATTERN_GEN_SELECT		0x100
#define ZYNQMP_DISP_AV_BUF_CLK_SRC			0x120
#define ZYNQMP_DISP_AV_BUF_CLK_SRC_VID_FROM_PS		BIT(0)
#define ZYNQMP_DISP_AV_BUF_CLK_SRC_AUD_FROM_PS		BIT(1)
#define ZYNQMP_DISP_AV_BUF_CLK_SRC_VID_INTERNAL_TIMING	BIT(2)
#define ZYNQMP_DISP_AV_BUF_SRST_REG			0x124
#define ZYNQMP_DISP_AV_BUF_SRST_REG_VID_RST		BIT(1)
#define ZYNQMP_DISP_AV_BUF_AUDIO_CH_CONFIG		0x12c
#define ZYNQMP_DISP_AV_BUF_GFX_COMP_SF(n)		(0x200 + ((n) * 4))
#define ZYNQMP_DISP_AV_BUF_VID_COMP_SF(n)		(0x20c + ((n) * 4))
#define ZYNQMP_DISP_AV_BUF_LIVD_VID_COMP_SF(n)		(0x218 + ((n) * 4))
#define ZYNQMP_DISP_AV_BUF_LIVE_VID_CONFIG		0x224
#define ZYNQMP_DISP_AV_BUF_LIVD_GFX_COMP_SF(n)		(0x228 + ((n) * 4))
#define ZYNQMP_DISP_AV_BUF_LIVE_GFX_CONFIG		0x234
#define ZYNQMP_DISP_AV_BUF_4BIT_SF			0x11111
#define ZYNQMP_DISP_AV_BUF_5BIT_SF			0x10842
#define ZYNQMP_DISP_AV_BUF_6BIT_SF			0x10410
#define ZYNQMP_DISP_AV_BUF_8BIT_SF			0x10101
#define ZYNQMP_DISP_AV_BUF_10BIT_SF			0x10040
#define ZYNQMP_DISP_AV_BUF_NULL_SF			0
#define ZYNQMP_DISP_AV_BUF_NUM_SF			3
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_BPC_6		0x0
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_BPC_8		0x1
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_BPC_10		0x2
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_BPC_12		0x3
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_BPC_MASK		GENMASK(2, 0)
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_FMT_RGB		0x0
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_FMT_YUV444	0x1
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_FMT_YUV422	0x2
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_FMT_YONLY	0x3
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_FMT_MASK		GENMASK(5, 4)
#define ZYNQMP_DISP_AV_BUF_LIVE_CONFIG_CB_FIRST		BIT(8)
#define ZYNQMP_DISP_AV_BUF_PALETTE_MEMORY		0x400

/* Audio registers */
#define ZYNQMP_DISP_AUD_MIXER_VOLUME			0x0
#define ZYNQMP_DISP_AUD_MIXER_VOLUME_NO_SCALE		0x20002000
#define ZYNQMP_DISP_AUD_MIXER_META_DATA			0x4
#define ZYNQMP_DISP_AUD_CH_STATUS0			0x8
#define ZYNQMP_DISP_AUD_CH_STATUS1			0xc
#define ZYNQMP_DISP_AUD_CH_STATUS2			0x10
#define ZYNQMP_DISP_AUD_CH_STATUS3			0x14
#define ZYNQMP_DISP_AUD_CH_STATUS4			0x18
#define ZYNQMP_DISP_AUD_CH_STATUS5			0x1c
#define ZYNQMP_DISP_AUD_CH_A_DATA0			0x20
#define ZYNQMP_DISP_AUD_CH_A_DATA1			0x24
#define ZYNQMP_DISP_AUD_CH_A_DATA2			0x28
#define ZYNQMP_DISP_AUD_CH_A_DATA3			0x2c
#define ZYNQMP_DISP_AUD_CH_A_DATA4			0x30
#define ZYNQMP_DISP_AUD_CH_A_DATA5			0x34
#define ZYNQMP_DISP_AUD_CH_B_DATA0			0x38
#define ZYNQMP_DISP_AUD_CH_B_DATA1			0x3c
#define ZYNQMP_DISP_AUD_CH_B_DATA2			0x40
#define ZYNQMP_DISP_AUD_CH_B_DATA3			0x44
#define ZYNQMP_DISP_AUD_CH_B_DATA4			0x48
#define ZYNQMP_DISP_AUD_CH_B_DATA5			0x4c
#define ZYNQMP_DISP_AUD_SOFT_RESET			0xc00
#define ZYNQMP_DISP_AUD_SOFT_RESET_AUD_SRST		BIT(0)

#endif /* _ZYNQMP_DISP_REGS_H_ */
