/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingAdapter;
import android.databinding.BindingBuildInfo;
import android.databinding.BindingConversion;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.databinding.Untaggable;
import android.databinding.annotationprocessor.AnnotationUtil;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

public class ProcessMethodAdapters
extends ProcessDataBinding.ProcessingStep {
    @Override
    public boolean onHandleStep(RoundEnvironment roundEnv, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
        L.d("processing adapters", new Object[0]);
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        Preconditions.checkNotNull(modelAnalyzer, "Model analyzer should be initialized first");
        SetterStore store = SetterStore.get(modelAnalyzer);
        this.clearIncrementalClasses(roundEnv, store);
        this.addBindingAdapters(roundEnv, processingEnvironment, store);
        this.addRenamed(roundEnv, processingEnvironment, store);
        this.addConversions(roundEnv, processingEnvironment, store);
        this.addUntaggable(roundEnv, processingEnvironment, store);
        try {
            store.write(buildInfo.modulePackage(), processingEnvironment);
        }
        catch (IOException e) {
            L.e(e, "Could not write BindingAdapter intermediate file.", new Object[0]);
        }
        return true;
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private void addBindingAdapters(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingAdapter.class)) {
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                L.e("@BindingAdapter on invalid element: %s", element);
                continue;
            }
            BindingAdapter bindingAdapter = element.getAnnotation(BindingAdapter.class);
            ExecutableElement executableElement = (ExecutableElement)element;
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (bindingAdapter.value().length == 0) {
                L.e("@BindingAdapter requires at least one attribute. %s", element);
                continue;
            }
            int numAttributes = bindingAdapter.value().length;
            if (parameters.size() != numAttributes + 1) {
                L.e("@BindingAdapter does not take %d parameters: %s", numAttributes + 1, element);
                continue;
            }
            ProcessMethodAdapters.warnAttributeNamespaces(bindingAdapter.value());
            try {
                if (numAttributes == 1) {
                    String attribute = bindingAdapter.value()[0];
                    L.d("------------------ @BindingAdapter for %s", element);
                    store.addBindingAdapter(processingEnv, attribute, executableElement);
                    continue;
                }
                store.addBindingAdapter(processingEnv, bindingAdapter.value(), executableElement);
            }
            catch (IllegalArgumentException e) {
                L.e(e, "@BindingAdapter for duplicate View and parameter type: %s", element);
            }
        }
    }

    private static void warnAttributeNamespace(String attribute) {
        if (attribute.contains(":") && !attribute.startsWith("android:")) {
            L.w("Application namespace for attribute %s will be ignored.", attribute);
        }
    }

    private static void warnAttributeNamespaces(String[] attributes) {
        for (String attribute : attributes) {
            ProcessMethodAdapters.warnAttributeNamespace(attribute);
        }
    }

    private void addRenamed(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingMethods.class)) {
            BindingMethods bindingMethods = element.getAnnotation(BindingMethods.class);
            for (BindingMethod bindingMethod : bindingMethods.value()) {
                String type;
                String attribute = bindingMethod.attribute();
                String method = bindingMethod.method();
                ProcessMethodAdapters.warnAttributeNamespace(attribute);
                try {
                    type = bindingMethod.type().getCanonicalName();
                }
                catch (MirroredTypeException e) {
                    type = e.getTypeMirror().toString();
                }
                store.addRenamedMethod(attribute, type, method, (TypeElement)element);
            }
        }
    }

    private void addConversions(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingConversion.class)) {
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@BindingConversion is only allowed on public static methods: " + element);
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getParameters().size() != 1) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@BindingConversion method should have one parameter: " + element);
                continue;
            }
            if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@BindingConversion method must return a value: " + element);
                continue;
            }
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "added conversion: " + element);
            store.addConversionMethod(executableElement);
        }
    }

    private void addUntaggable(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, Untaggable.class)) {
            Untaggable untaggable = element.getAnnotation(Untaggable.class);
            store.addUntaggableTypes(untaggable.value(), (TypeElement)element);
        }
    }

    private void clearIncrementalClasses(RoundEnvironment roundEnv, SetterStore store) {
        HashSet<String> classes = new HashSet<String>();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingAdapter.class)) {
            TypeElement containingClass = (TypeElement)element.getEnclosingElement();
            classes.add(containingClass.getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingMethods.class)) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingConversion.class)) {
            classes.add(((TypeElement)element.getEnclosingElement()).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, Untaggable.class)) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        store.clear(classes);
    }
}

