/*
 * Copyright (c) 2021, 2023-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <cstddef>
#include <cstdint>

#if defined(ARM_COMPUTE_ENABLE_SVE)

namespace arm_conv {
namespace depthwise {

void sve_fp32_nhwc_3x3_s1_output4x4_mla_depthfirst_indirect_impl(
  const float *const *const input_ptrs,
  float *const *const outptrs,
  const void *params,
  unsigned int n_channels,
  const float activation_min,
  const float activation_max
)
{
  struct Args
  {
    float *const *outptrs;
    const void *params;
    const float min, max;
    const float *inptrs[36];

    Args(
      const float *const *const input_ptrs,
      float *const *const outptrs,
      const void *const params,
      const float min,
      const float max
    ) : outptrs(outptrs), params(params), min(min), max(max)
    {
      inptrs[0] = input_ptrs[14];
      inptrs[1] = input_ptrs[0];
      inptrs[2] = input_ptrs[5];
      inptrs[3] = input_ptrs[15];
      inptrs[4] = input_ptrs[30];
      inptrs[5] = input_ptrs[35];
      inptrs[6] = input_ptrs[20];
      inptrs[7] = input_ptrs[1];
      inptrs[8] = input_ptrs[4];
      inptrs[9] = input_ptrs[21];
      inptrs[10] = input_ptrs[6];
      inptrs[11] = input_ptrs[11];
      inptrs[12] = input_ptrs[24];
      inptrs[13] = input_ptrs[8];
      inptrs[14] = input_ptrs[29];
      inptrs[15] = input_ptrs[9];
      inptrs[16] = input_ptrs[31];
      inptrs[17] = input_ptrs[13];
      inptrs[18] = input_ptrs[34];
      inptrs[19] = input_ptrs[16];
      inptrs[20] = input_ptrs[2];
      inptrs[21] = input_ptrs[19];
      inptrs[22] = input_ptrs[3];
      inptrs[23] = input_ptrs[12];
      inptrs[24] = input_ptrs[22];
      inptrs[25] = input_ptrs[17];
      inptrs[26] = input_ptrs[18];
      inptrs[27] = input_ptrs[26];
      inptrs[28] = input_ptrs[23];
      inptrs[29] = input_ptrs[32];
      inptrs[30] = input_ptrs[27];
      inptrs[31] = input_ptrs[33];
      inptrs[32] = input_ptrs[7];
      inptrs[33] = input_ptrs[10];
      inptrs[34] = input_ptrs[25];
      inptrs[35] = input_ptrs[28];

    }
  };

  Args params_struct(input_ptrs, outptrs, params,
                     activation_min, activation_max);

  __asm__ __volatile__(
    "ptrue p3.b\n"
    "ldr x7, [%x[params_struct], %[offsetof_args_params]]\n"
    "add x8, %x[params_struct], %[offsetof_Args_inptrs]\n"
    "ldr x17, [%x[params_struct], %[offsetof_args_outptrs]]\n"
    "cntw x16\n"
    "mov x15, #0x0\n"
    "ldp x23, x22, [x8, #0x0]\n"
    "ldp x21, x20, [x8, #0x10]\n"
    "whilelt p2.s, XZR, %x[n_channels]\n"
    "ld1w { z22.s }, p3/Z, [x7]\n"
    "ld1w { z0.s }, p3/Z, [x7, #1, MUL VL]\n"
    "ld1w { z1.s }, p3/Z, [x7, #2, MUL VL]\n"
    "ld1w { z2.s }, p3/Z, [x7, #3, MUL VL]\n"
    "ld1w { z3.s }, p3/Z, [x7, #4, MUL VL]\n"
    "ld1w { z4.s }, p3/Z, [x7, #5, MUL VL]\n"
    "cmp x16, %x[n_channels]\n"
    "sub x14, XZR, x16\n"
    "ld1w { z5.s }, p3/Z, [x7, #6, MUL VL]\n"
    "ld1w { z6.s }, p3/Z, [x7, #7, MUL VL]\n"
    "addvl x7, x7, #16\n"
    "ld1rw { z19.s }, p3/Z, [%x[params_struct], %[offsetof_args_min]]\n"
    "ld1rw { z14.s }, p3/Z, [%x[params_struct], %[offsetof_args_max]]\n"
    "ld1w { z9.s }, p2/Z, [x23, x15, LSL #2]\n"
    "ld1w { z10.s }, p2/Z, [x22, x15, LSL #2]\n"
    "ld1w { z7.s }, p3/Z, [x7, #-8, MUL VL]\n"
    "ld1w { z8.s }, p3/Z, [x7, #-7, MUL VL]\n"
    "addvl x7, x7, #-6\n"
    "ld1w { z11.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ld1w { z12.s }, p2/Z, [x20, x15, LSL #2]\n"
    "bge 2f\n"
    "1:"  // Channel loop
    "movprfx z29, z22\n fmla z29.s, p3/M, z4.s, z9.s\n"
    "movprfx z18, z22\n fmla z18.s, p3/M, z8.s, z9.s\n"
    "ldr x27, [x8, #0x20]\n"
    "ldr x24, [x8, #0x30]\n"
    "movprfx z17, z22\n fmla z17.s, p3/M, z3.s, z9.s\n"
    "movprfx z26, z22\n fmla z26.s, p3/M, z1.s, z9.s\n"
    "ldr x23, [x8, #0x28]\n"
    "ldr x22, [x8, #0x38]\n"
    "movprfx z21, z22\n fmla z21.s, p3/M, z0.s, z9.s\n"
    "movprfx z28, z22\n fmla z28.s, p3/M, z7.s, z9.s\n"
    "ldr x26, [x8, #0x40]\n"
    "ldr x20, [x8, #0x48]\n"
    "movprfx z25, z22\n fmla z25.s, p3/M, z6.s, z9.s\n"
    "movprfx z30, z22\n fmla z30.s, p3/M, z5.s, z9.s\n"
    "ldr x25, [x8, #0x50]\n"
    "ldr x21, [x8, #0x58]\n"
    "fmla z29.s, p3/M, z5.s, z12.s\n"
    "movprfx z23, z22\n fmla z23.s, p3/M, z2.s, z9.s\n"
    "ld1w { z16.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x13, [x8, #0x70]\n"
    "fmla z18.s, p3/M, z0.s, z10.s\n"
    "movprfx z10, z22\n fmla z10.s, p3/M, z2.s, z11.s\n"
    "ld1w { z9.s }, p2/Z, [x27, x15, LSL #2]\n"
    "ld1w { z27.s }, p2/Z, [x23, x15, LSL #2]\n"
    "fmla z17.s, p3/M, z4.s, z12.s\n"
    "fmla z26.s, p3/M, z2.s, z12.s\n"
    "ldr x24, [x8, #0x60]\n"
    "ldr x23, [x8, #0x68]\n"
    "fmla z21.s, p3/M, z1.s, z12.s\n"
    "fmla z28.s, p3/M, z8.s, z12.s\n"
    "incw x14\n"
    "mov p1.b, p2.b\n"
    "fmla z25.s, p3/M, z7.s, z12.s\n"
    "movprfx z31, z22\n fmla z31.s, p3/M, z6.s, z9.s\n"
    "ld1w { z9.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x28, [x8, #0x88]\n"
    "fmla z29.s, p3/M, z7.s, z16.s\n"
    "fmla z10.s, p3/M, z6.s, z12.s\n"
    "ldr x12, [x17, #0x0]\n"
    "ldr x11, [x17, #0x8]\n"
    "movprfx z15, z22\n fmla z15.s, p3/M, z3.s, z12.s\n"
    "movprfx z20, z22\n fmla z20.s, p3/M, z0.s, z12.s\n"
    "ld1w { z11.s }, p2/Z, [x22, x15, LSL #2]\n"
    "ldr x22, [x8, #0x78]\n"
    "movprfx z24, z22\n fmla z24.s, p3/M, z8.s, z27.s\n"
    "fmla z17.s, p3/M, z6.s, z16.s\n"
    "ld1w { z12.s }, p2/Z, [x26, x15, LSL #2]\n"
    "ldr x20, [x8, #0x80]\n"
    "fmla z26.s, p3/M, z4.s, z16.s\n"
    "fmla z21.s, p3/M, z3.s, z16.s\n"
    "ldr x10, [x17, #0x10]\n"
    "ldr x9, [x17, #0x18]\n"
    "movprfx z13, z22\n fmla z13.s, p3/M, z1.s, z16.s\n"
    "movprfx z27, z22\n fmla z27.s, p3/M, z0.s, z16.s\n"
    "whilelt p0.s, x16, %x[n_channels]\n"
    "ld1w { z22.s }, p3/Z, [x7]\n"
    "fmla z30.s, p3/M, z8.s, z16.s\n"
    "fmla z23.s, p3/M, z5.s, z16.s\n"
    "fmla z31.s, p3/M, z2.s, z16.s\n"
    "fmla z18.s, p3/M, z1.s, z11.s\n"
    "ld1w { z16.s }, p2/Z, [x25, x15, LSL #2]\n"
    "ldr x27, [x8, #0x90]\n"
    "fmla z28.s, p3/M, z0.s, z11.s\n"
    "fmla z25.s, p3/M, z2.s, z12.s\n"
    "ld1w { z11.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x21, [x8, #0x98]\n"
    "fmla z29.s, p3/M, z8.s, z9.s\n"
    "fmla z10.s, p3/M, z1.s, z12.s\n"
    "ld1w { z12.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x26, [x8, #0xa0]\n"
    "fmla z17.s, p3/M, z7.s, z9.s\n"
    "fmla z15.s, p3/M, z6.s, z9.s\n"
    "fmla z26.s, p3/M, z5.s, z9.s\n"
    "fmla z21.s, p3/M, z4.s, z9.s\n"
    "fmla z20.s, p3/M, z3.s, z9.s\n"
    "fmla z13.s, p3/M, z2.s, z9.s\n"
    "fmla z27.s, p3/M, z1.s, z9.s\n"
    "fmla z24.s, p3/M, z0.s, z9.s\n"
    "ld1w { z9.s }, p2/Z, [x23, x15, LSL #2]\n"
    "ldr x25, [x8, #0xa8]\n"
    "fmla z18.s, p3/M, z3.s, z16.s\n"
    "fmla z30.s, p3/M, z0.s, z16.s\n"
    "fmla z23.s, p3/M, z6.s, z12.s\n"
    "fmla z31.s, p3/M, z3.s, z12.s\n"
    "ld1w { z12.s }, p2/Z, [x13, x15, LSL #2]\n"
    "ldr x24, [x8, #0xb0]\n"
    "fmla z28.s, p3/M, z4.s, z9.s\n"
    "fmla z25.s, p3/M, z3.s, z9.s\n"
    "fmla z29.s, p3/M, z1.s, z9.s\n"
    "fmla z10.s, p3/M, z5.s, z11.s\n"
    "fmla z15.s, p3/M, z2.s, z11.s\n"
    "fmla z17.s, p3/M, z0.s, z9.s\n"
    "ld1w { z11.s }, p2/Z, [x22, x15, LSL #2]\n"
    "ldr x23, [x8, #0xb8]\n"
    "fmla z20.s, p3/M, z8.s, z12.s\n"
    "fmla z24.s, p3/M, z5.s, z12.s\n"
    "ld1w { z12.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x22, [x8, #0xc0]\n"
    "fmla z18.s, p3/M, z5.s, z9.s\n"
    "fmla z30.s, p3/M, z2.s, z9.s\n"
    "ld1w { z16.s }, p2/Z, [x28, x15, LSL #2]\n"
    "ldr x20, [x8, #0xc8]\n"
    "fmla z28.s, p3/M, z5.s, z11.s\n"
    "fmla z25.s, p3/M, z4.s, z11.s\n"
    "fmla z29.s, p3/M, z2.s, z11.s\n"
    "fmla z10.s, p3/M, z3.s, z11.s\n"
    "fmla z17.s, p3/M, z1.s, z11.s\n"
    "fmla z15.s, p3/M, z0.s, z11.s\n"
    "ld1w { z9.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x28, [x8, #0xd8]\n"
    "fmla z31.s, p3/M, z7.s, z12.s\n"
    "fmla z13.s, p3/M, z6.s, z12.s\n"
    "ld1w { z11.s }, p2/Z, [x27, x15, LSL #2]\n"
    "ldr x21, [x8, #0xd0]\n"
    "fmla z18.s, p3/M, z7.s, z16.s\n"
    "fmla z28.s, p3/M, z6.s, z16.s\n"
    "fmla z30.s, p3/M, z4.s, z16.s\n"
    "fmla z29.s, p3/M, z3.s, z16.s\n"
    "fmla z23.s, p3/M, z1.s, z16.s\n"
    "fmla z26.s, p3/M, z0.s, z16.s\n"
    "ld1w { z16.s }, p2/Z, [x26, x15, LSL #2]\n"
    "ldr x27, [x8, #0xe0]\n"
    "fmla z25.s, p3/M, z8.s, z9.s\n"
    "fmla z27.s, p3/M, z8.s, z11.s\n"
    "fmla z24.s, p3/M, z7.s, z11.s\n"
    "ld1w { z12.s }, p2/Z, [x25, x15, LSL #2]\n"
    "fmla z20.s, p3/M, z1.s, z9.s\n"
    "ldr x26, [x8, #0xe8]\n"
    "fmla z10.s, p3/M, z7.s, z9.s\n"
    "fmla z17.s, p3/M, z5.s, z9.s\n"
    "fmla z15.s, p3/M, z4.s, z9.s\n"
    "fmla z21.s, p3/M, z2.s, z9.s\n"
    "ld1w { z11.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x25, [x8, #0xf0]\n"
    "fmla z18.s, p3/M, z2.s, z16.s\n"
    "fmla z28.s, p3/M, z1.s, z16.s\n"
    "fmla z25.s, p3/M, z0.s, z16.s\n"
    "fmla z30.s, p3/M, z7.s, z12.s\n"
    "ld1w { z16.s }, p2/Z, [x23, x15, LSL #2]\n"
    "ldr x24, [x8, #0xf8]\n"
    "fmla z29.s, p3/M, z6.s, z12.s\n"
    "fmla z23.s, p3/M, z4.s, z12.s\n"
    "fmla z26.s, p3/M, z3.s, z12.s\n"
    "fmla z31.s, p3/M, z1.s, z12.s\n"
    "fmla z13.s, p3/M, z0.s, z12.s\n"
    "ld1w { z9.s }, p2/Z, [x22, x15, LSL #2]\n"
    "fmla z28.s, p3/M, z2.s, z11.s\n"
    "ldr x23, [x8, #0x100]\n"
    "fmla z25.s, p3/M, z1.s, z11.s\n"
    "fmla z10.s, p3/M, z0.s, z11.s\n"
    "ld1w { z11.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x20, [x8, #0x108]\n"
    "fmla z18.s, p3/M, z6.s, z16.s\n"
    "fmla z30.s, p3/M, z3.s, z16.s\n"
    "fmla z20.s, p3/M, z4.s, z9.s\n"
    "fmla z27.s, p3/M, z2.s, z9.s\n"
    "fmla z23.s, p3/M, z0.s, z16.s\n"
    "fmla z17.s, p3/M, z8.s, z9.s\n"
    "ld1w { z12.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x22, [x8, #0x110]\n"
    "fmla z15.s, p3/M, z7.s, z9.s\n"
    "fmla z21.s, p3/M, z5.s, z9.s\n"
    "fmla z24.s, p3/M, z1.s, z9.s\n"
    "ld1w { z16.s }, p2/Z, [x28, x15, LSL #2]\n"
    "fmla z10.s, p3/M, z8.s, z11.s\n"
    "ldr x21, [x8, #0x118]\n"
    "fmla z20.s, p3/M, z2.s, z11.s\n"
    "fmla z31.s, p3/M, z0.s, z12.s\n"
    "fmla z30.s, p3/M, z6.s, z12.s\n"
    "fmla z23.s, p3/M, z3.s, z12.s\n"
    "ld1w { z9.s }, p2/Z, [x26, x15, LSL #2]\n"
    "fmla z13.s, p3/M, z4.s, z16.s\n"
    "fmla z27.s, p3/M, z3.s, z16.s\n"
    "fmla z15.s, p3/M, z5.s, z11.s\n"
    "ld1w { z12.s }, p2/Z, [x27, x15, LSL #2]\n"
    "fmla z26.s, p3/M, z7.s, z16.s\n"
    "fmla z21.s, p3/M, z6.s, z16.s\n"
    "fmla z31.s, p3/M, z5.s, z16.s\n"
    "fmla z23.s, p3/M, z8.s, z16.s\n"
    "ld1w { z16.s }, p2/Z, [x25, x15, LSL #2]\n"
    "fmla z20.s, p3/M, z5.s, z12.s\n"
    "fmla z24.s, p3/M, z2.s, z12.s\n"
    "fmla z13.s, p3/M, z7.s, z9.s\n"
    "fmla z27.s, p3/M, z6.s, z9.s\n"
    "fmla z15.s, p3/M, z8.s, z12.s\n"
    "ld1w { z12.s }, p2/Z, [x24, x15, LSL #2]\n"
    "fmla z31.s, p3/M, z8.s, z9.s\n"
    "fmla z26.s, p3/M, z8.s, z16.s\n"
    "ld1w { z9.s }, p2/Z, [x23, x15, LSL #2]\n"
    "fmla z21.s, p3/M, z7.s, z16.s\n"
    "fmla z20.s, p3/M, z6.s, z16.s\n"
    "fmla z13.s, p3/M, z5.s, z16.s\n"
    "fmla z24.s, p3/M, z3.s, z16.s\n"
    "fmla z27.s, p3/M, z4.s, z16.s\n"
    "ld1w { z11.s }, p2/Z, [x20, x15, LSL #2]\n"
    "fmla z18.s, p3/M, z4.s, z9.s\n"
    "ldp x20, x26, [x8, #0x0]\n"
    "fmla z28.s, p3/M, z3.s, z9.s\n"
    "fmla z30.s, p3/M, z1.s, z9.s\n"
    "fmla z29.s, p3/M, z0.s, z9.s\n"
    "ld1w { z16.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ld1w { z0.s }, p3/Z, [x7, #1, MUL VL]\n"
    "fmla z25.s, p3/M, z5.s, z11.s\n"
    "fmla z10.s, p3/M, z4.s, z11.s\n"
    "fmla z13.s, p3/M, z8.s, z12.s\n"
    "ld1w { z9.s }, p0/Z, [x20, x16, LSL #2]\n"
    "fmla z27.s, p3/M, z7.s, z12.s\n"
    "fmla z24.s, p3/M, z6.s, z12.s\n"
    "ld1w { z12.s }, p2/Z, [x22, x15, LSL #2]\n"
    "fmax z18.s, p3/M, z18.s, z19.s\n"
    "fmla z17.s, p3/M, z2.s, z11.s\n"
    "fmla z15.s, p3/M, z1.s, z11.s\n"
    "fmax z28.s, p3/M, z28.s, z19.s\n"
    "fmax z30.s, p3/M, z30.s, z19.s\n"
    "fmax z25.s, p3/M, z25.s, z19.s\n"
    "fmla z21.s, p3/M, z8.s, z16.s\n"
    "fmla z20.s, p3/M, z7.s, z16.s\n"
    "fmax z29.s, p3/M, z29.s, z19.s\n"
    "fmax z10.s, p3/M, z10.s, z19.s\n"
    "fmla z23.s, p3/M, z7.s, z12.s\n"
    "fmla z26.s, p3/M, z6.s, z12.s\n"
    "fmin z18.s, p3/M, z18.s, z14.s\n"
    "fmin z28.s, p3/M, z28.s, z14.s\n"
    "fmla z31.s, p3/M, z4.s, z12.s\n"
    "fmla z13.s, p3/M, z3.s, z12.s\n"
    "ldp x25, x24, [x8, #0x10]\n"
    "fmin z25.s, p3/M, z25.s, z14.s\n"
    "fmax z17.s, p3/M, z17.s, z19.s\n"
    "fmla z27.s, p3/M, z5.s, z16.s\n"
    "fmla z24.s, p3/M, z4.s, z16.s\n"
    "fmin z10.s, p3/M, z10.s, z14.s\n"
    "fmax z15.s, p3/M, z15.s, z19.s\n"
    "st1w { z18.s }, p1, [x12, x14, LSL #2]\n"
    "ldr x23, [x17, #0x20]\n"
    "st1w { z28.s }, p1, [x11, x14, LSL #2]\n"
    "ldr x22, [x17, #0x28]\n"
    "fmin z30.s, p3/M, z30.s, z14.s\n"
    "fmin z29.s, p3/M, z29.s, z14.s\n"
    "st1w { z25.s }, p1, [x10, x14, LSL #2]\n"
    "ldr x21, [x17, #0x30]\n"
    "fmin z17.s, p3/M, z17.s, z14.s\n"
    "fmax z23.s, p3/M, z23.s, z19.s\n"
    "st1w { z10.s }, p1, [x9, x14, LSL #2]\n"
    "ldr x20, [x17, #0x38]\n"
    "fmin z15.s, p3/M, z15.s, z14.s\n"
    "fmax z26.s, p3/M, z26.s, z19.s\n"
    "fmax z21.s, p3/M, z21.s, z19.s\n"
    "fmax z20.s, p3/M, z20.s, z19.s\n"
    "st1w { z30.s }, p1, [x23, x14, LSL #2]\n"
    "ldr x23, [x17, #0x40]\n"
    "st1w { z29.s }, p1, [x22, x14, LSL #2]\n"
    "ldr x22, [x17, #0x48]\n"
    "incw x15\n"
    "ld1w { z10.s }, p0/Z, [x26, x16, LSL #2]\n"
    "st1w { z17.s }, p1, [x21, x14, LSL #2]\n"
    "ldr x21, [x17, #0x50]\n"
    "ld1w { z11.s }, p0/Z, [x25, x16, LSL #2]\n"
    "fmin z23.s, p3/M, z23.s, z14.s\n"
    "st1w { z15.s }, p1, [x20, x14, LSL #2]\n"
    "ldr x20, [x17, #0x58]\n"
    "ld1w { z12.s }, p0/Z, [x24, x16, LSL #2]\n"
    "incw x16\n"
    "fmin z26.s, p3/M, z26.s, z14.s\n"
    "fmin z21.s, p3/M, z21.s, z14.s\n"
    "ld1w { z1.s }, p3/Z, [x7, #2, MUL VL]\n"
    "ld1w { z2.s }, p3/Z, [x7, #3, MUL VL]\n"
    "fmin z20.s, p3/M, z20.s, z14.s\n"
    "fmax z31.s, p3/M, z31.s, z19.s\n"
    "st1w { z23.s }, p1, [x23, x14, LSL #2]\n"
    "ldr x23, [x17, #0x60]\n"
    "fmax z13.s, p3/M, z13.s, z19.s\n"
    "fmax z27.s, p3/M, z27.s, z19.s\n"
    "ld1w { z3.s }, p3/Z, [x7, #4, MUL VL]\n"
    "ld1w { z4.s }, p3/Z, [x7, #5, MUL VL]\n"
    "fmax z24.s, p3/M, z24.s, z19.s\n"
    "st1w { z26.s }, p1, [x22, x14, LSL #2]\n"
    "ldr x22, [x17, #0x68]\n"
    "ld1w { z5.s }, p3/Z, [x7, #6, MUL VL]\n"
    "st1w { z21.s }, p1, [x21, x14, LSL #2]\n"
    "ldr x21, [x17, #0x70]\n"
    "ld1w { z6.s }, p3/Z, [x7, #7, MUL VL]\n"
    "addvl x7, x7, #16\n"
    "st1w { z20.s }, p1, [x20, x14, LSL #2]\n"
    "ldr x20, [x17, #0x78]\n"
    "whilelt p2.s, x15, %x[n_channels]\n"
    "cmp x16, %x[n_channels]\n"
    "fmin z31.s, p3/M, z31.s, z14.s\n"
    "fmin z13.s, p3/M, z13.s, z14.s\n"
    "fmin z27.s, p3/M, z27.s, z14.s\n"
    "fmin z24.s, p3/M, z24.s, z14.s\n"
    "ld1w { z7.s }, p3/Z, [x7, #-8, MUL VL]\n"
    "ld1w { z8.s }, p3/Z, [x7, #-7, MUL VL]\n"
    "addvl x7, x7, #-6\n"
    "st1w { z31.s }, p1, [x23, x14, LSL #2]\n"
    "st1w { z13.s }, p1, [x22, x14, LSL #2]\n"
    "st1w { z27.s }, p1, [x21, x14, LSL #2]\n"
    "st1w { z24.s }, p1, [x20, x14, LSL #2]\n"
    "blt 1b\n"
    "2:"  // Channel tail
    "movprfx z16, z22\n fmla z16.s, p3/M, z4.s, z9.s\n"
    "movprfx z30, z22\n fmla z30.s, p3/M, z8.s, z9.s\n"
    "ldr x27, [x8, #0x20]\n"
    "ldr x24, [x8, #0x30]\n"
    "movprfx z13, z22\n fmla z13.s, p3/M, z3.s, z9.s\n"
    "movprfx z15, z22\n fmla z15.s, p3/M, z1.s, z9.s\n"
    "ldr x23, [x8, #0x28]\n"
    "ldr x22, [x8, #0x38]\n"
    "movprfx z20, z22\n fmla z20.s, p3/M, z0.s, z9.s\n"
    "movprfx z18, z22\n fmla z18.s, p3/M, z7.s, z9.s\n"
    "ldr x26, [x8, #0x40]\n"
    "ldr x21, [x8, #0x48]\n"
    "movprfx z26, z22\n fmla z26.s, p3/M, z6.s, z9.s\n"
    "movprfx z31, z22\n fmla z31.s, p3/M, z5.s, z9.s\n"
    "ldr x25, [x8, #0x50]\n"
    "ldr x20, [x8, #0x58]\n"
    "fmla z16.s, p3/M, z5.s, z12.s\n"
    "movprfx z28, z22\n fmla z28.s, p3/M, z2.s, z9.s\n"
    "ld1w { z27.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x13, [x8, #0x70]\n"
    "fmla z30.s, p3/M, z0.s, z10.s\n"
    "movprfx z29, z22\n fmla z29.s, p3/M, z2.s, z11.s\n"
    "ld1w { z17.s }, p2/Z, [x27, x15, LSL #2]\n"
    "ld1w { z24.s }, p2/Z, [x23, x15, LSL #2]\n"
    "fmla z13.s, p3/M, z4.s, z12.s\n"
    "fmla z15.s, p3/M, z2.s, z12.s\n"
    "ldr x24, [x8, #0x60]\n"
    "ldr x23, [x8, #0x68]\n"
    "fmla z20.s, p3/M, z1.s, z12.s\n"
    "fmla z18.s, p3/M, z8.s, z12.s\n"
    "incw x14\n"
    "mov p0.b, p2.b\n"
    "fmla z26.s, p3/M, z7.s, z12.s\n"
    "movprfx z9, z22\n fmla z9.s, p3/M, z6.s, z17.s\n"
    "ld1w { z10.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x28, [x8, #0x88]\n"
    "fmla z16.s, p3/M, z7.s, z27.s\n"
    "fmla z29.s, p3/M, z6.s, z12.s\n"
    "ldr x12, [x17, #0x0]\n"
    "ldr x11, [x17, #0x8]\n"
    "movprfx z11, z22\n fmla z11.s, p3/M, z3.s, z12.s\n"
    "movprfx z23, z22\n fmla z23.s, p3/M, z0.s, z12.s\n"
    "ld1w { z21.s }, p2/Z, [x22, x15, LSL #2]\n"
    "ldr x22, [x8, #0x78]\n"
    "movprfx z25, z22\n fmla z25.s, p3/M, z8.s, z24.s\n"
    "fmla z13.s, p3/M, z6.s, z27.s\n"
    "ld1w { z17.s }, p2/Z, [x26, x15, LSL #2]\n"
    "ldr x21, [x8, #0x80]\n"
    "fmla z15.s, p3/M, z4.s, z27.s\n"
    "fmla z20.s, p3/M, z3.s, z27.s\n"
    "ldr x10, [x17, #0x10]\n"
    "ldr x9, [x17, #0x18]\n"
    "movprfx z24, z22\n fmla z24.s, p3/M, z1.s, z27.s\n"
    "movprfx z12, z22\n fmla z12.s, p3/M, z0.s, z27.s\n"
    "fmla z31.s, p3/M, z8.s, z27.s\n"
    "fmla z28.s, p3/M, z5.s, z27.s\n"
    "fmla z9.s, p3/M, z2.s, z27.s\n"
    "fmla z30.s, p3/M, z1.s, z21.s\n"
    "ld1w { z27.s }, p2/Z, [x25, x15, LSL #2]\n"
    "ldr x27, [x8, #0x90]\n"
    "fmla z18.s, p3/M, z0.s, z21.s\n"
    "fmla z26.s, p3/M, z2.s, z17.s\n"
    "ld1w { z21.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x20, [x8, #0x98]\n"
    "fmla z16.s, p3/M, z8.s, z10.s\n"
    "fmla z29.s, p3/M, z1.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x26, [x8, #0xa0]\n"
    "fmla z13.s, p3/M, z7.s, z10.s\n"
    "fmla z11.s, p3/M, z6.s, z10.s\n"
    "fmla z15.s, p3/M, z5.s, z10.s\n"
    "fmla z20.s, p3/M, z4.s, z10.s\n"
    "fmla z23.s, p3/M, z3.s, z10.s\n"
    "fmla z24.s, p3/M, z2.s, z10.s\n"
    "fmla z12.s, p3/M, z1.s, z10.s\n"
    "fmla z25.s, p3/M, z0.s, z10.s\n"
    "ld1w { z22.s }, p2/Z, [x23, x15, LSL #2]\n"
    "ldr x25, [x8, #0xa8]\n"
    "fmla z30.s, p3/M, z3.s, z27.s\n"
    "fmla z31.s, p3/M, z0.s, z27.s\n"
    "fmla z28.s, p3/M, z6.s, z17.s\n"
    "fmla z9.s, p3/M, z3.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x13, x15, LSL #2]\n"
    "ldr x24, [x8, #0xb0]\n"
    "fmla z18.s, p3/M, z4.s, z22.s\n"
    "fmla z26.s, p3/M, z3.s, z22.s\n"
    "fmla z16.s, p3/M, z1.s, z22.s\n"
    "fmla z29.s, p3/M, z5.s, z21.s\n"
    "fmla z11.s, p3/M, z2.s, z21.s\n"
    "fmla z13.s, p3/M, z0.s, z22.s\n"
    "ld1w { z21.s }, p2/Z, [x22, x15, LSL #2]\n"
    "ldr x23, [x8, #0xb8]\n"
    "fmla z23.s, p3/M, z8.s, z17.s\n"
    "fmla z25.s, p3/M, z5.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x22, [x8, #0xc0]\n"
    "fmla z30.s, p3/M, z5.s, z22.s\n"
    "fmla z31.s, p3/M, z2.s, z22.s\n"
    "ld1w { z22.s }, p2/Z, [x28, x15, LSL #2]\n"
    "ldr x21, [x8, #0xc8]\n"
    "fmla z18.s, p3/M, z5.s, z21.s\n"
    "fmla z26.s, p3/M, z4.s, z21.s\n"
    "fmla z16.s, p3/M, z2.s, z21.s\n"
    "fmla z29.s, p3/M, z3.s, z21.s\n"
    "fmla z13.s, p3/M, z1.s, z21.s\n"
    "fmla z11.s, p3/M, z0.s, z21.s\n"
    "ld1w { z21.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x28, [x8, #0xd8]\n"
    "fmla z9.s, p3/M, z7.s, z17.s\n"
    "fmla z24.s, p3/M, z6.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x27, x15, LSL #2]\n"
    "ldr x20, [x8, #0xd0]\n"
    "fmla z30.s, p3/M, z7.s, z22.s\n"
    "fmla z18.s, p3/M, z6.s, z22.s\n"
    "fmla z31.s, p3/M, z4.s, z22.s\n"
    "fmla z16.s, p3/M, z3.s, z22.s\n"
    "fmla z28.s, p3/M, z1.s, z22.s\n"
    "fmla z15.s, p3/M, z0.s, z22.s\n"
    "ld1w { z22.s }, p2/Z, [x26, x15, LSL #2]\n"
    "ldr x27, [x8, #0xe0]\n"
    "fmla z26.s, p3/M, z8.s, z21.s\n"
    "fmla z12.s, p3/M, z8.s, z17.s\n"
    "fmla z25.s, p3/M, z7.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x25, x15, LSL #2]\n"
    "fmla z23.s, p3/M, z1.s, z21.s\n"
    "ldr x26, [x8, #0xe8]\n"
    "fmla z29.s, p3/M, z7.s, z21.s\n"
    "fmla z13.s, p3/M, z5.s, z21.s\n"
    "fmla z11.s, p3/M, z4.s, z21.s\n"
    "fmla z20.s, p3/M, z2.s, z21.s\n"
    "ld1w { z21.s }, p2/Z, [x24, x15, LSL #2]\n"
    "ldr x25, [x8, #0xf0]\n"
    "fmla z30.s, p3/M, z2.s, z22.s\n"
    "fmla z18.s, p3/M, z1.s, z22.s\n"
    "fmla z26.s, p3/M, z0.s, z22.s\n"
    "fmla z31.s, p3/M, z7.s, z17.s\n"
    "ld1w { z22.s }, p2/Z, [x23, x15, LSL #2]\n"
    "ldr x24, [x8, #0xf8]\n"
    "fmla z16.s, p3/M, z6.s, z17.s\n"
    "fmla z28.s, p3/M, z4.s, z17.s\n"
    "fmla z15.s, p3/M, z3.s, z17.s\n"
    "fmla z9.s, p3/M, z1.s, z17.s\n"
    "fmla z24.s, p3/M, z0.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x22, x15, LSL #2]\n"
    "fmla z18.s, p3/M, z2.s, z21.s\n"
    "ldr x23, [x8, #0x100]\n"
    "fmla z26.s, p3/M, z1.s, z21.s\n"
    "fmla z29.s, p3/M, z0.s, z21.s\n"
    "ld1w { z21.s }, p2/Z, [x21, x15, LSL #2]\n"
    "ldr x22, [x8, #0x108]\n"
    "fmla z30.s, p3/M, z6.s, z22.s\n"
    "fmla z31.s, p3/M, z3.s, z22.s\n"
    "fmla z23.s, p3/M, z4.s, z17.s\n"
    "fmla z12.s, p3/M, z2.s, z17.s\n"
    "fmla z28.s, p3/M, z0.s, z22.s\n"
    "fmla z13.s, p3/M, z8.s, z17.s\n"
    "ld1w { z22.s }, p2/Z, [x20, x15, LSL #2]\n"
    "ldr x21, [x8, #0x110]\n"
    "fmla z11.s, p3/M, z7.s, z17.s\n"
    "fmla z20.s, p3/M, z5.s, z17.s\n"
    "fmla z25.s, p3/M, z1.s, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x28, x15, LSL #2]\n"
    "fmla z29.s, p3/M, z8.s, z21.s\n"
    "ldr x20, [x8, #0x118]\n"
    "fmla z23.s, p3/M, z2.s, z21.s\n"
    "fmla z9.s, p3/M, z0.s, z22.s\n"
    "fmla z31.s, p3/M, z6.s, z22.s\n"
    "fmla z28.s, p3/M, z3.s, z22.s\n"
    "ld1w { z27.s }, p2/Z, [x26, x15, LSL #2]\n"
    "fmla z24.s, p3/M, z4.s, z17.s\n"
    "fmla z12.s, p3/M, z3.s, z17.s\n"
    "fmla z11.s, p3/M, z5.s, z21.s\n"
    "ld1w { z22.s }, p2/Z, [x27, x15, LSL #2]\n"
    "fmla z15.s, p3/M, z7.s, z17.s\n"
    "fmla z20.s, p3/M, z6.s, z17.s\n"
    "fmla z9.s, p3/M, z5.s, z17.s\n"
    "fmla z28.s, p3/M, z8.s, z17.s\n"
    "ld1w { z21.s }, p2/Z, [x25, x15, LSL #2]\n"
    "fmla z23.s, p3/M, z5.s, z22.s\n"
    "fmla z25.s, p3/M, z2.s, z22.s\n"
    "fmla z24.s, p3/M, z7.s, z27.s\n"
    "fmla z12.s, p3/M, z6.s, z27.s\n"
    "fmla z11.s, p3/M, z8.s, z22.s\n"
    "ld1w { z17.s }, p2/Z, [x24, x15, LSL #2]\n"
    "fmla z9.s, p3/M, z8.s, z27.s\n"
    "fmla z15.s, p3/M, z8.s, z21.s\n"
    "ld1w { z27.s }, p2/Z, [x23, x15, LSL #2]\n"
    "fmla z20.s, p3/M, z7.s, z21.s\n"
    "fmla z23.s, p3/M, z6.s, z21.s\n"
    "fmla z24.s, p3/M, z5.s, z21.s\n"
    "fmla z25.s, p3/M, z3.s, z21.s\n"
    "fmla z12.s, p3/M, z4.s, z21.s\n"
    "ld1w { z21.s }, p2/Z, [x22, x15, LSL #2]\n"
    "fmla z30.s, p3/M, z4.s, z27.s\n"
    "fmla z18.s, p3/M, z3.s, z27.s\n"
    "fmla z31.s, p3/M, z1.s, z27.s\n"
    "fmla z16.s, p3/M, z0.s, z27.s\n"
    "ld1w { z27.s }, p2/Z, [x20, x15, LSL #2]\n"
    "fmla z26.s, p3/M, z5.s, z21.s\n"
    "fmla z29.s, p3/M, z4.s, z21.s\n"
    "fmla z24.s, p3/M, z8.s, z17.s\n"
    "fmla z12.s, p3/M, z7.s, z17.s\n"
    "fmla z25.s, p3/M, z6.s, z17.s\n"
    "ld1w { z10.s }, p2/Z, [x21, x15, LSL #2]\n"
    "fmax z30.s, p3/M, z30.s, z19.s\n"
    "fmla z13.s, p3/M, z2.s, z21.s\n"
    "fmla z11.s, p3/M, z1.s, z21.s\n"
    "fmax z18.s, p3/M, z18.s, z19.s\n"
    "fmax z31.s, p3/M, z31.s, z19.s\n"
    "fmax z26.s, p3/M, z26.s, z19.s\n"
    "fmla z20.s, p3/M, z8.s, z27.s\n"
    "fmla z23.s, p3/M, z7.s, z27.s\n"
    "fmax z16.s, p3/M, z16.s, z19.s\n"
    "fmax z29.s, p3/M, z29.s, z19.s\n"
    "fmla z28.s, p3/M, z7.s, z10.s\n"
    "fmla z15.s, p3/M, z6.s, z10.s\n"
    "fmin z30.s, p3/M, z30.s, z14.s\n"
    "fmin z18.s, p3/M, z18.s, z14.s\n"
    "fmla z9.s, p3/M, z4.s, z10.s\n"
    "fmla z24.s, p3/M, z3.s, z10.s\n"
    "fmin z31.s, p3/M, z31.s, z14.s\n"
    "fmin z26.s, p3/M, z26.s, z14.s\n"
    "fmax z13.s, p3/M, z13.s, z19.s\n"
    "fmla z12.s, p3/M, z5.s, z27.s\n"
    "fmla z25.s, p3/M, z4.s, z27.s\n"
    "fmin z29.s, p3/M, z29.s, z14.s\n"
    "fmax z11.s, p3/M, z11.s, z19.s\n"
    "st1w { z30.s }, p0, [x12, x14, LSL #2]\n"
    "ldr x23, [x17, #0x20]\n"
    "st1w { z18.s }, p0, [x11, x14, LSL #2]\n"
    "ldr x22, [x17, #0x28]\n"
    "fmin z16.s, p3/M, z16.s, z14.s\n"
    "fmax z28.s, p3/M, z28.s, z19.s\n"
    "st1w { z26.s }, p0, [x10, x14, LSL #2]\n"
    "ldr x21, [x17, #0x30]\n"
    "fmin z13.s, p3/M, z13.s, z14.s\n"
    "fmax z15.s, p3/M, z15.s, z19.s\n"
    "st1w { z29.s }, p0, [x9, x14, LSL #2]\n"
    "ldr x20, [x17, #0x38]\n"
    "fmin z11.s, p3/M, z11.s, z14.s\n"
    "fmax z20.s, p3/M, z20.s, z19.s\n"
    "fmax z23.s, p3/M, z23.s, z19.s\n"
    "st1w { z31.s }, p0, [x23, x14, LSL #2]\n"
    "ldr x23, [x17, #0x40]\n"
    "fmin z28.s, p3/M, z28.s, z14.s\n"
    "st1w { z16.s }, p0, [x22, x14, LSL #2]\n"
    "ldr x22, [x17, #0x48]\n"
    "fmin z15.s, p3/M, z15.s, z14.s\n"
    "fmax z9.s, p3/M, z9.s, z19.s\n"
    "st1w { z13.s }, p0, [x21, x14, LSL #2]\n"
    "ldr x21, [x17, #0x50]\n"
    "fmin z20.s, p3/M, z20.s, z14.s\n"
    "fmax z24.s, p3/M, z24.s, z19.s\n"
    "st1w { z11.s }, p0, [x20, x14, LSL #2]\n"
    "ldr x20, [x17, #0x58]\n"
    "fmin z23.s, p3/M, z23.s, z14.s\n"
    "fmax z12.s, p3/M, z12.s, z19.s\n"
    "fmax z25.s, p3/M, z25.s, z19.s\n"
    "st1w { z28.s }, p0, [x23, x14, LSL #2]\n"
    "ldr x23, [x17, #0x60]\n"
    "fmin z9.s, p3/M, z9.s, z14.s\n"
    "st1w { z15.s }, p0, [x22, x14, LSL #2]\n"
    "ldr x22, [x17, #0x68]\n"
    "fmin z24.s, p3/M, z24.s, z14.s\n"
    "st1w { z20.s }, p0, [x21, x14, LSL #2]\n"
    "ldr x21, [x17, #0x70]\n"
    "fmin z12.s, p3/M, z12.s, z14.s\n"
    "st1w { z23.s }, p0, [x20, x14, LSL #2]\n"
    "ldr x20, [x17, #0x78]\n"
    "fmin z25.s, p3/M, z25.s, z14.s\n"
    "st1w { z9.s }, p0, [x23, x14, LSL #2]\n"
    "st1w { z24.s }, p0, [x22, x14, LSL #2]\n"
    "st1w { z12.s }, p0, [x21, x14, LSL #2]\n"
    "st1w { z25.s }, p0, [x20, x14, LSL #2]\n"
    :
    : [n_channels] "r" ((unsigned long) n_channels), [offsetof_Args_inptrs] "I" (offsetof(Args, inptrs)), [offsetof_args_max] "I" (offsetof(Args, max)), [offsetof_args_min] "I" (offsetof(Args, min)), [offsetof_args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_args_params] "I" (offsetof(Args, params)), [params_struct] "r" (&params_struct)
    : "cc", "memory", "p0", "p1", "p2", "p3", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SVE)
