info = {
    "name": "he",
    "date_order": "DMY",
    "january": [
        "ינואר",
        "ינו׳",
        "לינואר",
        "בינואר",
        "ינו"
    ],
    "february": [
        "פברואר",
        "פבר׳",
        "בפברואר",
        "לפברואר",
        "פבר"
    ],
    "march": [
        "מרץ",
        "במרץ",
        "למרץ",
        "מרס",
        "במרס",
        "למרס",
        "מארס",
        "במארס",
        "למארס"
    ],
    "april": [
        "אפריל",
        "אפר׳",
        "באפריל",
        "לאפריל",
        "אפר"
    ],
    "may": [
        "מאי",
        "במאי",
        "למאי"
    ],
    "june": [
        "יוני",
        "ביוני",
        "ליוני",
        "יונ"
    ],
    "july": [
        "יולי",
        "ביולי",
        "ליולי",
        "יול"
    ],
    "august": [
        "אוגוסט",
        "אוג׳",
        "באוגוסט",
        "לאוגוסט",
        "אוג"
    ],
    "september": [
        "ספטמבר",
        "ספט׳",
        "בספטמבר",
        "לספטמבר",
        "ספט"
    ],
    "october": [
        "אוקטובר",
        "אוק׳",
        "באוקטובר",
        "לאוקטובר",
        "אוק"
    ],
    "november": [
        "נובמבר",
        "נוב׳",
        "בנובמבר",
        "לנובמבר",
        "נוב"
    ],
    "december": [
        "דצמבר",
        "דצמ׳",
        "בדצמבר",
        "לדצמבר",
        "דצמ"
    ],
    "monday": [
        "יום שני",
        "יום ב׳",
        "שני",
        "יום ב"
    ],
    "tuesday": [
        "יום שלישי",
        "יום ג׳",
        "שלישי",
        "יום ג"
    ],
    "wednesday": [
        "יום רביעי",
        "יום ד׳",
        "רביעי",
        "יום ד"
    ],
    "thursday": [
        "יום חמישי",
        "יום ה׳",
        "חמישי",
        "יום ה"
    ],
    "friday": [
        "יום שישי",
        "יום ו׳",
        "שישי",
        "יום ו"
    ],
    "saturday": [
        "יום שבת",
        "שבת"
    ],
    "sunday": [
        "יום ראשון",
        "יום א׳",
        "ראשון",
        "יום א"
    ],
    "am": [
        "לפנה״צ"
    ],
    "pm": [
        "אחה״צ"
    ],
    "year": [
        "שנה",
        "שנ׳",
        "שנים",
        "בשנה"
    ],
    "month": [
        "חודש",
        "חו׳",
        "חודשים",
        "בחודש"
    ],
    "week": [
        "שבוע",
        "שב׳",
        "שבועות"
    ],
    "day": [
        "יום",
        "ימים",
        "ביום"
    ],
    "hour": [
        "שעה",
        "שע׳",
        "שעות"
    ],
    "minute": [
        "דקה",
        "דק׳",
        "דקות"
    ],
    "second": [
        "שנייה",
        "שנ׳",
        "שניה",
        "שניות"
    ],
    "relative-type": {
        "1 year ago": [
            "השנה שעברה"
        ],
        "0 year ago": [
            "השנה"
        ],
        "in 1 year": [
            "השנה הבאה"
        ],
        "1 month ago": [
            "החודש שעבר"
        ],
        "0 month ago": [
            "החודש"
        ],
        "in 1 month": [
            "החודש הבא"
        ],
        "1 week ago": [
            "השבוע שעבר"
        ],
        "0 week ago": [
            "השבוע"
        ],
        "in 1 week": [
            "השבוע הבא"
        ],
        "1 day ago": [
            "אתמול"
        ],
        "0 day ago": [
            "היום"
        ],
        "in 1 day": [
            "מחר"
        ],
        "0 hour ago": [
            "בשעה זו"
        ],
        "0 minute ago": [
            "בדקה זו"
        ],
        "0 second ago": [
            "עכשיו"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "בעוד (\\d+) שנים"
        ],
        "\\1 year ago": [
            "לפני (\\d+) שנים"
        ],
        "in \\1 month": [
            "בעוד (\\d+) חודשים",
            "בעוד (\\d+) חו׳"
        ],
        "\\1 month ago": [
            "לפני (\\d+) חודשים",
            "לפני (\\d+) חו׳"
        ],
        "in \\1 week": [
            "בעוד (\\d+) שבועות",
            "בעוד (\\d+) שב׳"
        ],
        "\\1 week ago": [
            "לפני (\\d+) שבועות",
            "לפני (\\d+) שב׳"
        ],
        "in \\1 day": [
            "בעוד יום (\\d+)",
            "בעוד (\\d+) ימים",
            "בעוד (\\d+) ימ׳"
        ],
        "\\1 day ago": [
            "לפני יום (\\d+)",
            "לפני (\\d+) ימים",
            "לפני (\\d+) ימ׳"
        ],
        "in \\1 hour": [
            "בעוד (\\d+) שעות",
            "בעוד (\\d+) שע׳"
        ],
        "\\1 hour ago": [
            "לפני (\\d+) שעות",
            "לפני (\\d+) שע׳"
        ],
        "in \\1 minute": [
            "בעוד (\\d+) דקות",
            "בעוד (\\d+) דק׳"
        ],
        "\\1 minute ago": [
            "לפני (\\d+) דקות",
            "לפני (\\d+) דק׳"
        ],
        "in \\1 second": [
            "בעוד (\\d+) שניות",
            "בעוד (\\d+) שנ׳"
        ],
        "\\1 second ago": [
            "לפני (\\d+) שניות",
            "לפני (\\d+) שנ׳"
        ]
    },
    "locale_specific": {},
    "sentence_splitter_group": 1,
    "skip": [
        "ה-",
        "ב-",
        "בשעה",
        "בסביבות",
        "בערך",
        "בקירוב",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "ago": [
        "לפני"
    ],
    "in": [
        "בעוד",
        "עוד"
    ],
    "simplifications": [
        {
            "ויום": "1 יום"
        },
        {
            "ושבוע": "1 שבוע"
        },
        {
            "וחודש": "1 חודש"
        },
        {
            "ושנה": "1 שנה"
        },
        {
            "ו(\\w+)": "\\1"
        },
        {
            "שנתיי?ם": "2 שנים"
        },
        {
            "חודשיים": "2 חודשים"
        },
        {
            "שבועיי?ם": "2 שבועות"
        },
        {
            "יומיי?ם": "2 ימים"
        },
        {
            "שעתיי?ם": "2 שעות"
        },
        {
            "שלשום": "2 ימים"
        },
        {
            "מחר": "בעוד 1 יום"
        },
        {
            "אחר חצות": "am"
        },
        {
            "חצות": "12 am"
        },
        {
            "לפנות בוקר": "am"
        },
        {
            "בבוקר": "am"
        },
        {
            "בצהריי?ם": "pm"
        },
        {
            "אחרי ה?צהריי?ם": "pm"
        },
        {
            "אחה\"צ": "pm"
        },
        {
            "לפנות ערב": "pm"
        },
        {
            "בערב": "pm"
        }
    ]
}
