% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{dbUnquoteIdentifier}
\alias{dbUnquoteIdentifier}
\title{Unquote identifiers}
\usage{
dbUnquoteIdentifier(conn, x, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{x}{An \link{SQL} or \link{Id} object.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbUnquoteIdentifier()} returns a list of objects
of the same length as the input.
For an empty character vector this function returns a length-0 object.
The names of the input argument are preserved in the output.
When passing the first element of a returned object again to
\code{dbUnquoteIdentifier()} as \code{x}
argument, it is returned unchanged (but wrapped in a list).
Passing objects of class \link{Id} should also return them unchanged (but wrapped in a list).
(For backends it may be most convenient to return \link{Id} objects
to achieve this behavior, but this is not required.)

An error is raised if plain character vectors are passed as the \code{x}
argument.
}
\description{
Call this method to convert a \link{SQL} object created by \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
back to a list of \link{Id} objects.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbUnquoteIdentifier")}
}
\section{Specification}{


For any character vector of length one, quoting (with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}})
then unquoting then quoting the first element is identical to just quoting.
This is also true for strings that
contain special characters such as a space,
a dot,
a comma,
or quotes used to mark strings
or identifiers,
if the database supports this.

Unquoting simple strings (consisting of only letters) wrapped with \code{\link[=SQL]{SQL()}}
and then quoting via \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} gives the same result as just
quoting the string.
Similarly, unquoting expressions of the form \code{SQL("schema.table")}
and then quoting gives the same result as quoting the identifier
constructed by \code{Id(schema = "schema", table = "table")}.

}

\examples{
# Unquoting allows to understand the structure of a
# possibly complex quoted identifier
dbUnquoteIdentifier(
  ANSI(),
  SQL(c('"Catalog"."Schema"."Table"', '"Schema"."Table"', '"UnqualifiedTable"'))
)

# The returned object is always a list,
# also for Id objects
dbUnquoteIdentifier(
  ANSI(),
  Id(catalog = "Catalog", schema = "Schema", table = "Table")
)

# Quoting is the inverse operation to unquoting the elements
# of the returned list
dbQuoteIdentifier(
  ANSI(),
  dbUnquoteIdentifier(ANSI(), SQL("UnqualifiedTable"))[[1]]
)

dbQuoteIdentifier(
  ANSI(),
  dbUnquoteIdentifier(ANSI(), Id(schema = "Schema", table = "Table"))[[1]]
)
}
\seealso{
Other DBIResult generics: 
\code{\link{DBIResult-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbColumnInfo}()},
\code{\link{dbFetch}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()}
}
\concept{DBIResult generics}
