/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/throwing_block_annotation.hpp
 *
 * $Id: throwing_block_annotation.hpp,v 1.11 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER
 * and @ref DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT 
 *
 * @test diagnostics/macros/throwing_block_annotation.t.cpp
 */
#ifndef DIAGNOSTICS__MACROS__THROWING_BLOCK_ANNOTATION_INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__THROWING_BLOCK_ANNOTATION_INCLUDE_GUARD

// ::diagnostics::logging_facility::log
#include <diagnostics/frame/logging_facility.hpp>

// DIAGNOSTICS_BASE_CONCAT
#include <diagnostics/util/preprocessor.hpp>

/**
 * @brief opens a @ref DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT
 */
#define DIAGNOSTICS_BASE_THROWING_BLOCK_ENTER \
     do { bool internal__caught_exception=false; \
       try { 


#define DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER(EXCEP,PRED,TAIL) \
                           (::std::string("EXPECTED.NAME=\"" #EXCEP "\" EXPECTED.PREDICATE=\"" #PRED "\" ") + TAIL)

#define DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER1(EXCEP,PRED) \
                           ("EXPECTED.NAME=\"" #EXCEP "\" EXPECTED.PREDICATE=\"" #PRED "\"")


#define DIAGNOSTICS_INTERNAL_THROWING_HANDLE_TE0(LEVEL,NR_WHAT,RETHROW,EXCEP,PRED) 

#define DIAGNOSTICS_INTERNAL_THROWING_HANDLE_TE1(LEVEL,NR_WHAT,RETHROW,EXCEP,PRED) \
    catch(::diagnostics::unittest::Test_Exception & e) { \
      DIAGNOSTICS_BASE_LOG(LEVEL, \
                           ::diagnostics::TYPE_WRONG_EXCEPTION, \
                           NR_WHAT, \
                           DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER(EXCEP,PRED,\
                           (::std::string("NAME=\"") + e.name() + "\" WHAT=\"" + e.what() + "\""))); \
      if(RETHROW) throw; else internal__caught_exception=true;  \
    } 


/**
 * @brief Closes a block which is expected to throw an exception of
 * type @a EXCEP.
 * 
 * If an exception of type @a EXCEP occurs which satisfies @a PRED,
 * no log message is generated.
 *
 * If an exception e of type @a EXCEP occurs which does not satisfy @a
 * PRED, then a (@a LEVEL, @ref diagnostics::TYPE_WRONG_EXCEPTION, @a NR_WHAT, 
 * EXPECTED.NAME="#EXCEP" EXPECTED.PREDICATE="#PRED" @a PRED_STR_WHAT(e)) is logged.
 *
 * If an exception e of a type not being convertible to @a EXCEP but
 * of type @a BASE occurs, a (@a LEVEL, @ref diagnostics::TYPE_WRONG_EXCEPTION, @a NR_WHAT, 
 * EXPECTED.NAME="#EXCEP" EXPECTED.PREDICATE="#PRED" @a STR_WHAT(e)) message is
 * logged.
 *
 * If an exception e of a type not being convertible to @a EXCEP and
 * not convertible to @a BASE occurs, a (@a LEVEL, @ref
 * diagnostics::TYPE_WRONG_EXCEPTION, @a NR_WHAT, 
 * EXPECTED.NAME="#EXCEP" EXPECTED.PREDICATE="#PRED") message is logged. 
 *
 * If an exception e of type @ref
 * diagnostics::unittest::Test_Exception is raised and @a
 * HANDLE_TE_EXLPLICITLY == 1) then a (@ a LEVEL, @ref
 * diagnostics::TYPE_WRONG_EXCEPTION, @a NR_WHAT, 
 * EXPECTED.NAME="#EXCEP" EXPECTED.PREDICATE="#PRED" NAME="e.name()" WHAT="e.what()"
 * message is logged.
 *
 * In all three of the above cases, if @a RETHROW is true, the
 * exception is rethrown, elsewise it is dropped.
 *
 * If no exception is raised, then (@a LEVEL, @ref
 * diagnostics::TYPE_MISSING_EXCEPTION, @a NR_WHAT
 * EXPECTED.NAME="#EXCEP" EXPECTED.PREDICATE="#PRED"
 * message is logged.
 */
#define DIAGNOSTICS_BASE_THROWING_BLOCK_EXIT(LEVEL,NR_WHAT,EXCEP,PRED,PRED_STR_WHAT,RETHROW,HANDLE_TE_EXLPLICITLY,BASE,STR_WHAT) \
    } \
    catch(EXCEP & e) { \
      if(!(PRED)) { \
        DIAGNOSTICS_BASE_LOG((LEVEL), \
                             ::diagnostics::TYPE_WRONG_EXCEPTION, \
                             (NR_WHAT), \
                             DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER(EXCEP,PRED,PRED_STR_WHAT(e))); \
        if(RETHROW) throw; else internal__caught_exception=true; \
      } \
      else { \
       if(RETHROW) throw; else internal__caught_exception=true;  \
      } \
    } \
    DIAGNOSTICS_BASE_CONCAT(DIAGNOSTICS_INTERNAL_THROWING_HANDLE_TE,HANDLE_TE_EXLPLICITLY)((LEVEL),(NR_WHAT),(RETHROW),EXCEP,PRED) \
    catch(BASE & e) { \
      DIAGNOSTICS_BASE_LOG((LEVEL), \
                           ::diagnostics::TYPE_WRONG_EXCEPTION, \
                           (NR_WHAT), \
                           DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER(EXCEP,PRED,STR_WHAT(e))); \
      if(RETHROW) throw; else internal__caught_exception=true; \
    } \
     catch(...) { \
      DIAGNOSTICS_BASE_LOG((LEVEL),::diagnostics::TYPE_WRONG_EXCEPTION,(NR_WHAT), \
                           DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER1(EXCEP,PRED)); \
      if(RETHROW) throw; else internal__caught_exception=true;  \
    } \
    if(!internal__caught_exception) { \
      DIAGNOSTICS_BASE_LOG((LEVEL),::diagnostics::TYPE_MISSING_EXCEPTION,(NR_WHAT), \
                           DIAGNOSTICS_INTERNAL_WHAT_STRING_BUILDER1(EXCEP,PRED)); \
    } } while(false)

#endif

// vim:ts=4:sw=4
