//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblockchain

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsortiumMember.
func (c *ConsortiumMember) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateModified":
			err = unpopulateTimeRFC3339(val, "DateModified", &c.DateModified)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "joinDate":
			err = unpopulateTimeRFC3339(val, "JoinDate", &c.JoinDate)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &c.Role)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &c.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Member.
func (m Member) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MemberProperties.
func (m MemberProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consortium", m.Consortium)
	populate(objectMap, "consortiumManagementAccountAddress", m.ConsortiumManagementAccountAddress)
	populate(objectMap, "consortiumManagementAccountPassword", m.ConsortiumManagementAccountPassword)
	populate(objectMap, "consortiumMemberDisplayName", m.ConsortiumMemberDisplayName)
	populate(objectMap, "consortiumRole", m.ConsortiumRole)
	populate(objectMap, "dns", m.DNS)
	populate(objectMap, "firewallRules", m.FirewallRules)
	populate(objectMap, "password", m.Password)
	populate(objectMap, "protocol", m.Protocol)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "publicKey", m.PublicKey)
	populate(objectMap, "rootContractAddress", m.RootContractAddress)
	populate(objectMap, "userName", m.UserName)
	populate(objectMap, "validatorNodesSku", m.ValidatorNodesSKU)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MemberPropertiesUpdate.
func (m MemberPropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consortiumManagementAccountPassword", m.ConsortiumManagementAccountPassword)
	populate(objectMap, "firewallRules", m.FirewallRules)
	populate(objectMap, "password", m.Password)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MemberUpdate.
func (m MemberUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TransactionNodeProperties.
func (t TransactionNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dns", t.DNS)
	populate(objectMap, "firewallRules", t.FirewallRules)
	populate(objectMap, "password", t.Password)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "publicKey", t.PublicKey)
	populate(objectMap, "userName", t.UserName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TransactionNodePropertiesUpdate.
func (t TransactionNodePropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "firewallRules", t.FirewallRules)
	populate(objectMap, "password", t.Password)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TransactionNodeUpdate.
func (t TransactionNodeUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
