//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlhsc

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ServerGroup.
func (s ServerGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerGroupConfiguration.
func (s ServerGroupConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerGroupConfigurationProperties.
func (s ServerGroupConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedValues", s.AllowedValues)
	populate(objectMap, "dataType", s.DataType)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "serverRoleGroupConfigurations", s.ServerRoleGroupConfigurations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerGroupForUpdate.
func (s ServerGroupForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerGroupProperties.
func (s ServerGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "availabilityZone", s.AvailabilityZone)
	populate(objectMap, "backupRetentionDays", s.BackupRetentionDays)
	populate(objectMap, "citusVersion", s.CitusVersion)
	populate(objectMap, "createMode", s.CreateMode)
	populate(objectMap, "delegatedSubnetArguments", s.DelegatedSubnetArguments)
	populateTimeRFC3339(objectMap, "earliestRestoreTime", s.EarliestRestoreTime)
	populate(objectMap, "enableMx", s.EnableMx)
	populate(objectMap, "enableShardsOnCoordinator", s.EnableShardsOnCoordinator)
	populate(objectMap, "enableZfs", s.EnableZfs)
	populate(objectMap, "maintenanceWindow", s.MaintenanceWindow)
	populateTimeRFC3339(objectMap, "pointInTimeUTC", s.PointInTimeUTC)
	populate(objectMap, "postgresqlVersion", s.PostgresqlVersion)
	populate(objectMap, "privateDnsZoneArguments", s.PrivateDNSZoneArguments)
	populate(objectMap, "readReplicas", s.ReadReplicas)
	populate(objectMap, "resourceProviderType", s.ResourceProviderType)
	populate(objectMap, "serverRoleGroups", s.ServerRoleGroups)
	populate(objectMap, "sourceLocation", s.SourceLocation)
	populate(objectMap, "sourceResourceGroupName", s.SourceResourceGroupName)
	populate(objectMap, "sourceServerGroup", s.SourceServerGroup)
	populate(objectMap, "sourceServerGroupName", s.SourceServerGroupName)
	populate(objectMap, "sourceSubscriptionId", s.SourceSubscriptionID)
	populate(objectMap, "standbyAvailabilityZone", s.StandbyAvailabilityZone)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerGroupProperties.
func (s *ServerGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &s.AdministratorLogin)
			delete(rawMsg, key)
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &s.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &s.AvailabilityZone)
			delete(rawMsg, key)
		case "backupRetentionDays":
			err = unpopulate(val, "BackupRetentionDays", &s.BackupRetentionDays)
			delete(rawMsg, key)
		case "citusVersion":
			err = unpopulate(val, "CitusVersion", &s.CitusVersion)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "delegatedSubnetArguments":
			err = unpopulate(val, "DelegatedSubnetArguments", &s.DelegatedSubnetArguments)
			delete(rawMsg, key)
		case "earliestRestoreTime":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreTime", &s.EarliestRestoreTime)
			delete(rawMsg, key)
		case "enableMx":
			err = unpopulate(val, "EnableMx", &s.EnableMx)
			delete(rawMsg, key)
		case "enableShardsOnCoordinator":
			err = unpopulate(val, "EnableShardsOnCoordinator", &s.EnableShardsOnCoordinator)
			delete(rawMsg, key)
		case "enableZfs":
			err = unpopulate(val, "EnableZfs", &s.EnableZfs)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &s.MaintenanceWindow)
			delete(rawMsg, key)
		case "pointInTimeUTC":
			err = unpopulateTimeRFC3339(val, "PointInTimeUTC", &s.PointInTimeUTC)
			delete(rawMsg, key)
		case "postgresqlVersion":
			err = unpopulate(val, "PostgresqlVersion", &s.PostgresqlVersion)
			delete(rawMsg, key)
		case "privateDnsZoneArguments":
			err = unpopulate(val, "PrivateDNSZoneArguments", &s.PrivateDNSZoneArguments)
			delete(rawMsg, key)
		case "readReplicas":
			err = unpopulate(val, "ReadReplicas", &s.ReadReplicas)
			delete(rawMsg, key)
		case "resourceProviderType":
			err = unpopulate(val, "ResourceProviderType", &s.ResourceProviderType)
			delete(rawMsg, key)
		case "serverRoleGroups":
			err = unpopulate(val, "ServerRoleGroups", &s.ServerRoleGroups)
			delete(rawMsg, key)
		case "sourceLocation":
			err = unpopulate(val, "SourceLocation", &s.SourceLocation)
			delete(rawMsg, key)
		case "sourceResourceGroupName":
			err = unpopulate(val, "SourceResourceGroupName", &s.SourceResourceGroupName)
			delete(rawMsg, key)
		case "sourceServerGroup":
			err = unpopulate(val, "SourceServerGroup", &s.SourceServerGroup)
			delete(rawMsg, key)
		case "sourceServerGroupName":
			err = unpopulate(val, "SourceServerGroupName", &s.SourceServerGroupName)
			delete(rawMsg, key)
		case "sourceSubscriptionId":
			err = unpopulate(val, "SourceSubscriptionID", &s.SourceSubscriptionID)
			delete(rawMsg, key)
		case "standbyAvailabilityZone":
			err = unpopulate(val, "StandbyAvailabilityZone", &s.StandbyAvailabilityZone)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerGroupPropertiesForUpdate.
func (s ServerGroupPropertiesForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "availabilityZone", s.AvailabilityZone)
	populate(objectMap, "backupRetentionDays", s.BackupRetentionDays)
	populate(objectMap, "citusVersion", s.CitusVersion)
	populate(objectMap, "enableShardsOnCoordinator", s.EnableShardsOnCoordinator)
	populate(objectMap, "maintenanceWindow", s.MaintenanceWindow)
	populate(objectMap, "postgresqlVersion", s.PostgresqlVersion)
	populate(objectMap, "serverRoleGroups", s.ServerRoleGroups)
	populate(objectMap, "standbyAvailabilityZone", s.StandbyAvailabilityZone)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerRoleGroup.
func (s ServerRoleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enableHa", s.EnableHa)
	populate(objectMap, "enablePublicIp", s.EnablePublicIP)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "role", s.Role)
	populate(objectMap, "serverCount", s.ServerCount)
	populate(objectMap, "serverEdition", s.ServerEdition)
	populate(objectMap, "serverNames", s.ServerNames)
	populate(objectMap, "storageQuotaInMb", s.StorageQuotaInMb)
	populate(objectMap, "vCores", s.VCores)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
