//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// HardwareComponentGroupsClient contains the methods for the HardwareComponentGroups group.
// Don't use this type directly, use NewHardwareComponentGroupsClient() instead.
type HardwareComponentGroupsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewHardwareComponentGroupsClient creates a new instance of HardwareComponentGroupsClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewHardwareComponentGroupsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*HardwareComponentGroupsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &HardwareComponentGroupsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginChangeControllerPowerState - Changes the power state of the controller.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// hardwareComponentGroupName - The hardware component group name.
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - The controller power state change request.
// options - HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions contains the optional parameters for the
// HardwareComponentGroupsClient.BeginChangeControllerPowerState method.
func (client *HardwareComponentGroupsClient) BeginChangeControllerPowerState(ctx context.Context, deviceName string, hardwareComponentGroupName string, resourceGroupName string, managerName string, parameters ControllerPowerStateChangeRequest, options *HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions) (*runtime.Poller[HardwareComponentGroupsClientChangeControllerPowerStateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.changeControllerPowerState(ctx, deviceName, hardwareComponentGroupName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[HardwareComponentGroupsClientChangeControllerPowerStateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[HardwareComponentGroupsClientChangeControllerPowerStateResponse](options.ResumeToken, client.pl, nil)
	}
}

// ChangeControllerPowerState - Changes the power state of the controller.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
func (client *HardwareComponentGroupsClient) changeControllerPowerState(ctx context.Context, deviceName string, hardwareComponentGroupName string, resourceGroupName string, managerName string, parameters ControllerPowerStateChangeRequest, options *HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions) (*http.Response, error) {
	req, err := client.changeControllerPowerStateCreateRequest(ctx, deviceName, hardwareComponentGroupName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// changeControllerPowerStateCreateRequest creates the ChangeControllerPowerState request.
func (client *HardwareComponentGroupsClient) changeControllerPowerStateCreateRequest(ctx context.Context, deviceName string, hardwareComponentGroupName string, resourceGroupName string, managerName string, parameters ControllerPowerStateChangeRequest, options *HardwareComponentGroupsClientBeginChangeControllerPowerStateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/hardwareComponentGroups/{hardwareComponentGroupName}/changeControllerPowerState"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{hardwareComponentGroupName}", hardwareComponentGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, runtime.MarshalAsJSON(req, parameters)
}

// NewListByDevicePager - Lists the hardware component groups at device-level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// resourceGroupName - The resource group name
// managerName - The manager name
// options - HardwareComponentGroupsClientListByDeviceOptions contains the optional parameters for the HardwareComponentGroupsClient.ListByDevice
// method.
func (client *HardwareComponentGroupsClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *HardwareComponentGroupsClientListByDeviceOptions) *runtime.Pager[HardwareComponentGroupsClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[HardwareComponentGroupsClientListByDeviceResponse]{
		More: func(page HardwareComponentGroupsClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *HardwareComponentGroupsClientListByDeviceResponse) (HardwareComponentGroupsClientListByDeviceResponse, error) {
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return HardwareComponentGroupsClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return HardwareComponentGroupsClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return HardwareComponentGroupsClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *HardwareComponentGroupsClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *HardwareComponentGroupsClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/hardwareComponentGroups"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *HardwareComponentGroupsClient) listByDeviceHandleResponse(resp *http.Response) (HardwareComponentGroupsClientListByDeviceResponse, error) {
	result := HardwareComponentGroupsClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HardwareComponentGroupList); err != nil {
		return HardwareComponentGroupsClientListByDeviceResponse{}, err
	}
	return result, nil
}
