//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstreamanalytics

import "time"

// AggregateFunctionProperties - The properties that are associated with an aggregate function.
type AggregateFunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string                `json:"type,omitempty"`
	Properties *FunctionConfiguration `json:"properties,omitempty"`

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type AggregateFunctionProperties.
func (a *AggregateFunctionProperties) GetFunctionProperties() *FunctionProperties {
	return &FunctionProperties{
		Type:       a.Type,
		Etag:       a.Etag,
		Properties: a.Properties,
	}
}

// AvroSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in Avro format.
type AvroSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType `json:"type,omitempty"`

	// The properties that are associated with the Avro serialization type. Required on PUT (CreateOrReplace) requests.
	Properties interface{} `json:"properties,omitempty"`
}

// GetSerialization implements the SerializationClassification interface for type AvroSerialization.
func (a *AvroSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: a.Type,
	}
}

// AzureDataLakeStoreOutputDataSource - Describes an Azure Data Lake Store output data source.
type AzureDataLakeStoreOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Azure Data Lake Store output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureDataLakeStoreOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureDataLakeStoreOutputDataSource.
func (a *AzureDataLakeStoreOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureDataLakeStoreOutputDataSourceProperties - The properties that are associated with an Azure Data Lake Store.
type AzureDataLakeStoreOutputDataSourceProperties struct {
	// The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`

	// The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
	FilePathPrefix *string `json:"filePathPrefix,omitempty"`

	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
	TenantID *string `json:"tenantId,omitempty"`

	// The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
}

// AzureFunctionOutputDataSource - Defines the metadata of AzureFunctionOutputDataSource
type AzureFunctionOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a Azure Function output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureFunctionOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureFunctionOutputDataSource.
func (a *AzureFunctionOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureFunctionOutputDataSourceProperties - The properties that are associated with an Azure Function output.
type AzureFunctionOutputDataSourceProperties struct {
	// If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
	APIKey *string `json:"apiKey,omitempty"`

	// The name of your Azure Functions app.
	FunctionAppName *string `json:"functionAppName,omitempty"`

	// The name of the function in your Azure Functions app.
	FunctionName *string `json:"functionName,omitempty"`

	// A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default
	// value is 100.
	MaxBatchCount *float32 `json:"maxBatchCount,omitempty"`

	// A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit
	// is in bytes. By default, this value is 262,144 bytes (256 KB).
	MaxBatchSize *float32 `json:"maxBatchSize,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBinding - The binding to an Azure Machine Learning web service.
type AzureMachineLearningWebServiceFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string `json:"type,omitempty"`

	// The binding properties associated with an Azure Machine learning web service.
	Properties *AzureMachineLearningWebServiceFunctionBindingProperties `json:"properties,omitempty"`
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type AzureMachineLearningWebServiceFunctionBinding.
func (a *AzureMachineLearningWebServiceFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: a.Type,
	}
}

// AzureMachineLearningWebServiceFunctionBindingProperties - The binding properties associated with an Azure Machine learning
// web service.
type AzureMachineLearningWebServiceFunctionBindingProperties struct {
	// The API key used to authenticate with Request-Response endpoint.
	APIKey *string `json:"apiKey,omitempty"`

	// Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
	BatchSize *int32 `json:"batchSize,omitempty"`

	// The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here:
	// https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	Endpoint *string `json:"endpoint,omitempty"`

	// The inputs for the Azure Machine Learning web service endpoint.
	Inputs *AzureMachineLearningWebServiceInputs `json:"inputs,omitempty"`

	// A list of outputs from the Azure Machine Learning web service endpoint execution.
	Outputs []*AzureMachineLearningWebServiceOutputColumn `json:"outputs,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties - The binding retrieval properties associated with an
// Azure Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingRetrievalProperties struct {
	// The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here:
	// https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	ExecuteEndpoint *string `json:"executeEndpoint,omitempty"`

	// The function type.
	UdfType *string `json:"udfType,omitempty"`
}

// AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default
// function definition for an Azure Machine Learning web service function.
type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string `json:"bindingType,omitempty"`

	// The binding retrieval properties associated with an Azure Machine learning web service.
	BindingRetrievalProperties *AzureMachineLearningWebServiceFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: a.BindingType,
	}
}

// AzureMachineLearningWebServiceInputColumn - Describes an input column for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputColumn struct {
	// The (Azure Machine Learning supported) data type of the input column. A list of valid Azure Machine Learning data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`

	// The zero based index of the function parameter this input maps to.
	MapTo *int32 `json:"mapTo,omitempty"`

	// The name of the input column.
	Name *string `json:"name,omitempty"`
}

// AzureMachineLearningWebServiceInputs - The inputs for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputs struct {
	// A list of input columns for the Azure Machine Learning web service endpoint.
	ColumnNames []*AzureMachineLearningWebServiceInputColumn `json:"columnNames,omitempty"`

	// The name of the input. This is the name provided while authoring the endpoint.
	Name *string `json:"name,omitempty"`
}

// AzureMachineLearningWebServiceOutputColumn - Describes an output column for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceOutputColumn struct {
	// The (Azure Machine Learning supported) data type of the output column. A list of valid Azure Machine Learning data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string `json:"dataType,omitempty"`

	// The name of the output column.
	Name *string `json:"name,omitempty"`
}

// AzureSQLDatabaseDataSourceProperties - The properties that are associated with an Azure SQL database data source.
type AzureSQLDatabaseDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`

	// Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float32 `json:"maxBatchCount,omitempty"`

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32 `json:"maxWriterCount,omitempty"`

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
}

// AzureSQLDatabaseOutputDataSource - Describes an Azure SQL database output data source.
type AzureSQLDatabaseOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Azure SQL database output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSQLDatabaseOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureSQLDatabaseOutputDataSource.
func (a *AzureSQLDatabaseOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureSQLDatabaseOutputDataSourceProperties - The properties that are associated with an Azure SQL database output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`

	// Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float32 `json:"maxBatchCount,omitempty"`

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32 `json:"maxWriterCount,omitempty"`

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
}

// AzureSQLReferenceInputDataSource - Describes an Azure SQL database reference input data source.
type AzureSQLReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with SQL DB input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSQLReferenceInputDataSourceProperties `json:"properties,omitempty"`
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type AzureSQLReferenceInputDataSource.
func (a *AzureSQLReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: a.Type,
	}
}

// AzureSQLReferenceInputDataSourceProperties - The properties that are associated with SQL DB input containing reference
// data. Required on PUT (CreateOrReplace) requests.
type AzureSQLReferenceInputDataSourceProperties struct {
	// This element is associated with the datasource element. This is the name of the database that output will be written to.
	Database *string `json:"database,omitempty"`

	// This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database.
	// To use this option, we recommend using temporal tables in Azure SQL
	// Database.
	DeltaSnapshotQuery *string `json:"deltaSnapshotQuery,omitempty"`

	// This element is associated with the datasource element. This query is used to fetch data from the sql database.
	FullSnapshotQuery *string `json:"fullSnapshotQuery,omitempty"`

	// This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database
	// instance.
	Password *string `json:"password,omitempty"`

	// This element is associated with the datasource element. This indicates how frequently the data will be fetched from the
	// database. It is of DateTime format.
	RefreshRate *string `json:"refreshRate,omitempty"`

	// Indicates the type of data refresh option.
	RefreshType *RefreshType `json:"refreshType,omitempty"`

	// This element is associated with the datasource element. This is the name of the server that contains the database that
	// will be written to.
	Server *string `json:"server,omitempty"`

	// This element is associated with the datasource element. The name of the table in the Azure SQL database..
	Table *string `json:"table,omitempty"`

	// This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database
	// instance.
	User *string `json:"user,omitempty"`
}

// AzureSynapseDataSourceProperties - The properties that are associated with an Azure SQL database data source.
type AzureSynapseDataSourceProperties struct {
	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
}

// AzureSynapseOutputDataSource - Describes an Azure Synapse output data source.
type AzureSynapseOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Azure Synapse output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSynapseOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureSynapseOutputDataSource.
func (a *AzureSynapseOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureSynapseOutputDataSourceProperties - The properties that are associated with an Azure Synapse output.
type AzureSynapseOutputDataSourceProperties struct {
	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string `json:"password,omitempty"`

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string `json:"server,omitempty"`

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string `json:"user,omitempty"`
}

// AzureTableOutputDataSource - Describes an Azure Table output data source.
type AzureTableOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Azure Table output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureTableOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureTableOutputDataSource.
func (a *AzureTableOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureTableOutputDataSourceProperties - The properties that are associated with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`

	// The number of rows to write to the Azure Table at a time.
	BatchSize *int32 `json:"batchSize,omitempty"`

	// If specified, each item in the array is the name of a column to remove (if present) from output event entities.
	ColumnsToRemove []*string `json:"columnsToRemove,omitempty"`

	// This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key
	// for the Azure Table. Required on PUT (CreateOrReplace) requests.
	PartitionKey *string `json:"partitionKey,omitempty"`

	// This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for
	// the Azure Table. Required on PUT (CreateOrReplace) requests.
	RowKey *string `json:"rowKey,omitempty"`

	// The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`
}

// BlobDataSourceProperties - The properties that are associated with a blob data source.
type BlobDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string `json:"pathPattern,omitempty"`

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobOutputDataSource - Describes a blob output data source.
type BlobOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a blob output. Required on PUT (CreateOrReplace) requests.
	Properties *BlobOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type BlobOutputDataSource.
func (b *BlobOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: b.Type,
	}
}

// BlobOutputDataSourceProperties - The properties that are associated with a blob output.
type BlobOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string `json:"pathPattern,omitempty"`

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobReferenceInputDataSource - Describes a blob input data source that contains reference data.
type BlobReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a blob input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *BlobReferenceInputDataSourceProperties `json:"properties,omitempty"`
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type BlobReferenceInputDataSource.
func (b *BlobReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: b.Type,
	}
}

// BlobReferenceInputDataSourceProperties - The properties that are associated with a blob input containing reference data.
type BlobReferenceInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string `json:"pathPattern,omitempty"`

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// BlobStreamInputDataSource - Describes a blob input data source that contains stream data.
type BlobStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a blob input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *BlobStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type BlobStreamInputDataSource.
func (b *BlobStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: b.Type,
	}
}

// BlobStreamInputDataSourceProperties - The properties that are associated with a blob input containing stream data.
type BlobStreamInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string `json:"container,omitempty"`

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string `json:"dateFormat,omitempty"`

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string `json:"pathPattern,omitempty"`

	// The partition count of the blob input data source. Range 1 - 1024.
	SourcePartitionCount *int32 `json:"sourcePartitionCount,omitempty"`

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string `json:"timeFormat,omitempty"`
}

// CSVSerialization - Describes how data from an input is serialized or how data is serialized when written to an output in
// CSV format.
type CSVSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType `json:"type,omitempty"`

	// The properties that are associated with the CSV serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *CSVSerializationProperties `json:"properties,omitempty"`
}

// GetSerialization implements the SerializationClassification interface for type CSVSerialization.
func (c *CSVSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: c.Type,
	}
}

// CSVSerializationProperties - The properties that are associated with the CSV serialization type.
type CSVSerializationProperties struct {
	// Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output.
	// Required on PUT (CreateOrReplace) requests.
	Encoding *Encoding `json:"encoding,omitempty"`

	// Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input
	// or
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required
	// on PUT (CreateOrReplace) requests.
	FieldDelimiter *string `json:"fieldDelimiter,omitempty"`
}

// Cluster - A Stream Analytics Cluster object
type Cluster struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties associated with a Stream Analytics cluster.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
	SKU *ClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The current entity tag for the cluster. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterInfo - The properties associated with a Stream Analytics cluster.
type ClusterInfo struct {
	// The resource id of cluster.
	ID *string `json:"id,omitempty"`
}

// ClusterJob - A streaming job.
type ClusterJob struct {
	// READ-ONLY; Resource ID of the streaming job.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The current execution state of the streaming job.
	JobState *JobState `json:"jobState,omitempty" azure:"ro"`

	// READ-ONLY; The number of streaming units that are used by the streaming job.
	StreamingUnits *int32 `json:"streamingUnits,omitempty" azure:"ro"`
}

// ClusterJobListResult - A list of streaming jobs. Populated by a List operation.
type ClusterJobListResult struct {
	// READ-ONLY; The URL to fetch the next set of streaming jobs.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of streaming jobs.
	Value []*ClusterJob `json:"value,omitempty" azure:"ro"`
}

// ClusterListResult - A list of clusters populated by a 'list' operation.
type ClusterListResult struct {
	// READ-ONLY; The URL to fetch the next set of clusters.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of clusters.
	Value []*Cluster `json:"value,omitempty" azure:"ro"`
}

// ClusterProperties - The properties associated with a Stream Analytics cluster.
type ClusterProperties struct {
	// READ-ONLY; Represents the number of streaming units currently being used on the cluster.
	CapacityAllocated *int32 `json:"capacityAllocated,omitempty" azure:"ro"`

	// READ-ONLY; Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running,
	// this would be the capacity allocated.
	CapacityAssigned *int32 `json:"capacityAssigned,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier for the cluster.
	ClusterID *string `json:"clusterId,omitempty" azure:"ro"`

	// READ-ONLY; The date this cluster was created.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled
	ProvisioningState *ClusterProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ClusterSKU - The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate)
// requests.
type ClusterSKU struct {
	// Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with
	// a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate)
	// requests.
	Capacity *int32 `json:"capacity,omitempty"`

	// Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
	Name *ClusterSKUName `json:"name,omitempty"`
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new resource to be created, but to prevent updating an existing record set. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListBySubscriptionOptions contains the optional parameters for the ClustersClient.ListBySubscription method.
type ClustersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListStreamingJobsOptions contains the optional parameters for the ClustersClient.ListStreamingJobs method.
type ClustersClientListStreamingJobsOptions struct {
	// placeholder for future optional parameters
}

// Compression - Describes how input data is compressed
type Compression struct {
	// REQUIRED; Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
	Type *CompressionType `json:"type,omitempty"`
}

// DiagnosticCondition - Condition applicable to the resource, or to the job overall, that warrant customer attention.
type DiagnosticCondition struct {
	// READ-ONLY; The opaque diagnostic code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The human-readable message describing the condition in detail. Localized in the Accept-Language of the client
	// request.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the
	// ops log around this time.
	Since *string `json:"since,omitempty" azure:"ro"`
}

// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
type Diagnostics struct {
	// READ-ONLY; A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer
	// attention.
	Conditions []*DiagnosticCondition `json:"conditions,omitempty" azure:"ro"`
}

// DocumentDbOutputDataSource - Describes a DocumentDB output data source.
type DocumentDbOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a DocumentDB output. Required on PUT (CreateOrReplace) requests.
	Properties *DocumentDbOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type DocumentDbOutputDataSource.
func (d *DocumentDbOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: d.Type,
	}
}

// DocumentDbOutputDataSourceProperties - The properties that are associated with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	// The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
	AccountID *string `json:"accountId,omitempty"`

	// The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`

	// The collection name pattern for the collections to be used. The collection name format can be constructed using the optional
	// {partition} token, where partitions start from 0. See the DocumentDB
	// section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required
	// on PUT (CreateOrReplace) requests.
	CollectionNamePattern *string `json:"collectionNamePattern,omitempty"`

	// The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
	Database *string `json:"database,omitempty"`

	// The name of the field in output events used to specify the primary key which insert or update operations are based on.
	DocumentID *string `json:"documentId,omitempty"`

	// The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern'
	// contains the {partition} token, this property is required to be
	// specified.
	PartitionKey *string `json:"partitionKey,omitempty"`
}

// Error - Common error representation.
type Error struct {
	// Error definition properties.
	Error *ErrorError `json:"error,omitempty"`
}

// ErrorDetails - Common error details representation.
type ErrorDetails struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message.
	Message *string `json:"message,omitempty"`

	// Error target.
	Target *string `json:"target,omitempty"`
}

// ErrorError - Error definition properties.
type ErrorError struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error details.
	Details []*ErrorDetails `json:"details,omitempty"`

	// Error message.
	Message *string `json:"message,omitempty"`

	// Error target.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse - Describes the error that occurred.
type ErrorResponse struct {
	// READ-ONLY; Error code associated with the error that occurred.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Describes the error in detail.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// EventHubDataSourceProperties - The common properties that are associated with Event Hub data sources.
type EventHubDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// EventHubOutputDataSource - Describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type EventHubOutputDataSource.
func (e *EventHubOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: e.Type,
	}
}

// EventHubOutputDataSourceProperties - The properties that are associated with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`

	// The key/column that is used to determine to which partition to send event data.
	PartitionKey *string `json:"partitionKey,omitempty"`

	// The properties associated with this Event Hub output.
	PropertyColumns []*string `json:"propertyColumns,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// EventHubStreamInputDataSource - Describes an Event Hub input data source that contains stream data.
type EventHubStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type EventHubStreamInputDataSource.
func (e *EventHubStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: e.Type,
	}
}

// EventHubStreamInputDataSourceProperties - The properties that are associated with a Event Hub input containing stream data.
type EventHubStreamInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer
	// group names for multiple inputs allows each of those inputs to receive the
	// same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string `json:"eventHubName,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// EventHubV2OutputDataSource - Describes an Event Hub output data source.
type EventHubV2OutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type EventHubV2OutputDataSource.
func (e *EventHubV2OutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: e.Type,
	}
}

// EventHubV2StreamInputDataSource - Describes an Event Hub input data source that contains stream data.
type EventHubV2StreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type EventHubV2StreamInputDataSource.
func (e *EventHubV2StreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: e.Type,
	}
}

// Function - A function object, containing all information associated with the named function. All functions are contained
// under a streaming job.
type Function struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// The properties that are associated with a function.
	Properties FunctionPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FunctionBindingClassification provides polymorphic access to related types.
// Call the interface's GetFunctionBinding() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureMachineLearningWebServiceFunctionBinding, *FunctionBinding, *JavaScriptFunctionBinding
type FunctionBindingClassification interface {
	// GetFunctionBinding returns the FunctionBinding content of the underlying type.
	GetFunctionBinding() *FunctionBinding
}

// FunctionBinding - The physical binding of the function. For example, in the Azure Machine Learning web service’s case,
// this describes the endpoint.
type FunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string `json:"type,omitempty"`
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type FunctionBinding.
func (f *FunctionBinding) GetFunctionBinding() *FunctionBinding { return f }

type FunctionConfiguration struct {
	// The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the
	// endpoint.
	Binding FunctionBindingClassification `json:"binding,omitempty"`
	Inputs  []*FunctionInput              `json:"inputs,omitempty"`

	// Describes the output of a function.
	Output *FunctionOutput `json:"output,omitempty"`
}

// FunctionInput - Describes one input parameter of a function.
type FunctionInput struct {
	// The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics
	// data types are described at
	// https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`

	// A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant.
	// Default is false.
	IsConfigurationParameter *bool `json:"isConfigurationParameter,omitempty"`
}

// FunctionListResult - Object containing a list of functions under a streaming job.
type FunctionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of functions under a streaming job. Populated by a 'List' operation.
	Value []*Function `json:"value,omitempty" azure:"ro"`
}

// FunctionOutput - Describes the output of a function.
type FunctionOutput struct {
	// The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string `json:"dataType,omitempty"`
}

// FunctionPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetFunctionProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AggregateFunctionProperties, *FunctionProperties, *ScalarFunctionProperties
type FunctionPropertiesClassification interface {
	// GetFunctionProperties returns the FunctionProperties content of the underlying type.
	GetFunctionProperties() *FunctionProperties
}

// FunctionProperties - The properties that are associated with a function.
type FunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string                `json:"type,omitempty"`
	Properties *FunctionConfiguration `json:"properties,omitempty"`

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type FunctionProperties.
func (f *FunctionProperties) GetFunctionProperties() *FunctionProperties { return f }

// FunctionRetrieveDefaultDefinitionParametersClassification provides polymorphic access to related types.
// Call the interface's GetFunctionRetrieveDefaultDefinitionParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, *FunctionRetrieveDefaultDefinitionParameters,
// - *JavaScriptFunctionRetrieveDefaultDefinitionParameters
type FunctionRetrieveDefaultDefinitionParametersClassification interface {
	// GetFunctionRetrieveDefaultDefinitionParameters returns the FunctionRetrieveDefaultDefinitionParameters content of the underlying type.
	GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters
}

// FunctionRetrieveDefaultDefinitionParameters - Parameters used to specify the type of function to retrieve the default definition
// for.
type FunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string `json:"bindingType,omitempty"`
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type FunctionRetrieveDefaultDefinitionParameters.
func (f *FunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return f
}

// FunctionsClientBeginTestOptions contains the optional parameters for the FunctionsClient.BeginTest method.
type FunctionsClientBeginTestOptions struct {
	// If the function specified does not already exist, this parameter must contain the full function definition intended to
	// be tested. If the function specified already exists, this parameter can be left
	// null to test the existing function as is or if specified, the properties specified will overwrite the corresponding properties
	// in the existing function (exactly like a PATCH operation) and the
	// resulting function will be tested.
	Function *Function
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FunctionsClientCreateOrReplaceOptions contains the optional parameters for the FunctionsClient.CreateOrReplace method.
type FunctionsClientCreateOrReplaceOptions struct {
	// The ETag of the function. Omit this value to always overwrite the current function. Specify the last-seen ETag value to
	// prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new function to be created, but to prevent updating an existing function. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// FunctionsClientDeleteOptions contains the optional parameters for the FunctionsClient.Delete method.
type FunctionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FunctionsClientGetOptions contains the optional parameters for the FunctionsClient.Get method.
type FunctionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FunctionsClientListByStreamingJobOptions contains the optional parameters for the FunctionsClient.ListByStreamingJob method.
type FunctionsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// FunctionsClientRetrieveDefaultDefinitionOptions contains the optional parameters for the FunctionsClient.RetrieveDefaultDefinition
// method.
type FunctionsClientRetrieveDefaultDefinitionOptions struct {
	// Parameters used to specify the type of function to retrieve the default definition for.
	FunctionRetrieveDefaultDefinitionParameters FunctionRetrieveDefaultDefinitionParametersClassification
}

// FunctionsClientUpdateOptions contains the optional parameters for the FunctionsClient.Update method.
type FunctionsClientUpdateOptions struct {
	// The ETag of the function. Omit this value to always overwrite the current function. Specify the last-seen ETag value to
	// prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// Identity - Describes how identity is verified
type Identity struct {
	// The identity principal ID
	PrincipalID *string `json:"principalId,omitempty"`

	// The identity tenantId
	TenantID *string `json:"tenantId,omitempty"`

	// The identity type
	Type *string `json:"type,omitempty"`
}

// Input - An input object, containing all information associated with the named input. All inputs are contained under a streaming
// job.
type Input struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
	Properties InputPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InputListResult - Object containing a list of inputs under a streaming job.
type InputListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of inputs under a streaming job. Populated by a 'List' operation.
	Value []*Input `json:"value,omitempty" azure:"ro"`
}

// InputPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetInputProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InputProperties, *ReferenceInputProperties, *StreamInputProperties
type InputPropertiesClassification interface {
	// GetInputProperties returns the InputProperties content of the underlying type.
	GetInputProperties() *InputProperties
}

// InputProperties - The properties that are associated with an input.
type InputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification `json:"serialization,omitempty"`

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty" azure:"ro"`

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetInputProperties implements the InputPropertiesClassification interface for type InputProperties.
func (i *InputProperties) GetInputProperties() *InputProperties { return i }

// InputsClientBeginTestOptions contains the optional parameters for the InputsClient.BeginTest method.
type InputsClientBeginTestOptions struct {
	// If the input specified does not already exist, this parameter must contain the full input definition intended to be tested.
	// If the input specified already exists, this parameter can be left null to
	// test the existing input as is or if specified, the properties specified will overwrite the corresponding properties in
	// the existing input (exactly like a PATCH operation) and the resulting input will
	// be tested.
	Input *Input
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InputsClientCreateOrReplaceOptions contains the optional parameters for the InputsClient.CreateOrReplace method.
type InputsClientCreateOrReplaceOptions struct {
	// The ETag of the input. Omit this value to always overwrite the current input. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new input to be created, but to prevent updating an existing input. Other values will result in a
	// 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// InputsClientDeleteOptions contains the optional parameters for the InputsClient.Delete method.
type InputsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// InputsClientGetOptions contains the optional parameters for the InputsClient.Get method.
type InputsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InputsClientListByStreamingJobOptions contains the optional parameters for the InputsClient.ListByStreamingJob method.
type InputsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// InputsClientUpdateOptions contains the optional parameters for the InputsClient.Update method.
type InputsClientUpdateOptions struct {
	// The ETag of the input. Omit this value to always overwrite the current input. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
}

// IoTHubStreamInputDataSource - Describes an IoT Hub input data source that contains stream data.
type IoTHubStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with an IoT Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *IoTHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type IoTHubStreamInputDataSource.
func (i *IoTHubStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: i.Type,
	}
}

// IoTHubStreamInputDataSourceProperties - The properties that are associated with a IoT Hub input containing stream data.
type IoTHubStreamInputDataSourceProperties struct {
	// The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input
	// uses the Iot Hub’s default consumer group.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
	Endpoint *string `json:"endpoint,omitempty"`

	// The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
	IotHubNamespace *string `json:"iotHubNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required
	// on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// JSONSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in JSON format.
type JSONSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType `json:"type,omitempty"`

	// The properties that are associated with the JSON serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *JSONSerializationProperties `json:"properties,omitempty"`
}

// GetSerialization implements the SerializationClassification interface for type JSONSerialization.
func (j *JSONSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: j.Type,
	}
}

// JSONSerializationProperties - The properties that are associated with the JSON serialization type.
type JSONSerializationProperties struct {
	// Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output.
	// Required on PUT (CreateOrReplace) requests.
	Encoding *Encoding `json:"encoding,omitempty"`

	// This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies
	// the format of the JSON the output will be written in. The currently supported
	// values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and
	// 'array' indicating the output will be formatted as an array of JSON objects.
	// Default value is 'lineSeparated' if left null.
	Format *JSONOutputSerializationFormat `json:"format,omitempty"`
}

// JavaScriptFunctionBinding - The binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string `json:"type,omitempty"`

	// The binding properties associated with a JavaScript function.
	Properties *JavaScriptFunctionBindingProperties `json:"properties,omitempty"`
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type JavaScriptFunctionBinding.
func (j *JavaScriptFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: j.Type,
	}
}

// JavaScriptFunctionBindingProperties - The binding properties associated with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	// The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
	Script *string `json:"script,omitempty"`
}

// JavaScriptFunctionBindingRetrievalProperties - The binding retrieval properties associated with a JavaScript function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	// The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'.
	Script *string `json:"script,omitempty"`

	// The function type.
	UdfType *string `json:"udfType,omitempty"`
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default function definition
// for a JavaScript function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string `json:"bindingType,omitempty"`

	// The binding retrieval properties associated with a JavaScript function.
	BindingRetrievalProperties *JavaScriptFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j *JavaScriptFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: j.BindingType,
	}
}

// JobStorageAccount - The properties that are associated with an Azure Storage account with MSI
type JobStorageAccount struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`
}

// OAuthBasedDataSourceProperties - The properties that are associated with data sources that use OAuth as their authentication
// model.
type OAuthBasedDataSourceProperties struct {
	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
}

// Operation - A Stream Analytics REST API operation
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - Contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Stream Analytics operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Stream Analytics operations supported by the Microsoft.StreamAnalytics resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Output - An output object, containing all information associated with the named output. All outputs are contained under
// a streaming job.
type Output struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// The properties that are associated with an output. Required on PUT (CreateOrReplace) requests.
	Properties *OutputProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OutputDataSourceClassification provides polymorphic access to related types.
// Call the interface's GetOutputDataSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureDataLakeStoreOutputDataSource, *AzureFunctionOutputDataSource, *AzureSQLDatabaseOutputDataSource, *AzureSynapseOutputDataSource,
// - *AzureTableOutputDataSource, *BlobOutputDataSource, *DocumentDbOutputDataSource, *EventHubOutputDataSource, *EventHubV2OutputDataSource,
// - *OutputDataSource, *PowerBIOutputDataSource, *ServiceBusQueueOutputDataSource, *ServiceBusTopicOutputDataSource
type OutputDataSourceClassification interface {
	// GetOutputDataSource returns the OutputDataSource content of the underlying type.
	GetOutputDataSource() *OutputDataSource
}

// OutputDataSource - Describes the data source that output will be written to.
type OutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type OutputDataSource.
func (o *OutputDataSource) GetOutputDataSource() *OutputDataSource { return o }

// OutputListResult - Object containing a list of outputs under a streaming job.
type OutputListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of outputs under a streaming job. Populated by a 'List' operation.
	Value []*Output `json:"value,omitempty" azure:"ro"`
}

// OutputProperties - The properties that are associated with an output.
type OutputProperties struct {
	// Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
	Datasource OutputDataSourceClassification `json:"datasource,omitempty"`

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification `json:"serialization,omitempty"`

	// The size window to constrain a Stream Analytics output to.
	SizeWindow *float32 `json:"sizeWindow,omitempty"`

	// The time frame for filtering Stream Analytics job outputs.
	TimeWindow *string `json:"timeWindow,omitempty"`

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty" azure:"ro"`

	// READ-ONLY; The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// OutputsClientBeginTestOptions contains the optional parameters for the OutputsClient.BeginTest method.
type OutputsClientBeginTestOptions struct {
	// If the output specified does not already exist, this parameter must contain the full output definition intended to be tested.
	// If the output specified already exists, this parameter can be left null to
	// test the existing output as is or if specified, the properties specified will overwrite the corresponding properties in
	// the existing output (exactly like a PATCH operation) and the resulting output
	// will be tested.
	Output *Output
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OutputsClientCreateOrReplaceOptions contains the optional parameters for the OutputsClient.CreateOrReplace method.
type OutputsClientCreateOrReplaceOptions struct {
	// The ETag of the output. Omit this value to always overwrite the current output. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new output to be created, but to prevent updating an existing output. Other values will result in
	// a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// OutputsClientDeleteOptions contains the optional parameters for the OutputsClient.Delete method.
type OutputsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OutputsClientGetOptions contains the optional parameters for the OutputsClient.Get method.
type OutputsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OutputsClientListByStreamingJobOptions contains the optional parameters for the OutputsClient.ListByStreamingJob method.
type OutputsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// OutputsClientUpdateOptions contains the optional parameters for the OutputsClient.Update method.
type OutputsClientUpdateOptions struct {
	// The ETag of the output. Omit this value to always overwrite the current output. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
}

// ParquetSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in Parquet format.
type ParquetSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType `json:"type,omitempty"`

	// The properties that are associated with the Parquet serialization type. Required on PUT (CreateOrReplace) requests.
	Properties interface{} `json:"properties,omitempty"`
}

// GetSerialization implements the SerializationClassification interface for type ParquetSerialization.
func (p *ParquetSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: p.Type,
	}
}

// PowerBIOutputDataSource - Describes a Power BI output data source.
type PowerBIOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a Power BI output. Required on PUT (CreateOrReplace) requests.
	Properties *PowerBIOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type PowerBIOutputDataSource.
func (p *PowerBIOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: p.Type,
	}
}

// PowerBIOutputDataSourceProperties - The properties that are associated with a Power BI output.
type PowerBIOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
	Dataset *string `json:"dataset,omitempty"`

	// The ID of the Power BI group.
	GroupID *string `json:"groupId,omitempty"`

	// The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
	GroupName *string `json:"groupName,omitempty"`

	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
	Table *string `json:"table,omitempty"`

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string `json:"tokenUserDisplayName,omitempty"`

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
}

// PrivateEndpoint - Complete information about the private endpoint.
type PrivateEndpoint struct {
	// The properties associated with a private endpoint.
	Properties *PrivateEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint)
	// and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointListResult - A list of private endpoints.
type PrivateEndpointListResult struct {
	// READ-ONLY; The URL to fetch the next set of private endpoints.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of private endpoints.
	Value []*PrivateEndpoint `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointProperties - The properties associated with a private endpoint.
type PrivateEndpointProperties struct {
	// A list of connections to the remote resource. Immutable after it is set.
	ManualPrivateLinkServiceConnections []*PrivateLinkServiceConnection `json:"manualPrivateLinkServiceConnections,omitempty"`

	// READ-ONLY; The date when this private endpoint was created.
	CreatedDate *string `json:"createdDate,omitempty" azure:"ro"`
}

// PrivateEndpointsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointsClient.BeginDelete method.
type PrivateEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointsClient.CreateOrUpdate
// method.
type PrivateEndpointsClientCreateOrUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new resource to be created, but to prevent updating an existing record set. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// PrivateEndpointsClientGetOptions contains the optional parameters for the PrivateEndpointsClient.Get method.
type PrivateEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointsClientListByClusterOptions contains the optional parameters for the PrivateEndpointsClient.ListByCluster
// method.
type PrivateEndpointsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkConnectionState - A collection of read-only information about the state of the connection to the private remote
// resource.
type PrivateLinkConnectionState struct {
	// READ-ONLY; A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`

	// READ-ONLY; The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnection - A grouping of information about the connection to the remote resource.
type PrivateLinkServiceConnection struct {
	// Bag of properties defining a privatelinkServiceConnection.
	Properties *PrivateLinkServiceConnectionProperties `json:"properties,omitempty"`
}

// PrivateLinkServiceConnectionProperties - Bag of properties defining a privatelinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT
	// (CreateOrUpdate) requests.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// A collection of read-only information about the state of the connection to the private remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty"`

	// READ-ONLY; A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string `json:"requestMessage,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReferenceInputDataSourceClassification provides polymorphic access to related types.
// Call the interface's GetReferenceInputDataSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureSQLReferenceInputDataSource, *BlobReferenceInputDataSource, *ReferenceInputDataSource
type ReferenceInputDataSourceClassification interface {
	// GetReferenceInputDataSource returns the ReferenceInputDataSource content of the underlying type.
	GetReferenceInputDataSource() *ReferenceInputDataSource
}

// ReferenceInputDataSource - Describes an input data source that contains reference data.
type ReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type ReferenceInputDataSource.
func (r *ReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource { return r }

// ReferenceInputProperties - The properties that are associated with an input containing reference data.
type ReferenceInputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`

	// Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
	Datasource ReferenceInputDataSourceClassification `json:"datasource,omitempty"`

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification `json:"serialization,omitempty"`

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty" azure:"ro"`

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetInputProperties implements the InputPropertiesClassification interface for type ReferenceInputProperties.
func (r *ReferenceInputProperties) GetInputProperties() *InputProperties {
	return &InputProperties{
		Type:          r.Type,
		Serialization: r.Serialization,
		Diagnostics:   r.Diagnostics,
		Etag:          r.Etag,
		Compression:   r.Compression,
		PartitionKey:  r.PartitionKey,
	}
}

// Resource - The base resource definition
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceTestStatus - Describes the status of the test operation along with error information, if applicable.
type ResourceTestStatus struct {
	// READ-ONLY; Describes the error that occurred.
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The status of the test operation.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// SKU - The properties that are associated with a SKU.
type SKU struct {
	// The name of the SKU. Required on PUT (CreateOrReplace) requests.
	Name *SKUName `json:"name,omitempty"`
}

// ScalarFunctionProperties - The properties that are associated with a scalar function.
type ScalarFunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string                `json:"type,omitempty"`
	Properties *FunctionConfiguration `json:"properties,omitempty"`

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type ScalarFunctionProperties.
func (s *ScalarFunctionProperties) GetFunctionProperties() *FunctionProperties {
	return &FunctionProperties{
		Type:       s.Type,
		Etag:       s.Etag,
		Properties: s.Properties,
	}
}

// ScaleStreamingJobParameters - Parameters supplied to the Scale Streaming Job operation.
type ScaleStreamingJobParameters struct {
	// Specifies the number of streaming units that the streaming job will scale to.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`
}

// SerializationClassification provides polymorphic access to related types.
// Call the interface's GetSerialization() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AvroSerialization, *CSVSerialization, *JSONSerialization, *ParquetSerialization, *Serialization
type SerializationClassification interface {
	// GetSerialization returns the Serialization content of the underlying type.
	GetSerialization() *Serialization
}

// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output.
type Serialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType `json:"type,omitempty"`
}

// GetSerialization implements the SerializationClassification interface for type Serialization.
func (s *Serialization) GetSerialization() *Serialization { return s }

// ServiceBusDataSourceProperties - The common properties that are associated with Service Bus data sources (Queues, Topics,
// Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
}

// ServiceBusQueueOutputDataSource - Describes a Service Bus Queue output data source.
type ServiceBusQueueOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a Service Bus Queue output. Required on PUT (CreateOrReplace) requests.
	Properties *ServiceBusQueueOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type ServiceBusQueueOutputDataSource.
func (s *ServiceBusQueueOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: s.Type,
	}
}

// ServiceBusQueueOutputDataSourceProperties - The properties that are associated with a Service Bus Queue output.
type ServiceBusQueueOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns []*string `json:"propertyColumns,omitempty"`

	// The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
	QueueName *string `json:"queueName,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`

	// The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId,
	// ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey,
	// SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns interface{} `json:"systemPropertyColumns,omitempty"`
}

// ServiceBusTopicOutputDataSource - Describes a Service Bus Topic output data source.
type ServiceBusTopicOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// The properties that are associated with a Service Bus Topic output. Required on PUT (CreateOrReplace) requests.
	Properties *ServiceBusTopicOutputDataSourceProperties `json:"properties,omitempty"`
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type ServiceBusTopicOutputDataSource.
func (s *ServiceBusTopicOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: s.Type,
	}
}

// ServiceBusTopicOutputDataSourceProperties - The properties that are associated with a Service Bus Topic output.
type ServiceBusTopicOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode `json:"authenticationMode,omitempty"`

	// A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns []*string `json:"propertyColumns,omitempty"`

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string `json:"sharedAccessPolicyKey,omitempty"`

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`

	// The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId,
	// ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey,
	// SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns map[string]*string `json:"systemPropertyColumns,omitempty"`

	// The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
	TopicName *string `json:"topicName,omitempty"`
}

// StartStreamingJobParameters - Parameters supplied to the Start Streaming Job operation.
type StartStreamingJobParameters struct {
	// Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event
	// stream should start whenever the job is started, start at a custom user time
	// stamp specified via the outputStartTime property, or start from the last event output time.
	OutputStartMode *OutputStartMode `json:"outputStartMode,omitempty"`

	// Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null
	// to indicate that the output event stream will start whenever the streaming job is
	// started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *time.Time `json:"outputStartTime,omitempty"`
}

// StorageAccount - The properties that are associated with an Azure Storage account
type StorageAccount struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string `json:"accountKey,omitempty"`

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string `json:"accountName,omitempty"`
}

// StreamInputDataSourceClassification provides polymorphic access to related types.
// Call the interface's GetStreamInputDataSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BlobStreamInputDataSource, *EventHubStreamInputDataSource, *EventHubV2StreamInputDataSource, *IoTHubStreamInputDataSource,
// - *StreamInputDataSource
type StreamInputDataSourceClassification interface {
	// GetStreamInputDataSource returns the StreamInputDataSource content of the underlying type.
	GetStreamInputDataSource() *StreamInputDataSource
}

// StreamInputDataSource - Describes an input data source that contains stream data.
type StreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type StreamInputDataSource.
func (s *StreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource { return s }

// StreamInputProperties - The properties that are associated with an input containing stream data.
type StreamInputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string `json:"type,omitempty"`

	// Describes how input data is compressed
	Compression *Compression `json:"compression,omitempty"`

	// Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
	Datasource StreamInputDataSourceClassification `json:"datasource,omitempty"`

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string `json:"partitionKey,omitempty"`

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification `json:"serialization,omitempty"`

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics `json:"diagnostics,omitempty" azure:"ro"`

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// GetInputProperties implements the InputPropertiesClassification interface for type StreamInputProperties.
func (s *StreamInputProperties) GetInputProperties() *InputProperties {
	return &InputProperties{
		Type:          s.Type,
		Serialization: s.Serialization,
		Diagnostics:   s.Diagnostics,
		Etag:          s.Etag,
		Compression:   s.Compression,
		PartitionKey:  s.PartitionKey,
	}
}

// StreamingJob - A streaming job object, containing all information associated with the named streaming job.
type StreamingJob struct {
	// Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
	Identity *Identity `json:"identity,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties that are associated with a streaming job. Required on PUT (CreateOrReplace) requests.
	Properties *StreamingJobProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StreamingJobListResult - Object containing a list of streaming jobs.
type StreamingJobListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of streaming jobs. Populated by a 'List' operation.
	Value []*StreamingJob `json:"value,omitempty" azure:"ro"`
}

// StreamingJobProperties - The properties that are associated with a streaming job.
type StreamingJobProperties struct {
	// The cluster which streaming jobs will run on.
	Cluster *ClusterInfo `json:"cluster,omitempty"`

	// Controls certain runtime behaviors of the streaming job.
	CompatibilityLevel *CompatibilityLevel `json:"compatibilityLevel,omitempty"`

	// Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify
	// jobStorageAccount property. .
	ContentStoragePolicy *ContentStoragePolicy `json:"contentStoragePolicy,omitempty"`

	// The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set
	// https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none
	// specified.
	DataLocale *string `json:"dataLocale,omitempty"`

	// The maximum tolerable delay in seconds where events arriving late could be included. Supported range is -1 to 1814399 (20.23:59:59
	// days) and -1 is used to specify wait indefinitely. If the property is
	// absent, it is interpreted to have a value of -1.
	EventsLateArrivalMaxDelayInSeconds *int32 `json:"eventsLateArrivalMaxDelayInSeconds,omitempty"`

	// The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
	EventsOutOfOrderMaxDelayInSeconds *int32 `json:"eventsOutOfOrderMaxDelayInSeconds,omitempty"`

	// Indicates the policy to apply to events that arrive out of order in the input event stream.
	EventsOutOfOrderPolicy *EventsOutOfOrderPolicy `json:"eventsOutOfOrderPolicy,omitempty"`

	// A list of one or more functions for the streaming job. The name property for each function is required when specifying
	// this property in a PUT request. This property cannot be modify via a PATCH
	// operation. You must use the PATCH API available for the individual transformation.
	Functions []*Function `json:"functions,omitempty"`

	// A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property
	// in a PUT request. This property cannot be modify via a PATCH operation.
	// You must use the PATCH API available for the individual input.
	Inputs []*Input `json:"inputs,omitempty"`

	// The properties that are associated with an Azure Storage account with MSI
	JobStorageAccount *JobStorageAccount `json:"jobStorageAccount,omitempty"`

	// Describes the type of the job. Valid modes are Cloud and 'Edge'.
	JobType *JobType `json:"jobType,omitempty"`

	// Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to
	// being malformed (missing column values, column values of wrong type or size).
	OutputErrorPolicy *OutputErrorPolicy `json:"outputErrorPolicy,omitempty"`

	// This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be
	// JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the
	// starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified
	// via the outputStartTime property, or start from the last event output
	// time.
	OutputStartMode *OutputStartMode `json:"outputStartMode,omitempty"`

	// Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null
	// to indicate that the output event stream will start whenever the streaming job is
	// started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *time.Time `json:"outputStartTime,omitempty"`

	// A list of one or more outputs for the streaming job. The name property for each output is required when specifying this
	// property in a PUT request. This property cannot be modify via a PATCH operation.
	// You must use the PATCH API available for the individual output.
	Outputs []*Output `json:"outputs,omitempty"`

	// Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
	SKU *SKU `json:"sku,omitempty"`

	// Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation
	// is required when specifying this property in a PUT request. This property
	// cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
	Transformation *Transformation `json:"transformation,omitempty"`

	// READ-ONLY; Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the
	// resource has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
	JobID *string `json:"jobId,omitempty" azure:"ro"`

	// READ-ONLY; Describes the state of the streaming job.
	JobState *string `json:"jobState,omitempty" azure:"ro"`

	// READ-ONLY; Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or
	// null indicating that output has not yet been produced. In case of multiple outputs or
	// multiple streams, this shows the latest value in that set.
	LastOutputEventTime *time.Time `json:"lastOutputEventTime,omitempty" azure:"ro"`

	// READ-ONLY; Describes the provisioning status of the streaming job.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// StreamingJobsClientBeginCreateOrReplaceOptions contains the optional parameters for the StreamingJobsClient.BeginCreateOrReplace
// method.
type StreamingJobsClientBeginCreateOrReplaceOptions struct {
	// The ETag of the streaming job. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new streaming job to be created, but to prevent updating an existing record set. Other values will
	// result in a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientBeginDeleteOptions contains the optional parameters for the StreamingJobsClient.BeginDelete method.
type StreamingJobsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientBeginScaleOptions contains the optional parameters for the StreamingJobsClient.BeginScale method.
type StreamingJobsClientBeginScaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Parameters applicable to a scale streaming job operation.
	ScaleJobParameters *ScaleStreamingJobParameters
}

// StreamingJobsClientBeginStartOptions contains the optional parameters for the StreamingJobsClient.BeginStart method.
type StreamingJobsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Parameters applicable to a start streaming job operation.
	StartJobParameters *StartStreamingJobParameters
}

// StreamingJobsClientBeginStopOptions contains the optional parameters for the StreamingJobsClient.BeginStop method.
type StreamingJobsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientGetOptions contains the optional parameters for the StreamingJobsClient.Get method.
type StreamingJobsClientGetOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientListByResourceGroupOptions contains the optional parameters for the StreamingJobsClient.ListByResourceGroup
// method.
type StreamingJobsClientListByResourceGroupOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientListOptions contains the optional parameters for the StreamingJobsClient.List method.
type StreamingJobsClientListOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientUpdateOptions contains the optional parameters for the StreamingJobsClient.Update method.
type StreamingJobsClientUpdateOptions struct {
	// The ETag of the streaming job. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// SubResource - The base sub-resource model definition.
type SubResource struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionQuota - Describes the current quota for the subscription.
type SubscriptionQuota struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Describes the properties of the quota.
	Properties *SubscriptionQuotaProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionQuotaProperties - Describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	// READ-ONLY; The current usage of this resource.
	CurrentCount *int32 `json:"currentCount,omitempty" azure:"ro"`

	// READ-ONLY; The max permitted usage of this resource.
	MaxCount *int32 `json:"maxCount,omitempty" azure:"ro"`
}

// SubscriptionQuotasListResult - Result of the GetQuotas operation. It contains a list of quotas for the subscription in
// a particular region.
type SubscriptionQuotasListResult struct {
	// READ-ONLY; List of quotas for the subscription in a particular region.
	Value []*SubscriptionQuota `json:"value,omitempty" azure:"ro"`
}

// SubscriptionsClientListQuotasOptions contains the optional parameters for the SubscriptionsClient.ListQuotas method.
type SubscriptionsClientListQuotasOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Transformation - A transformation object, containing all information associated with the named transformation. All transformations
// are contained under a streaming job.
type Transformation struct {
	// Resource name
	Name *string `json:"name,omitempty"`

	// The properties that are associated with a transformation. Required on PUT (CreateOrReplace) requests.
	Properties *TransformationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransformationProperties - The properties that are associated with a transformation.
type TransformationProperties struct {
	// Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language
	// (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT
	// (CreateOrReplace) requests.
	Query *string `json:"query,omitempty"`

	// Specifies the number of streaming units that the streaming job uses.
	StreamingUnits *int32 `json:"streamingUnits,omitempty"`

	// Specifies the valid streaming units a streaming job can scale to.
	ValidStreamingUnits []*int32 `json:"validStreamingUnits,omitempty"`

	// READ-ONLY; The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the
	// resource has changed between requests. You can also use it in the If-Match or
	// If-None-Match headers for write operations for optimistic concurrency.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// TransformationsClientCreateOrReplaceOptions contains the optional parameters for the TransformationsClient.CreateOrReplace
// method.
type TransformationsClientCreateOrReplaceOptions struct {
	// The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag
	// value to prevent accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new transformation to be created, but to prevent updating an existing transformation. Other values
	// will result in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// TransformationsClientGetOptions contains the optional parameters for the TransformationsClient.Get method.
type TransformationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TransformationsClientUpdateOptions contains the optional parameters for the TransformationsClient.Update method.
type TransformationsClientUpdateOptions struct {
	// The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag
	// value to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}
