# Diversity, Equity, and Inclusion Project Statement

<!---
The DEI.md file was originally created in the CHAOSS project. This comment provides attribution of that work as defined under the MIT license.
-->

<!---
Please use the DEI.md Guide at https://github.com/badging/ProjectBadging/blob/main/Guide.DEI.md when creating your DEI.md file
-->

![CHAOSS DEI Bronze Badge](https://images.ctfassets.net/xz1dnu24egyd/5qxlqiIMLUYwuinHpFm67P/edc10e44c37235cef20c0f910a947669/dei-bronze-badge.svg)

## GitLab

The scope of this DEI.md file is intended to cover the entire organization of GitLab. Any specific differences for a particular GitLab project may be noted within this document.

Our project prioritizes and reflects on DEI through a regular review of project policies and performance. This reflection is documented in the following DEI.md file based on specific [CHAOSS project](https://chaoss.community) DEI metrics.

### [Project Access](https://chaoss.community/?p=4953)

Project access is addressed in our project through various efforts. Through these efforts, we aim to support access for all. Specific efforts in our project include:

- GitLab’s mission is “everyone can contribute."
- All areas of GitLab are considered open to community contributions.
- The GitLab Community Edition (CE) is open source and licensed under the terms of the MIT license.
- The GitLab Enterprise Edition (EE) is licensed under The GitLab Enterprise Edition (EE) license and anyone can contribute to GitLab’s paid EE features by requesting a free EE license for contributing.
- The GitLab Community is accessible online through the GitLab Forum, GitLab Discord server, online events and community pairing sessions as well as in-person through Contribution Days, GitLab Meetups, and World Tour days.
- The GitLab.com SaaS product is conformant with the Voluntary Product Accessibility Template (VPAT 2.4) revised in June 2023.
- GitLab aims to conform to level AA of the World Wide Web Consortium (W3C) Web Content Accessibility Guidelines 2.1.
- Anyone can open up an issue on GitLab to express concerns or requests for accessibility improvements.
- GitLab has an internal Product Accessibility working group to perform accessibility checks and report accessibility violations.
- GitLab’s project maintainers and merge request coaches span global timezones and work asynchronously with contributors across the world.
- GitLab is developing a unified contributor program that recognizes and rewards non-code contributors including contributions through events, blog posts, and comments in issues and merge requests.
- GitLab encourages translation contributions and features translation documentation for making contributions through Crowdin.

### [Communication Transparency](https://chaoss.community/?p=4957)

Communication Transparency is addressed in our project through a variety of different efforts. Through these efforts, we aim to support transparency for all. Specific efforts in our project include:

- Transparency is one of GitLab’s six core values.
- GitLab is public by default.
- Any information that cannot be made public (e.g. security and abuse vulnerabilities, financial information, customer data) is marked as internal to the company or limited access within the company. All of the internal and limited access topics are listed publicly and any other information not marked as internal or limited access should be available externally to the public.
- GitLab operates using a single source of truth for all GitLab team members, users, customers, and other community members.
- The GitLab Docs are public and open to contribution.
- The GitLab Handbook is public and open to contribution.
- GitLab is transparent about security incidents.
- Incidents on GitLab SaaS are reported on the GitLab System Status and communicated on Twitter and Discord.
- GitLab operates the GitLab Unfiltered YouTube channel that shares all publicly available meetings, recordings and community pairing sessions.

### [Newcomer Experiences](https://chaoss.community/?p=4891)

The newcomer experience is addressed in our project through a variety of different efforts. Through these efforts, we aim to support the newcomer experience for all new members. Specific efforts in our project include:

- GitLab automatically applies a 1st contribution label to first-time contributors who open a merge request so they may be better identified and assisted by reviewers and coaches.
- GitLab uses weekly triage reports on first-time contributors who are awaiting a response to a merge request. This ensures newcomers always hear back from a real person about their merge request.
- GitLab reviews contributor documentation for inclusivity of newcomers, including improvements to documentation navigation, technical content and jargon, and improving workflow processes for newcomers.
- GitLab's contributor documentation includes a full walkthrough tutorial for newcomers to make their first contribution. This includes setting up the development environment, making code changes, documentation updates and ways to find support.
- GitLab uses quick win labels to identify issues for newcomers.
- GitLab has a dedicated Contributor Success team to facilitate newcomer onboarding, help newcomers find issues, assist newcomers through merge requests and communicate to reviewers on the behalf of contributors to ensure a smoother review experience.
- Newcomers are instructed to use the automated @gitlab-bot to ask for help directly in issues and merge requests. The bot will ping a merge request coach who will assist the newcomer.
- GitLab offers a community fork which helps newcomers collaborate with other contributors under a shared fork. This means newcomers do not have to maintain and update a personal fork.
- GitLab offers swag gifts to newcomers who make their first contribution.
- GitLab tracks metrics for new contributors with the goal of increasing total contributors to the project and helping convert new contributors into returning contributors.

### [Inclusive Leadership](https://chaoss.community/?p=3522)

Inclusive leadership is addressed in our project through a variety of different efforts. Through these efforts, we aim to support leadership opportunities for project members with an interest. Specific efforts in our project include:

- One or more project maintainers in the GitLab organization have completed neurodiversity and other DEI training.
- One or more project maintainers in the GitLab organization are a member of a working group related to a DEI initiative.
- One or more project maintainers in the GitLab organization participate in DEI group meetings or events.
- GitLab's hiring managers seek candidates from a diverse range of candidate pools to ensure the most qualified candidate is hired and GitLab's interview panels are representative of GitLab and society's diversity.

Our project recognizes that the inclusion of the DEI.md file and the provided reflection on the specific DEI metrics does not ensure community safety nor community inclusiveness. The inclusion of the DEI.md file signals that we, as a project, are committed to centering DEI in our project and regularly reviewing and reflecting on our project DEI practices.

If you do not feel that the DEI.md file appropriately addresses concerns you have about community safety and inclusiveness, please let us know. You can review the [GitLab Community Code of Conduct](https://about.gitlab.com/community/contribute/code-of-conduct/) and report your concerns or questions to the GitLab Trust and Safety team (abuse@gitlab.com).

Last Reviewed: 2023-11-29
