// Code generated by smithy-go-codegen DO NOT EDIT.

package apigatewayv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/apigatewayv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCreateApi struct {
}

func (*awsRestjson1_serializeOpCreateApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApiInput(v *CreateApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApiInput(v *CreateApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKeySelectionExpression != nil {
		ok := object.Key("apiKeySelectionExpression")
		ok.String(*v.ApiKeySelectionExpression)
	}

	if v.CorsConfiguration != nil {
		ok := object.Key("corsConfiguration")
		if err := awsRestjson1_serializeDocumentCors(v.CorsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CredentialsArn != nil {
		ok := object.Key("credentialsArn")
		ok.String(*v.CredentialsArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisableExecuteApiEndpoint {
		ok := object.Key("disableExecuteApiEndpoint")
		ok.Boolean(v.DisableExecuteApiEndpoint)
	}

	if v.DisableSchemaValidation {
		ok := object.Key("disableSchemaValidation")
		ok.Boolean(v.DisableSchemaValidation)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.ProtocolType) > 0 {
		ok := object.Key("protocolType")
		ok.String(string(v.ProtocolType))
	}

	if v.RouteKey != nil {
		ok := object.Key("routeKey")
		ok.String(*v.RouteKey)
	}

	if v.RouteSelectionExpression != nil {
		ok := object.Key("routeSelectionExpression")
		ok.String(*v.RouteSelectionExpression)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpCreateApiMapping struct {
}

func (*awsRestjson1_serializeOpCreateApiMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApiMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApiMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}/apimappings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateApiMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApiMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApiMappingInput(v *CreateApiMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApiMappingInput(v *CreateApiMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiId != nil {
		ok := object.Key("apiId")
		ok.String(*v.ApiId)
	}

	if v.ApiMappingKey != nil {
		ok := object.Key("apiMappingKey")
		ok.String(*v.ApiMappingKey)
	}

	if v.Stage != nil {
		ok := object.Key("stage")
		ok.String(*v.Stage)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAuthorizer struct {
}

func (*awsRestjson1_serializeOpCreateAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/authorizers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAuthorizerInput(v *CreateAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAuthorizerInput(v *CreateAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerCredentialsArn != nil {
		ok := object.Key("authorizerCredentialsArn")
		ok.String(*v.AuthorizerCredentialsArn)
	}

	if v.AuthorizerPayloadFormatVersion != nil {
		ok := object.Key("authorizerPayloadFormatVersion")
		ok.String(*v.AuthorizerPayloadFormatVersion)
	}

	if v.AuthorizerResultTtlInSeconds != 0 {
		ok := object.Key("authorizerResultTtlInSeconds")
		ok.Integer(v.AuthorizerResultTtlInSeconds)
	}

	if len(v.AuthorizerType) > 0 {
		ok := object.Key("authorizerType")
		ok.String(string(v.AuthorizerType))
	}

	if v.AuthorizerUri != nil {
		ok := object.Key("authorizerUri")
		ok.String(*v.AuthorizerUri)
	}

	if v.EnableSimpleResponses {
		ok := object.Key("enableSimpleResponses")
		ok.Boolean(v.EnableSimpleResponses)
	}

	if v.IdentitySource != nil {
		ok := object.Key("identitySource")
		if err := awsRestjson1_serializeDocumentIdentitySourceList(v.IdentitySource, ok); err != nil {
			return err
		}
	}

	if v.IdentityValidationExpression != nil {
		ok := object.Key("identityValidationExpression")
		ok.String(*v.IdentityValidationExpression)
	}

	if v.JwtConfiguration != nil {
		ok := object.Key("jwtConfiguration")
		if err := awsRestjson1_serializeDocumentJWTConfiguration(v.JwtConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDeployment struct {
}

func (*awsRestjson1_serializeOpCreateDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/deployments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDeploymentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDeploymentInput(v *CreateDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDeploymentInput(v *CreateDeploymentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDomainName struct {
}

func (*awsRestjson1_serializeOpCreateDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDomainNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDomainNameInput(v *CreateDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDomainNameInput(v *CreateDomainNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainName != nil {
		ok := object.Key("domainName")
		ok.String(*v.DomainName)
	}

	if v.DomainNameConfigurations != nil {
		ok := object.Key("domainNameConfigurations")
		if err := awsRestjson1_serializeDocumentDomainNameConfigurations(v.DomainNameConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MutualTlsAuthentication != nil {
		ok := object.Key("mutualTlsAuthentication")
		if err := awsRestjson1_serializeDocumentMutualTlsAuthenticationInput(v.MutualTlsAuthentication, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIntegration struct {
}

func (*awsRestjson1_serializeOpCreateIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIntegrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIntegrationInput(v *CreateIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIntegrationInput(v *CreateIntegrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionId != nil {
		ok := object.Key("connectionId")
		ok.String(*v.ConnectionId)
	}

	if len(v.ConnectionType) > 0 {
		ok := object.Key("connectionType")
		ok.String(string(v.ConnectionType))
	}

	if len(v.ContentHandlingStrategy) > 0 {
		ok := object.Key("contentHandlingStrategy")
		ok.String(string(v.ContentHandlingStrategy))
	}

	if v.CredentialsArn != nil {
		ok := object.Key("credentialsArn")
		ok.String(*v.CredentialsArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IntegrationMethod != nil {
		ok := object.Key("integrationMethod")
		ok.String(*v.IntegrationMethod)
	}

	if v.IntegrationSubtype != nil {
		ok := object.Key("integrationSubtype")
		ok.String(*v.IntegrationSubtype)
	}

	if len(v.IntegrationType) > 0 {
		ok := object.Key("integrationType")
		ok.String(string(v.IntegrationType))
	}

	if v.IntegrationUri != nil {
		ok := object.Key("integrationUri")
		ok.String(*v.IntegrationUri)
	}

	if len(v.PassthroughBehavior) > 0 {
		ok := object.Key("passthroughBehavior")
		ok.String(string(v.PassthroughBehavior))
	}

	if v.PayloadFormatVersion != nil {
		ok := object.Key("payloadFormatVersion")
		ok.String(*v.PayloadFormatVersion)
	}

	if v.RequestParameters != nil {
		ok := object.Key("requestParameters")
		if err := awsRestjson1_serializeDocumentIntegrationParameters(v.RequestParameters, ok); err != nil {
			return err
		}
	}

	if v.RequestTemplates != nil {
		ok := object.Key("requestTemplates")
		if err := awsRestjson1_serializeDocumentTemplateMap(v.RequestTemplates, ok); err != nil {
			return err
		}
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentResponseParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.TemplateSelectionExpression != nil {
		ok := object.Key("templateSelectionExpression")
		ok.String(*v.TemplateSelectionExpression)
	}

	if v.TimeoutInMillis != 0 {
		ok := object.Key("timeoutInMillis")
		ok.Integer(v.TimeoutInMillis)
	}

	if v.TlsConfig != nil {
		ok := object.Key("tlsConfig")
		if err := awsRestjson1_serializeDocumentTlsConfigInput(v.TlsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIntegrationResponse struct {
}

func (*awsRestjson1_serializeOpCreateIntegrationResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIntegrationResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIntegrationResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIntegrationResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIntegrationResponseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIntegrationResponseInput(v *CreateIntegrationResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIntegrationResponseInput(v *CreateIntegrationResponseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentHandlingStrategy) > 0 {
		ok := object.Key("contentHandlingStrategy")
		ok.String(string(v.ContentHandlingStrategy))
	}

	if v.IntegrationResponseKey != nil {
		ok := object.Key("integrationResponseKey")
		ok.String(*v.IntegrationResponseKey)
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentIntegrationParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.ResponseTemplates != nil {
		ok := object.Key("responseTemplates")
		if err := awsRestjson1_serializeDocumentTemplateMap(v.ResponseTemplates, ok); err != nil {
			return err
		}
	}

	if v.TemplateSelectionExpression != nil {
		ok := object.Key("templateSelectionExpression")
		ok.String(*v.TemplateSelectionExpression)
	}

	return nil
}

type awsRestjson1_serializeOpCreateModel struct {
}

func (*awsRestjson1_serializeOpCreateModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelInput(v *CreateModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelInput(v *CreateModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentType != nil {
		ok := object.Key("contentType")
		ok.String(*v.ContentType)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		ok.String(*v.Schema)
	}

	return nil
}

type awsRestjson1_serializeOpCreateRoute struct {
}

func (*awsRestjson1_serializeOpCreateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouteInput(v *CreateRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouteInput(v *CreateRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKeyRequired {
		ok := object.Key("apiKeyRequired")
		ok.Boolean(v.ApiKeyRequired)
	}

	if v.AuthorizationScopes != nil {
		ok := object.Key("authorizationScopes")
		if err := awsRestjson1_serializeDocumentAuthorizationScopes(v.AuthorizationScopes, ok); err != nil {
			return err
		}
	}

	if len(v.AuthorizationType) > 0 {
		ok := object.Key("authorizationType")
		ok.String(string(v.AuthorizationType))
	}

	if v.AuthorizerId != nil {
		ok := object.Key("authorizerId")
		ok.String(*v.AuthorizerId)
	}

	if v.ModelSelectionExpression != nil {
		ok := object.Key("modelSelectionExpression")
		ok.String(*v.ModelSelectionExpression)
	}

	if v.OperationName != nil {
		ok := object.Key("operationName")
		ok.String(*v.OperationName)
	}

	if v.RequestModels != nil {
		ok := object.Key("requestModels")
		if err := awsRestjson1_serializeDocumentRouteModels(v.RequestModels, ok); err != nil {
			return err
		}
	}

	if v.RequestParameters != nil {
		ok := object.Key("requestParameters")
		if err := awsRestjson1_serializeDocumentRouteParameters(v.RequestParameters, ok); err != nil {
			return err
		}
	}

	if v.RouteKey != nil {
		ok := object.Key("routeKey")
		ok.String(*v.RouteKey)
	}

	if v.RouteResponseSelectionExpression != nil {
		ok := object.Key("routeResponseSelectionExpression")
		ok.String(*v.RouteResponseSelectionExpression)
	}

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	return nil
}

type awsRestjson1_serializeOpCreateRouteResponse struct {
}

func (*awsRestjson1_serializeOpCreateRouteResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRouteResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/routeresponses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRouteResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouteResponseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouteResponseInput(v *CreateRouteResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouteResponseInput(v *CreateRouteResponseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelSelectionExpression != nil {
		ok := object.Key("modelSelectionExpression")
		ok.String(*v.ModelSelectionExpression)
	}

	if v.ResponseModels != nil {
		ok := object.Key("responseModels")
		if err := awsRestjson1_serializeDocumentRouteModels(v.ResponseModels, ok); err != nil {
			return err
		}
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentRouteParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.RouteResponseKey != nil {
		ok := object.Key("routeResponseKey")
		ok.String(*v.RouteResponseKey)
	}

	return nil
}

type awsRestjson1_serializeOpCreateStage struct {
}

func (*awsRestjson1_serializeOpCreateStage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStageInput(v *CreateStageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStageInput(v *CreateStageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLogSettings != nil {
		ok := object.Key("accessLogSettings")
		if err := awsRestjson1_serializeDocumentAccessLogSettings(v.AccessLogSettings, ok); err != nil {
			return err
		}
	}

	if v.AutoDeploy {
		ok := object.Key("autoDeploy")
		ok.Boolean(v.AutoDeploy)
	}

	if v.ClientCertificateId != nil {
		ok := object.Key("clientCertificateId")
		ok.String(*v.ClientCertificateId)
	}

	if v.DefaultRouteSettings != nil {
		ok := object.Key("defaultRouteSettings")
		if err := awsRestjson1_serializeDocumentRouteSettings(v.DefaultRouteSettings, ok); err != nil {
			return err
		}
	}

	if v.DeploymentId != nil {
		ok := object.Key("deploymentId")
		ok.String(*v.DeploymentId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.RouteSettings != nil {
		ok := object.Key("routeSettings")
		if err := awsRestjson1_serializeDocumentRouteSettingsMap(v.RouteSettings, ok); err != nil {
			return err
		}
	}

	if v.StageName != nil {
		ok := object.Key("stageName")
		ok.String(*v.StageName)
	}

	if v.StageVariables != nil {
		ok := object.Key("stageVariables")
		if err := awsRestjson1_serializeDocumentStageVariablesMap(v.StageVariables, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVpcLink struct {
}

func (*awsRestjson1_serializeOpCreateVpcLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVpcLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/vpclinks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVpcLinkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVpcLinkInput(v *CreateVpcLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVpcLinkInput(v *CreateVpcLinkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAccessLogSettings struct {
}

func (*awsRestjson1_serializeOpDeleteAccessLogSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAccessLogSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccessLogSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}/accesslogsettings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAccessLogSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAccessLogSettingsInput(v *DeleteAccessLogSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApi struct {
}

func (*awsRestjson1_serializeOpDeleteApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApiInput(v *DeleteApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApiMapping struct {
}

func (*awsRestjson1_serializeOpDeleteApiMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApiMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApiMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApiMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApiMappingInput(v *DeleteApiMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiMappingId == nil || len(*v.ApiMappingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiMappingId must not be empty")}
	}
	if v.ApiMappingId != nil {
		if err := encoder.SetURI("ApiMappingId").String(*v.ApiMappingId); err != nil {
			return err
		}
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAuthorizer struct {
}

func (*awsRestjson1_serializeOpDeleteAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/authorizers/{AuthorizerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAuthorizerInput(v *DeleteAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.AuthorizerId == nil || len(*v.AuthorizerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AuthorizerId must not be empty")}
	}
	if v.AuthorizerId != nil {
		if err := encoder.SetURI("AuthorizerId").String(*v.AuthorizerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCorsConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteCorsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCorsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCorsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/cors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCorsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCorsConfigurationInput(v *DeleteCorsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDeployment struct {
}

func (*awsRestjson1_serializeOpDeleteDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/deployments/{DeploymentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDeploymentInput(v *DeleteDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("DeploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDomainName struct {
}

func (*awsRestjson1_serializeOpDeleteDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDomainNameInput(v *DeleteDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIntegration struct {
}

func (*awsRestjson1_serializeOpDeleteIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIntegrationInput(v *DeleteIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIntegrationResponse struct {
}

func (*awsRestjson1_serializeOpDeleteIntegrationResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIntegrationResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIntegrationResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIntegrationResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIntegrationResponseInput(v *DeleteIntegrationResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	if v.IntegrationResponseId == nil || len(*v.IntegrationResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationResponseId must not be empty")}
	}
	if v.IntegrationResponseId != nil {
		if err := encoder.SetURI("IntegrationResponseId").String(*v.IntegrationResponseId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteModel struct {
}

func (*awsRestjson1_serializeOpDeleteModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models/{ModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteModelInput(v *DeleteModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ModelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("ModelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRoute struct {
}

func (*awsRestjson1_serializeOpDeleteRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteInput(v *DeleteRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouteRequestParameter struct {
}

func (*awsRestjson1_serializeOpDeleteRouteRequestParameter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouteRequestParameter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteRequestParameterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/requestparameters/{RequestParameterKey}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteRequestParameterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteRequestParameterInput(v *DeleteRouteRequestParameterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RequestParameterKey == nil || len(*v.RequestParameterKey) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RequestParameterKey must not be empty")}
	}
	if v.RequestParameterKey != nil {
		if err := encoder.SetURI("RequestParameterKey").String(*v.RequestParameterKey); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouteResponse struct {
}

func (*awsRestjson1_serializeOpDeleteRouteResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouteResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteResponseInput(v *DeleteRouteResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	if v.RouteResponseId == nil || len(*v.RouteResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteResponseId must not be empty")}
	}
	if v.RouteResponseId != nil {
		if err := encoder.SetURI("RouteResponseId").String(*v.RouteResponseId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouteSettings struct {
}

func (*awsRestjson1_serializeOpDeleteRouteSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouteSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}/routesettings/{RouteKey}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteSettingsInput(v *DeleteRouteSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteKey == nil || len(*v.RouteKey) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteKey must not be empty")}
	}
	if v.RouteKey != nil {
		if err := encoder.SetURI("RouteKey").String(*v.RouteKey); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStage struct {
}

func (*awsRestjson1_serializeOpDeleteStage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStageInput(v *DeleteStageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVpcLink struct {
}

func (*awsRestjson1_serializeOpDeleteVpcLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVpcLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/vpclinks/{VpcLinkId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVpcLinkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVpcLinkInput(v *DeleteVpcLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.VpcLinkId == nil || len(*v.VpcLinkId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VpcLinkId must not be empty")}
	}
	if v.VpcLinkId != nil {
		if err := encoder.SetURI("VpcLinkId").String(*v.VpcLinkId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportApi struct {
}

func (*awsRestjson1_serializeOpExportApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/exports/{Specification}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportApiInput(v *ExportApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.ExportVersion != nil {
		encoder.SetQuery("exportVersion").String(*v.ExportVersion)
	}

	if v.IncludeExtensions {
		encoder.SetQuery("includeExtensions").Boolean(v.IncludeExtensions)
	}

	if v.OutputType != nil {
		encoder.SetQuery("outputType").String(*v.OutputType)
	}

	if v.Specification == nil || len(*v.Specification) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Specification must not be empty")}
	}
	if v.Specification != nil {
		if err := encoder.SetURI("Specification").String(*v.Specification); err != nil {
			return err
		}
	}

	if v.StageName != nil {
		encoder.SetQuery("stageName").String(*v.StageName)
	}

	return nil
}

type awsRestjson1_serializeOpGetApi struct {
}

func (*awsRestjson1_serializeOpGetApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApiInput(v *GetApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApiMapping struct {
}

func (*awsRestjson1_serializeOpGetApiMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApiMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApiMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApiMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApiMappingInput(v *GetApiMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiMappingId == nil || len(*v.ApiMappingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiMappingId must not be empty")}
	}
	if v.ApiMappingId != nil {
		if err := encoder.SetURI("ApiMappingId").String(*v.ApiMappingId); err != nil {
			return err
		}
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApiMappings struct {
}

func (*awsRestjson1_serializeOpGetApiMappings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApiMappings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApiMappingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}/apimappings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApiMappingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApiMappingsInput(v *GetApiMappingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetApis struct {
}

func (*awsRestjson1_serializeOpGetApis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApisInput(v *GetApisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetAuthorizer struct {
}

func (*awsRestjson1_serializeOpGetAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/authorizers/{AuthorizerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAuthorizerInput(v *GetAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.AuthorizerId == nil || len(*v.AuthorizerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AuthorizerId must not be empty")}
	}
	if v.AuthorizerId != nil {
		if err := encoder.SetURI("AuthorizerId").String(*v.AuthorizerId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAuthorizers struct {
}

func (*awsRestjson1_serializeOpGetAuthorizers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAuthorizers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAuthorizersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/authorizers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAuthorizersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAuthorizersInput(v *GetAuthorizersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetDeployment struct {
}

func (*awsRestjson1_serializeOpGetDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/deployments/{DeploymentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDeploymentInput(v *GetDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("DeploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDeployments struct {
}

func (*awsRestjson1_serializeOpGetDeployments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDeployments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeploymentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/deployments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDeploymentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDeploymentsInput(v *GetDeploymentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetDomainName struct {
}

func (*awsRestjson1_serializeOpGetDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainNameInput(v *GetDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDomainNames struct {
}

func (*awsRestjson1_serializeOpGetDomainNames) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomainNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainNamesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainNamesInput(v *GetDomainNamesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetIntegration struct {
}

func (*awsRestjson1_serializeOpGetIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntegrationInput(v *GetIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIntegrationResponse struct {
}

func (*awsRestjson1_serializeOpGetIntegrationResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntegrationResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntegrationResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntegrationResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntegrationResponseInput(v *GetIntegrationResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	if v.IntegrationResponseId == nil || len(*v.IntegrationResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationResponseId must not be empty")}
	}
	if v.IntegrationResponseId != nil {
		if err := encoder.SetURI("IntegrationResponseId").String(*v.IntegrationResponseId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIntegrationResponses struct {
}

func (*awsRestjson1_serializeOpGetIntegrationResponses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntegrationResponses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntegrationResponsesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntegrationResponsesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntegrationResponsesInput(v *GetIntegrationResponsesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetIntegrations struct {
}

func (*awsRestjson1_serializeOpGetIntegrations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntegrations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntegrationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntegrationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntegrationsInput(v *GetIntegrationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetModel struct {
}

func (*awsRestjson1_serializeOpGetModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models/{ModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelInput(v *GetModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ModelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("ModelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModels struct {
}

func (*awsRestjson1_serializeOpGetModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelsInput(v *GetModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetModelTemplate struct {
}

func (*awsRestjson1_serializeOpGetModelTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models/{ModelId}/template")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelTemplateInput(v *GetModelTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ModelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("ModelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRoute struct {
}

func (*awsRestjson1_serializeOpGetRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouteInput(v *GetRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouteResponse struct {
}

func (*awsRestjson1_serializeOpGetRouteResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouteResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouteResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouteResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouteResponseInput(v *GetRouteResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	if v.RouteResponseId == nil || len(*v.RouteResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteResponseId must not be empty")}
	}
	if v.RouteResponseId != nil {
		if err := encoder.SetURI("RouteResponseId").String(*v.RouteResponseId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRouteResponses struct {
}

func (*awsRestjson1_serializeOpGetRouteResponses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRouteResponses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRouteResponsesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/routeresponses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRouteResponsesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRouteResponsesInput(v *GetRouteResponsesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRoutes struct {
}

func (*awsRestjson1_serializeOpGetRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRoutesInput(v *GetRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetStage struct {
}

func (*awsRestjson1_serializeOpGetStage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStageInput(v *GetStageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStages struct {
}

func (*awsRestjson1_serializeOpGetStages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStagesInput(v *GetStagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetTags struct {
}

func (*awsRestjson1_serializeOpGetTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTagsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTagsInput(v *GetTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVpcLink struct {
}

func (*awsRestjson1_serializeOpGetVpcLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVpcLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVpcLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/vpclinks/{VpcLinkId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVpcLinkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVpcLinkInput(v *GetVpcLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.VpcLinkId == nil || len(*v.VpcLinkId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VpcLinkId must not be empty")}
	}
	if v.VpcLinkId != nil {
		if err := encoder.SetURI("VpcLinkId").String(*v.VpcLinkId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVpcLinks struct {
}

func (*awsRestjson1_serializeOpGetVpcLinks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVpcLinks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVpcLinksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/vpclinks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVpcLinksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVpcLinksInput(v *GetVpcLinksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").String(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpImportApi struct {
}

func (*awsRestjson1_serializeOpImportApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpImportApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsImportApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentImportApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsImportApiInput(v *ImportApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Basepath != nil {
		encoder.SetQuery("basepath").String(*v.Basepath)
	}

	if v.FailOnWarnings {
		encoder.SetQuery("failOnWarnings").Boolean(v.FailOnWarnings)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentImportApiInput(v *ImportApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("body")
		ok.String(*v.Body)
	}

	return nil
}

type awsRestjson1_serializeOpReimportApi struct {
}

func (*awsRestjson1_serializeOpReimportApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReimportApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReimportApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReimportApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentReimportApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReimportApiInput(v *ReimportApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Basepath != nil {
		encoder.SetQuery("basepath").String(*v.Basepath)
	}

	if v.FailOnWarnings {
		encoder.SetQuery("failOnWarnings").Boolean(v.FailOnWarnings)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentReimportApiInput(v *ReimportApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("body")
		ok.String(*v.Body)
	}

	return nil
}

type awsRestjson1_serializeOpResetAuthorizersCache struct {
}

func (*awsRestjson1_serializeOpResetAuthorizersCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpResetAuthorizersCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetAuthorizersCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}/cache/authorizers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsResetAuthorizersCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsResetAuthorizersCacheInput(v *ResetAuthorizersCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApi struct {
}

func (*awsRestjson1_serializeOpUpdateApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApiInput(v *UpdateApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApiInput(v *UpdateApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKeySelectionExpression != nil {
		ok := object.Key("apiKeySelectionExpression")
		ok.String(*v.ApiKeySelectionExpression)
	}

	if v.CorsConfiguration != nil {
		ok := object.Key("corsConfiguration")
		if err := awsRestjson1_serializeDocumentCors(v.CorsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CredentialsArn != nil {
		ok := object.Key("credentialsArn")
		ok.String(*v.CredentialsArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisableExecuteApiEndpoint {
		ok := object.Key("disableExecuteApiEndpoint")
		ok.Boolean(v.DisableExecuteApiEndpoint)
	}

	if v.DisableSchemaValidation {
		ok := object.Key("disableSchemaValidation")
		ok.Boolean(v.DisableSchemaValidation)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RouteKey != nil {
		ok := object.Key("routeKey")
		ok.String(*v.RouteKey)
	}

	if v.RouteSelectionExpression != nil {
		ok := object.Key("routeSelectionExpression")
		ok.String(*v.RouteSelectionExpression)
	}

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApiMapping struct {
}

func (*awsRestjson1_serializeOpUpdateApiMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApiMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApiMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}/apimappings/{ApiMappingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApiMappingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApiMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApiMappingInput(v *UpdateApiMappingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiMappingId == nil || len(*v.ApiMappingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiMappingId must not be empty")}
	}
	if v.ApiMappingId != nil {
		if err := encoder.SetURI("ApiMappingId").String(*v.ApiMappingId); err != nil {
			return err
		}
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApiMappingInput(v *UpdateApiMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiId != nil {
		ok := object.Key("apiId")
		ok.String(*v.ApiId)
	}

	if v.ApiMappingKey != nil {
		ok := object.Key("apiMappingKey")
		ok.String(*v.ApiMappingKey)
	}

	if v.Stage != nil {
		ok := object.Key("stage")
		ok.String(*v.Stage)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAuthorizer struct {
}

func (*awsRestjson1_serializeOpUpdateAuthorizer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAuthorizer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAuthorizerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/authorizers/{AuthorizerId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAuthorizerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAuthorizerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAuthorizerInput(v *UpdateAuthorizerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.AuthorizerId == nil || len(*v.AuthorizerId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AuthorizerId must not be empty")}
	}
	if v.AuthorizerId != nil {
		if err := encoder.SetURI("AuthorizerId").String(*v.AuthorizerId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAuthorizerInput(v *UpdateAuthorizerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerCredentialsArn != nil {
		ok := object.Key("authorizerCredentialsArn")
		ok.String(*v.AuthorizerCredentialsArn)
	}

	if v.AuthorizerPayloadFormatVersion != nil {
		ok := object.Key("authorizerPayloadFormatVersion")
		ok.String(*v.AuthorizerPayloadFormatVersion)
	}

	if v.AuthorizerResultTtlInSeconds != 0 {
		ok := object.Key("authorizerResultTtlInSeconds")
		ok.Integer(v.AuthorizerResultTtlInSeconds)
	}

	if len(v.AuthorizerType) > 0 {
		ok := object.Key("authorizerType")
		ok.String(string(v.AuthorizerType))
	}

	if v.AuthorizerUri != nil {
		ok := object.Key("authorizerUri")
		ok.String(*v.AuthorizerUri)
	}

	if v.EnableSimpleResponses {
		ok := object.Key("enableSimpleResponses")
		ok.Boolean(v.EnableSimpleResponses)
	}

	if v.IdentitySource != nil {
		ok := object.Key("identitySource")
		if err := awsRestjson1_serializeDocumentIdentitySourceList(v.IdentitySource, ok); err != nil {
			return err
		}
	}

	if v.IdentityValidationExpression != nil {
		ok := object.Key("identityValidationExpression")
		ok.String(*v.IdentityValidationExpression)
	}

	if v.JwtConfiguration != nil {
		ok := object.Key("jwtConfiguration")
		if err := awsRestjson1_serializeDocumentJWTConfiguration(v.JwtConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDeployment struct {
}

func (*awsRestjson1_serializeOpUpdateDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/deployments/{DeploymentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDeploymentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDeploymentInput(v *UpdateDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("DeploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDeploymentInput(v *UpdateDeploymentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDomainName struct {
}

func (*awsRestjson1_serializeOpUpdateDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/domainnames/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDomainNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDomainNameInput(v *UpdateDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDomainNameInput(v *UpdateDomainNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainNameConfigurations != nil {
		ok := object.Key("domainNameConfigurations")
		if err := awsRestjson1_serializeDocumentDomainNameConfigurations(v.DomainNameConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MutualTlsAuthentication != nil {
		ok := object.Key("mutualTlsAuthentication")
		if err := awsRestjson1_serializeDocumentMutualTlsAuthenticationInput(v.MutualTlsAuthentication, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIntegration struct {
}

func (*awsRestjson1_serializeOpUpdateIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIntegrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIntegrationInput(v *UpdateIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIntegrationInput(v *UpdateIntegrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectionId != nil {
		ok := object.Key("connectionId")
		ok.String(*v.ConnectionId)
	}

	if len(v.ConnectionType) > 0 {
		ok := object.Key("connectionType")
		ok.String(string(v.ConnectionType))
	}

	if len(v.ContentHandlingStrategy) > 0 {
		ok := object.Key("contentHandlingStrategy")
		ok.String(string(v.ContentHandlingStrategy))
	}

	if v.CredentialsArn != nil {
		ok := object.Key("credentialsArn")
		ok.String(*v.CredentialsArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IntegrationMethod != nil {
		ok := object.Key("integrationMethod")
		ok.String(*v.IntegrationMethod)
	}

	if v.IntegrationSubtype != nil {
		ok := object.Key("integrationSubtype")
		ok.String(*v.IntegrationSubtype)
	}

	if len(v.IntegrationType) > 0 {
		ok := object.Key("integrationType")
		ok.String(string(v.IntegrationType))
	}

	if v.IntegrationUri != nil {
		ok := object.Key("integrationUri")
		ok.String(*v.IntegrationUri)
	}

	if len(v.PassthroughBehavior) > 0 {
		ok := object.Key("passthroughBehavior")
		ok.String(string(v.PassthroughBehavior))
	}

	if v.PayloadFormatVersion != nil {
		ok := object.Key("payloadFormatVersion")
		ok.String(*v.PayloadFormatVersion)
	}

	if v.RequestParameters != nil {
		ok := object.Key("requestParameters")
		if err := awsRestjson1_serializeDocumentIntegrationParameters(v.RequestParameters, ok); err != nil {
			return err
		}
	}

	if v.RequestTemplates != nil {
		ok := object.Key("requestTemplates")
		if err := awsRestjson1_serializeDocumentTemplateMap(v.RequestTemplates, ok); err != nil {
			return err
		}
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentResponseParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.TemplateSelectionExpression != nil {
		ok := object.Key("templateSelectionExpression")
		ok.String(*v.TemplateSelectionExpression)
	}

	if v.TimeoutInMillis != 0 {
		ok := object.Key("timeoutInMillis")
		ok.Integer(v.TimeoutInMillis)
	}

	if v.TlsConfig != nil {
		ok := object.Key("tlsConfig")
		if err := awsRestjson1_serializeDocumentTlsConfigInput(v.TlsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIntegrationResponse struct {
}

func (*awsRestjson1_serializeOpUpdateIntegrationResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIntegrationResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIntegrationResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/integrations/{IntegrationId}/integrationresponses/{IntegrationResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIntegrationResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIntegrationResponseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIntegrationResponseInput(v *UpdateIntegrationResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.IntegrationId == nil || len(*v.IntegrationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationId must not be empty")}
	}
	if v.IntegrationId != nil {
		if err := encoder.SetURI("IntegrationId").String(*v.IntegrationId); err != nil {
			return err
		}
	}

	if v.IntegrationResponseId == nil || len(*v.IntegrationResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IntegrationResponseId must not be empty")}
	}
	if v.IntegrationResponseId != nil {
		if err := encoder.SetURI("IntegrationResponseId").String(*v.IntegrationResponseId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIntegrationResponseInput(v *UpdateIntegrationResponseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentHandlingStrategy) > 0 {
		ok := object.Key("contentHandlingStrategy")
		ok.String(string(v.ContentHandlingStrategy))
	}

	if v.IntegrationResponseKey != nil {
		ok := object.Key("integrationResponseKey")
		ok.String(*v.IntegrationResponseKey)
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentIntegrationParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.ResponseTemplates != nil {
		ok := object.Key("responseTemplates")
		if err := awsRestjson1_serializeDocumentTemplateMap(v.ResponseTemplates, ok); err != nil {
			return err
		}
	}

	if v.TemplateSelectionExpression != nil {
		ok := object.Key("templateSelectionExpression")
		ok.String(*v.TemplateSelectionExpression)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateModel struct {
}

func (*awsRestjson1_serializeOpUpdateModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/models/{ModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateModelInput(v *UpdateModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.ModelId == nil || len(*v.ModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ModelId must not be empty")}
	}
	if v.ModelId != nil {
		if err := encoder.SetURI("ModelId").String(*v.ModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateModelInput(v *UpdateModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentType != nil {
		ok := object.Key("contentType")
		ok.String(*v.ContentType)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		ok.String(*v.Schema)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRoute struct {
}

func (*awsRestjson1_serializeOpUpdateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouteInput(v *UpdateRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouteInput(v *UpdateRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiKeyRequired {
		ok := object.Key("apiKeyRequired")
		ok.Boolean(v.ApiKeyRequired)
	}

	if v.AuthorizationScopes != nil {
		ok := object.Key("authorizationScopes")
		if err := awsRestjson1_serializeDocumentAuthorizationScopes(v.AuthorizationScopes, ok); err != nil {
			return err
		}
	}

	if len(v.AuthorizationType) > 0 {
		ok := object.Key("authorizationType")
		ok.String(string(v.AuthorizationType))
	}

	if v.AuthorizerId != nil {
		ok := object.Key("authorizerId")
		ok.String(*v.AuthorizerId)
	}

	if v.ModelSelectionExpression != nil {
		ok := object.Key("modelSelectionExpression")
		ok.String(*v.ModelSelectionExpression)
	}

	if v.OperationName != nil {
		ok := object.Key("operationName")
		ok.String(*v.OperationName)
	}

	if v.RequestModels != nil {
		ok := object.Key("requestModels")
		if err := awsRestjson1_serializeDocumentRouteModels(v.RequestModels, ok); err != nil {
			return err
		}
	}

	if v.RequestParameters != nil {
		ok := object.Key("requestParameters")
		if err := awsRestjson1_serializeDocumentRouteParameters(v.RequestParameters, ok); err != nil {
			return err
		}
	}

	if v.RouteKey != nil {
		ok := object.Key("routeKey")
		ok.String(*v.RouteKey)
	}

	if v.RouteResponseSelectionExpression != nil {
		ok := object.Key("routeResponseSelectionExpression")
		ok.String(*v.RouteResponseSelectionExpression)
	}

	if v.Target != nil {
		ok := object.Key("target")
		ok.String(*v.Target)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRouteResponse struct {
}

func (*awsRestjson1_serializeOpUpdateRouteResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRouteResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouteResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/routes/{RouteId}/routeresponses/{RouteResponseId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouteResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouteResponseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouteResponseInput(v *UpdateRouteResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.RouteId == nil || len(*v.RouteId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteId must not be empty")}
	}
	if v.RouteId != nil {
		if err := encoder.SetURI("RouteId").String(*v.RouteId); err != nil {
			return err
		}
	}

	if v.RouteResponseId == nil || len(*v.RouteResponseId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RouteResponseId must not be empty")}
	}
	if v.RouteResponseId != nil {
		if err := encoder.SetURI("RouteResponseId").String(*v.RouteResponseId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouteResponseInput(v *UpdateRouteResponseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelSelectionExpression != nil {
		ok := object.Key("modelSelectionExpression")
		ok.String(*v.ModelSelectionExpression)
	}

	if v.ResponseModels != nil {
		ok := object.Key("responseModels")
		if err := awsRestjson1_serializeDocumentRouteModels(v.ResponseModels, ok); err != nil {
			return err
		}
	}

	if v.ResponseParameters != nil {
		ok := object.Key("responseParameters")
		if err := awsRestjson1_serializeDocumentRouteParameters(v.ResponseParameters, ok); err != nil {
			return err
		}
	}

	if v.RouteResponseKey != nil {
		ok := object.Key("routeResponseKey")
		ok.String(*v.RouteResponseKey)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStage struct {
}

func (*awsRestjson1_serializeOpUpdateStage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/apis/{ApiId}/stages/{StageName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStageInput(v *UpdateStageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ApiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("ApiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.StageName == nil || len(*v.StageName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member StageName must not be empty")}
	}
	if v.StageName != nil {
		if err := encoder.SetURI("StageName").String(*v.StageName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStageInput(v *UpdateStageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessLogSettings != nil {
		ok := object.Key("accessLogSettings")
		if err := awsRestjson1_serializeDocumentAccessLogSettings(v.AccessLogSettings, ok); err != nil {
			return err
		}
	}

	if v.AutoDeploy {
		ok := object.Key("autoDeploy")
		ok.Boolean(v.AutoDeploy)
	}

	if v.ClientCertificateId != nil {
		ok := object.Key("clientCertificateId")
		ok.String(*v.ClientCertificateId)
	}

	if v.DefaultRouteSettings != nil {
		ok := object.Key("defaultRouteSettings")
		if err := awsRestjson1_serializeDocumentRouteSettings(v.DefaultRouteSettings, ok); err != nil {
			return err
		}
	}

	if v.DeploymentId != nil {
		ok := object.Key("deploymentId")
		ok.String(*v.DeploymentId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.RouteSettings != nil {
		ok := object.Key("routeSettings")
		if err := awsRestjson1_serializeDocumentRouteSettingsMap(v.RouteSettings, ok); err != nil {
			return err
		}
	}

	if v.StageVariables != nil {
		ok := object.Key("stageVariables")
		if err := awsRestjson1_serializeDocumentStageVariablesMap(v.StageVariables, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVpcLink struct {
}

func (*awsRestjson1_serializeOpUpdateVpcLink) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVpcLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVpcLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v2/vpclinks/{VpcLinkId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVpcLinkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVpcLinkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVpcLinkInput(v *UpdateVpcLinkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.VpcLinkId == nil || len(*v.VpcLinkId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VpcLinkId must not be empty")}
	}
	if v.VpcLinkId != nil {
		if err := encoder.SetURI("VpcLinkId").String(*v.VpcLinkId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVpcLinkInput(v *UpdateVpcLinkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAccessLogSettings(v *types.AccessLogSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationArn != nil {
		ok := object.Key("destinationArn")
		ok.String(*v.DestinationArn)
	}

	if v.Format != nil {
		ok := object.Key("format")
		ok.String(*v.Format)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthorizationScopes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCors(v *types.Cors, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowCredentials {
		ok := object.Key("allowCredentials")
		ok.Boolean(v.AllowCredentials)
	}

	if v.AllowHeaders != nil {
		ok := object.Key("allowHeaders")
		if err := awsRestjson1_serializeDocumentCorsHeaderList(v.AllowHeaders, ok); err != nil {
			return err
		}
	}

	if v.AllowMethods != nil {
		ok := object.Key("allowMethods")
		if err := awsRestjson1_serializeDocumentCorsMethodList(v.AllowMethods, ok); err != nil {
			return err
		}
	}

	if v.AllowOrigins != nil {
		ok := object.Key("allowOrigins")
		if err := awsRestjson1_serializeDocumentCorsOriginList(v.AllowOrigins, ok); err != nil {
			return err
		}
	}

	if v.ExposeHeaders != nil {
		ok := object.Key("exposeHeaders")
		if err := awsRestjson1_serializeDocumentCorsHeaderList(v.ExposeHeaders, ok); err != nil {
			return err
		}
	}

	if v.MaxAge != 0 {
		ok := object.Key("maxAge")
		ok.Integer(v.MaxAge)
	}

	return nil
}

func awsRestjson1_serializeDocumentCorsHeaderList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCorsMethodList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCorsOriginList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDomainNameConfiguration(v *types.DomainNameConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiGatewayDomainName != nil {
		ok := object.Key("apiGatewayDomainName")
		ok.String(*v.ApiGatewayDomainName)
	}

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.CertificateName != nil {
		ok := object.Key("certificateName")
		ok.String(*v.CertificateName)
	}

	if v.CertificateUploadDate != nil {
		ok := object.Key("certificateUploadDate")
		ok.String(smithytime.FormatDateTime(*v.CertificateUploadDate))
	}

	if len(v.DomainNameStatus) > 0 {
		ok := object.Key("domainNameStatus")
		ok.String(string(v.DomainNameStatus))
	}

	if v.DomainNameStatusMessage != nil {
		ok := object.Key("domainNameStatusMessage")
		ok.String(*v.DomainNameStatusMessage)
	}

	if len(v.EndpointType) > 0 {
		ok := object.Key("endpointType")
		ok.String(string(v.EndpointType))
	}

	if v.HostedZoneId != nil {
		ok := object.Key("hostedZoneId")
		ok.String(*v.HostedZoneId)
	}

	if v.OwnershipVerificationCertificateArn != nil {
		ok := object.Key("ownershipVerificationCertificateArn")
		ok.String(*v.OwnershipVerificationCertificateArn)
	}

	if len(v.SecurityPolicy) > 0 {
		ok := object.Key("securityPolicy")
		ok.String(string(v.SecurityPolicy))
	}

	return nil
}

func awsRestjson1_serializeDocumentDomainNameConfigurations(v []types.DomainNameConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDomainNameConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIdentitySourceList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentIntegrationParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentJWTConfiguration(v *types.JWTConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audience != nil {
		ok := object.Key("audience")
		if err := awsRestjson1_serializeDocument__listOf__string(v.Audience, ok); err != nil {
			return err
		}
	}

	if v.Issuer != nil {
		ok := object.Key("issuer")
		ok.String(*v.Issuer)
	}

	return nil
}

func awsRestjson1_serializeDocumentMutualTlsAuthenticationInput(v *types.MutualTlsAuthenticationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TruststoreUri != nil {
		ok := object.Key("truststoreUri")
		ok.String(*v.TruststoreUri)
	}

	if v.TruststoreVersion != nil {
		ok := object.Key("truststoreVersion")
		ok.String(*v.TruststoreVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameterConstraints(v *types.ParameterConstraints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Required {
		ok := object.Key("required")
		ok.Boolean(v.Required)
	}

	return nil
}

func awsRestjson1_serializeDocumentResponseParameters(v map[string]map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentIntegrationParameters(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteModels(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteParameters(v map[string]types.ParameterConstraints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentParameterConstraints(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRouteSettings(v *types.RouteSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataTraceEnabled {
		ok := object.Key("dataTraceEnabled")
		ok.Boolean(v.DataTraceEnabled)
	}

	if v.DetailedMetricsEnabled {
		ok := object.Key("detailedMetricsEnabled")
		ok.Boolean(v.DetailedMetricsEnabled)
	}

	if len(v.LoggingLevel) > 0 {
		ok := object.Key("loggingLevel")
		ok.String(string(v.LoggingLevel))
	}

	if v.ThrottlingBurstLimit != 0 {
		ok := object.Key("throttlingBurstLimit")
		ok.Integer(v.ThrottlingBurstLimit)
	}

	if v.ThrottlingRateLimit != 0 {
		ok := object.Key("throttlingRateLimit")
		switch {
		case math.IsNaN(v.ThrottlingRateLimit):
			ok.String("NaN")

		case math.IsInf(v.ThrottlingRateLimit, 1):
			ok.String("Infinity")

		case math.IsInf(v.ThrottlingRateLimit, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.ThrottlingRateLimit)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRouteSettingsMap(v map[string]types.RouteSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentRouteSettings(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStageVariablesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplateMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTlsConfigInput(v *types.TlsConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ServerNameToVerify != nil {
		ok := object.Key("serverNameToVerify")
		ok.String(*v.ServerNameToVerify)
	}

	return nil
}
