// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Provides the MIME content of the updated email message as an S3 object. All MIME
// content must meet the following criteria:
//
// * Each part of a multipart MIME
// message must be formatted properly.
//
// * Attachments must be of a content type
// that Amazon SES supports. For more information, see Unsupported Attachment Types
// (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types-appendix.html).
//
// *
// If any of the MIME parts in a message contain content that is outside of the
// 7-bit ASCII character range, we recommend encoding that content.
//
// * Per RFC 5321
// (https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6), the maximum length of
// each line of text, including the , must not exceed 1,000 characters.
//
// * The
// message must contain all the required header fields. Check the returned error
// message for more information.
//
// * The value of immutable headers must remain
// unchanged. Check the returned error message for more information.
//
// * Certain
// unique headers can only appear once. Check the returned error message for more
// information.
type RawMessageContent struct {

	// The S3 reference of an email message.
	//
	// This member is required.
	S3Reference *S3Reference

	noSmithyDocumentSerde
}

// Amazon S3 object representing the updated message content, in MIME format. The
// region for the S3 bucket containing the S3 object must match the region used for
// WorkMail operations. Also, for WorkMail to process an S3 object, it must have
// permission to access that object. For more information, see  Updating message
// content with AWS Lambda
// (https://docs.aws.amazon.com/workmail/latest/adminguide/update-with-lambda.html).
type S3Reference struct {

	// The S3 bucket name.
	//
	// This member is required.
	Bucket *string

	// The S3 key object name.
	//
	// This member is required.
	Key *string

	// If you enable versioning for the bucket, you can specify the object version.
	ObjectVersion *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
