package training

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Classification ...
	Classification DomainType = "Classification"
	// ObjectDetection ...
	ObjectDetection DomainType = "ObjectDetection"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Classification, ObjectDetection}
}

// ExportFlavor enumerates the values for export flavor.
type ExportFlavor string

const (
	// Linux ...
	Linux ExportFlavor = "Linux"
	// Windows ...
	Windows ExportFlavor = "Windows"
)

// PossibleExportFlavorValues returns an array of possible values for the ExportFlavor const type.
func PossibleExportFlavorValues() []ExportFlavor {
	return []ExportFlavor{Linux, Windows}
}

// ExportPlatform enumerates the values for export platform.
type ExportPlatform string

const (
	// CoreML ...
	CoreML ExportPlatform = "CoreML"
	// DockerFile ...
	DockerFile ExportPlatform = "DockerFile"
	// ONNX ...
	ONNX ExportPlatform = "ONNX"
	// TensorFlow ...
	TensorFlow ExportPlatform = "TensorFlow"
)

// PossibleExportPlatformValues returns an array of possible values for the ExportPlatform const type.
func PossibleExportPlatformValues() []ExportPlatform {
	return []ExportPlatform{CoreML, DockerFile, ONNX, TensorFlow}
}

// ExportStatusModel enumerates the values for export status model.
type ExportStatusModel string

const (
	// Done ...
	Done ExportStatusModel = "Done"
	// Exporting ...
	Exporting ExportStatusModel = "Exporting"
	// Failed ...
	Failed ExportStatusModel = "Failed"
)

// PossibleExportStatusModelValues returns an array of possible values for the ExportStatusModel const type.
func PossibleExportStatusModelValues() []ExportStatusModel {
	return []ExportStatusModel{Done, Exporting, Failed}
}

// ImageUploadStatus enumerates the values for image upload status.
type ImageUploadStatus string

const (
	// ErrorImageFormat ...
	ErrorImageFormat ImageUploadStatus = "ErrorImageFormat"
	// ErrorImageSize ...
	ErrorImageSize ImageUploadStatus = "ErrorImageSize"
	// ErrorLimitExceed ...
	ErrorLimitExceed ImageUploadStatus = "ErrorLimitExceed"
	// ErrorRegionLimitExceed ...
	ErrorRegionLimitExceed ImageUploadStatus = "ErrorRegionLimitExceed"
	// ErrorSource ...
	ErrorSource ImageUploadStatus = "ErrorSource"
	// ErrorStorage ...
	ErrorStorage ImageUploadStatus = "ErrorStorage"
	// ErrorTagLimitExceed ...
	ErrorTagLimitExceed ImageUploadStatus = "ErrorTagLimitExceed"
	// ErrorUnknown ...
	ErrorUnknown ImageUploadStatus = "ErrorUnknown"
	// OK ...
	OK ImageUploadStatus = "OK"
	// OKDuplicate ...
	OKDuplicate ImageUploadStatus = "OKDuplicate"
)

// PossibleImageUploadStatusValues returns an array of possible values for the ImageUploadStatus const type.
func PossibleImageUploadStatusValues() []ImageUploadStatus {
	return []ImageUploadStatus{ErrorImageFormat, ErrorImageSize, ErrorLimitExceed, ErrorRegionLimitExceed, ErrorSource, ErrorStorage, ErrorTagLimitExceed, ErrorUnknown, OK, OKDuplicate}
}

// OrderBy enumerates the values for order by.
type OrderBy string

const (
	// Newest ...
	Newest OrderBy = "Newest"
	// Oldest ...
	Oldest OrderBy = "Oldest"
	// Suggested ...
	Suggested OrderBy = "Suggested"
)

// PossibleOrderByValues returns an array of possible values for the OrderBy const type.
func PossibleOrderByValues() []OrderBy {
	return []OrderBy{Newest, Oldest, Suggested}
}
