/*
 * Copyright (c) Tony Bybell 2010.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#ifndef WAVE_TCLCB_H
#define WAVE_TCLCB_H

#include <config.h>

#ifdef HAVE_LIBTCL

#include <tcl.h>
#include <tk.h>
#include "debug.h"

#define WAVE_TCL_LIST_ELEMENT			(TCL_LIST_ELEMENT)
#define WAVE_TCL_APPEND_VALUE			(TCL_APPEND_VALUE)
#define WAVE_TCL_GLOBAL_ONLY			(TCL_GLOBAL_ONLY)

#else

#define WAVE_TCL_LIST_ELEMENT			(0)
#define WAVE_TCL_APPEND_VALUE			(0)
#define WAVE_TCL_GLOBAL_ONLY			(0)

#endif


#define WAVE_TCLCB_FLAGS_NONE			(WAVE_TCL_LIST_ELEMENT|WAVE_TCL_GLOBAL_ONLY)
#define WAVE_TCLCB_FLAGS_APPEND			(WAVE_TCL_LIST_ELEMENT|WAVE_TCL_GLOBAL_ONLY|WAVE_TCL_APPEND_VALUE)

/* ################################################################ */

#define WAVE_TCLCB_ERROR			"gtkwave::cbError"
#define WAVE_TCLCB_ERROR_FLAGS			WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_ERROR_INIT			""

#define WAVE_TCLCB_TIMER_PERIOD			"gtkwave::cbTimerPeriod"
#define WAVE_TCLCB_TIMER_PERIOD_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TIMER_PERIOD_INIT		"250"

#define WAVE_TCLCB_CURRENT_ACTIVE_TAB		"gtkwave::cbCurrentActiveTab"
#define WAVE_TCLCB_CURRENT_ACTIVE_TAB_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_CURRENT_ACTIVE_INIT		""

#define WAVE_TCLCB_QUIT_PROGRAM			"gtkwave::cbQuitProgram"
#define WAVE_TCLCB_QUIT_PROGRAM_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_QUIT_PROGRAM_INIT		""

#define WAVE_TCLCB_CLOSE_TAB_NUMBER		"gtkwave::cbCloseTabNumber"
#define WAVE_TCLCB_CLOSE_TAB_NUMBER_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_CLOSE_TAB_NUMBER_INIT	""

#define WAVE_TCLCB_RELOAD_BEGIN			"gtkwave::cbReloadBegin"
#define WAVE_TCLCB_RELOAD_BEGIN_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_RELOAD_BEGIN_INIT		""

#define WAVE_TCLCB_RELOAD_END			"gtkwave::cbReloadEnd"
#define WAVE_TCLCB_RELOAD_END_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_RELOAD_END_INIT		""

#define WAVE_TCLCB_TREE_EXPAND			"gtkwave::cbTreeExpand"
#define WAVE_TCLCB_TREE_EXPAND_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_EXPAND_INIT		""

#define WAVE_TCLCB_TREE_COLLAPSE		"gtkwave::cbTreeCollapse"
#define WAVE_TCLCB_TREE_COLLAPSE_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_COLLAPSE_INIT		""

#define WAVE_TCLCB_TREE_SELECT			"gtkwave::cbTreeSelect"
#define WAVE_TCLCB_TREE_SELECT_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_SELECT_INIT		""

#define WAVE_TCLCB_TREE_UNSELECT		"gtkwave::cbTreeUnselect"
#define WAVE_TCLCB_TREE_UNSELECT_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_UNSELECT_INIT		""

#define WAVE_TCLCB_TREE_SIG_SELECT		"gtkwave::cbTreeSigSelect"
#define WAVE_TCLCB_TREE_SIG_SELECT_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_SIG_SELECT_INIT		""

#define WAVE_TCLCB_TREE_SIG_UNSELECT		"gtkwave::cbTreeSigUnselect"
#define WAVE_TCLCB_TREE_SIG_UNSELECT_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_SIG_UNSELECT_INIT	""

#define WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK	"gtkwave::cbTreeSigDoubleClick"
#define WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK_INIT	""

#define WAVE_TCLCB_OPEN_TRACE_GROUP		"gtkwave::cbOpenTraceGroup"
#define WAVE_TCLCB_OPEN_TRACE_GROUP_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_OPEN_TRACE_GROUP_INIT	""

#define WAVE_TCLCB_CLOSE_TRACE_GROUP		"gtkwave::cbCloseTraceGroup"
#define WAVE_TCLCB_CLOSE_TRACE_GROUP_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_CLOSE_TRACE_GROUP_INIT	""

#define WAVE_TCLCB_TRACES_UPDATED		"gtkwave::cbTracesUpdated"
#define WAVE_TCLCB_TRACES_UPDATED_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TRACES_UPDATED_INIT		""

#define WAVE_TCLCB_FROM_ENTRY_UPDATED		"gtkwave::cbFromEntryUpdated"
#define WAVE_TCLCB_FROM_ENTRY_UPDATED_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_FROM_ENTRY_UPDATED_INIT	""

#define WAVE_TCLCB_TO_ENTRY_UPDATED		"gtkwave::cbToEntryUpdated"
#define WAVE_TCLCB_TO_ENTRY_UPDATED_FLAGS	WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_TO_ENTRY_UPDATED_INIT	""

#define WAVE_TCLCB_STATUS_TEXT			"gtkwave::cbStatusText"
#define WAVE_TCLCB_STATUS_TEXT_FLAGS		WAVE_TCLCB_FLAGS_NONE
#define WAVE_TCLCB_STATUS_TEXT_INIT		""

/* ################################################################ */

#define WAVE_TCLCB_MACRO_EXPANSION \
WAVE_TCLCB_M(WAVE_TCLCB_ERROR,			WAVE_TCLCB_ERROR_FLAGS,			WAVE_TCLCB_ERROR_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TIMER_PERIOD,		WAVE_TCLCB_TIMER_PERIOD_FLAGS,		WAVE_TCLCB_TIMER_PERIOD_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_CURRENT_ACTIVE_TAB,	WAVE_TCLCB_CURRENT_ACTIVE_TAB_FLAGS,	WAVE_TCLCB_CURRENT_ACTIVE_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_QUIT_PROGRAM,		WAVE_TCLCB_QUIT_PROGRAM_FLAGS,		WAVE_TCLCB_QUIT_PROGRAM_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_CLOSE_TAB_NUMBER,	WAVE_TCLCB_CLOSE_TAB_NUMBER_FLAGS,	WAVE_TCLCB_CLOSE_TAB_NUMBER_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_RELOAD_BEGIN,		WAVE_TCLCB_RELOAD_BEGIN_FLAGS,		WAVE_TCLCB_RELOAD_BEGIN_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_RELOAD_END,		WAVE_TCLCB_RELOAD_END_FLAGS,		WAVE_TCLCB_RELOAD_END_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_EXPAND,		WAVE_TCLCB_TREE_EXPAND_FLAGS,		WAVE_TCLCB_TREE_EXPAND_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_COLLAPSE,		WAVE_TCLCB_TREE_COLLAPSE_FLAGS,		WAVE_TCLCB_TREE_COLLAPSE_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_SELECT,		WAVE_TCLCB_TREE_SELECT_FLAGS,		WAVE_TCLCB_TREE_SELECT_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_UNSELECT,		WAVE_TCLCB_TREE_UNSELECT_FLAGS,		WAVE_TCLCB_TREE_UNSELECT_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_SIG_SELECT,	WAVE_TCLCB_TREE_SIG_SELECT_FLAGS,	WAVE_TCLCB_TREE_SIG_SELECT_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_SIG_UNSELECT,	WAVE_TCLCB_TREE_SIG_UNSELECT_FLAGS,	WAVE_TCLCB_TREE_SIG_UNSELECT_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK,	WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK_FLAGS,	WAVE_TCLCB_TREE_SIG_DOUBLE_CLICK_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_OPEN_TRACE_GROUP,	WAVE_TCLCB_OPEN_TRACE_GROUP_FLAGS,	WAVE_TCLCB_OPEN_TRACE_GROUP_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_CLOSE_TRACE_GROUP,	WAVE_TCLCB_CLOSE_TRACE_GROUP_FLAGS,	WAVE_TCLCB_CLOSE_TRACE_GROUP_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TRACES_UPDATED,		WAVE_TCLCB_TRACES_UPDATED_FLAGS,	WAVE_TCLCB_TRACES_UPDATED_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_FROM_ENTRY_UPDATED,	WAVE_TCLCB_FROM_ENTRY_UPDATED_FLAGS,	WAVE_TCLCB_FROM_ENTRY_UPDATED_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_TO_ENTRY_UPDATED,	WAVE_TCLCB_TO_ENTRY_UPDATED_FLAGS,	WAVE_TCLCB_TO_ENTRY_UPDATED_INIT),\
WAVE_TCLCB_M(WAVE_TCLCB_STATUS_TEXT,		WAVE_TCLCB_STATUS_TEXT_FLAGS,		WAVE_TCLCB_STATUS_TEXT_INIT),\
WAVE_TCLCB_M("",-1,"")

/* ################################################################ */

#endif
