-- Do not edit! Automatically created with doctest-extract from src/Data/List/HT/Private.hs
{-# LINE 21 "src/Data/List/HT/Private.hs" #-}

module DocTest.Data.List.HT.Private where

import Data.List.HT.Private
import Test.DocTest.Base
import qualified Test.DocTest.Driver as DocTest

{-# LINE 22 "src/Data/List/HT/Private.hs" #-}
import     qualified Test.QuickCheck as QC
import     Test.Utility (forAllPredicates)
import     Test.QuickCheck (NonNegative(NonNegative), Positive(Positive), NonEmptyList(NonEmpty))
import     qualified Data.List as List
import     Data.List (transpose)
import     Data.Maybe.HT (toMaybe)
import     Data.Maybe (mapMaybe, isNothing)
import     Data.Char (isLetter, toUpper)
import     Data.Eq.HT (equating)
import     Control.Monad (liftM2)

divMaybe     :: Int -> Int -> Maybe Int
divMaybe     m n = case divMod n m of (q,0) -> Just q; _ -> Nothing

forAllMaybeFn     :: (QC.Testable test) => ((Int -> Maybe Int) -> test) -> QC.Property
forAllMaybeFn     prop = QC.forAll (QC.choose (1,4)) $ prop . divMaybe

test :: DocTest.T ()
test = do
 DocTest.printPrefix "Data.List.HT.Private:101: "
{-# LINE 101 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 101 "src/Data/List/HT/Private.hs" #-}
   (groupBy (<) "abcdebcdef")
  [ExpectedLine [LineChunk "[\"abcde\",\"bcdef\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:108: "
{-# LINE 108 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 108 "src/Data/List/HT/Private.hs" #-}
   (List.groupBy (<) "abcdebcdef")
  [ExpectedLine [LineChunk "[\"abcdebcdef\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:179: "
{-# LINE 179 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 179 "src/Data/List/HT/Private.hs" #-}
   (words "a  a")
  [ExpectedLine [LineChunk "[\"a\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:181: "
{-# LINE 181 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 181 "src/Data/List/HT/Private.hs" #-}
   (chop (' '==) "a  a")
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:184: "
{-# LINE 184 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 184 "src/Data/List/HT/Private.hs" #-}
   (lines "a\n\na")
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:186: "
{-# LINE 186 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 186 "src/Data/List/HT/Private.hs" #-}
   (chop ('\n'==) "a\n\na")
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:189: "
{-# LINE 189 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 189 "src/Data/List/HT/Private.hs" #-}
   (lines "a\n")
  [ExpectedLine [LineChunk "[\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:191: "
{-# LINE 191 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 191 "src/Data/List/HT/Private.hs" #-}
   (chop ('\n'==) "a\n")
  [ExpectedLine [LineChunk "[\"a\",\"\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:220: "
{-# LINE 220 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 220 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> uncurry (++) (breakAfter p xs) == xs)
 DocTest.printPrefix "Data.List.HT.Private:239: "
{-# LINE 239 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 239 "src/Data/List/HT/Private.hs" #-}
          (forAllPredicates $ \p xs -> breakAfterRec p xs == breakAfterFoldr p xs)
 DocTest.printPrefix "Data.List.HT.Private:247: "
{-# LINE 247 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 247 "src/Data/List/HT/Private.hs" #-}
          (forAllPredicates $ \p xs -> breakAfterRec p xs == breakAfterBreak p xs)
 DocTest.printPrefix "Data.List.HT.Private:254: "
{-# LINE 254 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 254 "src/Data/List/HT/Private.hs" #-}
          (forAllPredicates $ \p xs -> breakAfterRec p xs == breakAfterTakeUntil p xs)
 DocTest.printPrefix "Data.List.HT.Private:267: "
{-# LINE 267 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 267 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> takeUntil p xs == fst (breakAfter p xs))
 DocTest.printPrefix "Data.List.HT.Private:280: "
{-# LINE 280 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 280 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> concat (segmentAfter p xs) == xs)
 DocTest.printPrefix "Data.List.HT.Private:281: "
{-# LINE 281 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 281 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> length (filter p xs) == length (tail (segmentAfter p xs)))
 DocTest.printPrefix "Data.List.HT.Private:282: "
{-# LINE 282 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 282 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p -> all (p . last) . init . segmentAfter p)
 DocTest.printPrefix "Data.List.HT.Private:283: "
{-# LINE 283 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 283 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p -> all (all (not . p) . init) . init . segmentAfter p)
 DocTest.printPrefix "Data.List.HT.Private:287: "
{-# LINE 287 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 287 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p x -> flip seq True . (!!100) . concat . segmentAfter p . cycle . (x:))
 DocTest.printPrefix "Data.List.HT.Private:309: "
{-# LINE 309 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 309 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> concat (segmentBefore p xs) == xs)
 DocTest.printPrefix "Data.List.HT.Private:310: "
{-# LINE 310 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 310 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> length (filter p xs) == length (tail (segmentBefore p xs)))
 DocTest.printPrefix "Data.List.HT.Private:311: "
{-# LINE 311 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 311 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p -> all (p . head) . tail . segmentBefore p)
 DocTest.printPrefix "Data.List.HT.Private:312: "
{-# LINE 312 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 312 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p -> all (all (not . p) . tail) . tail . segmentBefore p)
 DocTest.printPrefix "Data.List.HT.Private:313: "
{-# LINE 313 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 313 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p x -> flip seq True . (!!100) . concat . segmentBefore p . cycle . (x:))
 DocTest.printPrefix "Data.List.HT.Private:325: "
{-# LINE 325 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 325 "src/Data/List/HT/Private.hs" #-}
          (forAllPredicates $ \p xs -> segmentBefore p xs == segmentBefore' p xs)
 DocTest.printPrefix "Data.List.HT.Private:336: "
{-# LINE 336 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 336 "src/Data/List/HT/Private.hs" #-}
          (forAllPredicates $ \p xs -> segmentBefore p xs == segmentBefore'' p xs)
 DocTest.printPrefix "Data.List.HT.Private:348: "
{-# LINE 348 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 348 "src/Data/List/HT/Private.hs" #-}
   (segmentBeforeJust (\c -> toMaybe (isLetter c) (toUpper c)) "123a5345b---")
  [ExpectedLine [LineChunk "(\"123\",[('A',\"5345\"),('B',\"---\")])"]]
 DocTest.printPrefix "Data.List.HT.Private:364: "
{-# LINE 364 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 364 "src/Data/List/HT/Private.hs" #-}
   (segmentAfterJust (\c -> toMaybe (isLetter c) (toUpper c)) "123a5345b---")
  [ExpectedLine [LineChunk "([(\"123\",'A'),(\"5345\",'B')],\"---\")"]]
 DocTest.printPrefix "Data.List.HT.Private:380: "
{-# LINE 380 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 380 "src/Data/List/HT/Private.hs" #-}
     (forAllMaybeFn $ \f xs -> segmentBeforeJust f xs == segmentBeforeRight (map (\x -> maybe (Left x) Right (f x)) xs))
 DocTest.printPrefix "Data.List.HT.Private:377: "
{-# LINE 377 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 377 "src/Data/List/HT/Private.hs" #-}
   (segmentBeforeRight [Left 'a', Right LT, Right GT, Left 'b'])
  [ExpectedLine [LineChunk "(\"a\",[(LT,\"\"),(GT,\"b\")])"]]
 DocTest.printPrefix "Data.List.HT.Private:397: "
{-# LINE 397 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 397 "src/Data/List/HT/Private.hs" #-}
     (forAllMaybeFn $ \f xs -> segmentAfterJust f xs == segmentAfterRight (map (\x -> maybe (Left x) Right (f x)) xs))
 DocTest.printPrefix "Data.List.HT.Private:394: "
{-# LINE 394 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 394 "src/Data/List/HT/Private.hs" #-}
   (segmentAfterRight [Left 'a', Right LT, Right GT, Left 'b'])
  [ExpectedLine [LineChunk "([(\"a\",LT),(\"\",GT)],\"b\")"]]
 DocTest.printPrefix "Data.List.HT.Private:420: "
{-# LINE 420 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 420 "src/Data/List/HT/Private.hs" #-}
   (removeEach "abc")
  [ExpectedLine [LineChunk "[('a',\"bc\"),('b',\"ac\"),('c',\"ab\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:422: "
{-# LINE 422 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 422 "src/Data/List/HT/Private.hs" #-}
   (removeEach "a")
  [ExpectedLine [LineChunk "[('a',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:424: "
{-# LINE 424 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 424 "src/Data/List/HT/Private.hs" #-}
   (removeEach "")
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:432: "
{-# LINE 432 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 432 "src/Data/List/HT/Private.hs" #-}
   (splitEverywhere "abc")
  [ExpectedLine [LineChunk "[(\"\",'a',\"bc\"),(\"a\",'b',\"c\"),(\"ab\",'c',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:434: "
{-# LINE 434 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 434 "src/Data/List/HT/Private.hs" #-}
   (splitEverywhere "a")
  [ExpectedLine [LineChunk "[(\"\",'a',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:436: "
{-# LINE 436 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 436 "src/Data/List/HT/Private.hs" #-}
   (splitEverywhere "")
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:459: "
{-# LINE 459 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 459 "src/Data/List/HT/Private.hs" #-}
     (\(NonEmpty xs) -> splitLast (xs::String)  ==  (init xs, last xs))
 DocTest.printPrefix "Data.List.HT.Private:479: "
{-# LINE 479 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 479 "src/Data/List/HT/Private.hs" #-}
     (\xs -> maybe True ((init xs, last xs) == ) (viewR (xs::String)))
 DocTest.printPrefix "Data.List.HT.Private:500: "
{-# LINE 500 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 500 "src/Data/List/HT/Private.hs" #-}
     (\xs -> switchR True (\ixs lxs -> ixs == init xs && lxs == last xs) (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:514: "
{-# LINE 514 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 514 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> takeRev n (xs::String) == reverse (take n (reverse xs)))
 DocTest.printPrefix "Data.List.HT.Private:523: "
{-# LINE 523 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 523 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> dropRev n (xs::String) == reverse (drop n (reverse xs)))
 DocTest.printPrefix "Data.List.HT.Private:531: "
{-# LINE 531 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 531 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> splitAtRev n (xs::String) == (dropRev n xs, takeRev n xs))
 DocTest.printPrefix "Data.List.HT.Private:532: "
{-# LINE 532 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 532 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> (xs::String) == uncurry (++) (splitAtRev n xs))
 DocTest.printPrefix "Data.List.HT.Private:546: "
{-# LINE 546 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 546 "src/Data/List/HT/Private.hs" #-}
   (maybePrefixOf "abc" "abcdef")
  [ExpectedLine [LineChunk "Just \"def\""]]
 DocTest.printPrefix "Data.List.HT.Private:548: "
{-# LINE 548 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 548 "src/Data/List/HT/Private.hs" #-}
   (maybePrefixOf "def" "abcdef")
  [ExpectedLine [LineChunk "Nothing"]]
 DocTest.printPrefix "Data.List.HT.Private:557: "
{-# LINE 557 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 557 "src/Data/List/HT/Private.hs" #-}
   (maybeSuffixOf "abc" "abcdef")
  [ExpectedLine [LineChunk "Nothing"]]
 DocTest.printPrefix "Data.List.HT.Private:559: "
{-# LINE 559 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 559 "src/Data/List/HT/Private.hs" #-}
   (maybeSuffixOf "def" "abcdef")
  [ExpectedLine [LineChunk "Just \"abc\""]]
 DocTest.printPrefix "Data.List.HT.Private:570: "
{-# LINE 570 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 570 "src/Data/List/HT/Private.hs" #-}
     (forAllMaybeFn $ \f xs -> partitionMaybe f xs == (mapMaybe f xs, filter (isNothing . f) xs))
 DocTest.printPrefix "Data.List.HT.Private:571: "
{-# LINE 571 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 571 "src/Data/List/HT/Private.hs" #-}
     (forAllPredicates $ \p xs -> partition p xs == partitionMaybe (\x -> toMaybe (p x) x) xs)
 DocTest.printPrefix "Data.List.HT.Private:584: "
{-# LINE 584 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 584 "src/Data/List/HT/Private.hs" #-}
   (takeWhileJust [Just 'a', Just 'b', Nothing, Just 'c'])
  [ExpectedLine [LineChunk "\"ab\""]]
 DocTest.printPrefix "Data.List.HT.Private:589: "
{-# LINE 589 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 589 "src/Data/List/HT/Private.hs" #-}
   (takeWhileJust $ map (fmap fst . viewL) ["abc","def","","xyz"])
  [ExpectedLine [LineChunk "\"ad\""]]
 DocTest.printPrefix "Data.List.HT.Private:610: "
{-# LINE 610 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 610 "src/Data/List/HT/Private.hs" #-}
          (forAllMaybeFn $ \f xs -> dropWhileNothing f xs == dropWhileNothingRec f xs)
 DocTest.printPrefix "Data.List.HT.Private:617: "
{-# LINE 617 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 617 "src/Data/List/HT/Private.hs" #-}
          (forAllMaybeFn $ \f xs -> snd (breakJust f xs) == dropWhileNothing f xs)
 DocTest.printPrefix "Data.List.HT.Private:628: "
{-# LINE 628 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 628 "src/Data/List/HT/Private.hs" #-}
          (forAllMaybeFn $ \f xs -> breakJust f xs == breakJustRemoveEach f xs)
 DocTest.printPrefix "Data.List.HT.Private:636: "
{-# LINE 636 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 636 "src/Data/List/HT/Private.hs" #-}
          (forAllMaybeFn $ \f xs -> breakJust f xs == breakJustPartial f xs)
 DocTest.printPrefix "Data.List.HT.Private:664: "
{-# LINE 664 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 664 "src/Data/List/HT/Private.hs" #-}
   (sieve 6 ['a'..'z'])
  [ExpectedLine [LineChunk "\"agmsy\""]]
 DocTest.printPrefix "Data.List.HT.Private:671: "
{-# LINE 671 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 671 "src/Data/List/HT/Private.hs" #-}
          (\(Positive n) xs -> sieve n xs == sieve' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:674: "
{-# LINE 674 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 674 "src/Data/List/HT/Private.hs" #-}
          (\(Positive n) xs -> sieve n xs == sieve'' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:677: "
{-# LINE 677 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 677 "src/Data/List/HT/Private.hs" #-}
          (\(Positive n) xs -> sieve n xs == sieve''' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:689: "
{-# LINE 689 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 689 "src/Data/List/HT/Private.hs" #-}
     (\(NonEmpty xs) -> QC.forAll (QC.choose (1, length xs)) $ \n -> sliceHorizontal n xs == transpose (sliceVertical n (xs::String)))
 DocTest.printPrefix "Data.List.HT.Private:690: "
{-# LINE 690 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 690 "src/Data/List/HT/Private.hs" #-}
     (\(NonEmpty xs) -> QC.forAll (QC.choose (1, length xs)) $ \n -> sliceVertical  n xs == transpose (sliceHorizontal n (xs::String)))
 DocTest.printPrefix "Data.List.HT.Private:686: "
{-# LINE 686 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 686 "src/Data/List/HT/Private.hs" #-}
   (sliceHorizontal 6 ['a'..'z'])
  [ExpectedLine [LineChunk "[\"agmsy\",\"bhntz\",\"ciou\",\"djpv\",\"ekqw\",\"flrx\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:694: "
{-# LINE 694 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 694 "src/Data/List/HT/Private.hs" #-}
   (sliceHorizontal 4 ([]::[Int]))
  [ExpectedLine [LineChunk "[[],[],[],[]]"]]
 DocTest.printPrefix "Data.List.HT.Private:702: "
{-# LINE 702 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 702 "src/Data/List/HT/Private.hs" #-}
          (\(NonNegative n) xs -> sliceHorizontal n xs == sliceHorizontal' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:706: "
{-# LINE 706 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 706 "src/Data/List/HT/Private.hs" #-}
          (\(Positive n) xs -> sliceHorizontal n xs == sliceHorizontal'' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:715: "
{-# LINE 715 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 715 "src/Data/List/HT/Private.hs" #-}
   (sliceVertical 6 ['a'..'z'])
  [ExpectedLine [LineChunk "[\"abcdef\",\"ghijkl\",\"mnopqr\",\"stuvwx\",\"yz\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:724: "
{-# LINE 724 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 724 "src/Data/List/HT/Private.hs" #-}
          (\(NonNegative n) xs -> equating (take 100000) (sliceVertical n xs) (sliceVertical' n (xs::String)))
 DocTest.printPrefix "Data.List.HT.Private:737: "
{-# LINE 737 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 737 "src/Data/List/HT/Private.hs" #-}
     (\(NonEmpty xs) ys -> replace xs xs ys == (ys::String))
 DocTest.printPrefix "Data.List.HT.Private:738: "
{-# LINE 738 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 738 "src/Data/List/HT/Private.hs" #-}
     (\(NonEmpty xs) (NonEmpty ys) -> equating (take 1000) (replace xs ys (cycle xs)) (cycle (ys::String)))
 DocTest.printPrefix "Data.List.HT.Private:876: "
{-# LINE 876 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 876 "src/Data/List/HT/Private.hs" #-}
     (\xs -> shearTranspose xs  ==  map reverse (shear (xs::[String])))
 DocTest.printPrefix "Data.List.HT.Private:911: "
{-# LINE 911 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 911 "src/Data/List/HT/Private.hs" #-}
     (\xs ys -> let f x y = (x::Char,y::Int) in concat (outerProduct f xs ys)  ==  liftM2 f xs ys)
 DocTest.printPrefix "Data.List.HT.Private:934: "
{-# LINE 934 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 934 "src/Data/List/HT/Private.hs" #-}
     (\ys xs -> let ps = map (<=) ys in takeWhileMulti ps xs == takeWhileMulti' ps (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:999: "
{-# LINE 999 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 999 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> lengthAtLeast n (xs::String)  ==  (length xs >= n))
 DocTest.printPrefix "Data.List.HT.Private:988: "
{-# LINE 988 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 988 "src/Data/List/HT/Private.hs" #-}
   (lengthAtLeast 0 "")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:990: "
{-# LINE 990 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 990 "src/Data/List/HT/Private.hs" #-}
   (lengthAtLeast 3 "ab")
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:992: "
{-# LINE 992 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 992 "src/Data/List/HT/Private.hs" #-}
   (lengthAtLeast 3 "abc")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:994: "
{-# LINE 994 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 994 "src/Data/List/HT/Private.hs" #-}
   (lengthAtLeast 3 $ repeat 'a')
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:996: "
{-# LINE 996 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 996 "src/Data/List/HT/Private.hs" #-}
   (lengthAtLeast 3 $ "abc" ++ undefined)
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1021: "
{-# LINE 1021 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1021 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> lengthAtMost n (xs::String)  ==  (length xs <= n))
 DocTest.printPrefix "Data.List.HT.Private:1008: "
{-# LINE 1008 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1008 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 0 "")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1010: "
{-# LINE 1010 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1010 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 3 "ab")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1012: "
{-# LINE 1012 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1012 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 3 "abc")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1014: "
{-# LINE 1014 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1014 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 3 "abcd")
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1016: "
{-# LINE 1016 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1016 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 3 $ repeat 'a')
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1018: "
{-# LINE 1018 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1018 "src/Data/List/HT/Private.hs" #-}
   (lengthAtMost 3 $ "abcd" ++ undefined)
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1030: "
{-# LINE 1030 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1030 "src/Data/List/HT/Private.hs" #-}
     (\n xs -> lengthAtMost0 n (xs::String)  ==  (length xs <= n))
 DocTest.printPrefix "Data.List.HT.Private:1077: "
{-# LINE 1077 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1077 "src/Data/List/HT/Private.hs" #-}
     (\(NonNegative n) (NonEmpty xs) -> rotate n xs == rotate' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:1084: "
{-# LINE 1084 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1084 "src/Data/List/HT/Private.hs" #-}
     (\(NonNegative n) xs -> rotate n xs == rotate'' n (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:1094: "
{-# LINE 1094 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1094 "src/Data/List/HT/Private.hs" #-}
   (mergeBy (<=) "agh" "begz")
  [ExpectedLine [LineChunk "\"abegghz\""]]
 DocTest.printPrefix "Data.List.HT.Private:1102: "
{-# LINE 1102 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1102 "src/Data/List/HT/Private.hs" #-}
   (allEqual "aab")
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1104: "
{-# LINE 1104 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1104 "src/Data/List/HT/Private.hs" #-}
   (allEqual "aaa")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1106: "
{-# LINE 1106 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1106 "src/Data/List/HT/Private.hs" #-}
   (allEqual "aa")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1108: "
{-# LINE 1108 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1108 "src/Data/List/HT/Private.hs" #-}
   (allEqual "a")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1110: "
{-# LINE 1110 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1110 "src/Data/List/HT/Private.hs" #-}
   (allEqual "")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1117: "
{-# LINE 1117 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1117 "src/Data/List/HT/Private.hs" #-}
   (isAscending "abc")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1119: "
{-# LINE 1119 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1119 "src/Data/List/HT/Private.hs" #-}
   (isAscending "abb")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1121: "
{-# LINE 1121 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1121 "src/Data/List/HT/Private.hs" #-}
   (isAscending "aba")
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1123: "
{-# LINE 1123 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1123 "src/Data/List/HT/Private.hs" #-}
   (isAscending "cba")
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1125: "
{-# LINE 1125 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1125 "src/Data/List/HT/Private.hs" #-}
   (isAscending "a")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1127: "
{-# LINE 1127 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1127 "src/Data/List/HT/Private.hs" #-}
   (isAscending "")
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1149: "
{-# LINE 1149 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1149 "src/Data/List/HT/Private.hs" #-}
     (\x xs -> mapAdjacent subtract (scanl (+) x xs) == (xs::[Integer]))
 DocTest.printPrefix "Data.List.HT.Private:1140: "
{-# LINE 1140 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1140 "src/Data/List/HT/Private.hs" #-}
   (mapAdjacent (<=) "")
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1142: "
{-# LINE 1142 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1142 "src/Data/List/HT/Private.hs" #-}
   (mapAdjacent (<=) "a")
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1144: "
{-# LINE 1144 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1144 "src/Data/List/HT/Private.hs" #-}
   (mapAdjacent (<=) "aba")
  [ExpectedLine [LineChunk "[True,False]"]]
 DocTest.printPrefix "Data.List.HT.Private:1146: "
{-# LINE 1146 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1146 "src/Data/List/HT/Private.hs" #-}
   (mapAdjacent (,) "abc")
  [ExpectedLine [LineChunk "[('a','b'),('b','c')]"]]
 DocTest.printPrefix "Data.List.HT.Private:1157: "
{-# LINE 1157 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1157 "src/Data/List/HT/Private.hs" #-}
     (\xs -> mapAdjacent (,) xs == mapAdjacentPointfree (,) (xs::String))
 DocTest.printPrefix "Data.List.HT.Private:1164: "
{-# LINE 1164 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1164 "src/Data/List/HT/Private.hs" #-}
   (let f x y z = [x,y]++show(z::Int) in mapAdjacent1 f 'a' [('b',1), ('c',2), ('d',3)])
  [ExpectedLine [LineChunk "[\"ab1\",\"bc2\",\"cd3\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:1183: "
{-# LINE 1183 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1183 "src/Data/List/HT/Private.hs" #-}
     (\(NonNegative n) -> length (range n :: [Integer]) == n)
 DocTest.printPrefix "Data.List.HT.Private:1176: "
{-# LINE 1176 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1176 "src/Data/List/HT/Private.hs" #-}
   (range 0 :: [Integer])
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1178: "
{-# LINE 1178 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1178 "src/Data/List/HT/Private.hs" #-}
   (range 1 :: [Integer])
  [ExpectedLine [LineChunk "[0]"]]
 DocTest.printPrefix "Data.List.HT.Private:1180: "
{-# LINE 1180 "src/Data/List/HT/Private.hs" #-}
 DocTest.example
{-# LINE 1180 "src/Data/List/HT/Private.hs" #-}
   (range 8 :: [Integer])
  [ExpectedLine [LineChunk "[0,1,2,3,4,5,6,7]"]]
 DocTest.printPrefix "Data.List.HT.Private:1210: "
{-# LINE 1210 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1210 "src/Data/List/HT/Private.hs" #-}
     (\x -> equating (take 1000) (List.iterate (x+) x) (iterateAssociative (+) (x::Integer)))
 DocTest.printPrefix "Data.List.HT.Private:1229: "
{-# LINE 1229 "src/Data/List/HT/Private.hs" #-}
 DocTest.property
{-# LINE 1229 "src/Data/List/HT/Private.hs" #-}
     (\x -> equating (take 1000) (List.iterate (x+) x) (iterateLeaky (+) (x::Integer)))
