
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStyle.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStyle>
#include <QApplication>
#include <QChildEvent>
#include <QEvent>
#include <QFontMetrics>
#include <QIcon>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QSize>
#include <QStyleHintReturn>
#include <QStyleOption>
#include <QStyleOptionComplex>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStyle

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStyle::staticMetaObject);
}


// int QStyle::combinedLayoutSpacing(QFlags<QSizePolicy::ControlType> controls1, QFlags<QSizePolicy::ControlType> controls2, Qt::Orientation orientation, QStyleOption *option, QWidget *widget)


static void _init_f_combinedLayoutSpacing_c11699 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("controls1");
  decl->add_arg<QFlags<QSizePolicy::ControlType> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("controls2");
  decl->add_arg<QFlags<QSizePolicy::ControlType> > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "nullptr");
  decl->add_arg<QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_combinedLayoutSpacing_c11699 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QSizePolicy::ControlType> arg1 = gsi::arg_reader<QFlags<QSizePolicy::ControlType> >() (args, heap);
  QFlags<QSizePolicy::ControlType> arg2 = gsi::arg_reader<QFlags<QSizePolicy::ControlType> >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  QStyleOption *arg4 = args ? gsi::arg_reader<QStyleOption * >() (args, heap) : gsi::arg_maker<QStyleOption * >() (nullptr, heap);
  QWidget *arg5 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<int > ((int)((QStyle *)cls)->combinedLayoutSpacing (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref(), arg4, arg5));
}


// void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)


static void _init_f_drawComplexControl_c9027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawComplexControl_c9027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->drawComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4);
}


// void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawControl_c8285 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawControl_c8285 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ControlElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->drawControl (qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(arg1).cref(), arg2, arg3, arg4);
}


// void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)


static void _init_f_drawItemPixmap_c5678 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawItemPixmap_c5678 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg4 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->drawItemPixmap (arg1, arg2, arg3, arg4);
}


// void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)


static void _init_f_drawItemText_c10604 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole", true, "QPalette::NoRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawItemText_c10604 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QPalette &arg4 = gsi::arg_reader<const QPalette & >() (args, heap);
  bool arg5 = gsi::arg_reader<bool >() (args, heap);
  const QString &arg6 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args ? gsi::arg_reader<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPalette::ColorRole>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPalette::ColorRole>(heap, QPalette::NoRole), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->drawItemText (arg1, arg2, arg3, arg4, arg5, arg6, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg7).cref());
}


// void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawPrimitive_c8501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPrimitive_c8501 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->drawPrimitive (qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(arg1).cref(), arg2, arg3, arg4);
}


// QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)


static void _init_f_generatedIconPixmap_c5776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_generatedIconPixmap_c5776 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QIcon::Mode>::target_type & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QStyleOption *arg3 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  ret.write<QPixmap > ((QPixmap)((QStyle *)cls)->generatedIconPixmap (qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg1).cref(), arg2, arg3));
}


// QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)


static void _init_f_hitTestComplexControl_c9517 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_f_hitTestComplexControl_c9517 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  const QPoint &arg3 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)qt_gsi::CppToQtAdaptor<QStyle::SubControl>(((QStyle *)cls)->hitTestComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4)));
}


// QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)


static void _init_f_itemPixmapRect_c4360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_itemPixmapRect_c4360 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QPixmap &arg3 = gsi::arg_reader<const QPixmap & >() (args, heap);
  ret.write<QRect > ((QRect)((QStyle *)cls)->itemPixmapRect (arg1, arg2, arg3));
}


// QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)


static void _init_f_itemTextRect_c7544 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_f_itemTextRect_c7544 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFontMetrics &arg1 = gsi::arg_reader<const QFontMetrics & >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  bool arg4 = gsi::arg_reader<bool >() (args, heap);
  const QString &arg5 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QRect > ((QRect)((QStyle *)cls)->itemTextRect (arg1, arg2, arg3, arg4, arg5));
}


// int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)


static void _init_f_layoutSpacing_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "nullptr");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_layoutSpacing_c11697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QStyleOption *arg4 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (nullptr, heap);
  const QWidget *arg5 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<int > ((int)((QStyle *)cls)->layoutSpacing (qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref(), arg4, arg5));
}


// QString QStyle::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStyle *)cls)->name ());
}


// int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)


static void _init_f_pixelMetric_c6642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "nullptr");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_pixelMetric_c6642 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (nullptr, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<int > ((int)((QStyle *)cls)->pixelMetric (qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(arg1).cref(), arg2, arg3));
}


// void QStyle::polish(QWidget *widget)


static void _init_f_polish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->polish (arg1);
}


// void QStyle::polish(QApplication *application)


static void _init_f_polish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->polish (arg1);
}


// void QStyle::polish(QPalette &palette)


static void _init_f_polish_1418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1418 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = gsi::arg_reader<QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->polish (arg1);
}


// const QStyle *QStyle::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QStyle * > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QStyle * > ((const QStyle *)((QStyle *)cls)->proxy ());
}


// QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)


static void _init_f_sizeFromContents_c8477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_f_sizeFromContents_c8477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ContentsType>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QSize &arg3 = gsi::arg_reader<const QSize & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<QSize > ((QSize)((QStyle *)cls)->sizeFromContents (qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(arg1).cref(), arg2, arg3, arg4));
}


// QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)


static void _init_f_standardIcon_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "nullptr");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_f_standardIcon_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (nullptr, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<QIcon > ((QIcon)((QStyle *)cls)->standardIcon (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}


// QPalette QStyle::standardPalette()


static void _init_f_standardPalette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_standardPalette_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QStyle *)cls)->standardPalette ());
}


// QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)


static void _init_f_standardPixmap_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "nullptr");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_standardPixmap_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (nullptr, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<QPixmap > ((QPixmap)((QStyle *)cls)->standardPixmap (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}


// int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)


static void _init_f_styleHint_c8615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stylehint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "nullptr");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData", true, "nullptr");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_f_styleHint_c8615 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StyleHint>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (nullptr, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  QStyleHintReturn *arg4 = args ? gsi::arg_reader<QStyleHintReturn * >() (args, heap) : gsi::arg_maker<QStyleHintReturn * >() (nullptr, heap);
  ret.write<int > ((int)((QStyle *)cls)->styleHint (qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(arg1).cref(), arg2, arg3, arg4));
}


// QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)


static void _init_f_subControlRect_c9798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_subControlRect_c9798 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubControl>::target_type & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<QRect > ((QRect)((QStyle *)cls)->subControlRect (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(arg3).cref(), arg4));
}


// QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)


static void _init_f_subElementRect_c6528 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subElement");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_subElementRect_c6528 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (nullptr, heap);
  ret.write<QRect > ((QRect)((QStyle *)cls)->subElementRect (qt_gsi::QtToCppAdaptor<QStyle::SubElement>(arg1).cref(), arg2, arg3));
}


// void QStyle::unpolish(QWidget *widget)


static void _init_f_unpolish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->unpolish (arg1);
}


// void QStyle::unpolish(QApplication *application)


static void _init_f_unpolish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle *)cls)->unpolish (arg1);
}


// static QRect QStyle::alignedRect(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment, const QSize &size, const QRect &rectangle)


static void _init_f_alignedRect_8339 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("size");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rectangle");
  decl->add_arg<const QRect & > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_alignedRect_8339 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  const QSize &arg3 = gsi::arg_reader<const QSize & >() (args, heap);
  const QRect &arg4 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)QStyle::alignedRect (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2, arg3, arg4));
}


// static int QStyle::sliderPositionFromValue(int min, int max, int val, int space, bool upsideDown)


static void _init_f_sliderPositionFromValue_3500 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("val");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("space");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("upsideDown", true, "false");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_sliderPositionFromValue_3500 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  bool arg5 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<int > ((int)QStyle::sliderPositionFromValue (arg1, arg2, arg3, arg4, arg5));
}


// static int QStyle::sliderValueFromPosition(int min, int max, int pos, int space, bool upsideDown)


static void _init_f_sliderValueFromPosition_3500 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pos");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("space");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("upsideDown", true, "false");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_sliderValueFromPosition_3500 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  bool arg5 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<int > ((int)QStyle::sliderValueFromPosition (arg1, arg2, arg3, arg4, arg5));
}


// static QString QStyle::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStyle::tr (arg1, arg2, arg3));
}


// static QFlags<Qt::AlignmentFlag> QStyle::visualAlignment(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_visualAlignment_4958 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_visualAlignment_4958 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg2 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)QStyle::visualAlignment (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2));
}


// static QPoint QStyle::visualPos(Qt::LayoutDirection direction, const QRect &boundingRect, const QPoint &logicalPos)


static void _init_f_visualPos_5808 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundingRect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalPos");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<QPoint > ();
}

static void _call_f_visualPos_5808 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  const QPoint &arg3 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)QStyle::visualPos (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2, arg3));
}


// static QRect QStyle::visualRect(Qt::LayoutDirection direction, const QRect &boundingRect, const QRect &logicalRect)


static void _init_f_visualRect_5684 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundingRect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalRect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_visualRect_5684 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)QStyle::visualRect (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QStyle () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("combinedLayoutSpacing", "@brief Method int QStyle::combinedLayoutSpacing(QFlags<QSizePolicy::ControlType> controls1, QFlags<QSizePolicy::ControlType> controls2, Qt::Orientation orientation, QStyleOption *option, QWidget *widget)\n", true, &_init_f_combinedLayoutSpacing_c11699, &_call_f_combinedLayoutSpacing_c11699);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Method void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)\n", true, &_init_f_drawComplexControl_c9027, &_call_f_drawComplexControl_c9027);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Method void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\n", true, &_init_f_drawControl_c8285, &_call_f_drawControl_c8285);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Method void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\n", true, &_init_f_drawItemPixmap_c5678, &_call_f_drawItemPixmap_c5678);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@brief Method void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\n", true, &_init_f_drawItemText_c10604, &_call_f_drawItemText_c10604);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Method void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\n", true, &_init_f_drawPrimitive_c8501, &_call_f_drawPrimitive_c8501);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Method QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\n", true, &_init_f_generatedIconPixmap_c5776, &_call_f_generatedIconPixmap_c5776);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Method QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)\n", true, &_init_f_hitTestComplexControl_c9517, &_call_f_hitTestComplexControl_c9517);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Method QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\n", true, &_init_f_itemPixmapRect_c4360, &_call_f_itemPixmapRect_c4360);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@brief Method QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\n", true, &_init_f_itemTextRect_c7544, &_call_f_itemTextRect_c7544);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@brief Method int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_layoutSpacing_c11697, &_call_f_layoutSpacing_c11697);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QStyle::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Method int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_pixelMetric_c6642, &_call_f_pixelMetric_c6642);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QWidget *widget)\n", false, &_init_f_polish_1315, &_call_f_polish_1315);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QApplication *application)\n", false, &_init_f_polish_1843, &_call_f_polish_1843);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QPalette &palette)\n", false, &_init_f_polish_1418, &_call_f_polish_1418);
  methods += new qt_gsi::GenericMethod ("proxy", "@brief Method const QStyle *QStyle::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Method QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)\n", true, &_init_f_sizeFromContents_c8477, &_call_f_sizeFromContents_c8477);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@brief Method QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_standardIcon_c6956, &_call_f_standardIcon_c6956);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@brief Method QPalette QStyle::standardPalette()\n", true, &_init_f_standardPalette_c0, &_call_f_standardPalette_c0);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Method QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\n", true, &_init_f_standardPixmap_c6956, &_call_f_standardPixmap_c6956);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Method int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\n", true, &_init_f_styleHint_c8615, &_call_f_styleHint_c8615);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Method QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\n", true, &_init_f_subControlRect_c9798, &_call_f_subControlRect_c9798);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Method QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_subElementRect_c6528, &_call_f_subElementRect_c6528);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QStyle::unpolish(QWidget *widget)\n", false, &_init_f_unpolish_1315, &_call_f_unpolish_1315);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QStyle::unpolish(QApplication *application)\n", false, &_init_f_unpolish_1843, &_call_f_unpolish_1843);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QStyle::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QStyle::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("alignedRect", "@brief Static method QRect QStyle::alignedRect(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment, const QSize &size, const QRect &rectangle)\nThis method is static and can be called without an instance.", &_init_f_alignedRect_8339, &_call_f_alignedRect_8339);
  methods += new qt_gsi::GenericStaticMethod ("sliderPositionFromValue", "@brief Static method int QStyle::sliderPositionFromValue(int min, int max, int val, int space, bool upsideDown)\nThis method is static and can be called without an instance.", &_init_f_sliderPositionFromValue_3500, &_call_f_sliderPositionFromValue_3500);
  methods += new qt_gsi::GenericStaticMethod ("sliderValueFromPosition", "@brief Static method int QStyle::sliderValueFromPosition(int min, int max, int pos, int space, bool upsideDown)\nThis method is static and can be called without an instance.", &_init_f_sliderValueFromPosition_3500, &_call_f_sliderValueFromPosition_3500);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyle::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("visualAlignment", "@brief Static method QFlags<Qt::AlignmentFlag> QStyle::visualAlignment(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment)\nThis method is static and can be called without an instance.", &_init_f_visualAlignment_4958, &_call_f_visualAlignment_4958);
  methods += new qt_gsi::GenericStaticMethod ("visualPos", "@brief Static method QPoint QStyle::visualPos(Qt::LayoutDirection direction, const QRect &boundingRect, const QPoint &logicalPos)\nThis method is static and can be called without an instance.", &_init_f_visualPos_5808, &_call_f_visualPos_5808);
  methods += new qt_gsi::GenericStaticMethod ("visualRect", "@brief Static method QRect QStyle::visualRect(Qt::LayoutDirection direction, const QRect &boundingRect, const QRect &logicalRect)\nThis method is static and can be called without an instance.", &_init_f_visualRect_5684, &_call_f_visualRect_5684);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QStyle> decl_QStyle (qtdecl_QObject (), "QtWidgets", "QStyle_Native",
  methods_QStyle (),
  "@hide\n@alias QStyle");

GSI_QTWIDGETS_PUBLIC gsi::Class<QStyle> &qtdecl_QStyle () { return decl_QStyle; }

}


class QStyle_Adaptor : public QStyle, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStyle_Adaptor();

  //  [adaptor ctor] QStyle::QStyle()
  QStyle_Adaptor() : QStyle()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QStyle::isSignalConnected(const QMetaMethod &signal)
  bool fp_QStyle_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QStyle::isSignalConnected(signal);
  }

  //  [expose] int QStyle::receivers(const char *signal)
  int fp_QStyle_receivers_c1731 (const char *signal) const {
    return QStyle::receivers(signal);
  }

  //  [expose] QObject *QStyle::sender()
  QObject * fp_QStyle_sender_c0 () const {
    return QStyle::sender();
  }

  //  [expose] int QStyle::senderSignalIndex()
  int fp_QStyle_senderSignalIndex_c0 () const {
    return QStyle::senderSignalIndex();
  }

  //  [emitter impl] void QStyle::destroyed(QObject *)
  void emitter_QStyle_destroyed_1302(QObject *arg1)
  {
    emit QStyle::destroyed(arg1);
  }

  //  [adaptor impl] void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)
  void cbs_drawComplexControl_c9027_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (cc);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (p);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("drawComplexControl");
  }

  virtual void drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget) const
  {
    if (cb_drawComplexControl_c9027_1.can_issue()) {
      cb_drawComplexControl_c9027_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawComplexControl_c9027_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, p, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawComplexControl");
    }
  }

  //  [adaptor impl] void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawControl_c8285_1(const qt_gsi::Converter<QStyle::ControlElement>::target_type & element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    __SUPPRESS_UNUSED_WARNING (element);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (p);
    __SUPPRESS_UNUSED_WARNING (w);
    throw qt_gsi::AbstractMethodCalledException("drawControl");
  }

  virtual void drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawControl_c8285_1.can_issue()) {
      cb_drawControl_c8285_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::ControlElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawControl_c8285_1, qt_gsi::CppToQtAdaptor<QStyle::ControlElement>(element), opt, p, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawControl");
    }
  }

  //  [adaptor impl] void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)
  void cbs_drawItemPixmap_c5678_0(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
  }

  virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    if (cb_drawItemPixmap_c5678_0.can_issue()) {
      cb_drawItemPixmap_c5678_0.issue<QStyle_Adaptor, QPainter *, const QRect &, int, const QPixmap &>(&QStyle_Adaptor::cbs_drawItemPixmap_c5678_0, painter, rect, alignment, pixmap);
    } else {
      QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
  }

  //  [adaptor impl] void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)
  void cbs_drawItemText_c10604_1(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, const qt_gsi::Converter<QPalette::ColorRole>::target_type & textRole) const
  {
    QStyle::drawItemText(painter, rect, flags, pal, enabled, text, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(textRole).cref());
  }

  virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole) const
  {
    if (cb_drawItemText_c10604_1.can_issue()) {
      cb_drawItemText_c10604_1.issue<QStyle_Adaptor, QPainter *, const QRect &, int, const QPalette &, bool, const QString &, const qt_gsi::Converter<QPalette::ColorRole>::target_type &>(&QStyle_Adaptor::cbs_drawItemText_c10604_1, painter, rect, flags, pal, enabled, text, qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(textRole));
    } else {
      QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
  }

  //  [adaptor impl] void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawPrimitive_c8501_1(const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    __SUPPRESS_UNUSED_WARNING (pe);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (p);
    __SUPPRESS_UNUSED_WARNING (w);
    throw qt_gsi::AbstractMethodCalledException("drawPrimitive");
  }

  virtual void drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawPrimitive_c8501_1.can_issue()) {
      cb_drawPrimitive_c8501_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawPrimitive_c8501_1, qt_gsi::CppToQtAdaptor<QStyle::PrimitiveElement>(pe), opt, p, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawPrimitive");
    }
  }

  //  [adaptor impl] bool QStyle::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QStyle::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStyle_Adaptor, bool, QEvent *>(&QStyle_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QStyle::event(_event);
    }
  }

  //  [adaptor impl] bool QStyle::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QStyle::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStyle_Adaptor, bool, QObject *, QEvent *>(&QStyle_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QStyle::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)
  QPixmap cbs_generatedIconPixmap_c5776_0(const qt_gsi::Converter<QIcon::Mode>::target_type & iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    __SUPPRESS_UNUSED_WARNING (iconMode);
    __SUPPRESS_UNUSED_WARNING (pixmap);
    __SUPPRESS_UNUSED_WARNING (opt);
    throw qt_gsi::AbstractMethodCalledException("generatedIconPixmap");
  }

  virtual QPixmap generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    if (cb_generatedIconPixmap_c5776_0.can_issue()) {
      return cb_generatedIconPixmap_c5776_0.issue<QStyle_Adaptor, QPixmap, const qt_gsi::Converter<QIcon::Mode>::target_type &, const QPixmap &, const QStyleOption *>(&QStyle_Adaptor::cbs_generatedIconPixmap_c5776_0, qt_gsi::CppToQtAdaptor<QIcon::Mode>(iconMode), pixmap, opt);
    } else {
      throw qt_gsi::AbstractMethodCalledException("generatedIconPixmap");
    }
  }

  //  [adaptor impl] QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)
  qt_gsi::Converter<QStyle::SubControl>::target_type cbs_hitTestComplexControl_c9517_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (cc);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (pt);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("hitTestComplexControl");
  }

  virtual QStyle::SubControl hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget) const
  {
    if (cb_hitTestComplexControl_c9517_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStyle::SubControl>(cb_hitTestComplexControl_c9517_1.issue<QStyle_Adaptor, qt_gsi::Converter<QStyle::SubControl>::target_type, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const QPoint &, const QWidget *>(&QStyle_Adaptor::cbs_hitTestComplexControl_c9517_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, pt, widget)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("hitTestComplexControl");
    }
  }

  //  [adaptor impl] QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)
  QRect cbs_itemPixmapRect_c4360_0(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    return QStyle::itemPixmapRect(r, flags, pixmap);
  }

  virtual QRect itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    if (cb_itemPixmapRect_c4360_0.can_issue()) {
      return cb_itemPixmapRect_c4360_0.issue<QStyle_Adaptor, QRect, const QRect &, int, const QPixmap &>(&QStyle_Adaptor::cbs_itemPixmapRect_c4360_0, r, flags, pixmap);
    } else {
      return QStyle::itemPixmapRect(r, flags, pixmap);
    }
  }

  //  [adaptor impl] QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)
  QRect cbs_itemTextRect_c7544_0(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    return QStyle::itemTextRect(fm, r, flags, enabled, text);
  }

  virtual QRect itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    if (cb_itemTextRect_c7544_0.can_issue()) {
      return cb_itemTextRect_c7544_0.issue<QStyle_Adaptor, QRect, const QFontMetrics &, const QRect &, int, bool, const QString &>(&QStyle_Adaptor::cbs_itemTextRect_c7544_0, fm, r, flags, enabled, text);
    } else {
      return QStyle::itemTextRect(fm, r, flags, enabled, text);
    }
  }

  //  [adaptor impl] int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)
  int cbs_layoutSpacing_c11697_2(const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control1, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control2, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QStyleOption *option, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (control1);
    __SUPPRESS_UNUSED_WARNING (control2);
    __SUPPRESS_UNUSED_WARNING (orientation);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("layoutSpacing");
  }

  virtual int layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_layoutSpacing_c11697_2.can_issue()) {
      return cb_layoutSpacing_c11697_2.issue<QStyle_Adaptor, int, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type &, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type &, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_layoutSpacing_c11697_2, qt_gsi::CppToQtAdaptor<QSizePolicy::ControlType>(control1), qt_gsi::CppToQtAdaptor<QSizePolicy::ControlType>(control2), qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("layoutSpacing");
    }
  }

  //  [emitter impl] void QStyle::objectNameChanged(const QString &objectName)
  void emitter_QStyle_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QStyle::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)
  int cbs_pixelMetric_c6642_2(const qt_gsi::Converter<QStyle::PixelMetric>::target_type & metric, const QStyleOption *option, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (metric);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("pixelMetric");
  }

  virtual int pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_pixelMetric_c6642_2.can_issue()) {
      return cb_pixelMetric_c6642_2.issue<QStyle_Adaptor, int, const qt_gsi::Converter<QStyle::PixelMetric>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_pixelMetric_c6642_2, qt_gsi::CppToQtAdaptor<QStyle::PixelMetric>(metric), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pixelMetric");
    }
  }

  //  [adaptor impl] void QStyle::polish(QWidget *widget)
  void cbs_polish_1315_0(QWidget *widget)
  {
    QStyle::polish(widget);
  }

  virtual void polish(QWidget *widget)
  {
    if (cb_polish_1315_0.can_issue()) {
      cb_polish_1315_0.issue<QStyle_Adaptor, QWidget *>(&QStyle_Adaptor::cbs_polish_1315_0, widget);
    } else {
      QStyle::polish(widget);
    }
  }

  //  [adaptor impl] void QStyle::polish(QApplication *application)
  void cbs_polish_1843_0(QApplication *application)
  {
    QStyle::polish(application);
  }

  virtual void polish(QApplication *application)
  {
    if (cb_polish_1843_0.can_issue()) {
      cb_polish_1843_0.issue<QStyle_Adaptor, QApplication *>(&QStyle_Adaptor::cbs_polish_1843_0, application);
    } else {
      QStyle::polish(application);
    }
  }

  //  [adaptor impl] void QStyle::polish(QPalette &palette)
  void cbs_polish_1418_0(QPalette &palette)
  {
    QStyle::polish(palette);
  }

  virtual void polish(QPalette &palette)
  {
    if (cb_polish_1418_0.can_issue()) {
      cb_polish_1418_0.issue<QStyle_Adaptor, QPalette &>(&QStyle_Adaptor::cbs_polish_1418_0, palette);
    } else {
      QStyle::polish(palette);
    }
  }

  //  [adaptor impl] QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)
  QSize cbs_sizeFromContents_c8477_1(const qt_gsi::Converter<QStyle::ContentsType>::target_type & ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w) const
  {
    __SUPPRESS_UNUSED_WARNING (ct);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (contentsSize);
    __SUPPRESS_UNUSED_WARNING (w);
    throw qt_gsi::AbstractMethodCalledException("sizeFromContents");
  }

  virtual QSize sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w) const
  {
    if (cb_sizeFromContents_c8477_1.can_issue()) {
      return cb_sizeFromContents_c8477_1.issue<QStyle_Adaptor, QSize, const qt_gsi::Converter<QStyle::ContentsType>::target_type &, const QStyleOption *, const QSize &, const QWidget *>(&QStyle_Adaptor::cbs_sizeFromContents_c8477_1, qt_gsi::CppToQtAdaptor<QStyle::ContentsType>(ct), opt, contentsSize, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sizeFromContents");
    }
  }

  //  [adaptor impl] QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)
  QIcon cbs_standardIcon_c6956_2(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardIcon, const QStyleOption *option, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (_standardIcon);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("standardIcon");
  }

  virtual QIcon standardIcon(QStyle::StandardPixmap _standardIcon, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_standardIcon_c6956_2.can_issue()) {
      return cb_standardIcon_c6956_2.issue<QStyle_Adaptor, QIcon, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_standardIcon_c6956_2, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardIcon), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("standardIcon");
    }
  }

  //  [adaptor impl] QPalette QStyle::standardPalette()
  QPalette cbs_standardPalette_c0_0() const
  {
    return QStyle::standardPalette();
  }

  virtual QPalette standardPalette() const
  {
    if (cb_standardPalette_c0_0.can_issue()) {
      return cb_standardPalette_c0_0.issue<QStyle_Adaptor, QPalette>(&QStyle_Adaptor::cbs_standardPalette_c0_0);
    } else {
      return QStyle::standardPalette();
    }
  }

  //  [adaptor impl] QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)
  QPixmap cbs_standardPixmap_c6956_2(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (_standardPixmap);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("standardPixmap");
  }

  virtual QPixmap standardPixmap(QStyle::StandardPixmap _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardPixmap_c6956_2.can_issue()) {
      return cb_standardPixmap_c6956_2.issue<QStyle_Adaptor, QPixmap, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_standardPixmap_c6956_2, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardPixmap), opt, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("standardPixmap");
    }
  }

  //  [adaptor impl] int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)
  int cbs_styleHint_c8615_3(const qt_gsi::Converter<QStyle::StyleHint>::target_type & stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    __SUPPRESS_UNUSED_WARNING (stylehint);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (widget);
    __SUPPRESS_UNUSED_WARNING (returnData);
    throw qt_gsi::AbstractMethodCalledException("styleHint");
  }

  virtual int styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    if (cb_styleHint_c8615_3.can_issue()) {
      return cb_styleHint_c8615_3.issue<QStyle_Adaptor, int, const qt_gsi::Converter<QStyle::StyleHint>::target_type &, const QStyleOption *, const QWidget *, QStyleHintReturn *>(&QStyle_Adaptor::cbs_styleHint_c8615_3, qt_gsi::CppToQtAdaptor<QStyle::StyleHint>(stylehint), opt, widget, returnData);
    } else {
      throw qt_gsi::AbstractMethodCalledException("styleHint");
    }
  }

  //  [adaptor impl] QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)
  QRect cbs_subControlRect_c9798_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const qt_gsi::Converter<QStyle::SubControl>::target_type & sc, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (cc);
    __SUPPRESS_UNUSED_WARNING (opt);
    __SUPPRESS_UNUSED_WARNING (sc);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("subControlRect");
  }

  virtual QRect subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget) const
  {
    if (cb_subControlRect_c9798_1.can_issue()) {
      return cb_subControlRect_c9798_1.issue<QStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const qt_gsi::Converter<QStyle::SubControl>::target_type &, const QWidget *>(&QStyle_Adaptor::cbs_subControlRect_c9798_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, qt_gsi::CppToQtAdaptor<QStyle::SubControl>(sc), widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("subControlRect");
    }
  }

  //  [adaptor impl] QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)
  QRect cbs_subElementRect_c6528_1(const qt_gsi::Converter<QStyle::SubElement>::target_type & subElement, const QStyleOption *option, const QWidget *widget) const
  {
    __SUPPRESS_UNUSED_WARNING (subElement);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("subElementRect");
  }

  virtual QRect subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_subElementRect_c6528_1.can_issue()) {
      return cb_subElementRect_c6528_1.issue<QStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::SubElement>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_subElementRect_c6528_1, qt_gsi::CppToQtAdaptor<QStyle::SubElement>(subElement), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("subElementRect");
    }
  }

  //  [adaptor impl] void QStyle::unpolish(QWidget *widget)
  void cbs_unpolish_1315_0(QWidget *widget)
  {
    QStyle::unpolish(widget);
  }

  virtual void unpolish(QWidget *widget)
  {
    if (cb_unpolish_1315_0.can_issue()) {
      cb_unpolish_1315_0.issue<QStyle_Adaptor, QWidget *>(&QStyle_Adaptor::cbs_unpolish_1315_0, widget);
    } else {
      QStyle::unpolish(widget);
    }
  }

  //  [adaptor impl] void QStyle::unpolish(QApplication *application)
  void cbs_unpolish_1843_0(QApplication *application)
  {
    QStyle::unpolish(application);
  }

  virtual void unpolish(QApplication *application)
  {
    if (cb_unpolish_1843_0.can_issue()) {
      cb_unpolish_1843_0.issue<QStyle_Adaptor, QApplication *>(&QStyle_Adaptor::cbs_unpolish_1843_0, application);
    } else {
      QStyle::unpolish(application);
    }
  }

  //  [adaptor impl] void QStyle::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QStyle::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStyle_Adaptor, QChildEvent *>(&QStyle_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QStyle::childEvent(event);
    }
  }

  //  [adaptor impl] void QStyle::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QStyle::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStyle_Adaptor, QEvent *>(&QStyle_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QStyle::customEvent(event);
    }
  }

  //  [adaptor impl] void QStyle::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QStyle::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QStyle_Adaptor, const QMetaMethod &>(&QStyle_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QStyle::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStyle::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QStyle::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStyle_Adaptor, QTimerEvent *>(&QStyle_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QStyle::timerEvent(event);
    }
  }

  gsi::Callback cb_drawComplexControl_c9027_1;
  gsi::Callback cb_drawControl_c8285_1;
  gsi::Callback cb_drawItemPixmap_c5678_0;
  gsi::Callback cb_drawItemText_c10604_1;
  gsi::Callback cb_drawPrimitive_c8501_1;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_generatedIconPixmap_c5776_0;
  gsi::Callback cb_hitTestComplexControl_c9517_1;
  gsi::Callback cb_itemPixmapRect_c4360_0;
  gsi::Callback cb_itemTextRect_c7544_0;
  gsi::Callback cb_layoutSpacing_c11697_2;
  gsi::Callback cb_pixelMetric_c6642_2;
  gsi::Callback cb_polish_1315_0;
  gsi::Callback cb_polish_1843_0;
  gsi::Callback cb_polish_1418_0;
  gsi::Callback cb_sizeFromContents_c8477_1;
  gsi::Callback cb_standardIcon_c6956_2;
  gsi::Callback cb_standardPalette_c0_0;
  gsi::Callback cb_standardPixmap_c6956_2;
  gsi::Callback cb_styleHint_c8615_3;
  gsi::Callback cb_subControlRect_c9798_1;
  gsi::Callback cb_subElementRect_c6528_1;
  gsi::Callback cb_unpolish_1315_0;
  gsi::Callback cb_unpolish_1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStyle_Adaptor::~QStyle_Adaptor() { }

//  Constructor QStyle::QStyle() (adaptor class)

static void _init_ctor_QStyle_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QStyle_Adaptor> ();
}

static void _call_ctor_QStyle_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle_Adaptor *> (new QStyle_Adaptor ());
}


// void QStyle::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QStyle::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QStyle::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QStyle_Adaptor *)cls)->emitter_QStyle_destroyed_1302 (arg1);
}


// void QStyle::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)

static void _init_cbs_drawComplexControl_c9027_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawComplexControl_c9027_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_drawComplexControl_c9027_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawComplexControl_c9027_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawComplexControl_c9027_1 = cb;
}


// void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawControl_c8285_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawControl_c8285_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_drawControl_c8285_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawControl_c8285_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawControl_c8285_1 = cb;
}


// void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)

static void _init_cbs_drawItemPixmap_c5678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemPixmap_c5678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPixmap &arg4 = args.read<const QPixmap & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_drawItemPixmap_c5678_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawItemPixmap_c5678_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawItemPixmap_c5678_0 = cb;
}


// void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)

static void _init_cbs_drawItemText_c10604_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemText_c10604_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPalette &arg4 = args.read<const QPalette & > (heap);
  bool arg5 = args.read<bool > (heap);
  const QString &arg6 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_drawItemText_c10604_1 (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static void _set_callback_cbs_drawItemText_c10604_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawItemText_c10604_1 = cb;
}


// void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawPrimitive_c8501_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawPrimitive_c8501_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_drawPrimitive_c8501_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawPrimitive_c8501_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawPrimitive_c8501_1 = cb;
}


// bool QStyle::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyle_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QStyle::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyle_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)

static void _init_cbs_generatedIconPixmap_c5776_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_generatedIconPixmap_c5776_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > (heap);
  const QPixmap &arg2 = args.read<const QPixmap & > (heap);
  const QStyleOption *arg3 = args.read<const QStyleOption * > (heap);
  ret.write<QPixmap > ((QPixmap)((QStyle_Adaptor *)cls)->cbs_generatedIconPixmap_c5776_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_generatedIconPixmap_c5776_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_generatedIconPixmap_c5776_0 = cb;
}


// QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)

static void _init_cbs_hitTestComplexControl_c9517_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_cbs_hitTestComplexControl_c9517_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const QPoint &arg3 = args.read<const QPoint & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)((QStyle_Adaptor *)cls)->cbs_hitTestComplexControl_c9517_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_hitTestComplexControl_c9517_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_hitTestComplexControl_c9517_1 = cb;
}


// exposed bool QStyle::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QStyle_Adaptor *)cls)->fp_QStyle_isSignalConnected_c2394 (arg1));
}


// QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)

static void _init_cbs_itemPixmapRect_c4360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemPixmapRect_c4360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  int arg2 = args.read<int > (heap);
  const QPixmap &arg3 = args.read<const QPixmap & > (heap);
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_itemPixmapRect_c4360_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_itemPixmapRect_c4360_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_itemPixmapRect_c4360_0 = cb;
}


// QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)

static void _init_cbs_itemTextRect_c7544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemTextRect_c7544_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  bool arg4 = args.read<bool > (heap);
  const QString &arg5 = args.read<const QString & > (heap);
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_itemTextRect_c7544_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_itemTextRect_c7544_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_itemTextRect_c7544_0 = cb;
}


// int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_layoutSpacing_c11697_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_cbs_layoutSpacing_c11697_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QStyleOption *arg4 = args.read<const QStyleOption * > (heap);
  const QWidget *arg5 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->cbs_layoutSpacing_c11697_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_layoutSpacing_c11697_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_layoutSpacing_c11697_2 = cb;
}


// emitter void QStyle::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QStyle_Adaptor *)cls)->emitter_QStyle_objectNameChanged_4567 (arg1);
}


// int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_pixelMetric_c6642_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_cbs_pixelMetric_c6642_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->cbs_pixelMetric_c6642_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_pixelMetric_c6642_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_pixelMetric_c6642_2 = cb;
}


// void QStyle::polish(QWidget *widget)

static void _init_cbs_polish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_polish_1315_0 (arg1);
}

static void _set_callback_cbs_polish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1315_0 = cb;
}


// void QStyle::polish(QApplication *application)

static void _init_cbs_polish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_polish_1843_0 (arg1);
}

static void _set_callback_cbs_polish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1843_0 = cb;
}


// void QStyle::polish(QPalette &palette)

static void _init_cbs_polish_1418_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1418_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = args.read<QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_polish_1418_0 (arg1);
}

static void _set_callback_cbs_polish_1418_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1418_0 = cb;
}


// exposed int QStyle::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->fp_QStyle_receivers_c1731 (arg1));
}


// exposed QObject *QStyle::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QStyle_Adaptor *)cls)->fp_QStyle_sender_c0 ());
}


// exposed int QStyle::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->fp_QStyle_senderSignalIndex_c0 ());
}


// QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)

static void _init_cbs_sizeFromContents_c8477_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeFromContents_c8477_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QSize &arg3 = args.read<const QSize & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QSize > ((QSize)((QStyle_Adaptor *)cls)->cbs_sizeFromContents_c8477_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sizeFromContents_c8477_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_sizeFromContents_c8477_1 = cb;
}


// QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_standardIcon_c6956_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_cbs_standardIcon_c6956_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QIcon > ((QIcon)((QStyle_Adaptor *)cls)->cbs_standardIcon_c6956_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardIcon_c6956_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_standardIcon_c6956_2 = cb;
}


// QPalette QStyle::standardPalette()

static void _init_cbs_standardPalette_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_cbs_standardPalette_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QStyle_Adaptor *)cls)->cbs_standardPalette_c0_0 ());
}

static void _set_callback_cbs_standardPalette_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_standardPalette_c0_0 = cb;
}


// QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardPixmap_c6956_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_standardPixmap_c6956_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QPixmap > ((QPixmap)((QStyle_Adaptor *)cls)->cbs_standardPixmap_c6956_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardPixmap_c6956_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_standardPixmap_c6956_2 = cb;
}


// int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)

static void _init_cbs_styleHint_c8615_3 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stylehint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_cbs_styleHint_c8615_3 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  QStyleHintReturn *arg4 = args.read<QStyleHintReturn * > (heap);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->cbs_styleHint_c8615_3 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_styleHint_c8615_3 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_styleHint_c8615_3 = cb;
}


// QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)

static void _init_cbs_subControlRect_c9798_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_cbs_subControlRect_c9798_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_subControlRect_c9798_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_subControlRect_c9798_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_subControlRect_c9798_1 = cb;
}


// QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_subElementRect_c6528_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subElement");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_subElementRect_c6528_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_subElementRect_c6528_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_subElementRect_c6528_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_subElementRect_c6528_1 = cb;
}


// void QStyle::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QStyle::unpolish(QWidget *widget)

static void _init_cbs_unpolish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_unpolish_1315_0 (arg1);
}

static void _set_callback_cbs_unpolish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_unpolish_1315_0 = cb;
}


// void QStyle::unpolish(QApplication *application)

static void _init_cbs_unpolish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyle_Adaptor *)cls)->cbs_unpolish_1843_0 (arg1);
}

static void _set_callback_cbs_unpolish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_unpolish_1843_0 = cb;
}


namespace gsi
{

gsi::Class<QStyle> &qtdecl_QStyle ();

static gsi::Methods methods_QStyle_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStyle::QStyle()\nThis method creates an object of class QStyle.", &_init_ctor_QStyle_Adaptor_0, &_call_ctor_QStyle_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStyle::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStyle::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QStyle::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStyle::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Virtual method void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@hide", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1, &_set_callback_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Virtual method void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@hide", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1, &_set_callback_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Virtual method void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@hide", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0, &_set_callback_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@brief Virtual method void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@hide", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1, &_set_callback_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Virtual method void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@hide", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1, &_set_callback_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStyle::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStyle::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Virtual method QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@hide", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0, &_set_callback_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Virtual method QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@hide", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1, &_set_callback_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QStyle::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Virtual method QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@hide", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0, &_set_callback_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@brief Virtual method QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@hide", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0, &_set_callback_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@brief Virtual method int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_layoutSpacing_c11697_2, &_call_cbs_layoutSpacing_c11697_2);
  methods += new qt_gsi::GenericMethod ("layoutSpacing", "@hide", true, &_init_cbs_layoutSpacing_c11697_2, &_call_cbs_layoutSpacing_c11697_2, &_set_callback_cbs_layoutSpacing_c11697_2);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QStyle::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Virtual method int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@hide", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2, &_set_callback_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0, &_set_callback_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QApplication *application)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0, &_set_callback_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QPalette &palette)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0, &_set_callback_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QStyle::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QStyle::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QStyle::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Virtual method QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@hide", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1, &_set_callback_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@brief Virtual method QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardIcon_c6956_2, &_call_cbs_standardIcon_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardIcon", "@hide", true, &_init_cbs_standardIcon_c6956_2, &_call_cbs_standardIcon_c6956_2, &_set_callback_cbs_standardIcon_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@brief Virtual method QPalette QStyle::standardPalette()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@hide", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0, &_set_callback_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Virtual method QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@hide", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2, &_set_callback_cbs_standardPixmap_c6956_2);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Virtual method int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("styleHint", "@hide", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3, &_set_callback_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Virtual method QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@hide", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1, &_set_callback_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Virtual method QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@hide", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1, &_set_callback_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStyle::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QStyle::unpolish(QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0, &_set_callback_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QStyle::unpolish(QApplication *application)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0, &_set_callback_cbs_unpolish_1843_0);
  return methods;
}

gsi::Class<QStyle_Adaptor> decl_QStyle_Adaptor (qtdecl_QStyle (), "QtWidgets", "QStyle",
  methods_QStyle_Adaptor (),
  "@qt\n@brief Binding of QStyle");

}


//  Implementation of the enum wrapper class for QStyle::ComplexControl
namespace qt_gsi
{

static gsi::Enum<QStyle::ComplexControl> decl_QStyle_ComplexControl_Enum ("QtWidgets", "QStyle_ComplexControl",
    gsi::enum_const ("CC_SpinBox", QStyle::CC_SpinBox, "@brief Enum constant QStyle::CC_SpinBox") +
    gsi::enum_const ("CC_ComboBox", QStyle::CC_ComboBox, "@brief Enum constant QStyle::CC_ComboBox") +
    gsi::enum_const ("CC_ScrollBar", QStyle::CC_ScrollBar, "@brief Enum constant QStyle::CC_ScrollBar") +
    gsi::enum_const ("CC_Slider", QStyle::CC_Slider, "@brief Enum constant QStyle::CC_Slider") +
    gsi::enum_const ("CC_ToolButton", QStyle::CC_ToolButton, "@brief Enum constant QStyle::CC_ToolButton") +
    gsi::enum_const ("CC_TitleBar", QStyle::CC_TitleBar, "@brief Enum constant QStyle::CC_TitleBar") +
    gsi::enum_const ("CC_Dial", QStyle::CC_Dial, "@brief Enum constant QStyle::CC_Dial") +
    gsi::enum_const ("CC_GroupBox", QStyle::CC_GroupBox, "@brief Enum constant QStyle::CC_GroupBox") +
    gsi::enum_const ("CC_MdiControls", QStyle::CC_MdiControls, "@brief Enum constant QStyle::CC_MdiControls") +
    gsi::enum_const ("CC_CustomBase", QStyle::CC_CustomBase, "@brief Enum constant QStyle::CC_CustomBase"),
  "@qt\n@brief This class represents the QStyle::ComplexControl enum");

static gsi::QFlagsClass<QStyle::ComplexControl > decl_QStyle_ComplexControl_Enums ("QtWidgets", "QStyle_QFlags_ComplexControl",
  "@qt\n@brief This class represents the QFlags<QStyle::ComplexControl> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ComplexControl_Enum_in_parent (decl_QStyle_ComplexControl_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_ComplexControl_Enum_as_child (decl_QStyle_ComplexControl_Enum, "ComplexControl");
static gsi::ClassExt<QStyle> decl_QStyle_ComplexControl_Enums_as_child (decl_QStyle_ComplexControl_Enums, "QFlags_ComplexControl");

}


//  Implementation of the enum wrapper class for QStyle::ContentsType
namespace qt_gsi
{

static gsi::Enum<QStyle::ContentsType> decl_QStyle_ContentsType_Enum ("QtWidgets", "QStyle_ContentsType",
    gsi::enum_const ("CT_PushButton", QStyle::CT_PushButton, "@brief Enum constant QStyle::CT_PushButton") +
    gsi::enum_const ("CT_CheckBox", QStyle::CT_CheckBox, "@brief Enum constant QStyle::CT_CheckBox") +
    gsi::enum_const ("CT_RadioButton", QStyle::CT_RadioButton, "@brief Enum constant QStyle::CT_RadioButton") +
    gsi::enum_const ("CT_ToolButton", QStyle::CT_ToolButton, "@brief Enum constant QStyle::CT_ToolButton") +
    gsi::enum_const ("CT_ComboBox", QStyle::CT_ComboBox, "@brief Enum constant QStyle::CT_ComboBox") +
    gsi::enum_const ("CT_Splitter", QStyle::CT_Splitter, "@brief Enum constant QStyle::CT_Splitter") +
    gsi::enum_const ("CT_ProgressBar", QStyle::CT_ProgressBar, "@brief Enum constant QStyle::CT_ProgressBar") +
    gsi::enum_const ("CT_MenuItem", QStyle::CT_MenuItem, "@brief Enum constant QStyle::CT_MenuItem") +
    gsi::enum_const ("CT_MenuBarItem", QStyle::CT_MenuBarItem, "@brief Enum constant QStyle::CT_MenuBarItem") +
    gsi::enum_const ("CT_MenuBar", QStyle::CT_MenuBar, "@brief Enum constant QStyle::CT_MenuBar") +
    gsi::enum_const ("CT_Menu", QStyle::CT_Menu, "@brief Enum constant QStyle::CT_Menu") +
    gsi::enum_const ("CT_TabBarTab", QStyle::CT_TabBarTab, "@brief Enum constant QStyle::CT_TabBarTab") +
    gsi::enum_const ("CT_Slider", QStyle::CT_Slider, "@brief Enum constant QStyle::CT_Slider") +
    gsi::enum_const ("CT_ScrollBar", QStyle::CT_ScrollBar, "@brief Enum constant QStyle::CT_ScrollBar") +
    gsi::enum_const ("CT_LineEdit", QStyle::CT_LineEdit, "@brief Enum constant QStyle::CT_LineEdit") +
    gsi::enum_const ("CT_SpinBox", QStyle::CT_SpinBox, "@brief Enum constant QStyle::CT_SpinBox") +
    gsi::enum_const ("CT_SizeGrip", QStyle::CT_SizeGrip, "@brief Enum constant QStyle::CT_SizeGrip") +
    gsi::enum_const ("CT_TabWidget", QStyle::CT_TabWidget, "@brief Enum constant QStyle::CT_TabWidget") +
    gsi::enum_const ("CT_DialogButtons", QStyle::CT_DialogButtons, "@brief Enum constant QStyle::CT_DialogButtons") +
    gsi::enum_const ("CT_HeaderSection", QStyle::CT_HeaderSection, "@brief Enum constant QStyle::CT_HeaderSection") +
    gsi::enum_const ("CT_GroupBox", QStyle::CT_GroupBox, "@brief Enum constant QStyle::CT_GroupBox") +
    gsi::enum_const ("CT_MdiControls", QStyle::CT_MdiControls, "@brief Enum constant QStyle::CT_MdiControls") +
    gsi::enum_const ("CT_ItemViewItem", QStyle::CT_ItemViewItem, "@brief Enum constant QStyle::CT_ItemViewItem") +
    gsi::enum_const ("CT_CustomBase", QStyle::CT_CustomBase, "@brief Enum constant QStyle::CT_CustomBase"),
  "@qt\n@brief This class represents the QStyle::ContentsType enum");

static gsi::QFlagsClass<QStyle::ContentsType > decl_QStyle_ContentsType_Enums ("QtWidgets", "QStyle_QFlags_ContentsType",
  "@qt\n@brief This class represents the QFlags<QStyle::ContentsType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ContentsType_Enum_in_parent (decl_QStyle_ContentsType_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_ContentsType_Enum_as_child (decl_QStyle_ContentsType_Enum, "ContentsType");
static gsi::ClassExt<QStyle> decl_QStyle_ContentsType_Enums_as_child (decl_QStyle_ContentsType_Enums, "QFlags_ContentsType");

}


//  Implementation of the enum wrapper class for QStyle::ControlElement
namespace qt_gsi
{

static gsi::Enum<QStyle::ControlElement> decl_QStyle_ControlElement_Enum ("QtWidgets", "QStyle_ControlElement",
    gsi::enum_const ("CE_PushButton", QStyle::CE_PushButton, "@brief Enum constant QStyle::CE_PushButton") +
    gsi::enum_const ("CE_PushButtonBevel", QStyle::CE_PushButtonBevel, "@brief Enum constant QStyle::CE_PushButtonBevel") +
    gsi::enum_const ("CE_PushButtonLabel", QStyle::CE_PushButtonLabel, "@brief Enum constant QStyle::CE_PushButtonLabel") +
    gsi::enum_const ("CE_CheckBox", QStyle::CE_CheckBox, "@brief Enum constant QStyle::CE_CheckBox") +
    gsi::enum_const ("CE_CheckBoxLabel", QStyle::CE_CheckBoxLabel, "@brief Enum constant QStyle::CE_CheckBoxLabel") +
    gsi::enum_const ("CE_RadioButton", QStyle::CE_RadioButton, "@brief Enum constant QStyle::CE_RadioButton") +
    gsi::enum_const ("CE_RadioButtonLabel", QStyle::CE_RadioButtonLabel, "@brief Enum constant QStyle::CE_RadioButtonLabel") +
    gsi::enum_const ("CE_TabBarTab", QStyle::CE_TabBarTab, "@brief Enum constant QStyle::CE_TabBarTab") +
    gsi::enum_const ("CE_TabBarTabShape", QStyle::CE_TabBarTabShape, "@brief Enum constant QStyle::CE_TabBarTabShape") +
    gsi::enum_const ("CE_TabBarTabLabel", QStyle::CE_TabBarTabLabel, "@brief Enum constant QStyle::CE_TabBarTabLabel") +
    gsi::enum_const ("CE_ProgressBar", QStyle::CE_ProgressBar, "@brief Enum constant QStyle::CE_ProgressBar") +
    gsi::enum_const ("CE_ProgressBarGroove", QStyle::CE_ProgressBarGroove, "@brief Enum constant QStyle::CE_ProgressBarGroove") +
    gsi::enum_const ("CE_ProgressBarContents", QStyle::CE_ProgressBarContents, "@brief Enum constant QStyle::CE_ProgressBarContents") +
    gsi::enum_const ("CE_ProgressBarLabel", QStyle::CE_ProgressBarLabel, "@brief Enum constant QStyle::CE_ProgressBarLabel") +
    gsi::enum_const ("CE_MenuItem", QStyle::CE_MenuItem, "@brief Enum constant QStyle::CE_MenuItem") +
    gsi::enum_const ("CE_MenuScroller", QStyle::CE_MenuScroller, "@brief Enum constant QStyle::CE_MenuScroller") +
    gsi::enum_const ("CE_MenuVMargin", QStyle::CE_MenuVMargin, "@brief Enum constant QStyle::CE_MenuVMargin") +
    gsi::enum_const ("CE_MenuHMargin", QStyle::CE_MenuHMargin, "@brief Enum constant QStyle::CE_MenuHMargin") +
    gsi::enum_const ("CE_MenuTearoff", QStyle::CE_MenuTearoff, "@brief Enum constant QStyle::CE_MenuTearoff") +
    gsi::enum_const ("CE_MenuEmptyArea", QStyle::CE_MenuEmptyArea, "@brief Enum constant QStyle::CE_MenuEmptyArea") +
    gsi::enum_const ("CE_MenuBarItem", QStyle::CE_MenuBarItem, "@brief Enum constant QStyle::CE_MenuBarItem") +
    gsi::enum_const ("CE_MenuBarEmptyArea", QStyle::CE_MenuBarEmptyArea, "@brief Enum constant QStyle::CE_MenuBarEmptyArea") +
    gsi::enum_const ("CE_ToolButtonLabel", QStyle::CE_ToolButtonLabel, "@brief Enum constant QStyle::CE_ToolButtonLabel") +
    gsi::enum_const ("CE_Header", QStyle::CE_Header, "@brief Enum constant QStyle::CE_Header") +
    gsi::enum_const ("CE_HeaderSection", QStyle::CE_HeaderSection, "@brief Enum constant QStyle::CE_HeaderSection") +
    gsi::enum_const ("CE_HeaderLabel", QStyle::CE_HeaderLabel, "@brief Enum constant QStyle::CE_HeaderLabel") +
    gsi::enum_const ("CE_ToolBoxTab", QStyle::CE_ToolBoxTab, "@brief Enum constant QStyle::CE_ToolBoxTab") +
    gsi::enum_const ("CE_SizeGrip", QStyle::CE_SizeGrip, "@brief Enum constant QStyle::CE_SizeGrip") +
    gsi::enum_const ("CE_Splitter", QStyle::CE_Splitter, "@brief Enum constant QStyle::CE_Splitter") +
    gsi::enum_const ("CE_RubberBand", QStyle::CE_RubberBand, "@brief Enum constant QStyle::CE_RubberBand") +
    gsi::enum_const ("CE_DockWidgetTitle", QStyle::CE_DockWidgetTitle, "@brief Enum constant QStyle::CE_DockWidgetTitle") +
    gsi::enum_const ("CE_ScrollBarAddLine", QStyle::CE_ScrollBarAddLine, "@brief Enum constant QStyle::CE_ScrollBarAddLine") +
    gsi::enum_const ("CE_ScrollBarSubLine", QStyle::CE_ScrollBarSubLine, "@brief Enum constant QStyle::CE_ScrollBarSubLine") +
    gsi::enum_const ("CE_ScrollBarAddPage", QStyle::CE_ScrollBarAddPage, "@brief Enum constant QStyle::CE_ScrollBarAddPage") +
    gsi::enum_const ("CE_ScrollBarSubPage", QStyle::CE_ScrollBarSubPage, "@brief Enum constant QStyle::CE_ScrollBarSubPage") +
    gsi::enum_const ("CE_ScrollBarSlider", QStyle::CE_ScrollBarSlider, "@brief Enum constant QStyle::CE_ScrollBarSlider") +
    gsi::enum_const ("CE_ScrollBarFirst", QStyle::CE_ScrollBarFirst, "@brief Enum constant QStyle::CE_ScrollBarFirst") +
    gsi::enum_const ("CE_ScrollBarLast", QStyle::CE_ScrollBarLast, "@brief Enum constant QStyle::CE_ScrollBarLast") +
    gsi::enum_const ("CE_FocusFrame", QStyle::CE_FocusFrame, "@brief Enum constant QStyle::CE_FocusFrame") +
    gsi::enum_const ("CE_ComboBoxLabel", QStyle::CE_ComboBoxLabel, "@brief Enum constant QStyle::CE_ComboBoxLabel") +
    gsi::enum_const ("CE_ToolBar", QStyle::CE_ToolBar, "@brief Enum constant QStyle::CE_ToolBar") +
    gsi::enum_const ("CE_ToolBoxTabShape", QStyle::CE_ToolBoxTabShape, "@brief Enum constant QStyle::CE_ToolBoxTabShape") +
    gsi::enum_const ("CE_ToolBoxTabLabel", QStyle::CE_ToolBoxTabLabel, "@brief Enum constant QStyle::CE_ToolBoxTabLabel") +
    gsi::enum_const ("CE_HeaderEmptyArea", QStyle::CE_HeaderEmptyArea, "@brief Enum constant QStyle::CE_HeaderEmptyArea") +
    gsi::enum_const ("CE_ColumnViewGrip", QStyle::CE_ColumnViewGrip, "@brief Enum constant QStyle::CE_ColumnViewGrip") +
    gsi::enum_const ("CE_ItemViewItem", QStyle::CE_ItemViewItem, "@brief Enum constant QStyle::CE_ItemViewItem") +
    gsi::enum_const ("CE_ShapedFrame", QStyle::CE_ShapedFrame, "@brief Enum constant QStyle::CE_ShapedFrame") +
    gsi::enum_const ("CE_CustomBase", QStyle::CE_CustomBase, "@brief Enum constant QStyle::CE_CustomBase"),
  "@qt\n@brief This class represents the QStyle::ControlElement enum");

static gsi::QFlagsClass<QStyle::ControlElement > decl_QStyle_ControlElement_Enums ("QtWidgets", "QStyle_QFlags_ControlElement",
  "@qt\n@brief This class represents the QFlags<QStyle::ControlElement> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ControlElement_Enum_in_parent (decl_QStyle_ControlElement_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_ControlElement_Enum_as_child (decl_QStyle_ControlElement_Enum, "ControlElement");
static gsi::ClassExt<QStyle> decl_QStyle_ControlElement_Enums_as_child (decl_QStyle_ControlElement_Enums, "QFlags_ControlElement");

}


//  Implementation of the enum wrapper class for QStyle::PixelMetric
namespace qt_gsi
{

static gsi::Enum<QStyle::PixelMetric> decl_QStyle_PixelMetric_Enum ("QtWidgets", "QStyle_PixelMetric",
    gsi::enum_const ("PM_ButtonMargin", QStyle::PM_ButtonMargin, "@brief Enum constant QStyle::PM_ButtonMargin") +
    gsi::enum_const ("PM_ButtonDefaultIndicator", QStyle::PM_ButtonDefaultIndicator, "@brief Enum constant QStyle::PM_ButtonDefaultIndicator") +
    gsi::enum_const ("PM_MenuButtonIndicator", QStyle::PM_MenuButtonIndicator, "@brief Enum constant QStyle::PM_MenuButtonIndicator") +
    gsi::enum_const ("PM_ButtonShiftHorizontal", QStyle::PM_ButtonShiftHorizontal, "@brief Enum constant QStyle::PM_ButtonShiftHorizontal") +
    gsi::enum_const ("PM_ButtonShiftVertical", QStyle::PM_ButtonShiftVertical, "@brief Enum constant QStyle::PM_ButtonShiftVertical") +
    gsi::enum_const ("PM_DefaultFrameWidth", QStyle::PM_DefaultFrameWidth, "@brief Enum constant QStyle::PM_DefaultFrameWidth") +
    gsi::enum_const ("PM_SpinBoxFrameWidth", QStyle::PM_SpinBoxFrameWidth, "@brief Enum constant QStyle::PM_SpinBoxFrameWidth") +
    gsi::enum_const ("PM_ComboBoxFrameWidth", QStyle::PM_ComboBoxFrameWidth, "@brief Enum constant QStyle::PM_ComboBoxFrameWidth") +
    gsi::enum_const ("PM_MaximumDragDistance", QStyle::PM_MaximumDragDistance, "@brief Enum constant QStyle::PM_MaximumDragDistance") +
    gsi::enum_const ("PM_ScrollBarExtent", QStyle::PM_ScrollBarExtent, "@brief Enum constant QStyle::PM_ScrollBarExtent") +
    gsi::enum_const ("PM_ScrollBarSliderMin", QStyle::PM_ScrollBarSliderMin, "@brief Enum constant QStyle::PM_ScrollBarSliderMin") +
    gsi::enum_const ("PM_SliderThickness", QStyle::PM_SliderThickness, "@brief Enum constant QStyle::PM_SliderThickness") +
    gsi::enum_const ("PM_SliderControlThickness", QStyle::PM_SliderControlThickness, "@brief Enum constant QStyle::PM_SliderControlThickness") +
    gsi::enum_const ("PM_SliderLength", QStyle::PM_SliderLength, "@brief Enum constant QStyle::PM_SliderLength") +
    gsi::enum_const ("PM_SliderTickmarkOffset", QStyle::PM_SliderTickmarkOffset, "@brief Enum constant QStyle::PM_SliderTickmarkOffset") +
    gsi::enum_const ("PM_SliderSpaceAvailable", QStyle::PM_SliderSpaceAvailable, "@brief Enum constant QStyle::PM_SliderSpaceAvailable") +
    gsi::enum_const ("PM_DockWidgetSeparatorExtent", QStyle::PM_DockWidgetSeparatorExtent, "@brief Enum constant QStyle::PM_DockWidgetSeparatorExtent") +
    gsi::enum_const ("PM_DockWidgetHandleExtent", QStyle::PM_DockWidgetHandleExtent, "@brief Enum constant QStyle::PM_DockWidgetHandleExtent") +
    gsi::enum_const ("PM_DockWidgetFrameWidth", QStyle::PM_DockWidgetFrameWidth, "@brief Enum constant QStyle::PM_DockWidgetFrameWidth") +
    gsi::enum_const ("PM_TabBarTabOverlap", QStyle::PM_TabBarTabOverlap, "@brief Enum constant QStyle::PM_TabBarTabOverlap") +
    gsi::enum_const ("PM_TabBarTabHSpace", QStyle::PM_TabBarTabHSpace, "@brief Enum constant QStyle::PM_TabBarTabHSpace") +
    gsi::enum_const ("PM_TabBarTabVSpace", QStyle::PM_TabBarTabVSpace, "@brief Enum constant QStyle::PM_TabBarTabVSpace") +
    gsi::enum_const ("PM_TabBarBaseHeight", QStyle::PM_TabBarBaseHeight, "@brief Enum constant QStyle::PM_TabBarBaseHeight") +
    gsi::enum_const ("PM_TabBarBaseOverlap", QStyle::PM_TabBarBaseOverlap, "@brief Enum constant QStyle::PM_TabBarBaseOverlap") +
    gsi::enum_const ("PM_ProgressBarChunkWidth", QStyle::PM_ProgressBarChunkWidth, "@brief Enum constant QStyle::PM_ProgressBarChunkWidth") +
    gsi::enum_const ("PM_SplitterWidth", QStyle::PM_SplitterWidth, "@brief Enum constant QStyle::PM_SplitterWidth") +
    gsi::enum_const ("PM_TitleBarHeight", QStyle::PM_TitleBarHeight, "@brief Enum constant QStyle::PM_TitleBarHeight") +
    gsi::enum_const ("PM_MenuScrollerHeight", QStyle::PM_MenuScrollerHeight, "@brief Enum constant QStyle::PM_MenuScrollerHeight") +
    gsi::enum_const ("PM_MenuHMargin", QStyle::PM_MenuHMargin, "@brief Enum constant QStyle::PM_MenuHMargin") +
    gsi::enum_const ("PM_MenuVMargin", QStyle::PM_MenuVMargin, "@brief Enum constant QStyle::PM_MenuVMargin") +
    gsi::enum_const ("PM_MenuPanelWidth", QStyle::PM_MenuPanelWidth, "@brief Enum constant QStyle::PM_MenuPanelWidth") +
    gsi::enum_const ("PM_MenuTearoffHeight", QStyle::PM_MenuTearoffHeight, "@brief Enum constant QStyle::PM_MenuTearoffHeight") +
    gsi::enum_const ("PM_MenuDesktopFrameWidth", QStyle::PM_MenuDesktopFrameWidth, "@brief Enum constant QStyle::PM_MenuDesktopFrameWidth") +
    gsi::enum_const ("PM_MenuBarPanelWidth", QStyle::PM_MenuBarPanelWidth, "@brief Enum constant QStyle::PM_MenuBarPanelWidth") +
    gsi::enum_const ("PM_MenuBarItemSpacing", QStyle::PM_MenuBarItemSpacing, "@brief Enum constant QStyle::PM_MenuBarItemSpacing") +
    gsi::enum_const ("PM_MenuBarVMargin", QStyle::PM_MenuBarVMargin, "@brief Enum constant QStyle::PM_MenuBarVMargin") +
    gsi::enum_const ("PM_MenuBarHMargin", QStyle::PM_MenuBarHMargin, "@brief Enum constant QStyle::PM_MenuBarHMargin") +
    gsi::enum_const ("PM_IndicatorWidth", QStyle::PM_IndicatorWidth, "@brief Enum constant QStyle::PM_IndicatorWidth") +
    gsi::enum_const ("PM_IndicatorHeight", QStyle::PM_IndicatorHeight, "@brief Enum constant QStyle::PM_IndicatorHeight") +
    gsi::enum_const ("PM_ExclusiveIndicatorWidth", QStyle::PM_ExclusiveIndicatorWidth, "@brief Enum constant QStyle::PM_ExclusiveIndicatorWidth") +
    gsi::enum_const ("PM_ExclusiveIndicatorHeight", QStyle::PM_ExclusiveIndicatorHeight, "@brief Enum constant QStyle::PM_ExclusiveIndicatorHeight") +
    gsi::enum_const ("PM_DialogButtonsSeparator", QStyle::PM_DialogButtonsSeparator, "@brief Enum constant QStyle::PM_DialogButtonsSeparator") +
    gsi::enum_const ("PM_DialogButtonsButtonWidth", QStyle::PM_DialogButtonsButtonWidth, "@brief Enum constant QStyle::PM_DialogButtonsButtonWidth") +
    gsi::enum_const ("PM_DialogButtonsButtonHeight", QStyle::PM_DialogButtonsButtonHeight, "@brief Enum constant QStyle::PM_DialogButtonsButtonHeight") +
    gsi::enum_const ("PM_MdiSubWindowFrameWidth", QStyle::PM_MdiSubWindowFrameWidth, "@brief Enum constant QStyle::PM_MdiSubWindowFrameWidth") +
    gsi::enum_const ("PM_MdiSubWindowMinimizedWidth", QStyle::PM_MdiSubWindowMinimizedWidth, "@brief Enum constant QStyle::PM_MdiSubWindowMinimizedWidth") +
    gsi::enum_const ("PM_HeaderMargin", QStyle::PM_HeaderMargin, "@brief Enum constant QStyle::PM_HeaderMargin") +
    gsi::enum_const ("PM_HeaderMarkSize", QStyle::PM_HeaderMarkSize, "@brief Enum constant QStyle::PM_HeaderMarkSize") +
    gsi::enum_const ("PM_HeaderGripMargin", QStyle::PM_HeaderGripMargin, "@brief Enum constant QStyle::PM_HeaderGripMargin") +
    gsi::enum_const ("PM_TabBarTabShiftHorizontal", QStyle::PM_TabBarTabShiftHorizontal, "@brief Enum constant QStyle::PM_TabBarTabShiftHorizontal") +
    gsi::enum_const ("PM_TabBarTabShiftVertical", QStyle::PM_TabBarTabShiftVertical, "@brief Enum constant QStyle::PM_TabBarTabShiftVertical") +
    gsi::enum_const ("PM_TabBarScrollButtonWidth", QStyle::PM_TabBarScrollButtonWidth, "@brief Enum constant QStyle::PM_TabBarScrollButtonWidth") +
    gsi::enum_const ("PM_ToolBarFrameWidth", QStyle::PM_ToolBarFrameWidth, "@brief Enum constant QStyle::PM_ToolBarFrameWidth") +
    gsi::enum_const ("PM_ToolBarHandleExtent", QStyle::PM_ToolBarHandleExtent, "@brief Enum constant QStyle::PM_ToolBarHandleExtent") +
    gsi::enum_const ("PM_ToolBarItemSpacing", QStyle::PM_ToolBarItemSpacing, "@brief Enum constant QStyle::PM_ToolBarItemSpacing") +
    gsi::enum_const ("PM_ToolBarItemMargin", QStyle::PM_ToolBarItemMargin, "@brief Enum constant QStyle::PM_ToolBarItemMargin") +
    gsi::enum_const ("PM_ToolBarSeparatorExtent", QStyle::PM_ToolBarSeparatorExtent, "@brief Enum constant QStyle::PM_ToolBarSeparatorExtent") +
    gsi::enum_const ("PM_ToolBarExtensionExtent", QStyle::PM_ToolBarExtensionExtent, "@brief Enum constant QStyle::PM_ToolBarExtensionExtent") +
    gsi::enum_const ("PM_SpinBoxSliderHeight", QStyle::PM_SpinBoxSliderHeight, "@brief Enum constant QStyle::PM_SpinBoxSliderHeight") +
    gsi::enum_const ("PM_ToolBarIconSize", QStyle::PM_ToolBarIconSize, "@brief Enum constant QStyle::PM_ToolBarIconSize") +
    gsi::enum_const ("PM_ListViewIconSize", QStyle::PM_ListViewIconSize, "@brief Enum constant QStyle::PM_ListViewIconSize") +
    gsi::enum_const ("PM_IconViewIconSize", QStyle::PM_IconViewIconSize, "@brief Enum constant QStyle::PM_IconViewIconSize") +
    gsi::enum_const ("PM_SmallIconSize", QStyle::PM_SmallIconSize, "@brief Enum constant QStyle::PM_SmallIconSize") +
    gsi::enum_const ("PM_LargeIconSize", QStyle::PM_LargeIconSize, "@brief Enum constant QStyle::PM_LargeIconSize") +
    gsi::enum_const ("PM_FocusFrameVMargin", QStyle::PM_FocusFrameVMargin, "@brief Enum constant QStyle::PM_FocusFrameVMargin") +
    gsi::enum_const ("PM_FocusFrameHMargin", QStyle::PM_FocusFrameHMargin, "@brief Enum constant QStyle::PM_FocusFrameHMargin") +
    gsi::enum_const ("PM_ToolTipLabelFrameWidth", QStyle::PM_ToolTipLabelFrameWidth, "@brief Enum constant QStyle::PM_ToolTipLabelFrameWidth") +
    gsi::enum_const ("PM_CheckBoxLabelSpacing", QStyle::PM_CheckBoxLabelSpacing, "@brief Enum constant QStyle::PM_CheckBoxLabelSpacing") +
    gsi::enum_const ("PM_TabBarIconSize", QStyle::PM_TabBarIconSize, "@brief Enum constant QStyle::PM_TabBarIconSize") +
    gsi::enum_const ("PM_SizeGripSize", QStyle::PM_SizeGripSize, "@brief Enum constant QStyle::PM_SizeGripSize") +
    gsi::enum_const ("PM_DockWidgetTitleMargin", QStyle::PM_DockWidgetTitleMargin, "@brief Enum constant QStyle::PM_DockWidgetTitleMargin") +
    gsi::enum_const ("PM_MessageBoxIconSize", QStyle::PM_MessageBoxIconSize, "@brief Enum constant QStyle::PM_MessageBoxIconSize") +
    gsi::enum_const ("PM_ButtonIconSize", QStyle::PM_ButtonIconSize, "@brief Enum constant QStyle::PM_ButtonIconSize") +
    gsi::enum_const ("PM_DockWidgetTitleBarButtonMargin", QStyle::PM_DockWidgetTitleBarButtonMargin, "@brief Enum constant QStyle::PM_DockWidgetTitleBarButtonMargin") +
    gsi::enum_const ("PM_RadioButtonLabelSpacing", QStyle::PM_RadioButtonLabelSpacing, "@brief Enum constant QStyle::PM_RadioButtonLabelSpacing") +
    gsi::enum_const ("PM_LayoutLeftMargin", QStyle::PM_LayoutLeftMargin, "@brief Enum constant QStyle::PM_LayoutLeftMargin") +
    gsi::enum_const ("PM_LayoutTopMargin", QStyle::PM_LayoutTopMargin, "@brief Enum constant QStyle::PM_LayoutTopMargin") +
    gsi::enum_const ("PM_LayoutRightMargin", QStyle::PM_LayoutRightMargin, "@brief Enum constant QStyle::PM_LayoutRightMargin") +
    gsi::enum_const ("PM_LayoutBottomMargin", QStyle::PM_LayoutBottomMargin, "@brief Enum constant QStyle::PM_LayoutBottomMargin") +
    gsi::enum_const ("PM_LayoutHorizontalSpacing", QStyle::PM_LayoutHorizontalSpacing, "@brief Enum constant QStyle::PM_LayoutHorizontalSpacing") +
    gsi::enum_const ("PM_LayoutVerticalSpacing", QStyle::PM_LayoutVerticalSpacing, "@brief Enum constant QStyle::PM_LayoutVerticalSpacing") +
    gsi::enum_const ("PM_TabBar_ScrollButtonOverlap", QStyle::PM_TabBar_ScrollButtonOverlap, "@brief Enum constant QStyle::PM_TabBar_ScrollButtonOverlap") +
    gsi::enum_const ("PM_TextCursorWidth", QStyle::PM_TextCursorWidth, "@brief Enum constant QStyle::PM_TextCursorWidth") +
    gsi::enum_const ("PM_TabCloseIndicatorWidth", QStyle::PM_TabCloseIndicatorWidth, "@brief Enum constant QStyle::PM_TabCloseIndicatorWidth") +
    gsi::enum_const ("PM_TabCloseIndicatorHeight", QStyle::PM_TabCloseIndicatorHeight, "@brief Enum constant QStyle::PM_TabCloseIndicatorHeight") +
    gsi::enum_const ("PM_ScrollView_ScrollBarSpacing", QStyle::PM_ScrollView_ScrollBarSpacing, "@brief Enum constant QStyle::PM_ScrollView_ScrollBarSpacing") +
    gsi::enum_const ("PM_ScrollView_ScrollBarOverlap", QStyle::PM_ScrollView_ScrollBarOverlap, "@brief Enum constant QStyle::PM_ScrollView_ScrollBarOverlap") +
    gsi::enum_const ("PM_SubMenuOverlap", QStyle::PM_SubMenuOverlap, "@brief Enum constant QStyle::PM_SubMenuOverlap") +
    gsi::enum_const ("PM_TreeViewIndentation", QStyle::PM_TreeViewIndentation, "@brief Enum constant QStyle::PM_TreeViewIndentation") +
    gsi::enum_const ("PM_HeaderDefaultSectionSizeHorizontal", QStyle::PM_HeaderDefaultSectionSizeHorizontal, "@brief Enum constant QStyle::PM_HeaderDefaultSectionSizeHorizontal") +
    gsi::enum_const ("PM_HeaderDefaultSectionSizeVertical", QStyle::PM_HeaderDefaultSectionSizeVertical, "@brief Enum constant QStyle::PM_HeaderDefaultSectionSizeVertical") +
    gsi::enum_const ("PM_TitleBarButtonIconSize", QStyle::PM_TitleBarButtonIconSize, "@brief Enum constant QStyle::PM_TitleBarButtonIconSize") +
    gsi::enum_const ("PM_TitleBarButtonSize", QStyle::PM_TitleBarButtonSize, "@brief Enum constant QStyle::PM_TitleBarButtonSize") +
    gsi::enum_const ("PM_LineEditIconSize", QStyle::PM_LineEditIconSize, "@brief Enum constant QStyle::PM_LineEditIconSize") +
    gsi::enum_const ("PM_CustomBase", QStyle::PM_CustomBase, "@brief Enum constant QStyle::PM_CustomBase"),
  "@qt\n@brief This class represents the QStyle::PixelMetric enum");

static gsi::QFlagsClass<QStyle::PixelMetric > decl_QStyle_PixelMetric_Enums ("QtWidgets", "QStyle_QFlags_PixelMetric",
  "@qt\n@brief This class represents the QFlags<QStyle::PixelMetric> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_PixelMetric_Enum_in_parent (decl_QStyle_PixelMetric_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_PixelMetric_Enum_as_child (decl_QStyle_PixelMetric_Enum, "PixelMetric");
static gsi::ClassExt<QStyle> decl_QStyle_PixelMetric_Enums_as_child (decl_QStyle_PixelMetric_Enums, "QFlags_PixelMetric");

}


//  Implementation of the enum wrapper class for QStyle::PrimitiveElement
namespace qt_gsi
{

static gsi::Enum<QStyle::PrimitiveElement> decl_QStyle_PrimitiveElement_Enum ("QtWidgets", "QStyle_PrimitiveElement",
    gsi::enum_const ("PE_Frame", QStyle::PE_Frame, "@brief Enum constant QStyle::PE_Frame") +
    gsi::enum_const ("PE_FrameDefaultButton", QStyle::PE_FrameDefaultButton, "@brief Enum constant QStyle::PE_FrameDefaultButton") +
    gsi::enum_const ("PE_FrameDockWidget", QStyle::PE_FrameDockWidget, "@brief Enum constant QStyle::PE_FrameDockWidget") +
    gsi::enum_const ("PE_FrameFocusRect", QStyle::PE_FrameFocusRect, "@brief Enum constant QStyle::PE_FrameFocusRect") +
    gsi::enum_const ("PE_FrameGroupBox", QStyle::PE_FrameGroupBox, "@brief Enum constant QStyle::PE_FrameGroupBox") +
    gsi::enum_const ("PE_FrameLineEdit", QStyle::PE_FrameLineEdit, "@brief Enum constant QStyle::PE_FrameLineEdit") +
    gsi::enum_const ("PE_FrameMenu", QStyle::PE_FrameMenu, "@brief Enum constant QStyle::PE_FrameMenu") +
    gsi::enum_const ("PE_FrameStatusBarItem", QStyle::PE_FrameStatusBarItem, "@brief Enum constant QStyle::PE_FrameStatusBarItem") +
    gsi::enum_const ("PE_FrameTabWidget", QStyle::PE_FrameTabWidget, "@brief Enum constant QStyle::PE_FrameTabWidget") +
    gsi::enum_const ("PE_FrameWindow", QStyle::PE_FrameWindow, "@brief Enum constant QStyle::PE_FrameWindow") +
    gsi::enum_const ("PE_FrameButtonBevel", QStyle::PE_FrameButtonBevel, "@brief Enum constant QStyle::PE_FrameButtonBevel") +
    gsi::enum_const ("PE_FrameButtonTool", QStyle::PE_FrameButtonTool, "@brief Enum constant QStyle::PE_FrameButtonTool") +
    gsi::enum_const ("PE_FrameTabBarBase", QStyle::PE_FrameTabBarBase, "@brief Enum constant QStyle::PE_FrameTabBarBase") +
    gsi::enum_const ("PE_PanelButtonCommand", QStyle::PE_PanelButtonCommand, "@brief Enum constant QStyle::PE_PanelButtonCommand") +
    gsi::enum_const ("PE_PanelButtonBevel", QStyle::PE_PanelButtonBevel, "@brief Enum constant QStyle::PE_PanelButtonBevel") +
    gsi::enum_const ("PE_PanelButtonTool", QStyle::PE_PanelButtonTool, "@brief Enum constant QStyle::PE_PanelButtonTool") +
    gsi::enum_const ("PE_PanelMenuBar", QStyle::PE_PanelMenuBar, "@brief Enum constant QStyle::PE_PanelMenuBar") +
    gsi::enum_const ("PE_PanelToolBar", QStyle::PE_PanelToolBar, "@brief Enum constant QStyle::PE_PanelToolBar") +
    gsi::enum_const ("PE_PanelLineEdit", QStyle::PE_PanelLineEdit, "@brief Enum constant QStyle::PE_PanelLineEdit") +
    gsi::enum_const ("PE_IndicatorArrowDown", QStyle::PE_IndicatorArrowDown, "@brief Enum constant QStyle::PE_IndicatorArrowDown") +
    gsi::enum_const ("PE_IndicatorArrowLeft", QStyle::PE_IndicatorArrowLeft, "@brief Enum constant QStyle::PE_IndicatorArrowLeft") +
    gsi::enum_const ("PE_IndicatorArrowRight", QStyle::PE_IndicatorArrowRight, "@brief Enum constant QStyle::PE_IndicatorArrowRight") +
    gsi::enum_const ("PE_IndicatorArrowUp", QStyle::PE_IndicatorArrowUp, "@brief Enum constant QStyle::PE_IndicatorArrowUp") +
    gsi::enum_const ("PE_IndicatorBranch", QStyle::PE_IndicatorBranch, "@brief Enum constant QStyle::PE_IndicatorBranch") +
    gsi::enum_const ("PE_IndicatorButtonDropDown", QStyle::PE_IndicatorButtonDropDown, "@brief Enum constant QStyle::PE_IndicatorButtonDropDown") +
    gsi::enum_const ("PE_IndicatorItemViewItemCheck", QStyle::PE_IndicatorItemViewItemCheck, "@brief Enum constant QStyle::PE_IndicatorItemViewItemCheck") +
    gsi::enum_const ("PE_IndicatorCheckBox", QStyle::PE_IndicatorCheckBox, "@brief Enum constant QStyle::PE_IndicatorCheckBox") +
    gsi::enum_const ("PE_IndicatorDockWidgetResizeHandle", QStyle::PE_IndicatorDockWidgetResizeHandle, "@brief Enum constant QStyle::PE_IndicatorDockWidgetResizeHandle") +
    gsi::enum_const ("PE_IndicatorHeaderArrow", QStyle::PE_IndicatorHeaderArrow, "@brief Enum constant QStyle::PE_IndicatorHeaderArrow") +
    gsi::enum_const ("PE_IndicatorMenuCheckMark", QStyle::PE_IndicatorMenuCheckMark, "@brief Enum constant QStyle::PE_IndicatorMenuCheckMark") +
    gsi::enum_const ("PE_IndicatorProgressChunk", QStyle::PE_IndicatorProgressChunk, "@brief Enum constant QStyle::PE_IndicatorProgressChunk") +
    gsi::enum_const ("PE_IndicatorRadioButton", QStyle::PE_IndicatorRadioButton, "@brief Enum constant QStyle::PE_IndicatorRadioButton") +
    gsi::enum_const ("PE_IndicatorSpinDown", QStyle::PE_IndicatorSpinDown, "@brief Enum constant QStyle::PE_IndicatorSpinDown") +
    gsi::enum_const ("PE_IndicatorSpinMinus", QStyle::PE_IndicatorSpinMinus, "@brief Enum constant QStyle::PE_IndicatorSpinMinus") +
    gsi::enum_const ("PE_IndicatorSpinPlus", QStyle::PE_IndicatorSpinPlus, "@brief Enum constant QStyle::PE_IndicatorSpinPlus") +
    gsi::enum_const ("PE_IndicatorSpinUp", QStyle::PE_IndicatorSpinUp, "@brief Enum constant QStyle::PE_IndicatorSpinUp") +
    gsi::enum_const ("PE_IndicatorToolBarHandle", QStyle::PE_IndicatorToolBarHandle, "@brief Enum constant QStyle::PE_IndicatorToolBarHandle") +
    gsi::enum_const ("PE_IndicatorToolBarSeparator", QStyle::PE_IndicatorToolBarSeparator, "@brief Enum constant QStyle::PE_IndicatorToolBarSeparator") +
    gsi::enum_const ("PE_PanelTipLabel", QStyle::PE_PanelTipLabel, "@brief Enum constant QStyle::PE_PanelTipLabel") +
    gsi::enum_const ("PE_IndicatorTabTear", QStyle::PE_IndicatorTabTear, "@brief Enum constant QStyle::PE_IndicatorTabTear") +
    gsi::enum_const ("PE_IndicatorTabTearLeft", QStyle::PE_IndicatorTabTearLeft, "@brief Enum constant QStyle::PE_IndicatorTabTearLeft") +
    gsi::enum_const ("PE_PanelScrollAreaCorner", QStyle::PE_PanelScrollAreaCorner, "@brief Enum constant QStyle::PE_PanelScrollAreaCorner") +
    gsi::enum_const ("PE_Widget", QStyle::PE_Widget, "@brief Enum constant QStyle::PE_Widget") +
    gsi::enum_const ("PE_IndicatorColumnViewArrow", QStyle::PE_IndicatorColumnViewArrow, "@brief Enum constant QStyle::PE_IndicatorColumnViewArrow") +
    gsi::enum_const ("PE_IndicatorItemViewItemDrop", QStyle::PE_IndicatorItemViewItemDrop, "@brief Enum constant QStyle::PE_IndicatorItemViewItemDrop") +
    gsi::enum_const ("PE_PanelItemViewItem", QStyle::PE_PanelItemViewItem, "@brief Enum constant QStyle::PE_PanelItemViewItem") +
    gsi::enum_const ("PE_PanelItemViewRow", QStyle::PE_PanelItemViewRow, "@brief Enum constant QStyle::PE_PanelItemViewRow") +
    gsi::enum_const ("PE_PanelStatusBar", QStyle::PE_PanelStatusBar, "@brief Enum constant QStyle::PE_PanelStatusBar") +
    gsi::enum_const ("PE_IndicatorTabClose", QStyle::PE_IndicatorTabClose, "@brief Enum constant QStyle::PE_IndicatorTabClose") +
    gsi::enum_const ("PE_PanelMenu", QStyle::PE_PanelMenu, "@brief Enum constant QStyle::PE_PanelMenu") +
    gsi::enum_const ("PE_IndicatorTabTearRight", QStyle::PE_IndicatorTabTearRight, "@brief Enum constant QStyle::PE_IndicatorTabTearRight") +
    gsi::enum_const ("PE_CustomBase", QStyle::PE_CustomBase, "@brief Enum constant QStyle::PE_CustomBase"),
  "@qt\n@brief This class represents the QStyle::PrimitiveElement enum");

static gsi::QFlagsClass<QStyle::PrimitiveElement > decl_QStyle_PrimitiveElement_Enums ("QtWidgets", "QStyle_QFlags_PrimitiveElement",
  "@qt\n@brief This class represents the QFlags<QStyle::PrimitiveElement> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_PrimitiveElement_Enum_in_parent (decl_QStyle_PrimitiveElement_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_PrimitiveElement_Enum_as_child (decl_QStyle_PrimitiveElement_Enum, "PrimitiveElement");
static gsi::ClassExt<QStyle> decl_QStyle_PrimitiveElement_Enums_as_child (decl_QStyle_PrimitiveElement_Enums, "QFlags_PrimitiveElement");

}


//  Implementation of the enum wrapper class for QStyle::StandardPixmap
namespace qt_gsi
{

static gsi::Enum<QStyle::StandardPixmap> decl_QStyle_StandardPixmap_Enum ("QtWidgets", "QStyle_StandardPixmap",
    gsi::enum_const ("SP_TitleBarMenuButton", QStyle::SP_TitleBarMenuButton, "@brief Enum constant QStyle::SP_TitleBarMenuButton") +
    gsi::enum_const ("SP_TitleBarMinButton", QStyle::SP_TitleBarMinButton, "@brief Enum constant QStyle::SP_TitleBarMinButton") +
    gsi::enum_const ("SP_TitleBarMaxButton", QStyle::SP_TitleBarMaxButton, "@brief Enum constant QStyle::SP_TitleBarMaxButton") +
    gsi::enum_const ("SP_TitleBarCloseButton", QStyle::SP_TitleBarCloseButton, "@brief Enum constant QStyle::SP_TitleBarCloseButton") +
    gsi::enum_const ("SP_TitleBarNormalButton", QStyle::SP_TitleBarNormalButton, "@brief Enum constant QStyle::SP_TitleBarNormalButton") +
    gsi::enum_const ("SP_TitleBarShadeButton", QStyle::SP_TitleBarShadeButton, "@brief Enum constant QStyle::SP_TitleBarShadeButton") +
    gsi::enum_const ("SP_TitleBarUnshadeButton", QStyle::SP_TitleBarUnshadeButton, "@brief Enum constant QStyle::SP_TitleBarUnshadeButton") +
    gsi::enum_const ("SP_TitleBarContextHelpButton", QStyle::SP_TitleBarContextHelpButton, "@brief Enum constant QStyle::SP_TitleBarContextHelpButton") +
    gsi::enum_const ("SP_DockWidgetCloseButton", QStyle::SP_DockWidgetCloseButton, "@brief Enum constant QStyle::SP_DockWidgetCloseButton") +
    gsi::enum_const ("SP_MessageBoxInformation", QStyle::SP_MessageBoxInformation, "@brief Enum constant QStyle::SP_MessageBoxInformation") +
    gsi::enum_const ("SP_MessageBoxWarning", QStyle::SP_MessageBoxWarning, "@brief Enum constant QStyle::SP_MessageBoxWarning") +
    gsi::enum_const ("SP_MessageBoxCritical", QStyle::SP_MessageBoxCritical, "@brief Enum constant QStyle::SP_MessageBoxCritical") +
    gsi::enum_const ("SP_MessageBoxQuestion", QStyle::SP_MessageBoxQuestion, "@brief Enum constant QStyle::SP_MessageBoxQuestion") +
    gsi::enum_const ("SP_DesktopIcon", QStyle::SP_DesktopIcon, "@brief Enum constant QStyle::SP_DesktopIcon") +
    gsi::enum_const ("SP_TrashIcon", QStyle::SP_TrashIcon, "@brief Enum constant QStyle::SP_TrashIcon") +
    gsi::enum_const ("SP_ComputerIcon", QStyle::SP_ComputerIcon, "@brief Enum constant QStyle::SP_ComputerIcon") +
    gsi::enum_const ("SP_DriveFDIcon", QStyle::SP_DriveFDIcon, "@brief Enum constant QStyle::SP_DriveFDIcon") +
    gsi::enum_const ("SP_DriveHDIcon", QStyle::SP_DriveHDIcon, "@brief Enum constant QStyle::SP_DriveHDIcon") +
    gsi::enum_const ("SP_DriveCDIcon", QStyle::SP_DriveCDIcon, "@brief Enum constant QStyle::SP_DriveCDIcon") +
    gsi::enum_const ("SP_DriveDVDIcon", QStyle::SP_DriveDVDIcon, "@brief Enum constant QStyle::SP_DriveDVDIcon") +
    gsi::enum_const ("SP_DriveNetIcon", QStyle::SP_DriveNetIcon, "@brief Enum constant QStyle::SP_DriveNetIcon") +
    gsi::enum_const ("SP_DirOpenIcon", QStyle::SP_DirOpenIcon, "@brief Enum constant QStyle::SP_DirOpenIcon") +
    gsi::enum_const ("SP_DirClosedIcon", QStyle::SP_DirClosedIcon, "@brief Enum constant QStyle::SP_DirClosedIcon") +
    gsi::enum_const ("SP_DirLinkIcon", QStyle::SP_DirLinkIcon, "@brief Enum constant QStyle::SP_DirLinkIcon") +
    gsi::enum_const ("SP_DirLinkOpenIcon", QStyle::SP_DirLinkOpenIcon, "@brief Enum constant QStyle::SP_DirLinkOpenIcon") +
    gsi::enum_const ("SP_FileIcon", QStyle::SP_FileIcon, "@brief Enum constant QStyle::SP_FileIcon") +
    gsi::enum_const ("SP_FileLinkIcon", QStyle::SP_FileLinkIcon, "@brief Enum constant QStyle::SP_FileLinkIcon") +
    gsi::enum_const ("SP_ToolBarHorizontalExtensionButton", QStyle::SP_ToolBarHorizontalExtensionButton, "@brief Enum constant QStyle::SP_ToolBarHorizontalExtensionButton") +
    gsi::enum_const ("SP_ToolBarVerticalExtensionButton", QStyle::SP_ToolBarVerticalExtensionButton, "@brief Enum constant QStyle::SP_ToolBarVerticalExtensionButton") +
    gsi::enum_const ("SP_FileDialogStart", QStyle::SP_FileDialogStart, "@brief Enum constant QStyle::SP_FileDialogStart") +
    gsi::enum_const ("SP_FileDialogEnd", QStyle::SP_FileDialogEnd, "@brief Enum constant QStyle::SP_FileDialogEnd") +
    gsi::enum_const ("SP_FileDialogToParent", QStyle::SP_FileDialogToParent, "@brief Enum constant QStyle::SP_FileDialogToParent") +
    gsi::enum_const ("SP_FileDialogNewFolder", QStyle::SP_FileDialogNewFolder, "@brief Enum constant QStyle::SP_FileDialogNewFolder") +
    gsi::enum_const ("SP_FileDialogDetailedView", QStyle::SP_FileDialogDetailedView, "@brief Enum constant QStyle::SP_FileDialogDetailedView") +
    gsi::enum_const ("SP_FileDialogInfoView", QStyle::SP_FileDialogInfoView, "@brief Enum constant QStyle::SP_FileDialogInfoView") +
    gsi::enum_const ("SP_FileDialogContentsView", QStyle::SP_FileDialogContentsView, "@brief Enum constant QStyle::SP_FileDialogContentsView") +
    gsi::enum_const ("SP_FileDialogListView", QStyle::SP_FileDialogListView, "@brief Enum constant QStyle::SP_FileDialogListView") +
    gsi::enum_const ("SP_FileDialogBack", QStyle::SP_FileDialogBack, "@brief Enum constant QStyle::SP_FileDialogBack") +
    gsi::enum_const ("SP_DirIcon", QStyle::SP_DirIcon, "@brief Enum constant QStyle::SP_DirIcon") +
    gsi::enum_const ("SP_DialogOkButton", QStyle::SP_DialogOkButton, "@brief Enum constant QStyle::SP_DialogOkButton") +
    gsi::enum_const ("SP_DialogCancelButton", QStyle::SP_DialogCancelButton, "@brief Enum constant QStyle::SP_DialogCancelButton") +
    gsi::enum_const ("SP_DialogHelpButton", QStyle::SP_DialogHelpButton, "@brief Enum constant QStyle::SP_DialogHelpButton") +
    gsi::enum_const ("SP_DialogOpenButton", QStyle::SP_DialogOpenButton, "@brief Enum constant QStyle::SP_DialogOpenButton") +
    gsi::enum_const ("SP_DialogSaveButton", QStyle::SP_DialogSaveButton, "@brief Enum constant QStyle::SP_DialogSaveButton") +
    gsi::enum_const ("SP_DialogCloseButton", QStyle::SP_DialogCloseButton, "@brief Enum constant QStyle::SP_DialogCloseButton") +
    gsi::enum_const ("SP_DialogApplyButton", QStyle::SP_DialogApplyButton, "@brief Enum constant QStyle::SP_DialogApplyButton") +
    gsi::enum_const ("SP_DialogResetButton", QStyle::SP_DialogResetButton, "@brief Enum constant QStyle::SP_DialogResetButton") +
    gsi::enum_const ("SP_DialogDiscardButton", QStyle::SP_DialogDiscardButton, "@brief Enum constant QStyle::SP_DialogDiscardButton") +
    gsi::enum_const ("SP_DialogYesButton", QStyle::SP_DialogYesButton, "@brief Enum constant QStyle::SP_DialogYesButton") +
    gsi::enum_const ("SP_DialogNoButton", QStyle::SP_DialogNoButton, "@brief Enum constant QStyle::SP_DialogNoButton") +
    gsi::enum_const ("SP_ArrowUp", QStyle::SP_ArrowUp, "@brief Enum constant QStyle::SP_ArrowUp") +
    gsi::enum_const ("SP_ArrowDown", QStyle::SP_ArrowDown, "@brief Enum constant QStyle::SP_ArrowDown") +
    gsi::enum_const ("SP_ArrowLeft", QStyle::SP_ArrowLeft, "@brief Enum constant QStyle::SP_ArrowLeft") +
    gsi::enum_const ("SP_ArrowRight", QStyle::SP_ArrowRight, "@brief Enum constant QStyle::SP_ArrowRight") +
    gsi::enum_const ("SP_ArrowBack", QStyle::SP_ArrowBack, "@brief Enum constant QStyle::SP_ArrowBack") +
    gsi::enum_const ("SP_ArrowForward", QStyle::SP_ArrowForward, "@brief Enum constant QStyle::SP_ArrowForward") +
    gsi::enum_const ("SP_DirHomeIcon", QStyle::SP_DirHomeIcon, "@brief Enum constant QStyle::SP_DirHomeIcon") +
    gsi::enum_const ("SP_CommandLink", QStyle::SP_CommandLink, "@brief Enum constant QStyle::SP_CommandLink") +
    gsi::enum_const ("SP_VistaShield", QStyle::SP_VistaShield, "@brief Enum constant QStyle::SP_VistaShield") +
    gsi::enum_const ("SP_BrowserReload", QStyle::SP_BrowserReload, "@brief Enum constant QStyle::SP_BrowserReload") +
    gsi::enum_const ("SP_BrowserStop", QStyle::SP_BrowserStop, "@brief Enum constant QStyle::SP_BrowserStop") +
    gsi::enum_const ("SP_MediaPlay", QStyle::SP_MediaPlay, "@brief Enum constant QStyle::SP_MediaPlay") +
    gsi::enum_const ("SP_MediaStop", QStyle::SP_MediaStop, "@brief Enum constant QStyle::SP_MediaStop") +
    gsi::enum_const ("SP_MediaPause", QStyle::SP_MediaPause, "@brief Enum constant QStyle::SP_MediaPause") +
    gsi::enum_const ("SP_MediaSkipForward", QStyle::SP_MediaSkipForward, "@brief Enum constant QStyle::SP_MediaSkipForward") +
    gsi::enum_const ("SP_MediaSkipBackward", QStyle::SP_MediaSkipBackward, "@brief Enum constant QStyle::SP_MediaSkipBackward") +
    gsi::enum_const ("SP_MediaSeekForward", QStyle::SP_MediaSeekForward, "@brief Enum constant QStyle::SP_MediaSeekForward") +
    gsi::enum_const ("SP_MediaSeekBackward", QStyle::SP_MediaSeekBackward, "@brief Enum constant QStyle::SP_MediaSeekBackward") +
    gsi::enum_const ("SP_MediaVolume", QStyle::SP_MediaVolume, "@brief Enum constant QStyle::SP_MediaVolume") +
    gsi::enum_const ("SP_MediaVolumeMuted", QStyle::SP_MediaVolumeMuted, "@brief Enum constant QStyle::SP_MediaVolumeMuted") +
    gsi::enum_const ("SP_LineEditClearButton", QStyle::SP_LineEditClearButton, "@brief Enum constant QStyle::SP_LineEditClearButton") +
    gsi::enum_const ("SP_DialogYesToAllButton", QStyle::SP_DialogYesToAllButton, "@brief Enum constant QStyle::SP_DialogYesToAllButton") +
    gsi::enum_const ("SP_DialogNoToAllButton", QStyle::SP_DialogNoToAllButton, "@brief Enum constant QStyle::SP_DialogNoToAllButton") +
    gsi::enum_const ("SP_DialogSaveAllButton", QStyle::SP_DialogSaveAllButton, "@brief Enum constant QStyle::SP_DialogSaveAllButton") +
    gsi::enum_const ("SP_DialogAbortButton", QStyle::SP_DialogAbortButton, "@brief Enum constant QStyle::SP_DialogAbortButton") +
    gsi::enum_const ("SP_DialogRetryButton", QStyle::SP_DialogRetryButton, "@brief Enum constant QStyle::SP_DialogRetryButton") +
    gsi::enum_const ("SP_DialogIgnoreButton", QStyle::SP_DialogIgnoreButton, "@brief Enum constant QStyle::SP_DialogIgnoreButton") +
    gsi::enum_const ("SP_RestoreDefaultsButton", QStyle::SP_RestoreDefaultsButton, "@brief Enum constant QStyle::SP_RestoreDefaultsButton") +
    gsi::enum_const ("SP_CustomBase", QStyle::SP_CustomBase, "@brief Enum constant QStyle::SP_CustomBase"),
  "@qt\n@brief This class represents the QStyle::StandardPixmap enum");

static gsi::QFlagsClass<QStyle::StandardPixmap > decl_QStyle_StandardPixmap_Enums ("QtWidgets", "QStyle_QFlags_StandardPixmap",
  "@qt\n@brief This class represents the QFlags<QStyle::StandardPixmap> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_StandardPixmap_Enum_in_parent (decl_QStyle_StandardPixmap_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_StandardPixmap_Enum_as_child (decl_QStyle_StandardPixmap_Enum, "StandardPixmap");
static gsi::ClassExt<QStyle> decl_QStyle_StandardPixmap_Enums_as_child (decl_QStyle_StandardPixmap_Enums, "QFlags_StandardPixmap");

}


//  Implementation of the enum wrapper class for QStyle::StyleHint
namespace qt_gsi
{

static gsi::Enum<QStyle::StyleHint> decl_QStyle_StyleHint_Enum ("QtWidgets", "QStyle_StyleHint",
    gsi::enum_const ("SH_EtchDisabledText", QStyle::SH_EtchDisabledText, "@brief Enum constant QStyle::SH_EtchDisabledText") +
    gsi::enum_const ("SH_DitherDisabledText", QStyle::SH_DitherDisabledText, "@brief Enum constant QStyle::SH_DitherDisabledText") +
    gsi::enum_const ("SH_ScrollBar_MiddleClickAbsolutePosition", QStyle::SH_ScrollBar_MiddleClickAbsolutePosition, "@brief Enum constant QStyle::SH_ScrollBar_MiddleClickAbsolutePosition") +
    gsi::enum_const ("SH_ScrollBar_ScrollWhenPointerLeavesControl", QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl, "@brief Enum constant QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl") +
    gsi::enum_const ("SH_TabBar_SelectMouseType", QStyle::SH_TabBar_SelectMouseType, "@brief Enum constant QStyle::SH_TabBar_SelectMouseType") +
    gsi::enum_const ("SH_TabBar_Alignment", QStyle::SH_TabBar_Alignment, "@brief Enum constant QStyle::SH_TabBar_Alignment") +
    gsi::enum_const ("SH_Header_ArrowAlignment", QStyle::SH_Header_ArrowAlignment, "@brief Enum constant QStyle::SH_Header_ArrowAlignment") +
    gsi::enum_const ("SH_Slider_SnapToValue", QStyle::SH_Slider_SnapToValue, "@brief Enum constant QStyle::SH_Slider_SnapToValue") +
    gsi::enum_const ("SH_Slider_SloppyKeyEvents", QStyle::SH_Slider_SloppyKeyEvents, "@brief Enum constant QStyle::SH_Slider_SloppyKeyEvents") +
    gsi::enum_const ("SH_ProgressDialog_CenterCancelButton", QStyle::SH_ProgressDialog_CenterCancelButton, "@brief Enum constant QStyle::SH_ProgressDialog_CenterCancelButton") +
    gsi::enum_const ("SH_ProgressDialog_TextLabelAlignment", QStyle::SH_ProgressDialog_TextLabelAlignment, "@brief Enum constant QStyle::SH_ProgressDialog_TextLabelAlignment") +
    gsi::enum_const ("SH_PrintDialog_RightAlignButtons", QStyle::SH_PrintDialog_RightAlignButtons, "@brief Enum constant QStyle::SH_PrintDialog_RightAlignButtons") +
    gsi::enum_const ("SH_MainWindow_SpaceBelowMenuBar", QStyle::SH_MainWindow_SpaceBelowMenuBar, "@brief Enum constant QStyle::SH_MainWindow_SpaceBelowMenuBar") +
    gsi::enum_const ("SH_FontDialog_SelectAssociatedText", QStyle::SH_FontDialog_SelectAssociatedText, "@brief Enum constant QStyle::SH_FontDialog_SelectAssociatedText") +
    gsi::enum_const ("SH_Menu_AllowActiveAndDisabled", QStyle::SH_Menu_AllowActiveAndDisabled, "@brief Enum constant QStyle::SH_Menu_AllowActiveAndDisabled") +
    gsi::enum_const ("SH_Menu_SpaceActivatesItem", QStyle::SH_Menu_SpaceActivatesItem, "@brief Enum constant QStyle::SH_Menu_SpaceActivatesItem") +
    gsi::enum_const ("SH_Menu_SubMenuPopupDelay", QStyle::SH_Menu_SubMenuPopupDelay, "@brief Enum constant QStyle::SH_Menu_SubMenuPopupDelay") +
    gsi::enum_const ("SH_ScrollView_FrameOnlyAroundContents", QStyle::SH_ScrollView_FrameOnlyAroundContents, "@brief Enum constant QStyle::SH_ScrollView_FrameOnlyAroundContents") +
    gsi::enum_const ("SH_MenuBar_AltKeyNavigation", QStyle::SH_MenuBar_AltKeyNavigation, "@brief Enum constant QStyle::SH_MenuBar_AltKeyNavigation") +
    gsi::enum_const ("SH_ComboBox_ListMouseTracking", QStyle::SH_ComboBox_ListMouseTracking, "@brief Enum constant QStyle::SH_ComboBox_ListMouseTracking") +
    gsi::enum_const ("SH_Menu_MouseTracking", QStyle::SH_Menu_MouseTracking, "@brief Enum constant QStyle::SH_Menu_MouseTracking") +
    gsi::enum_const ("SH_MenuBar_MouseTracking", QStyle::SH_MenuBar_MouseTracking, "@brief Enum constant QStyle::SH_MenuBar_MouseTracking") +
    gsi::enum_const ("SH_ItemView_ChangeHighlightOnFocus", QStyle::SH_ItemView_ChangeHighlightOnFocus, "@brief Enum constant QStyle::SH_ItemView_ChangeHighlightOnFocus") +
    gsi::enum_const ("SH_Widget_ShareActivation", QStyle::SH_Widget_ShareActivation, "@brief Enum constant QStyle::SH_Widget_ShareActivation") +
    gsi::enum_const ("SH_Workspace_FillSpaceOnMaximize", QStyle::SH_Workspace_FillSpaceOnMaximize, "@brief Enum constant QStyle::SH_Workspace_FillSpaceOnMaximize") +
    gsi::enum_const ("SH_ComboBox_Popup", QStyle::SH_ComboBox_Popup, "@brief Enum constant QStyle::SH_ComboBox_Popup") +
    gsi::enum_const ("SH_TitleBar_NoBorder", QStyle::SH_TitleBar_NoBorder, "@brief Enum constant QStyle::SH_TitleBar_NoBorder") +
    gsi::enum_const ("SH_Slider_StopMouseOverSlider", QStyle::SH_Slider_StopMouseOverSlider, "@brief Enum constant QStyle::SH_Slider_StopMouseOverSlider") +
    gsi::enum_const ("SH_BlinkCursorWhenTextSelected", QStyle::SH_BlinkCursorWhenTextSelected, "@brief Enum constant QStyle::SH_BlinkCursorWhenTextSelected") +
    gsi::enum_const ("SH_RichText_FullWidthSelection", QStyle::SH_RichText_FullWidthSelection, "@brief Enum constant QStyle::SH_RichText_FullWidthSelection") +
    gsi::enum_const ("SH_Menu_Scrollable", QStyle::SH_Menu_Scrollable, "@brief Enum constant QStyle::SH_Menu_Scrollable") +
    gsi::enum_const ("SH_GroupBox_TextLabelVerticalAlignment", QStyle::SH_GroupBox_TextLabelVerticalAlignment, "@brief Enum constant QStyle::SH_GroupBox_TextLabelVerticalAlignment") +
    gsi::enum_const ("SH_GroupBox_TextLabelColor", QStyle::SH_GroupBox_TextLabelColor, "@brief Enum constant QStyle::SH_GroupBox_TextLabelColor") +
    gsi::enum_const ("SH_Menu_SloppySubMenus", QStyle::SH_Menu_SloppySubMenus, "@brief Enum constant QStyle::SH_Menu_SloppySubMenus") +
    gsi::enum_const ("SH_Table_GridLineColor", QStyle::SH_Table_GridLineColor, "@brief Enum constant QStyle::SH_Table_GridLineColor") +
    gsi::enum_const ("SH_LineEdit_PasswordCharacter", QStyle::SH_LineEdit_PasswordCharacter, "@brief Enum constant QStyle::SH_LineEdit_PasswordCharacter") +
    gsi::enum_const ("SH_DialogButtons_DefaultButton", QStyle::SH_DialogButtons_DefaultButton, "@brief Enum constant QStyle::SH_DialogButtons_DefaultButton") +
    gsi::enum_const ("SH_ToolBox_SelectedPageTitleBold", QStyle::SH_ToolBox_SelectedPageTitleBold, "@brief Enum constant QStyle::SH_ToolBox_SelectedPageTitleBold") +
    gsi::enum_const ("SH_TabBar_PreferNoArrows", QStyle::SH_TabBar_PreferNoArrows, "@brief Enum constant QStyle::SH_TabBar_PreferNoArrows") +
    gsi::enum_const ("SH_ScrollBar_LeftClickAbsolutePosition", QStyle::SH_ScrollBar_LeftClickAbsolutePosition, "@brief Enum constant QStyle::SH_ScrollBar_LeftClickAbsolutePosition") +
    gsi::enum_const ("SH_ListViewExpand_SelectMouseType", QStyle::SH_ListViewExpand_SelectMouseType, "@brief Enum constant QStyle::SH_ListViewExpand_SelectMouseType") +
    gsi::enum_const ("SH_UnderlineShortcut", QStyle::SH_UnderlineShortcut, "@brief Enum constant QStyle::SH_UnderlineShortcut") +
    gsi::enum_const ("SH_SpinBox_AnimateButton", QStyle::SH_SpinBox_AnimateButton, "@brief Enum constant QStyle::SH_SpinBox_AnimateButton") +
    gsi::enum_const ("SH_SpinBox_KeyPressAutoRepeatRate", QStyle::SH_SpinBox_KeyPressAutoRepeatRate, "@brief Enum constant QStyle::SH_SpinBox_KeyPressAutoRepeatRate") +
    gsi::enum_const ("SH_SpinBox_ClickAutoRepeatRate", QStyle::SH_SpinBox_ClickAutoRepeatRate, "@brief Enum constant QStyle::SH_SpinBox_ClickAutoRepeatRate") +
    gsi::enum_const ("SH_Menu_FillScreenWithScroll", QStyle::SH_Menu_FillScreenWithScroll, "@brief Enum constant QStyle::SH_Menu_FillScreenWithScroll") +
    gsi::enum_const ("SH_ToolTipLabel_Opacity", QStyle::SH_ToolTipLabel_Opacity, "@brief Enum constant QStyle::SH_ToolTipLabel_Opacity") +
    gsi::enum_const ("SH_DrawMenuBarSeparator", QStyle::SH_DrawMenuBarSeparator, "@brief Enum constant QStyle::SH_DrawMenuBarSeparator") +
    gsi::enum_const ("SH_TitleBar_ModifyNotification", QStyle::SH_TitleBar_ModifyNotification, "@brief Enum constant QStyle::SH_TitleBar_ModifyNotification") +
    gsi::enum_const ("SH_Button_FocusPolicy", QStyle::SH_Button_FocusPolicy, "@brief Enum constant QStyle::SH_Button_FocusPolicy") +
    gsi::enum_const ("SH_MessageBox_UseBorderForButtonSpacing", QStyle::SH_MessageBox_UseBorderForButtonSpacing, "@brief Enum constant QStyle::SH_MessageBox_UseBorderForButtonSpacing") +
    gsi::enum_const ("SH_TitleBar_AutoRaise", QStyle::SH_TitleBar_AutoRaise, "@brief Enum constant QStyle::SH_TitleBar_AutoRaise") +
    gsi::enum_const ("SH_ToolButton_PopupDelay", QStyle::SH_ToolButton_PopupDelay, "@brief Enum constant QStyle::SH_ToolButton_PopupDelay") +
    gsi::enum_const ("SH_FocusFrame_Mask", QStyle::SH_FocusFrame_Mask, "@brief Enum constant QStyle::SH_FocusFrame_Mask") +
    gsi::enum_const ("SH_RubberBand_Mask", QStyle::SH_RubberBand_Mask, "@brief Enum constant QStyle::SH_RubberBand_Mask") +
    gsi::enum_const ("SH_WindowFrame_Mask", QStyle::SH_WindowFrame_Mask, "@brief Enum constant QStyle::SH_WindowFrame_Mask") +
    gsi::enum_const ("SH_SpinControls_DisableOnBounds", QStyle::SH_SpinControls_DisableOnBounds, "@brief Enum constant QStyle::SH_SpinControls_DisableOnBounds") +
    gsi::enum_const ("SH_Dial_BackgroundRole", QStyle::SH_Dial_BackgroundRole, "@brief Enum constant QStyle::SH_Dial_BackgroundRole") +
    gsi::enum_const ("SH_ComboBox_LayoutDirection", QStyle::SH_ComboBox_LayoutDirection, "@brief Enum constant QStyle::SH_ComboBox_LayoutDirection") +
    gsi::enum_const ("SH_ItemView_EllipsisLocation", QStyle::SH_ItemView_EllipsisLocation, "@brief Enum constant QStyle::SH_ItemView_EllipsisLocation") +
    gsi::enum_const ("SH_ItemView_ShowDecorationSelected", QStyle::SH_ItemView_ShowDecorationSelected, "@brief Enum constant QStyle::SH_ItemView_ShowDecorationSelected") +
    gsi::enum_const ("SH_ItemView_ActivateItemOnSingleClick", QStyle::SH_ItemView_ActivateItemOnSingleClick, "@brief Enum constant QStyle::SH_ItemView_ActivateItemOnSingleClick") +
    gsi::enum_const ("SH_ScrollBar_ContextMenu", QStyle::SH_ScrollBar_ContextMenu, "@brief Enum constant QStyle::SH_ScrollBar_ContextMenu") +
    gsi::enum_const ("SH_ScrollBar_RollBetweenButtons", QStyle::SH_ScrollBar_RollBetweenButtons, "@brief Enum constant QStyle::SH_ScrollBar_RollBetweenButtons") +
    gsi::enum_const ("SH_Slider_AbsoluteSetButtons", QStyle::SH_Slider_AbsoluteSetButtons, "@brief Enum constant QStyle::SH_Slider_AbsoluteSetButtons") +
    gsi::enum_const ("SH_Slider_PageSetButtons", QStyle::SH_Slider_PageSetButtons, "@brief Enum constant QStyle::SH_Slider_PageSetButtons") +
    gsi::enum_const ("SH_Menu_KeyboardSearch", QStyle::SH_Menu_KeyboardSearch, "@brief Enum constant QStyle::SH_Menu_KeyboardSearch") +
    gsi::enum_const ("SH_TabBar_ElideMode", QStyle::SH_TabBar_ElideMode, "@brief Enum constant QStyle::SH_TabBar_ElideMode") +
    gsi::enum_const ("SH_DialogButtonLayout", QStyle::SH_DialogButtonLayout, "@brief Enum constant QStyle::SH_DialogButtonLayout") +
    gsi::enum_const ("SH_ComboBox_PopupFrameStyle", QStyle::SH_ComboBox_PopupFrameStyle, "@brief Enum constant QStyle::SH_ComboBox_PopupFrameStyle") +
    gsi::enum_const ("SH_MessageBox_TextInteractionFlags", QStyle::SH_MessageBox_TextInteractionFlags, "@brief Enum constant QStyle::SH_MessageBox_TextInteractionFlags") +
    gsi::enum_const ("SH_DialogButtonBox_ButtonsHaveIcons", QStyle::SH_DialogButtonBox_ButtonsHaveIcons, "@brief Enum constant QStyle::SH_DialogButtonBox_ButtonsHaveIcons") +
    gsi::enum_const ("SH_MessageBox_CenterButtons", QStyle::SH_MessageBox_CenterButtons, "@brief Enum constant QStyle::SH_MessageBox_CenterButtons") +
    gsi::enum_const ("SH_Menu_SelectionWrap", QStyle::SH_Menu_SelectionWrap, "@brief Enum constant QStyle::SH_Menu_SelectionWrap") +
    gsi::enum_const ("SH_ItemView_MovementWithoutUpdatingSelection", QStyle::SH_ItemView_MovementWithoutUpdatingSelection, "@brief Enum constant QStyle::SH_ItemView_MovementWithoutUpdatingSelection") +
    gsi::enum_const ("SH_ToolTip_Mask", QStyle::SH_ToolTip_Mask, "@brief Enum constant QStyle::SH_ToolTip_Mask") +
    gsi::enum_const ("SH_FocusFrame_AboveWidget", QStyle::SH_FocusFrame_AboveWidget, "@brief Enum constant QStyle::SH_FocusFrame_AboveWidget") +
    gsi::enum_const ("SH_TextControl_FocusIndicatorTextCharFormat", QStyle::SH_TextControl_FocusIndicatorTextCharFormat, "@brief Enum constant QStyle::SH_TextControl_FocusIndicatorTextCharFormat") +
    gsi::enum_const ("SH_WizardStyle", QStyle::SH_WizardStyle, "@brief Enum constant QStyle::SH_WizardStyle") +
    gsi::enum_const ("SH_ItemView_ArrowKeysNavigateIntoChildren", QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren, "@brief Enum constant QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren") +
    gsi::enum_const ("SH_Menu_Mask", QStyle::SH_Menu_Mask, "@brief Enum constant QStyle::SH_Menu_Mask") +
    gsi::enum_const ("SH_Menu_FlashTriggeredItem", QStyle::SH_Menu_FlashTriggeredItem, "@brief Enum constant QStyle::SH_Menu_FlashTriggeredItem") +
    gsi::enum_const ("SH_Menu_FadeOutOnHide", QStyle::SH_Menu_FadeOutOnHide, "@brief Enum constant QStyle::SH_Menu_FadeOutOnHide") +
    gsi::enum_const ("SH_SpinBox_ClickAutoRepeatThreshold", QStyle::SH_SpinBox_ClickAutoRepeatThreshold, "@brief Enum constant QStyle::SH_SpinBox_ClickAutoRepeatThreshold") +
    gsi::enum_const ("SH_ItemView_PaintAlternatingRowColorsForEmptyArea", QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea, "@brief Enum constant QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea") +
    gsi::enum_const ("SH_FormLayoutWrapPolicy", QStyle::SH_FormLayoutWrapPolicy, "@brief Enum constant QStyle::SH_FormLayoutWrapPolicy") +
    gsi::enum_const ("SH_TabWidget_DefaultTabPosition", QStyle::SH_TabWidget_DefaultTabPosition, "@brief Enum constant QStyle::SH_TabWidget_DefaultTabPosition") +
    gsi::enum_const ("SH_ToolBar_Movable", QStyle::SH_ToolBar_Movable, "@brief Enum constant QStyle::SH_ToolBar_Movable") +
    gsi::enum_const ("SH_FormLayoutFieldGrowthPolicy", QStyle::SH_FormLayoutFieldGrowthPolicy, "@brief Enum constant QStyle::SH_FormLayoutFieldGrowthPolicy") +
    gsi::enum_const ("SH_FormLayoutFormAlignment", QStyle::SH_FormLayoutFormAlignment, "@brief Enum constant QStyle::SH_FormLayoutFormAlignment") +
    gsi::enum_const ("SH_FormLayoutLabelAlignment", QStyle::SH_FormLayoutLabelAlignment, "@brief Enum constant QStyle::SH_FormLayoutLabelAlignment") +
    gsi::enum_const ("SH_ItemView_DrawDelegateFrame", QStyle::SH_ItemView_DrawDelegateFrame, "@brief Enum constant QStyle::SH_ItemView_DrawDelegateFrame") +
    gsi::enum_const ("SH_TabBar_CloseButtonPosition", QStyle::SH_TabBar_CloseButtonPosition, "@brief Enum constant QStyle::SH_TabBar_CloseButtonPosition") +
    gsi::enum_const ("SH_DockWidget_ButtonsHaveFrame", QStyle::SH_DockWidget_ButtonsHaveFrame, "@brief Enum constant QStyle::SH_DockWidget_ButtonsHaveFrame") +
    gsi::enum_const ("SH_ToolButtonStyle", QStyle::SH_ToolButtonStyle, "@brief Enum constant QStyle::SH_ToolButtonStyle") +
    gsi::enum_const ("SH_RequestSoftwareInputPanel", QStyle::SH_RequestSoftwareInputPanel, "@brief Enum constant QStyle::SH_RequestSoftwareInputPanel") +
    gsi::enum_const ("SH_ScrollBar_Transient", QStyle::SH_ScrollBar_Transient, "@brief Enum constant QStyle::SH_ScrollBar_Transient") +
    gsi::enum_const ("SH_Menu_SupportsSections", QStyle::SH_Menu_SupportsSections, "@brief Enum constant QStyle::SH_Menu_SupportsSections") +
    gsi::enum_const ("SH_ToolTip_WakeUpDelay", QStyle::SH_ToolTip_WakeUpDelay, "@brief Enum constant QStyle::SH_ToolTip_WakeUpDelay") +
    gsi::enum_const ("SH_ToolTip_FallAsleepDelay", QStyle::SH_ToolTip_FallAsleepDelay, "@brief Enum constant QStyle::SH_ToolTip_FallAsleepDelay") +
    gsi::enum_const ("SH_Widget_Animate", QStyle::SH_Widget_Animate, "@brief Enum constant QStyle::SH_Widget_Animate") +
    gsi::enum_const ("SH_Splitter_OpaqueResize", QStyle::SH_Splitter_OpaqueResize, "@brief Enum constant QStyle::SH_Splitter_OpaqueResize") +
    gsi::enum_const ("SH_ComboBox_UseNativePopup", QStyle::SH_ComboBox_UseNativePopup, "@brief Enum constant QStyle::SH_ComboBox_UseNativePopup") +
    gsi::enum_const ("SH_LineEdit_PasswordMaskDelay", QStyle::SH_LineEdit_PasswordMaskDelay, "@brief Enum constant QStyle::SH_LineEdit_PasswordMaskDelay") +
    gsi::enum_const ("SH_TabBar_ChangeCurrentDelay", QStyle::SH_TabBar_ChangeCurrentDelay, "@brief Enum constant QStyle::SH_TabBar_ChangeCurrentDelay") +
    gsi::enum_const ("SH_Menu_SubMenuUniDirection", QStyle::SH_Menu_SubMenuUniDirection, "@brief Enum constant QStyle::SH_Menu_SubMenuUniDirection") +
    gsi::enum_const ("SH_Menu_SubMenuUniDirectionFailCount", QStyle::SH_Menu_SubMenuUniDirectionFailCount, "@brief Enum constant QStyle::SH_Menu_SubMenuUniDirectionFailCount") +
    gsi::enum_const ("SH_Menu_SubMenuSloppySelectOtherActions", QStyle::SH_Menu_SubMenuSloppySelectOtherActions, "@brief Enum constant QStyle::SH_Menu_SubMenuSloppySelectOtherActions") +
    gsi::enum_const ("SH_Menu_SubMenuSloppyCloseTimeout", QStyle::SH_Menu_SubMenuSloppyCloseTimeout, "@brief Enum constant QStyle::SH_Menu_SubMenuSloppyCloseTimeout") +
    gsi::enum_const ("SH_Menu_SubMenuResetWhenReenteringParent", QStyle::SH_Menu_SubMenuResetWhenReenteringParent, "@brief Enum constant QStyle::SH_Menu_SubMenuResetWhenReenteringParent") +
    gsi::enum_const ("SH_Menu_SubMenuDontStartSloppyOnLeave", QStyle::SH_Menu_SubMenuDontStartSloppyOnLeave, "@brief Enum constant QStyle::SH_Menu_SubMenuDontStartSloppyOnLeave") +
    gsi::enum_const ("SH_ItemView_ScrollMode", QStyle::SH_ItemView_ScrollMode, "@brief Enum constant QStyle::SH_ItemView_ScrollMode") +
    gsi::enum_const ("SH_TitleBar_ShowToolTipsOnButtons", QStyle::SH_TitleBar_ShowToolTipsOnButtons, "@brief Enum constant QStyle::SH_TitleBar_ShowToolTipsOnButtons") +
    gsi::enum_const ("SH_Widget_Animation_Duration", QStyle::SH_Widget_Animation_Duration, "@brief Enum constant QStyle::SH_Widget_Animation_Duration") +
    gsi::enum_const ("SH_ComboBox_AllowWheelScrolling", QStyle::SH_ComboBox_AllowWheelScrolling, "@brief Enum constant QStyle::SH_ComboBox_AllowWheelScrolling") +
    gsi::enum_const ("SH_SpinBox_ButtonsInsideFrame", QStyle::SH_SpinBox_ButtonsInsideFrame, "@brief Enum constant QStyle::SH_SpinBox_ButtonsInsideFrame") +
    gsi::enum_const ("SH_SpinBox_StepModifier", QStyle::SH_SpinBox_StepModifier, "@brief Enum constant QStyle::SH_SpinBox_StepModifier") +
    gsi::enum_const ("SH_TabBar_AllowWheelScrolling", QStyle::SH_TabBar_AllowWheelScrolling, "@brief Enum constant QStyle::SH_TabBar_AllowWheelScrolling") +
    gsi::enum_const ("SH_CustomBase", QStyle::SH_CustomBase, "@brief Enum constant QStyle::SH_CustomBase"),
  "@qt\n@brief This class represents the QStyle::StyleHint enum");

static gsi::QFlagsClass<QStyle::StyleHint > decl_QStyle_StyleHint_Enums ("QtWidgets", "QStyle_QFlags_StyleHint",
  "@qt\n@brief This class represents the QFlags<QStyle::StyleHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_StyleHint_Enum_in_parent (decl_QStyle_StyleHint_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_StyleHint_Enum_as_child (decl_QStyle_StyleHint_Enum, "StyleHint");
static gsi::ClassExt<QStyle> decl_QStyle_StyleHint_Enums_as_child (decl_QStyle_StyleHint_Enums, "QFlags_StyleHint");

}


//  Implementation of the enum wrapper class for QStyle::SubControl
namespace qt_gsi
{

static gsi::Enum<QStyle::SubControl> decl_QStyle_SubControl_Enum ("QtWidgets", "QStyle_SubControl",
    gsi::enum_const ("SC_None", QStyle::SC_None, "@brief Enum constant QStyle::SC_None") +
    gsi::enum_const ("SC_ScrollBarAddLine", QStyle::SC_ScrollBarAddLine, "@brief Enum constant QStyle::SC_ScrollBarAddLine") +
    gsi::enum_const ("SC_ScrollBarSubLine", QStyle::SC_ScrollBarSubLine, "@brief Enum constant QStyle::SC_ScrollBarSubLine") +
    gsi::enum_const ("SC_ScrollBarAddPage", QStyle::SC_ScrollBarAddPage, "@brief Enum constant QStyle::SC_ScrollBarAddPage") +
    gsi::enum_const ("SC_ScrollBarSubPage", QStyle::SC_ScrollBarSubPage, "@brief Enum constant QStyle::SC_ScrollBarSubPage") +
    gsi::enum_const ("SC_ScrollBarFirst", QStyle::SC_ScrollBarFirst, "@brief Enum constant QStyle::SC_ScrollBarFirst") +
    gsi::enum_const ("SC_ScrollBarLast", QStyle::SC_ScrollBarLast, "@brief Enum constant QStyle::SC_ScrollBarLast") +
    gsi::enum_const ("SC_ScrollBarSlider", QStyle::SC_ScrollBarSlider, "@brief Enum constant QStyle::SC_ScrollBarSlider") +
    gsi::enum_const ("SC_ScrollBarGroove", QStyle::SC_ScrollBarGroove, "@brief Enum constant QStyle::SC_ScrollBarGroove") +
    gsi::enum_const ("SC_SpinBoxUp", QStyle::SC_SpinBoxUp, "@brief Enum constant QStyle::SC_SpinBoxUp") +
    gsi::enum_const ("SC_SpinBoxDown", QStyle::SC_SpinBoxDown, "@brief Enum constant QStyle::SC_SpinBoxDown") +
    gsi::enum_const ("SC_SpinBoxFrame", QStyle::SC_SpinBoxFrame, "@brief Enum constant QStyle::SC_SpinBoxFrame") +
    gsi::enum_const ("SC_SpinBoxEditField", QStyle::SC_SpinBoxEditField, "@brief Enum constant QStyle::SC_SpinBoxEditField") +
    gsi::enum_const ("SC_ComboBoxFrame", QStyle::SC_ComboBoxFrame, "@brief Enum constant QStyle::SC_ComboBoxFrame") +
    gsi::enum_const ("SC_ComboBoxEditField", QStyle::SC_ComboBoxEditField, "@brief Enum constant QStyle::SC_ComboBoxEditField") +
    gsi::enum_const ("SC_ComboBoxArrow", QStyle::SC_ComboBoxArrow, "@brief Enum constant QStyle::SC_ComboBoxArrow") +
    gsi::enum_const ("SC_ComboBoxListBoxPopup", QStyle::SC_ComboBoxListBoxPopup, "@brief Enum constant QStyle::SC_ComboBoxListBoxPopup") +
    gsi::enum_const ("SC_SliderGroove", QStyle::SC_SliderGroove, "@brief Enum constant QStyle::SC_SliderGroove") +
    gsi::enum_const ("SC_SliderHandle", QStyle::SC_SliderHandle, "@brief Enum constant QStyle::SC_SliderHandle") +
    gsi::enum_const ("SC_SliderTickmarks", QStyle::SC_SliderTickmarks, "@brief Enum constant QStyle::SC_SliderTickmarks") +
    gsi::enum_const ("SC_ToolButton", QStyle::SC_ToolButton, "@brief Enum constant QStyle::SC_ToolButton") +
    gsi::enum_const ("SC_ToolButtonMenu", QStyle::SC_ToolButtonMenu, "@brief Enum constant QStyle::SC_ToolButtonMenu") +
    gsi::enum_const ("SC_TitleBarSysMenu", QStyle::SC_TitleBarSysMenu, "@brief Enum constant QStyle::SC_TitleBarSysMenu") +
    gsi::enum_const ("SC_TitleBarMinButton", QStyle::SC_TitleBarMinButton, "@brief Enum constant QStyle::SC_TitleBarMinButton") +
    gsi::enum_const ("SC_TitleBarMaxButton", QStyle::SC_TitleBarMaxButton, "@brief Enum constant QStyle::SC_TitleBarMaxButton") +
    gsi::enum_const ("SC_TitleBarCloseButton", QStyle::SC_TitleBarCloseButton, "@brief Enum constant QStyle::SC_TitleBarCloseButton") +
    gsi::enum_const ("SC_TitleBarNormalButton", QStyle::SC_TitleBarNormalButton, "@brief Enum constant QStyle::SC_TitleBarNormalButton") +
    gsi::enum_const ("SC_TitleBarShadeButton", QStyle::SC_TitleBarShadeButton, "@brief Enum constant QStyle::SC_TitleBarShadeButton") +
    gsi::enum_const ("SC_TitleBarUnshadeButton", QStyle::SC_TitleBarUnshadeButton, "@brief Enum constant QStyle::SC_TitleBarUnshadeButton") +
    gsi::enum_const ("SC_TitleBarContextHelpButton", QStyle::SC_TitleBarContextHelpButton, "@brief Enum constant QStyle::SC_TitleBarContextHelpButton") +
    gsi::enum_const ("SC_TitleBarLabel", QStyle::SC_TitleBarLabel, "@brief Enum constant QStyle::SC_TitleBarLabel") +
    gsi::enum_const ("SC_DialGroove", QStyle::SC_DialGroove, "@brief Enum constant QStyle::SC_DialGroove") +
    gsi::enum_const ("SC_DialHandle", QStyle::SC_DialHandle, "@brief Enum constant QStyle::SC_DialHandle") +
    gsi::enum_const ("SC_DialTickmarks", QStyle::SC_DialTickmarks, "@brief Enum constant QStyle::SC_DialTickmarks") +
    gsi::enum_const ("SC_GroupBoxCheckBox", QStyle::SC_GroupBoxCheckBox, "@brief Enum constant QStyle::SC_GroupBoxCheckBox") +
    gsi::enum_const ("SC_GroupBoxLabel", QStyle::SC_GroupBoxLabel, "@brief Enum constant QStyle::SC_GroupBoxLabel") +
    gsi::enum_const ("SC_GroupBoxContents", QStyle::SC_GroupBoxContents, "@brief Enum constant QStyle::SC_GroupBoxContents") +
    gsi::enum_const ("SC_GroupBoxFrame", QStyle::SC_GroupBoxFrame, "@brief Enum constant QStyle::SC_GroupBoxFrame") +
    gsi::enum_const ("SC_MdiMinButton", QStyle::SC_MdiMinButton, "@brief Enum constant QStyle::SC_MdiMinButton") +
    gsi::enum_const ("SC_MdiNormalButton", QStyle::SC_MdiNormalButton, "@brief Enum constant QStyle::SC_MdiNormalButton") +
    gsi::enum_const ("SC_MdiCloseButton", QStyle::SC_MdiCloseButton, "@brief Enum constant QStyle::SC_MdiCloseButton") +
    gsi::enum_const ("SC_CustomBase", QStyle::SC_CustomBase, "@brief Enum constant QStyle::SC_CustomBase") +
    gsi::enum_const ("SC_All", QStyle::SC_All, "@brief Enum constant QStyle::SC_All"),
  "@qt\n@brief This class represents the QStyle::SubControl enum");

static gsi::QFlagsClass<QStyle::SubControl > decl_QStyle_SubControl_Enums ("QtWidgets", "QStyle_QFlags_SubControl",
  "@qt\n@brief This class represents the QFlags<QStyle::SubControl> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_SubControl_Enum_in_parent (decl_QStyle_SubControl_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_SubControl_Enum_as_child (decl_QStyle_SubControl_Enum, "SubControl");
static gsi::ClassExt<QStyle> decl_QStyle_SubControl_Enums_as_child (decl_QStyle_SubControl_Enums, "QFlags_SubControl");

}


//  Implementation of the enum wrapper class for QStyle::SubElement
namespace qt_gsi
{

static gsi::Enum<QStyle::SubElement> decl_QStyle_SubElement_Enum ("QtWidgets", "QStyle_SubElement",
    gsi::enum_const ("SE_PushButtonContents", QStyle::SE_PushButtonContents, "@brief Enum constant QStyle::SE_PushButtonContents") +
    gsi::enum_const ("SE_PushButtonFocusRect", QStyle::SE_PushButtonFocusRect, "@brief Enum constant QStyle::SE_PushButtonFocusRect") +
    gsi::enum_const ("SE_CheckBoxIndicator", QStyle::SE_CheckBoxIndicator, "@brief Enum constant QStyle::SE_CheckBoxIndicator") +
    gsi::enum_const ("SE_CheckBoxContents", QStyle::SE_CheckBoxContents, "@brief Enum constant QStyle::SE_CheckBoxContents") +
    gsi::enum_const ("SE_CheckBoxFocusRect", QStyle::SE_CheckBoxFocusRect, "@brief Enum constant QStyle::SE_CheckBoxFocusRect") +
    gsi::enum_const ("SE_CheckBoxClickRect", QStyle::SE_CheckBoxClickRect, "@brief Enum constant QStyle::SE_CheckBoxClickRect") +
    gsi::enum_const ("SE_RadioButtonIndicator", QStyle::SE_RadioButtonIndicator, "@brief Enum constant QStyle::SE_RadioButtonIndicator") +
    gsi::enum_const ("SE_RadioButtonContents", QStyle::SE_RadioButtonContents, "@brief Enum constant QStyle::SE_RadioButtonContents") +
    gsi::enum_const ("SE_RadioButtonFocusRect", QStyle::SE_RadioButtonFocusRect, "@brief Enum constant QStyle::SE_RadioButtonFocusRect") +
    gsi::enum_const ("SE_RadioButtonClickRect", QStyle::SE_RadioButtonClickRect, "@brief Enum constant QStyle::SE_RadioButtonClickRect") +
    gsi::enum_const ("SE_ComboBoxFocusRect", QStyle::SE_ComboBoxFocusRect, "@brief Enum constant QStyle::SE_ComboBoxFocusRect") +
    gsi::enum_const ("SE_SliderFocusRect", QStyle::SE_SliderFocusRect, "@brief Enum constant QStyle::SE_SliderFocusRect") +
    gsi::enum_const ("SE_ProgressBarGroove", QStyle::SE_ProgressBarGroove, "@brief Enum constant QStyle::SE_ProgressBarGroove") +
    gsi::enum_const ("SE_ProgressBarContents", QStyle::SE_ProgressBarContents, "@brief Enum constant QStyle::SE_ProgressBarContents") +
    gsi::enum_const ("SE_ProgressBarLabel", QStyle::SE_ProgressBarLabel, "@brief Enum constant QStyle::SE_ProgressBarLabel") +
    gsi::enum_const ("SE_ToolBoxTabContents", QStyle::SE_ToolBoxTabContents, "@brief Enum constant QStyle::SE_ToolBoxTabContents") +
    gsi::enum_const ("SE_HeaderLabel", QStyle::SE_HeaderLabel, "@brief Enum constant QStyle::SE_HeaderLabel") +
    gsi::enum_const ("SE_HeaderArrow", QStyle::SE_HeaderArrow, "@brief Enum constant QStyle::SE_HeaderArrow") +
    gsi::enum_const ("SE_TabWidgetTabBar", QStyle::SE_TabWidgetTabBar, "@brief Enum constant QStyle::SE_TabWidgetTabBar") +
    gsi::enum_const ("SE_TabWidgetTabPane", QStyle::SE_TabWidgetTabPane, "@brief Enum constant QStyle::SE_TabWidgetTabPane") +
    gsi::enum_const ("SE_TabWidgetTabContents", QStyle::SE_TabWidgetTabContents, "@brief Enum constant QStyle::SE_TabWidgetTabContents") +
    gsi::enum_const ("SE_TabWidgetLeftCorner", QStyle::SE_TabWidgetLeftCorner, "@brief Enum constant QStyle::SE_TabWidgetLeftCorner") +
    gsi::enum_const ("SE_TabWidgetRightCorner", QStyle::SE_TabWidgetRightCorner, "@brief Enum constant QStyle::SE_TabWidgetRightCorner") +
    gsi::enum_const ("SE_ItemViewItemCheckIndicator", QStyle::SE_ItemViewItemCheckIndicator, "@brief Enum constant QStyle::SE_ItemViewItemCheckIndicator") +
    gsi::enum_const ("SE_TabBarTearIndicator", QStyle::SE_TabBarTearIndicator, "@brief Enum constant QStyle::SE_TabBarTearIndicator") +
    gsi::enum_const ("SE_TabBarTearIndicatorLeft", QStyle::SE_TabBarTearIndicatorLeft, "@brief Enum constant QStyle::SE_TabBarTearIndicatorLeft") +
    gsi::enum_const ("SE_TreeViewDisclosureItem", QStyle::SE_TreeViewDisclosureItem, "@brief Enum constant QStyle::SE_TreeViewDisclosureItem") +
    gsi::enum_const ("SE_LineEditContents", QStyle::SE_LineEditContents, "@brief Enum constant QStyle::SE_LineEditContents") +
    gsi::enum_const ("SE_FrameContents", QStyle::SE_FrameContents, "@brief Enum constant QStyle::SE_FrameContents") +
    gsi::enum_const ("SE_DockWidgetCloseButton", QStyle::SE_DockWidgetCloseButton, "@brief Enum constant QStyle::SE_DockWidgetCloseButton") +
    gsi::enum_const ("SE_DockWidgetFloatButton", QStyle::SE_DockWidgetFloatButton, "@brief Enum constant QStyle::SE_DockWidgetFloatButton") +
    gsi::enum_const ("SE_DockWidgetTitleBarText", QStyle::SE_DockWidgetTitleBarText, "@brief Enum constant QStyle::SE_DockWidgetTitleBarText") +
    gsi::enum_const ("SE_DockWidgetIcon", QStyle::SE_DockWidgetIcon, "@brief Enum constant QStyle::SE_DockWidgetIcon") +
    gsi::enum_const ("SE_CheckBoxLayoutItem", QStyle::SE_CheckBoxLayoutItem, "@brief Enum constant QStyle::SE_CheckBoxLayoutItem") +
    gsi::enum_const ("SE_ComboBoxLayoutItem", QStyle::SE_ComboBoxLayoutItem, "@brief Enum constant QStyle::SE_ComboBoxLayoutItem") +
    gsi::enum_const ("SE_DateTimeEditLayoutItem", QStyle::SE_DateTimeEditLayoutItem, "@brief Enum constant QStyle::SE_DateTimeEditLayoutItem") +
    gsi::enum_const ("SE_LabelLayoutItem", QStyle::SE_LabelLayoutItem, "@brief Enum constant QStyle::SE_LabelLayoutItem") +
    gsi::enum_const ("SE_ProgressBarLayoutItem", QStyle::SE_ProgressBarLayoutItem, "@brief Enum constant QStyle::SE_ProgressBarLayoutItem") +
    gsi::enum_const ("SE_PushButtonLayoutItem", QStyle::SE_PushButtonLayoutItem, "@brief Enum constant QStyle::SE_PushButtonLayoutItem") +
    gsi::enum_const ("SE_RadioButtonLayoutItem", QStyle::SE_RadioButtonLayoutItem, "@brief Enum constant QStyle::SE_RadioButtonLayoutItem") +
    gsi::enum_const ("SE_SliderLayoutItem", QStyle::SE_SliderLayoutItem, "@brief Enum constant QStyle::SE_SliderLayoutItem") +
    gsi::enum_const ("SE_SpinBoxLayoutItem", QStyle::SE_SpinBoxLayoutItem, "@brief Enum constant QStyle::SE_SpinBoxLayoutItem") +
    gsi::enum_const ("SE_ToolButtonLayoutItem", QStyle::SE_ToolButtonLayoutItem, "@brief Enum constant QStyle::SE_ToolButtonLayoutItem") +
    gsi::enum_const ("SE_FrameLayoutItem", QStyle::SE_FrameLayoutItem, "@brief Enum constant QStyle::SE_FrameLayoutItem") +
    gsi::enum_const ("SE_GroupBoxLayoutItem", QStyle::SE_GroupBoxLayoutItem, "@brief Enum constant QStyle::SE_GroupBoxLayoutItem") +
    gsi::enum_const ("SE_TabWidgetLayoutItem", QStyle::SE_TabWidgetLayoutItem, "@brief Enum constant QStyle::SE_TabWidgetLayoutItem") +
    gsi::enum_const ("SE_ItemViewItemDecoration", QStyle::SE_ItemViewItemDecoration, "@brief Enum constant QStyle::SE_ItemViewItemDecoration") +
    gsi::enum_const ("SE_ItemViewItemText", QStyle::SE_ItemViewItemText, "@brief Enum constant QStyle::SE_ItemViewItemText") +
    gsi::enum_const ("SE_ItemViewItemFocusRect", QStyle::SE_ItemViewItemFocusRect, "@brief Enum constant QStyle::SE_ItemViewItemFocusRect") +
    gsi::enum_const ("SE_TabBarTabLeftButton", QStyle::SE_TabBarTabLeftButton, "@brief Enum constant QStyle::SE_TabBarTabLeftButton") +
    gsi::enum_const ("SE_TabBarTabRightButton", QStyle::SE_TabBarTabRightButton, "@brief Enum constant QStyle::SE_TabBarTabRightButton") +
    gsi::enum_const ("SE_TabBarTabText", QStyle::SE_TabBarTabText, "@brief Enum constant QStyle::SE_TabBarTabText") +
    gsi::enum_const ("SE_ShapedFrameContents", QStyle::SE_ShapedFrameContents, "@brief Enum constant QStyle::SE_ShapedFrameContents") +
    gsi::enum_const ("SE_ToolBarHandle", QStyle::SE_ToolBarHandle, "@brief Enum constant QStyle::SE_ToolBarHandle") +
    gsi::enum_const ("SE_TabBarScrollLeftButton", QStyle::SE_TabBarScrollLeftButton, "@brief Enum constant QStyle::SE_TabBarScrollLeftButton") +
    gsi::enum_const ("SE_TabBarScrollRightButton", QStyle::SE_TabBarScrollRightButton, "@brief Enum constant QStyle::SE_TabBarScrollRightButton") +
    gsi::enum_const ("SE_TabBarTearIndicatorRight", QStyle::SE_TabBarTearIndicatorRight, "@brief Enum constant QStyle::SE_TabBarTearIndicatorRight") +
    gsi::enum_const ("SE_PushButtonBevel", QStyle::SE_PushButtonBevel, "@brief Enum constant QStyle::SE_PushButtonBevel") +
    gsi::enum_const ("SE_CustomBase", QStyle::SE_CustomBase, "@brief Enum constant QStyle::SE_CustomBase"),
  "@qt\n@brief This class represents the QStyle::SubElement enum");

static gsi::QFlagsClass<QStyle::SubElement > decl_QStyle_SubElement_Enums ("QtWidgets", "QStyle_QFlags_SubElement",
  "@qt\n@brief This class represents the QFlags<QStyle::SubElement> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_SubElement_Enum_in_parent (decl_QStyle_SubElement_Enum.defs ());
static gsi::ClassExt<QStyle> decl_QStyle_SubElement_Enum_as_child (decl_QStyle_SubElement_Enum, "SubElement");
static gsi::ClassExt<QStyle> decl_QStyle_SubElement_Enums_as_child (decl_QStyle_SubElement_Enums, "QFlags_SubElement");

}

