/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.wizards;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class InputParentDialog
extends InputDialog {
    private String parentType;

    public InputParentDialog(Shell parentShell, String dialogTitle) {
        super(parentShell, dialogTitle, "Parent prototype name", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return "Empty name";
                }
                String correct = newText.toUpperCase();
                if (newText.compareTo(correct) != 0) {
                    return "Invalid prototype name";
                }
                return null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Label label = new Label(c, 0);
        label.setText("Choose Parent inheritance type");
        String[] values = new String[]{"Shared", "Non Shared", "Shared Expanded", "Non Shared Expanded"};
        this.parentType = values[0];
        Combo combo = new Combo(c, 0);
        combo.setItems(values);
        combo.select(0);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputParentDialog.this.parentType = combo.getText();
            }
        });
        return c;
    }

    public String getParentName() {
        return this.getValue();
    }

    public String getParentType() {
        return this.parentType;
    }
}

