; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=x86_64-apple-macosx10.7 -passes=inferattrs,dse -S %s | FileCheck %s

; Tests for libcalls only available on Darwin platforms.

declare void @memset_pattern4(i8*, i8*, i64)
declare void @memset_pattern8(i8*, i8*, i64)
declare void @memset_pattern16(i8*, i8*, i64)

define void @test_memset_pattern4_const_size(i8* noalias %a, i8* noalias %pattern) {
; CHECK-LABEL: @test_memset_pattern4_const_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern4(i8* [[A]], i8* [[PATTERN:%.*]], i64 17)
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern4(i8* %a, i8* %pattern, i64 17)
  ret void
}

define void @test_memset_pattern4_variable_size(i8* noalias %a, i8* noalias %pattern, i64 %n) {
; CHECK-LABEL: @test_memset_pattern4_variable_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_1:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 1
; CHECK-NEXT:    store i8 0, i8* [[A_GEP_1]], align 1
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern4(i8* [[A]], i8* [[PATTERN:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern4(i8* %a, i8* %pattern, i64 %n)
  ret void
}

define void @test_memset_pattern8_const_size(i8* noalias %a, i8* noalias %pattern) {
; CHECK-LABEL: @test_memset_pattern8_const_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern8(i8* [[A]], i8* [[PATTERN:%.*]], i64 17)
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern8(i8* %a, i8* %pattern, i64 17)
  ret void
}

define void @test_memset_pattern8_variable_size(i8* noalias %a, i8* noalias %pattern, i64 %n) {
; CHECK-LABEL: @test_memset_pattern8_variable_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_1:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 1
; CHECK-NEXT:    store i8 0, i8* [[A_GEP_1]], align 1
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern8(i8* [[A]], i8* [[PATTERN:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern8(i8* %a, i8* %pattern, i64 %n)
  ret void
}

define void @test_memset_pattern16_const_size(i8* noalias %a, i8* noalias %pattern) {
; CHECK-LABEL: @test_memset_pattern16_const_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern16(i8* [[A]], i8* [[PATTERN:%.*]], i64 17)
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern16(i8* %a, i8* %pattern, i64 17)
  ret void
}

define void @test_memset_pattern16_variable_size(i8* noalias %a, i8* noalias %pattern, i64 %n) {
; CHECK-LABEL: @test_memset_pattern16_variable_size(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_GEP_1:%.*]] = getelementptr i8, i8* [[A:%.*]], i32 1
; CHECK-NEXT:    store i8 0, i8* [[A_GEP_1]], align 1
; CHECK-NEXT:    [[A_GEP_17:%.*]] = getelementptr i8, i8* [[A]], i32 17
; CHECK-NEXT:    store i8 1, i8* [[A_GEP_17]], align 1
; CHECK-NEXT:    call void @memset_pattern16(i8* [[A]], i8* [[PATTERN:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  %a.gep.1 = getelementptr i8, i8* %a, i32 1
  store i8 0, i8* %a.gep.1
  %a.gep.17 = getelementptr i8, i8* %a, i32 17
  store i8 1, i8* %a.gep.17
  call void @memset_pattern16(i8* %a, i8* %pattern, i64 %n)
  ret void
}
