/*
 * This file is part of ofono-qt
 *
 * Copyright (C) 2010-2011 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Alexander Kanavin <alex.kanavin@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <QtTest/QtTest>
#include <QtCore/QObject>

#include <ofonovoicecallmanager.h>

#include <QtDebug>


class TestOfonoVoiceCallManager : public QObject
{
    Q_OBJECT

private slots:
    void initTestCase()
    {
	m = new OfonoVoiceCallManager(OfonoModem::ManualSelect, "/phonesim", this);
	QCOMPARE(m->modem()->isValid(), true);	

	if (!m->modem()->powered()) {
  	    m->modem()->setPowered(true);
            QTest::qWait(5000);
        }
        if (!m->modem()->online()) {
  	    m->modem()->setOnline(true);
            QTest::qWait(5000);
        }
	QCOMPARE(m->isValid(), true);
    }

    void testOfonoVoiceCallManager()
    {
        bool success = false;
    	QVERIFY(m->emergencyNumbers().count() > 0);

	QSignalSpy emergencyNumbers(m, SIGNAL(emergencyNumbersChanged(QStringList)));
        QSignalSpy dspy(m, SIGNAL(callAdded(QString, QVariantMap)));
        QSignalSpy hupreg(m,SIGNAL(hangupAllComplete(bool)));
        QSignalSpy tonereg(m,SIGNAL(sendTonesComplete(bool)));
        QSignalSpy hspy(m, SIGNAL(callRemoved(QString)));

        m->modem()->setPowered(false);
        QTest::qWait(5000);
        m->modem()->setPowered(true);
        QTest::qWait(5000);
  	m->modem()->setOnline(true);
        QTest::qWait(5000);

        QCOMPARE(emergencyNumbers.count(), 1);
        QVERIFY(emergencyNumbers.takeFirst().at(0).toStringList().count() > 0);
        //Dial testing
        QDBusObjectPath objectPath = m->dial("123","", success);
        qDebug() << "Please find a call in 'Dialing' state in phonesim window and press 'Active' button";
        QTest::qWait(15000);
        QCOMPARE(objectPath.path().isEmpty(), false);
        QCOMPARE(success, true);
        QCOMPARE(dspy.count(), 1);
        //Tones testing
        QTest::qWait(5000);
        m->sendTones("1234");
        QTest::qWait(5000);
        QCOMPARE(tonereg.count(), 1);
        QCOMPARE(tonereg.takeFirst().at(0).toBool(),true);
        QTest::qWait(5000);
        QStringList calls = m->getCalls();
        QVERIFY(calls.size()>0);
        //hangup testing
        m->hangupAll();
        QTest::qWait(5000);
        QCOMPARE(hupreg.count(), 1);
        QCOMPARE(hupreg.takeFirst().at(0).toBool(),true);
        QCOMPARE(hspy.count(), 1);

    }

    void testoFonoVoiceCallManagerStep2()
    {
        bool success = false;
        // test dial failure and hangup of incoming alerting call
        QSignalSpy hupreg(m,SIGNAL(hangupAllComplete(bool)));
        QSignalSpy dspy(m, SIGNAL(callAdded(QString, QVariantMap)));
        QSignalSpy hspy(m, SIGNAL(callRemoved(QString)));


        QDBusObjectPath objectPath = m->dial("199","", success);
        QTest::qWait(5000);
        QCOMPARE(objectPath.path().isEmpty(), false);
        QCOMPARE(success, false);
        QTest::qWait(10000);
        QCOMPARE(dspy.count(), 1);

        //hangup the alerting call
        m->hangupAll();
        QTest::qWait(5000);
        QCOMPARE(hupreg.count(), 1);
        QCOMPARE(hupreg.takeFirst().at(0).toBool(),true);

        QTest::qWait(10000);
        QCOMPARE(hspy.count(), 1);

    }

    void cleanupTestCase()
    {

    }


private:
    OfonoVoiceCallManager *m;
};

QTEST_MAIN(TestOfonoVoiceCallManager)
#include "test_ofonovoicecallmanager.moc"
