/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QDateTime>

/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassCore
{

class DECLSPEC RecentFilesHandler
{

  public:
  RecentFilesHandler();
  virtual ~RecentFilesHandler();

  int size() const;

  void setMaxItemCount(int count);
  int getMaxItemCount() const;

  void addItem(const QString &file_path);
  void removeItem(const QString &file_path);
  QPair<QDateTime, QString> getItem(const QString &file_path);
  QPair<QDateTime, QString> getItem(QDateTime &date_time);
  QStringList allItemsSortedByTime(bool most_recent_first = true);

  void clear();

  QByteArray makeDataForSettings() const;
  void makeFromSettingsData(const QByteArray &data);


  private:
  QMap<QDateTime, QString> m_filePathsTimeUsed;
  int m_maxItemCount = 10;
};


} // namespace libXpertMassCore
} // namespace MsXpS
