# This script gives the following, which were defined
# in 03pre-initialization.bash, permanent values for the rest of the
# program to use:
#
#     TMPDIR (exported)
#     DO_NOT_INFORM_TO_STDOUT (integer, not exported)
#
# The script sets the following, which carry through to the rest of
# the program:
#
#     V VV
#     now.stamp (file)
#
# The script introduces these state variables for the rest of the program to
# share, modify and use:
#
#     DIST1 MIRROR
#     IS_BACKPORTS (integer)
#
# Other things the script sets are only of local significance and can safely be
# overwritten by other scripts.

# Silence the program's chatter to stdout if stdout is needed
# for formatted output.
declare V='v' VV='-v'
if (($OPT_SUMS)); then
    V=''; VV=''
    # The following variable was initialized by 03pre-initialization.bash.
    # Here, the variable's value is finalized.
    DO_NOT_INFORM_TO_STDOUT=1
fi
readonly V VV DO_NOT_INFORM_TO_STDOUT

# Establish a temporary directory in which the program can keep runtime
# working files.
TMPDIR="/tmp/$NAME.$$" # already exported in 03pre-initialization.bash
readonly TMPDIR
[ -e "$TMPDIR" ] && rm -r$V -- "$TMPDIR"; mkdir -p$V -m 0700 -- "$TMPDIR";
touch -- "$TMPDIR/now.stamp"

# These are shared state variables that carry through to and are modified by
# the various other scripts.
declare DIST1=$DIST MIRROR=$MIRROR_PRIMARY
declare -i IS_BACKPORTS=0
true

