---
name: Bowtie 2
url: http://bowtie-bio.sourceforge.net/bowtie2/
description: >
  Bowtie 2 is an ultrafast and memory-efficient tool for aligning sequencing
  reads to long reference sequences.
---

The Bowtie 2 module parses results generated by
[Bowtie 2](http://bowtie-bio.sourceforge.net/bowtie2/),
an ultrafast and memory-efficient tool for aligning sequencing
reads to long reference sequences.

Please note that the Bowtie 2 logs are difficult to parse as they don't contain
much extra information (such as what the input data was). A typical log looks like this:

```
314537 reads; of these:
  314537 (100.00%) were paired; of these:
    111016 (35.30%) aligned concordantly 0 times
    193300 (61.46%) aligned concordantly exactly 1 time
    10221 (3.25%) aligned concordantly >1 times
    ----
    111016 pairs aligned concordantly 0 times; of these:
      11377 (10.25%) aligned discordantly 1 time
    ----
    99639 pairs aligned 0 times concordantly or discordantly; of these:
      199278 mates make up the pairs; of these:
        112779 (56.59%) aligned 0 times
        85802 (43.06%) aligned exactly 1 time
        697 (0.35%) aligned >1 times
82.07% overall alignment rate
```

Bowtie 2 logs are from `STDERR` - some pipelines (such as [Cluster Flow](http://clusterflow.io))
print the Bowtie 2 command before this, so MultiQC looks to see if this can be recognised in the same
file. If not, it takes the filename as the sample name.

Bowtie 2 is used by other tools too, so if your log file contains the word `bisulfite`, MultiQC will
assume that this is actually Bismark and ignore the Bowtie 2 logs.
