% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-profiles.R
\name{get_profile_of}
\alias{get_profile_of}
\title{Complete a data frame with missing combinations of data}
\usage{
get_profile_of(data, sources, values_fill = NA)
}
\arguments{
\item{data}{A data frame.}

\item{sources}{A named vector or list with the values to expand and get
profile.}

\item{values_fill}{Optionally, a (scalar) value that specifies what each
\code{value} should be filled in with when missing.

This can be a named list if you want to apply different fill values to
different value columns.}
}
\value{
A data frame with the expanded grid of the values passed in
\code{sources} and filled as specified in the \code{fill} argument.
}
\description{
Turns implicit missing values into explicit missing values. This is a wrapper
around \code{\link[tidyr:expand]{expand()}}, \code{\link[dplyr:mutate-joins]{dplyr::full_join()}} and \code{\link[tidyr:replace_na]{replace_na()}} that's useful for
completing missing combinations of data.
}
\examples{
\dontrun{
library(dplyr, warn.conflicts = FALSE)
df <- tibble(
    group = c(1:2, 1),
    item_id = c(1:2, 2),
    item_name = c("a", "b", "b"),
    value1 = 1:3,
    value2 = 4:6
)

to_get_profile <- list(group = c(1, 2, 3), item_id = c(1, 2))

# This will add the combinations of group 3 with the id of the items
df \%>\% get_profile_of(sources = to_get_profile)

# You can also choose to fill in missing values

# This only fill with "Unknown" the NA values of the column item_name
df \%>\% get_profile_of(
    sources = to_get_profile,
    values_fill = list(item_name = "Unknown")
)

# Replace all NAs with "Unkwnon"
df \%>\% get_profile_of(sources = to_get_profile, values_fill = "Unknown")
}
}
\seealso{
\link[tidyr:complete]{complete} \link[tidyr:expand]{expand}
}
\keyword{internal}
