% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsterms.R
\name{brmsterms}
\alias{brmsterms}
\alias{parse_bf}
\alias{brmsterms.default}
\alias{brmsterms.brmsformula}
\alias{brmsterms.mvbrmsformula}
\title{Parse Formulas of \pkg{brms} Models}
\usage{
brmsterms(formula, ...)

\method{brmsterms}{default}(formula, ...)

\method{brmsterms}{brmsformula}(formula, check_response = TRUE, resp_rhs_all = TRUE, ...)

\method{brmsterms}{mvbrmsformula}(formula, ...)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link{brmsformula}}.}

\item{...}{Further arguments passed to or from other methods.}

\item{check_response}{Logical; Indicates whether the left-hand side
of \code{formula} (i.e. response variables and addition arguments)
should be parsed. If \code{FALSE}, \code{formula} may also be one-sided.}

\item{resp_rhs_all}{Logical; Indicates whether to also include response
variables on the right-hand side of formula \code{.$allvars},
where \code{.} represents the output of \code{brmsterms}.}
}
\value{
An object of class \code{brmsterms} or \code{mvbrmsterms}
  (for multivariate models), which is a \code{list} containing all
  required information initially stored in \code{formula}
  in an easier to use format, basically a list of formulas
  (not an abstract syntax tree).
}
\description{
Parse formulas objects for use in \pkg{brms}.
}
\details{
This is the main formula parsing function of \pkg{brms}.
  It should usually not be called directly, but is exported to allow
  package developers making use of the formula syntax implemented
  in \pkg{brms}. As long as no other packages depend on this functions,
  it may be changed without deprecation warnings, when new features make
  this necessary.
}
\seealso{
\code{\link{brm}},
  \code{\link{brmsformula}},
  \code{\link{mvbrmsformula}}
}
