% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_trees.R
\name{trees}
\alias{trees}
\alias{min_n}
\alias{sample_size}
\alias{sample_prop}
\alias{loss_reduction}
\alias{tree_depth}
\alias{prune}
\alias{cost_complexity}
\title{Parameter functions related to tree- and rule-based models.}
\usage{
trees(range = c(1L, 2000L), trans = NULL)

min_n(range = c(2L, 40L), trans = NULL)

sample_size(range = c(unknown(), unknown()), trans = NULL)

sample_prop(range = c(1/10, 1), trans = NULL)

loss_reduction(range = c(-10, 1.5), trans = transform_log10())

tree_depth(range = c(1L, 15L), trans = NULL)

prune(values = c(TRUE, FALSE))

cost_complexity(range = c(-10, -1), trans = transform_log10())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{A vector of possible values (\code{TRUE} or \code{FALSE}).}
}
\description{
These are parameter generating functions that can be used for modeling,
especially in conjunction with the \pkg{parsnip} package.
}
\details{
These functions generate parameters that are useful when the model is
based on trees or rules.
\itemize{
\item \code{trees()}: The number of trees contained in a random forest or boosted
ensemble. In the latter case, this is equal to the number of boosting
iterations. (See \code{parsnip::rand_forest()} and \code{parsnip::boost_tree()}).
\item \code{min_n()}: The minimum number of data points in a node that is required
for the node to be split further. (See \code{parsnip::rand_forest()} and
\code{parsnip::boost_tree()}).
\item \code{sample_size()}: The size of the data set used for modeling within an
iteration of the modeling algorithm, such as stochastic gradient boosting.
(See \code{parsnip::boost_tree()}).
\item \code{sample_prop()}: The same as \code{sample_size()} but as a proportion of the
total sample.
\item \code{loss_reduction()}: The reduction in the loss function required to split
further. (See \code{parsnip::boost_tree()}). This corresponds to \code{gamma} in
\pkg{xgboost}.
\item \code{tree_depth()}: The maximum depth of the tree (i.e. number of splits).
(See \code{parsnip::boost_tree()}).
\item \code{prune()}: A logical for whether a tree or set of rules should be pruned.
\item \code{cost_complexity()}: The cost-complexity parameter in classical CART models.
}
}
\examples{
trees()
min_n()
sample_size()
loss_reduction()
tree_depth()
prune()
cost_complexity()
}
