% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_f.R
\name{dist_f}
\alias{dist_f}
\title{The F Distribution}
\usage{
dist_f(df1, df2, ncp = NULL)
}
\arguments{
\item{df1, df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{ncp}{non-centrality parameter. If omitted the central F is assumed.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a Gamma random variable
with parameters
\code{shape} = \eqn{\alpha} and
\code{rate} = \eqn{\beta}.

\strong{Support}: \eqn{x \in (0, \infty)}

\strong{Mean}: \eqn{\frac{\alpha}{\beta}}

\strong{Variance}: \eqn{\frac{\alpha}{\beta^2}}

\strong{Probability density function (p.m.f)}:

\deqn{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }{
    E(e^(tX)) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }
}
\examples{
dist <- dist_f(df1 = c(1,2,5,10,100), df2 = c(1,1,2,1,100))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Fdist]{stats::FDist}
}
