% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficient-binreg.R
\name{Effbinreg}
\alias{Effbinreg}
\title{Efficient IPCW for binary data}
\usage{
Effbinreg(
  formula,
  data,
  cause = 1,
  time = NULL,
  beta = NULL,
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  cens.model = ~+1,
  se = TRUE,
  kaplan.meier = TRUE,
  cens.code = 0,
  no.opt = FALSE,
  method = "nr",
  augmentation = NULL,
  h = NULL,
  MCaugment = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{beta}{starting values}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{cens.model}{only stratified cox model without covariates}

\item{se}{to compute se's  based on IPCW}

\item{kaplan.meier}{uses Kaplan-Meier for IPCW in contrast to exp(-Baseline)}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{augmentation}{to augment binomial regression}

\item{h}{h for estimating equation}

\item{MCaugment}{iid of h and censoring model}

\item{...}{Additional arguments to lower level funtions}

\item{model}{exp or linear}
}
\description{
Simple version of comp.risk function of timereg for just one time-point thus fitting the model 
\deqn{E(T \leq t | X ) = expit( X^T beta) }
}
\details{
Based on binomial regresion IPCW response estimating equation: 
\deqn{ X  ( \Delta (T \leq t)/G_c(T_i-) - expit( X^T beta)) = 0 }
for IPCW adjusted responses. 

Based on binomial regresion IPCW response estimating equation: 
\deqn{ h(X) X ( \Delta (T \leq t)/G_c(T_i-) - expit( X^T beta)) = 0 }
for IPCW adjusted responses where $h$ is given as an argument together with iid of censoring with h. 
By using appropriately the h argument we can also do the efficient IPCW estimator estimator this works 
the prepsurv and prepcif for survival or competing risks data. In this case also the censoring martingale 
should be given for variance calculation and this also comes out of the prepsurv or prepcif functions. 
(Experimental version at this stage).

Variance is based on  \deqn{ \sum w_i^2 } also with IPCW adjustment, and naive.var is variance 
under known censoring model. 

Censoring model may depend on strata.
}
\author{
Thomas Scheike
}
