#' Compressive strength of concrete mixtures
#'
#' Yeh (2006) describes an aggregated data set for experimental designs used to
#' test the compressive strength of concrete mixtures. The data are used by
#' Kuhn and Johnson (2013).
#'
#'
#' @name concrete
#' @aliases concrete
#' @docType data
#' @return \item{concrete}{a tibble}
#' @keywords datasets
#' @source
#' Yeh I (2006). "Analysis of Strength of Concrete Using Design of Experiments
#' and Neural Networks." *Journal of Materials in Civil Engineering*, 18, 597-604.
#'
#' Kuhn, M., Johnson, K. (2013) *Applied Predictive Modeling*, Springer.
#' @examples
#' data(concrete)
#' str(concrete)
NULL
