% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeNewtonRaphson}
\alias{mxComputeNewtonRaphson}
\alias{MxComputeNewtonRaphson-class}
\title{Optimize parameters using the Newton-Raphson algorithm}
\usage{
mxComputeNewtonRaphson(
  freeSet = NA_character_,
  ...,
  fitfunction = "fitfunction",
  maxIter = 100L,
  tolerance = 1e-12,
  verbose = 0L
)
}
\arguments{
\item{freeSet}{names of matrices containing free variables}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}

\item{maxIter}{maximum number of iterations}

\item{tolerance}{optimization is considered converged when the maximum relative change in fit is less than tolerance}

\item{verbose}{integer. Level of run-time diagnostic output. Set to zero to disable}
}
\description{
This optimizer requires analytic 1st and 2nd derivatives of the
fit function. Box constraints are supported. Parameters can
approach box constraints but will not leave the feasible region
(even by some small epsilon>0). Non-finite fit values are
interpreted as soft feasibility constraints. That is, when a
non-finite fit is encountered, line search is continued after the
step size is multiplied by 10%. Comprehensive diagnostics are
available by increasing the verbose level.
}
\references{
Luenberger, D. G. & Ye, Y. (2008). \emph{Linear and nonlinear programming.} Springer.
}
