% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.do.R
\name{list.rbind}
\alias{list.rbind}
\title{Bind all list elements by row}
\usage{
list.rbind(.data)
}
\arguments{
\item{.data}{\code{list}}
}
\description{
The function binds all list elements by row. Each element of the list is expected
to be an atomic vector, \code{data.frame}, or \code{data.table}. If list elements
are also lists, the result can be a list-valued matrix. In this case,
\code{list.stack} may produce a better result.
}
\examples{
x <- lapply(1:3,function(i) { c(a=i,b=i^2)})
df <- lapply(1:3,function(i) { data.frame(a=i,b=i^2,c=letters[i])})
list.rbind(x)
list.rbind(df)
}
\seealso{
\code{\link{list.cbind}}, \code{\link{list.stack}}
}

