% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinystan-objects.R
\name{as.shinystan}
\alias{as.shinystan}
\alias{is.shinystan}
\alias{as.shinystan,array-method}
\alias{as.shinystan,list-method}
\alias{as.shinystan,mcmc.list-method}
\alias{as.shinystan,stanfit-method}
\alias{as.shinystan,stanreg-method}
\alias{as.shinystan,CmdStanMCMC-method}
\title{Create and test \code{shinystan} objects}
\usage{
as.shinystan(X, ...)

is.shinystan(X)

\S4method{as.shinystan}{array}(
  X,
  model_name = "unnamed model",
  warmup = 0,
  burnin = 0,
  param_dims = list(),
  model_code = NULL,
  note = NULL,
  sampler_params = NULL,
  algorithm = NULL,
  max_treedepth = NULL,
  ...
)

\S4method{as.shinystan}{list}(
  X,
  model_name = "unnamed model",
  warmup = 0,
  burnin = 0,
  param_dims = list(),
  model_code = NULL,
  note = NULL,
  sampler_params = NULL,
  algorithm = NULL,
  max_treedepth = NULL,
  ...
)

\S4method{as.shinystan}{mcmc.list}(
  X,
  model_name = "unnamed model",
  warmup = 0,
  burnin = 0,
  param_dims = list(),
  model_code = NULL,
  note = NULL,
  ...
)

\S4method{as.shinystan}{stanfit}(X, pars, model_name = X@model_name, note = NULL, ...)

\S4method{as.shinystan}{stanreg}(X, ppd = TRUE, seed = 1234, model_name = NULL, note = NULL, ...)

\S4method{as.shinystan}{CmdStanMCMC}(X, pars = NULL, model_name = NULL, note = NULL, ...)
}
\arguments{
\item{X}{For \code{as.shinystan}, an object to be converted to a
\code{shinystan} object. See the Methods section below. For
\code{is.shinystan}, an object to check.}

\item{...}{Arguments passed to the individual methods.}

\item{model_name}{A string giving a name for the model.}

\item{warmup}{The number of iterations to treat as warmup. Should be
\code{0} if warmup iterations are not included in \code{X}.}

\item{burnin}{Deprecated. Use \code{warmup} instead. The \code{burnin}
argument will be removed in a future release.}

\item{param_dims}{Rarely used and never necessary. A named list giving the 
dimensions for all parameters. For scalar parameters use \code{0} as the 
dimension. See Examples.}

\item{model_code}{Optionally, a character string with the code used to run
the model. This can also be added to your \code{shinystan} object later
using the \code{\link[shinystan]{model_code}} function. See 
\code{\link[shinystan]{model_code}} for additional formatting instructions.
After launching the app the code will be viewable in the \strong{Model 
Code} tab. For \code{stanfit} (\pkg{rstan}) and \code{stanreg}
(\pkg{rstanarm}) objects the model code is automatically retrieved from the
object.}

\item{note}{Optionally, text to display on the \strong{Notepad} page in the 
'ShinyStan' GUI (stored in \code{user_model_info} slot of the
\code{shinystan} object).}

\item{sampler_params, algorithm, max_treedepth}{Rarely used and never 
necessary. If using the \code{as.shinystan} method for arrays or lists, 
these arguments can be used to manually provide information that is 
automatically retrieved from a stanfit object when using the 
\code{as.shinystan} method for stanfit objects. If specified, 
\code{sampler_params} must have the same structure as an object returned by
\code{\link[rstan]{get_sampler_params}} (\pkg{rstan}), which is a list of 
matrices, with one matrix per chain. \code{algorithm}, if specified, must 
be either \code{"NUTS"} or \code{"HMC"} (static HMC). If \code{algorithm}
is \code{"NUTS"} then \code{max_treedepth} (an integer indicating the
maximum allowed treedepth when the model was fit) must also be provided.}

\item{pars}{For stanfit objects (\pkg{rstan}), an optional character vector 
specifying which parameters should be included in the \code{shinystan}
object.}

\item{ppd}{For \code{stanreg} objects (\pkg{rstanarm}), \code{ppd} 
(logical) indicates whether to draw from the posterior predictive 
distribution before launching the app. The default is \code{TRUE}, 
although for very large objects it can be convenient to set it to 
\code{FALSE} as drawing from the posterior predictive distribution can be 
time consuming. If \code{ppd} is \code{TRUE} then graphical posterior
predictive checks are available when 'ShinyStan' is launched.}

\item{seed}{Passed to \code{\link[rstanarm]{pp_check}} (\pkg{rstanarm}) if 
\code{ppd} is \code{TRUE}.}
}
\value{
\code{as.shinystan} returns a \code{shinystan} object, which is an
  instance of S4 class \code{"shinystan"}.
  
  \code{is.shinystan} returns \code{TRUE} if the tested object is a
  \code{shinystan} object and \code{FALSE} otherwise.
}
\description{
The \code{as.shinystan} function creates \code{shinystan}
  objects that can be used with \code{\link{launch_shinystan}} and various
  other functions in the \pkg{shinystan} package. \code{as.shinystan} is a
  generic for which the \pkg{shinystan} package provides several methods.
  Currently methods are provided for creating \code{shinystan} objects from
  arrays, lists of matrices, \code{stanfit} objects (\pkg{rstan}),
  \code{stanreg} objects (\pkg{rstanarm}), and \code{mcmc.list} objects
  (\pkg{coda}).
  
  \code{is.shinystan} tests if an object is a \code{shinystan} object.
}
\section{Functions}{
\itemize{
\item \code{as.shinystan,array-method}: Create a \code{shinystan} object from a 3-D
\code{\link{array}} of simulations. The array should have dimensions
corresponding to iterations, chains, and parameters, in that order.

\item \code{as.shinystan,list-method}: Create a \code{shinystan} object from a
\code{\link{list}} of matrices. Each \code{\link{matrix}} (or 2-D array)
should contain the simulations for an individual chain and all of the
matrices should have the same number of iterations (rows) and parameters
(columns). Parameters should have the same names and be in the same order.

\item \code{as.shinystan,mcmc.list-method}: Create a \code{shinystan} object from an 
\code{mcmc.list} object (\pkg{coda}).

\item \code{as.shinystan,stanfit-method}: Create a \code{shinystan} object from a
\code{stanfit} object (\pkg{\link[rstan]{rstan}}). Fewer optional arguments
are available for this method because all important information can be
taken automatically from the \code{stanfit} object.

\item \code{as.shinystan,stanreg-method}: Create a \code{shinystan} object from a
\code{stanreg} object (\pkg{\link[rstanarm]{rstanarm}}).

\item \code{as.shinystan,CmdStanMCMC-method}: Create a \code{shinystan} object from a 
\code{CmdStanMCMC} object (\pkg{cmdstanr}).
}}

\examples{
 
\dontrun{
sso <- as.shinystan(X, ...) # replace ... with optional arguments or omit it
launch_shinystan(sso)
}

\dontrun{   
########################
### list of matrices ###
########################

# Generate some fake data
chain1 <- cbind(beta1 = rnorm(100), beta2 = rnorm(100), sigma = rexp(100))
chain2 <- cbind(beta1 = rnorm(100), beta2 = rnorm(100), sigma = rexp(100))
sso <- as.shinystan(list(chain1, chain2))
launch_shinystan(sso)

# We can also specify some or all of the optional arguments
# note: in order to use param_dims we need to rename 'beta1' and 'beta2'
# to 'beta[1]' and 'beta[2]'
colnames(chain1) <- colnames(chain2) <- c(paste0("beta[",1:2,"]"), "sigma")
sso2 <- as.shinystan(list(chain1, chain2), 
                     model_name = "Example", warmup = 0, 
                     param_dims = list(beta = 2, sigma = 0))
launch_shinystan(sso2)
}

\dontrun{
######################
### stanfit object ###
######################
library("rstan")
fit <- stan_demo("eight_schools")
sso <- as.shinystan(fit, model_name = "example")
}

\dontrun{
######################
### stanreg object ###
######################
library("rstanarm")
example("example_model")
sso <- as.shinystan(example_model)
launch_shinystan(sso)
}

}
\seealso{
\code{\link{launch_shinystan}} to launch the 'ShinyStan' interface 
  using a particular \code{shinystan} object.

\code{\link{drop_parameters}} to remove parameters from a
  \code{shinystan} object.

\code{\link{generate_quantity}} to add a new quantity to a
  \code{shinystan} object.
}
