% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cassettes.R
\name{cassettes}
\alias{cassettes}
\alias{current_cassette}
\alias{cassette_path}
\title{List cassettes, get current cassette, etc.}
\usage{
cassettes(on_disk = TRUE, verb = FALSE)

current_cassette()

cassette_path()
}
\arguments{
\item{on_disk}{(logical) Check for cassettes on disk + cassettes in session
(\code{TRUE}), or check for only cassettes in session (\code{FALSE}). Default: \code{TRUE}}

\item{verb}{(logical) verbose messages}
}
\description{
List cassettes, get current cassette, etc.
}
\details{
\itemize{
\item \code{cassettes()}: returns cassettes found in your R session, you can toggle
whether we pull from those on disk or not
\item \code{current_cassette()}: returns an empty list when no cassettes are in use,
while it returns the current cassette (a \code{Cassette} object) when one is
in use
\item \code{cassette_path()}: just gives you the current directory path where
cassettes will be stored
}
}
\examples{
vcr_configure(dir = tempdir())

# list all cassettes
cassettes()
cassettes(on_disk = FALSE)

# list the currently active cassette
insert_cassette("stuffthings")
current_cassette()
eject_cassette()

cassettes()
cassettes(on_disk = FALSE)

# list the path to cassettes
cassette_path()
vcr_configure(dir = file.path(tempdir(), "foo"))
cassette_path()

vcr_configure_reset()
}
