// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Align;
use crate::Buildable;
use crate::Container;
use crate::DirectionType;
use crate::NotebookTab;
use crate::PackType;
use crate::PositionType;
use crate::ResizeMode;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkNotebook")]
    pub struct Notebook(Object<ffi::GtkNotebook, ffi::GtkNotebookClass>) @extends Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_notebook_get_type(),
    }
}

impl Notebook {
    #[doc(alias = "gtk_notebook_new")]
    pub fn new() -> Notebook {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_notebook_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Notebook`] objects.
    ///
    /// This method returns an instance of [`NotebookBuilder`] which can be used to create [`Notebook`] objects.
    pub fn builder() -> NotebookBuilder {
        NotebookBuilder::default()
    }
}

impl Default for Notebook {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Notebook`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct NotebookBuilder {
    enable_popup: Option<bool>,
    group_name: Option<String>,
    page: Option<i32>,
    scrollable: Option<bool>,
    show_border: Option<bool>,
    show_tabs: Option<bool>,
    tab_pos: Option<PositionType>,
    border_width: Option<u32>,
    child: Option<Widget>,
    resize_mode: Option<ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
}

impl NotebookBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`NotebookBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Notebook`].
    pub fn build(self) -> Notebook {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref enable_popup) = self.enable_popup {
            properties.push(("enable-popup", enable_popup));
        }
        if let Some(ref group_name) = self.group_name {
            properties.push(("group-name", group_name));
        }
        if let Some(ref page) = self.page {
            properties.push(("page", page));
        }
        if let Some(ref scrollable) = self.scrollable {
            properties.push(("scrollable", scrollable));
        }
        if let Some(ref show_border) = self.show_border {
            properties.push(("show-border", show_border));
        }
        if let Some(ref show_tabs) = self.show_tabs {
            properties.push(("show-tabs", show_tabs));
        }
        if let Some(ref tab_pos) = self.tab_pos {
            properties.push(("tab-pos", tab_pos));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        glib::Object::new::<Notebook>(&properties)
            .expect("Failed to create an instance of Notebook")
    }

    pub fn enable_popup(mut self, enable_popup: bool) -> Self {
        self.enable_popup = Some(enable_popup);
        self
    }

    pub fn group_name(mut self, group_name: &str) -> Self {
        self.group_name = Some(group_name.to_string());
        self
    }

    pub fn page(mut self, page: i32) -> Self {
        self.page = Some(page);
        self
    }

    pub fn scrollable(mut self, scrollable: bool) -> Self {
        self.scrollable = Some(scrollable);
        self
    }

    pub fn show_border(mut self, show_border: bool) -> Self {
        self.show_border = Some(show_border);
        self
    }

    pub fn show_tabs(mut self, show_tabs: bool) -> Self {
        self.show_tabs = Some(show_tabs);
        self
    }

    pub fn tab_pos(mut self, tab_pos: PositionType) -> Self {
        self.tab_pos = Some(tab_pos);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_20")))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub const NONE_NOTEBOOK: Option<&Notebook> = None;

pub trait NotebookExt: 'static {
    #[doc(alias = "gtk_notebook_detach_tab")]
    fn detach_tab<P: IsA<Widget>>(&self, child: &P);

    #[doc(alias = "gtk_notebook_get_action_widget")]
    #[doc(alias = "get_action_widget")]
    fn action_widget(&self, pack_type: PackType) -> Option<Widget>;

    #[doc(alias = "gtk_notebook_get_group_name")]
    #[doc(alias = "get_group_name")]
    fn group_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_notebook_get_menu_label")]
    #[doc(alias = "get_menu_label")]
    fn menu_label<P: IsA<Widget>>(&self, child: &P) -> Option<Widget>;

    #[doc(alias = "gtk_notebook_get_menu_label_text")]
    #[doc(alias = "get_menu_label_text")]
    fn menu_label_text<P: IsA<Widget>>(&self, child: &P) -> Option<glib::GString>;

    #[doc(alias = "gtk_notebook_get_scrollable")]
    #[doc(alias = "get_scrollable")]
    fn is_scrollable(&self) -> bool;

    #[doc(alias = "gtk_notebook_get_show_border")]
    #[doc(alias = "get_show_border")]
    fn shows_border(&self) -> bool;

    #[doc(alias = "gtk_notebook_get_show_tabs")]
    #[doc(alias = "get_show_tabs")]
    fn shows_tabs(&self) -> bool;

    #[doc(alias = "gtk_notebook_get_tab_detachable")]
    #[doc(alias = "get_tab_detachable")]
    fn tab_is_detachable<P: IsA<Widget>>(&self, child: &P) -> bool;

    #[doc(alias = "gtk_notebook_get_tab_label")]
    #[doc(alias = "get_tab_label")]
    fn tab_label<P: IsA<Widget>>(&self, child: &P) -> Option<Widget>;

    #[doc(alias = "gtk_notebook_get_tab_label_text")]
    #[doc(alias = "get_tab_label_text")]
    fn tab_label_text<P: IsA<Widget>>(&self, child: &P) -> Option<glib::GString>;

    #[doc(alias = "gtk_notebook_get_tab_pos")]
    #[doc(alias = "get_tab_pos")]
    fn tab_pos(&self) -> PositionType;

    #[doc(alias = "gtk_notebook_get_tab_reorderable")]
    #[doc(alias = "get_tab_reorderable")]
    fn tab_is_reorderable<P: IsA<Widget>>(&self, child: &P) -> bool;

    #[doc(alias = "gtk_notebook_next_page")]
    fn next_page(&self);

    #[doc(alias = "gtk_notebook_popup_disable")]
    fn popup_disable(&self);

    #[doc(alias = "gtk_notebook_popup_enable")]
    fn popup_enable(&self);

    #[doc(alias = "gtk_notebook_prev_page")]
    fn prev_page(&self);

    #[doc(alias = "gtk_notebook_set_action_widget")]
    fn set_action_widget<P: IsA<Widget>>(&self, widget: &P, pack_type: PackType);

    #[doc(alias = "gtk_notebook_set_group_name")]
    fn set_group_name(&self, group_name: Option<&str>);

    #[doc(alias = "gtk_notebook_set_menu_label")]
    fn set_menu_label<P: IsA<Widget>, Q: IsA<Widget>>(&self, child: &P, menu_label: Option<&Q>);

    #[doc(alias = "gtk_notebook_set_menu_label_text")]
    fn set_menu_label_text<P: IsA<Widget>>(&self, child: &P, menu_text: &str);

    #[doc(alias = "gtk_notebook_set_scrollable")]
    fn set_scrollable(&self, scrollable: bool);

    #[doc(alias = "gtk_notebook_set_show_border")]
    fn set_show_border(&self, show_border: bool);

    #[doc(alias = "gtk_notebook_set_show_tabs")]
    fn set_show_tabs(&self, show_tabs: bool);

    #[doc(alias = "gtk_notebook_set_tab_detachable")]
    fn set_tab_detachable<P: IsA<Widget>>(&self, child: &P, detachable: bool);

    #[doc(alias = "gtk_notebook_set_tab_label")]
    fn set_tab_label<P: IsA<Widget>, Q: IsA<Widget>>(&self, child: &P, tab_label: Option<&Q>);

    #[doc(alias = "gtk_notebook_set_tab_label_text")]
    fn set_tab_label_text<P: IsA<Widget>>(&self, child: &P, tab_text: &str);

    #[doc(alias = "gtk_notebook_set_tab_pos")]
    fn set_tab_pos(&self, pos: PositionType);

    #[doc(alias = "gtk_notebook_set_tab_reorderable")]
    fn set_tab_reorderable<P: IsA<Widget>>(&self, child: &P, reorderable: bool);

    #[doc(alias = "enable-popup")]
    fn enables_popup(&self) -> bool;

    #[doc(alias = "enable-popup")]
    fn set_enable_popup(&self, enable_popup: bool);

    fn page(&self) -> i32;

    fn set_page(&self, page: i32);

    #[doc(hidden)]
    fn child_is_detachable<T: IsA<Widget>>(&self, item: &T) -> bool;

    #[doc(hidden)]
    fn set_child_detachable<T: IsA<Widget>>(&self, item: &T, detachable: bool);

    #[doc(hidden)]
    #[doc(alias = "child.menu-label")]
    fn child_menu_label<T: IsA<Widget>>(&self, item: &T) -> Option<glib::GString>;

    #[doc(hidden)]
    #[doc(alias = "child.menu-label")]
    fn set_child_menu_label<T: IsA<Widget>>(&self, item: &T, menu_label: Option<&str>);

    #[doc(hidden)]
    fn child_position<T: IsA<Widget>>(&self, item: &T) -> i32;

    #[doc(hidden)]
    fn set_child_position<T: IsA<Widget>>(&self, item: &T, position: i32);

    #[doc(hidden)]
    fn child_is_reorderable<T: IsA<Widget>>(&self, item: &T) -> bool;

    #[doc(hidden)]
    fn set_child_reorderable<T: IsA<Widget>>(&self, item: &T, reorderable: bool);

    #[doc(hidden)]
    #[doc(alias = "child.tab-expand")]
    fn child_tab_expands<T: IsA<Widget>>(&self, item: &T) -> bool;

    #[doc(hidden)]
    #[doc(alias = "child.tab-expand")]
    fn set_child_tab_expand<T: IsA<Widget>>(&self, item: &T, tab_expand: bool);

    #[doc(hidden)]
    #[doc(alias = "child.tab-fill")]
    fn child_tab_fills<T: IsA<Widget>>(&self, item: &T) -> bool;

    #[doc(hidden)]
    #[doc(alias = "child.tab-fill")]
    fn set_child_tab_fill<T: IsA<Widget>>(&self, item: &T, tab_fill: bool);

    #[doc(hidden)]
    #[doc(alias = "child.tab-label")]
    fn child_tab_label<T: IsA<Widget>>(&self, item: &T) -> Option<glib::GString>;

    #[doc(hidden)]
    #[doc(alias = "child.tab-label")]
    fn set_child_tab_label<T: IsA<Widget>>(&self, item: &T, tab_label: Option<&str>);

    #[doc(alias = "change-current-page")]
    fn connect_change_current_page<F: Fn(&Self, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_change_current_page(&self, object: i32) -> bool;

    #[doc(alias = "create-window")]
    fn connect_create_window<F: Fn(&Self, &Widget, i32, i32) -> Notebook + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "focus-tab")]
    fn connect_focus_tab<F: Fn(&Self, NotebookTab) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_focus_tab(&self, object: NotebookTab) -> bool;

    #[doc(alias = "move-focus-out")]
    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_focus_out(&self, object: DirectionType);

    #[doc(alias = "page-added")]
    fn connect_page_added<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "page-removed")]
    fn connect_page_removed<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "page-reordered")]
    fn connect_page_reordered<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "reorder-tab")]
    fn connect_reorder_tab<F: Fn(&Self, DirectionType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_reorder_tab(&self, object: DirectionType, p0: bool) -> bool;

    #[doc(alias = "select-page")]
    fn connect_select_page<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_page(&self, object: bool) -> bool;

    #[doc(alias = "switch-page")]
    fn connect_switch_page<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-popup")]
    fn connect_enable_popup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "group-name")]
    fn connect_group_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "page")]
    fn connect_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scrollable")]
    fn connect_scrollable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-border")]
    fn connect_show_border_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-tabs")]
    fn connect_show_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tab-pos")]
    fn connect_tab_pos_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Notebook>> NotebookExt for O {
    fn detach_tab<P: IsA<Widget>>(&self, child: &P) {
        unsafe {
            ffi::gtk_notebook_detach_tab(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    fn action_widget(&self, pack_type: PackType) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_action_widget(
                self.as_ref().to_glib_none().0,
                pack_type.into_glib(),
            ))
        }
    }

    fn group_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_group_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn menu_label<P: IsA<Widget>>(&self, child: &P) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_menu_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn menu_label_text<P: IsA<Widget>>(&self, child: &P) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_menu_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_scrollable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_scrollable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_border(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_show_border(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_tabs(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_show_tabs(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_is_detachable<P: IsA<Widget>>(&self, child: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_detachable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_label<P: IsA<Widget>>(&self, child: &P) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_tab_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_label_text<P: IsA<Widget>>(&self, child: &P) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_notebook_get_tab_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_pos(&self) -> PositionType {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_pos(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_is_reorderable<P: IsA<Widget>>(&self, child: &P) -> bool {
        unsafe {
            from_glib(ffi::gtk_notebook_get_tab_reorderable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    fn next_page(&self) {
        unsafe {
            ffi::gtk_notebook_next_page(self.as_ref().to_glib_none().0);
        }
    }

    fn popup_disable(&self) {
        unsafe {
            ffi::gtk_notebook_popup_disable(self.as_ref().to_glib_none().0);
        }
    }

    fn popup_enable(&self) {
        unsafe {
            ffi::gtk_notebook_popup_enable(self.as_ref().to_glib_none().0);
        }
    }

    fn prev_page(&self) {
        unsafe {
            ffi::gtk_notebook_prev_page(self.as_ref().to_glib_none().0);
        }
    }

    fn set_action_widget<P: IsA<Widget>>(&self, widget: &P, pack_type: PackType) {
        unsafe {
            ffi::gtk_notebook_set_action_widget(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                pack_type.into_glib(),
            );
        }
    }

    fn set_group_name(&self, group_name: Option<&str>) {
        unsafe {
            ffi::gtk_notebook_set_group_name(
                self.as_ref().to_glib_none().0,
                group_name.to_glib_none().0,
            );
        }
    }

    fn set_menu_label<P: IsA<Widget>, Q: IsA<Widget>>(&self, child: &P, menu_label: Option<&Q>) {
        unsafe {
            ffi::gtk_notebook_set_menu_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                menu_label.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_menu_label_text<P: IsA<Widget>>(&self, child: &P, menu_text: &str) {
        unsafe {
            ffi::gtk_notebook_set_menu_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                menu_text.to_glib_none().0,
            );
        }
    }

    fn set_scrollable(&self, scrollable: bool) {
        unsafe {
            ffi::gtk_notebook_set_scrollable(
                self.as_ref().to_glib_none().0,
                scrollable.into_glib(),
            );
        }
    }

    fn set_show_border(&self, show_border: bool) {
        unsafe {
            ffi::gtk_notebook_set_show_border(
                self.as_ref().to_glib_none().0,
                show_border.into_glib(),
            );
        }
    }

    fn set_show_tabs(&self, show_tabs: bool) {
        unsafe {
            ffi::gtk_notebook_set_show_tabs(self.as_ref().to_glib_none().0, show_tabs.into_glib());
        }
    }

    fn set_tab_detachable<P: IsA<Widget>>(&self, child: &P, detachable: bool) {
        unsafe {
            ffi::gtk_notebook_set_tab_detachable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                detachable.into_glib(),
            );
        }
    }

    fn set_tab_label<P: IsA<Widget>, Q: IsA<Widget>>(&self, child: &P, tab_label: Option<&Q>) {
        unsafe {
            ffi::gtk_notebook_set_tab_label(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                tab_label.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_tab_label_text<P: IsA<Widget>>(&self, child: &P, tab_text: &str) {
        unsafe {
            ffi::gtk_notebook_set_tab_label_text(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                tab_text.to_glib_none().0,
            );
        }
    }

    fn set_tab_pos(&self, pos: PositionType) {
        unsafe {
            ffi::gtk_notebook_set_tab_pos(self.as_ref().to_glib_none().0, pos.into_glib());
        }
    }

    fn set_tab_reorderable<P: IsA<Widget>>(&self, child: &P, reorderable: bool) {
        unsafe {
            ffi::gtk_notebook_set_tab_reorderable(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    fn enables_popup(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-popup\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `enable-popup` getter")
        }
    }

    fn set_enable_popup(&self, enable_popup: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"enable-popup\0".as_ptr() as *const _,
                enable_popup.to_value().to_glib_none().0,
            );
        }
    }

    fn page(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"page\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `page` getter")
        }
    }

    fn set_page(&self, page: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"page\0".as_ptr() as *const _,
                page.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_is_detachable<T: IsA<Widget>>(&self, item: &T) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"detachable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `detachable` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_detachable<T: IsA<Widget>>(&self, item: &T, detachable: bool) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"detachable\0".as_ptr() as *const _,
                detachable.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_menu_label<T: IsA<Widget>>(&self, item: &T) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"menu-label\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `menu-label` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_menu_label<T: IsA<Widget>>(&self, item: &T, menu_label: Option<&str>) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"menu-label\0".as_ptr() as *const _,
                menu_label.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_position<T: IsA<Widget>>(&self, item: &T) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"position\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `position` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_position<T: IsA<Widget>>(&self, item: &T, position: i32) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"position\0".as_ptr() as *const _,
                position.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_is_reorderable<T: IsA<Widget>>(&self, item: &T) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"reorderable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `reorderable` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_reorderable<T: IsA<Widget>>(&self, item: &T, reorderable: bool) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"reorderable\0".as_ptr() as *const _,
                reorderable.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_tab_expands<T: IsA<Widget>>(&self, item: &T) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-expand\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tab-expand` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_tab_expand<T: IsA<Widget>>(&self, item: &T, tab_expand: bool) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-expand\0".as_ptr() as *const _,
                tab_expand.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_tab_fills<T: IsA<Widget>>(&self, item: &T) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-fill\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tab-fill` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_tab_fill<T: IsA<Widget>>(&self, item: &T, tab_fill: bool) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-fill\0".as_ptr() as *const _,
                tab_fill.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(hidden)]
    fn child_tab_label<T: IsA<Widget>>(&self, item: &T) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            crate::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-label\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tab-label` getter")
        }
    }

    #[doc(hidden)]
    fn set_child_tab_label<T: IsA<Widget>>(&self, item: &T, tab_label: Option<&str>) {
        unsafe {
            crate::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut crate::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"tab-label\0".as_ptr() as *const _,
                tab_label.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_change_current_page<F: Fn(&Self, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn change_current_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, i32) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref(), object).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-current-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    change_current_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_current_page(&self, object: i32) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("change-current-page", &[&object])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_change_current_page`")
    }

    fn connect_create_window<F: Fn(&Self, &Widget, i32, i32) -> Notebook + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_window_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, i32, i32) -> Notebook + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            page: *mut ffi::GtkWidget,
            x: libc::c_int,
            y: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::GtkNotebook {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(page),
                x,
                y,
            ) /*Not checked*/
            .to_glib_none()
            .0
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-window\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    create_window_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_focus_tab<F: Fn(&Self, NotebookTab) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn focus_tab_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, NotebookTab) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkNotebookTab,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"focus-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    focus_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_focus_tab(&self, object: NotebookTab) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("focus-tab", &[&object])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_focus_tab`")
    }

    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_out_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus-out\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_out_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus_out(&self, object: DirectionType) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("move-focus-out", &[&object])
                .unwrap()
        };
    }

    fn connect_page_added<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn page_added_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-added\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_added_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_page_removed<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn page_removed_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-removed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_removed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_page_reordered<F: Fn(&Self, &Widget, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn page_reordered_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            child: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(child),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-reordered\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_reordered_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_reorder_tab<F: Fn(&Self, DirectionType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn reorder_tab_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, DirectionType, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: ffi::GtkDirectionType,
            p0: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
                from_glib(p0),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"reorder-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    reorder_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_reorder_tab(&self, object: DirectionType, p0: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("reorder-tab", &[&object, &p0])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_reorder_tab`")
    }

    fn connect_select_page<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            object: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_page(&self, object: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut glib::gobject_ffi::GObject)
                .emit_by_name("select-page", &[&object])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_select_page`")
    }

    fn connect_switch_page<F: Fn(&Self, &Widget, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn switch_page_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P, &Widget, u32) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            page: *mut ffi::GtkWidget,
            page_num: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Notebook::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(page),
                page_num,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"switch-page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    switch_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_popup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_popup_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_group_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_group_name_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::group-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_group_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::page\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_page_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scrollable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scrollable_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scrollable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scrollable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_border_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_border_trampoline<
            P: IsA<Notebook>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-border\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_border_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_tabs_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tab_pos_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_pos_trampoline<P: IsA<Notebook>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkNotebook,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Notebook::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tab-pos\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tab_pos_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Notebook {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Notebook")
    }
}
