use super::Command;
use clap::{Args, ValueEnum};
use rdftk_core::error::Error;
use std::process::ExitCode;

// ------------------------------------------------------------------------------------------------
// Public Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Public Types
// ------------------------------------------------------------------------------------------------

#[derive(Args, Debug)]
pub(crate) struct NamespaceCmd {
    #[arg(short = 'n', long)]
    #[arg(value_enum)]
    named: KnownNamespace,

    /// Input SDML file name to read from, or '-' to read from stdin
    #[arg(short, long)]
    #[clap(value_parser, default_value = "-", conflicts_with = "named")]
    input: clio::Input,
}

#[derive(ValueEnum, Copy, Clone, Debug, PartialEq, Eq, Hash)]
pub(crate) enum KnownNamespace {
    Owl,
    Rdf,
    RdfSchema,
    Skos,
    Xsd,
}

// ------------------------------------------------------------------------------------------------
// Public Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Types
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Implementations
// ------------------------------------------------------------------------------------------------

impl Command for NamespaceCmd {
    fn execute(self) -> Result<ExitCode, Error> {
        todo!()
    }
}

// ------------------------------------------------------------------------------------------------
// Private Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Modules
// ------------------------------------------------------------------------------------------------
