# /*##########################################################################
#
# Copyright (c) 2017-2021 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/
"""This package provides classes that describes :class:`.SceneWidget` content.
"""

__authors__ = ["T. Vincent"]
__license__ = "MIT"
__date__ = "15/11/2017"


from .core import DataItem3D, Item3D, GroupItem, GroupWithAxesItem  # noqa
from .core import ItemChangedType, Item3DChangedType  # noqa
from .mixins import (ColormapMixIn, ComplexMixIn, InterpolationMixIn,  # noqa
                     PlaneMixIn, SymbolMixIn)  # noqa
from .clipplane import ClipPlane  # noqa
from .image import ImageData, ImageRgba, HeightMapData, HeightMapRGBA  # noqa
from .mesh import Mesh, ColormapMesh, Box, Cylinder, Hexagon  # noqa
from .scatter import Scatter2D, Scatter3D  # noqa
from .volume import ComplexField3D, ScalarField3D  # noqa
