// Copyright 2016 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.20.1
// source: trillian_log_api.proto

package trillian

import (
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ChargeTo describes the user(s) associated with the request whose quota should
// be checked and charged.
type ChargeTo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// user is a list of personality-defined strings.
	// Trillian will treat them as /User/%{user}/... keys when checking and
	// charging quota.
	// If one or more of the specified users has insufficient quota, the
	// request will be denied.
	//
	// As an example, a Certificate Transparency frontend might set the following
	// user strings when sending a QueueLeaf request to the Trillian log:
	//   - The requesting IP address.
	//     This would limit the number of requests per IP.
	//   - The "intermediate-<hash>" for each of the intermediate certificates in
	//     the submitted chain.
	//     This would have the effect of limiting the rate of submissions under
	//     a given intermediate/root.
	User []string `protobuf:"bytes,1,rep,name=user,proto3" json:"user,omitempty"`
}

func (x *ChargeTo) Reset() {
	*x = ChargeTo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChargeTo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChargeTo) ProtoMessage() {}

func (x *ChargeTo) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChargeTo.ProtoReflect.Descriptor instead.
func (*ChargeTo) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{0}
}

func (x *ChargeTo) GetUser() []string {
	if x != nil {
		return x.User
	}
	return nil
}

type QueueLeafRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaf     *LogLeaf  `protobuf:"bytes,2,opt,name=leaf,proto3" json:"leaf,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,3,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *QueueLeafRequest) Reset() {
	*x = QueueLeafRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeafRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeafRequest) ProtoMessage() {}

func (x *QueueLeafRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeafRequest.ProtoReflect.Descriptor instead.
func (*QueueLeafRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{1}
}

func (x *QueueLeafRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *QueueLeafRequest) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *QueueLeafRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type QueueLeafResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// queued_leaf describes the leaf which is or will be incorporated into the
	// Log.  If the submitted leaf was already present in the Log (as indicated by
	// its leaf identity hash), then the returned leaf will be the pre-existing
	// leaf entry rather than the submitted leaf.
	QueuedLeaf *QueuedLogLeaf `protobuf:"bytes,2,opt,name=queued_leaf,json=queuedLeaf,proto3" json:"queued_leaf,omitempty"`
}

func (x *QueueLeafResponse) Reset() {
	*x = QueueLeafResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeafResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeafResponse) ProtoMessage() {}

func (x *QueueLeafResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeafResponse.ProtoReflect.Descriptor instead.
func (*QueueLeafResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{2}
}

func (x *QueueLeafResponse) GetQueuedLeaf() *QueuedLogLeaf {
	if x != nil {
		return x.QueuedLeaf
	}
	return nil
}

type GetInclusionProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId     int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	LeafIndex int64     `protobuf:"varint,2,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	TreeSize  int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	ChargeTo  *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetInclusionProofRequest) Reset() {
	*x = GetInclusionProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofRequest) ProtoMessage() {}

func (x *GetInclusionProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofRequest.ProtoReflect.Descriptor instead.
func (*GetInclusionProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{3}
}

func (x *GetInclusionProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetInclusionProofRequest) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *GetInclusionProofRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetInclusionProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetInclusionProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The proof field may be empty if the requested tree_size was larger
	// than that available at the server (e.g. because there is skew between
	// server instances, and an earlier client request was processed by a
	// more up-to-date instance).  In this case, the signed_log_root
	// field will indicate the tree size that the server is aware of, and
	// the proof field will be empty.
	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetInclusionProofResponse) Reset() {
	*x = GetInclusionProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofResponse) ProtoMessage() {}

func (x *GetInclusionProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofResponse.ProtoReflect.Descriptor instead.
func (*GetInclusionProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{4}
}

func (x *GetInclusionProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetInclusionProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetInclusionProofByHashRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId int64 `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// The leaf hash field provides the Merkle tree hash of the leaf entry
	// to be retrieved.
	LeafHash        []byte    `protobuf:"bytes,2,opt,name=leaf_hash,json=leafHash,proto3" json:"leaf_hash,omitempty"`
	TreeSize        int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	OrderBySequence bool      `protobuf:"varint,4,opt,name=order_by_sequence,json=orderBySequence,proto3" json:"order_by_sequence,omitempty"`
	ChargeTo        *ChargeTo `protobuf:"bytes,5,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetInclusionProofByHashRequest) Reset() {
	*x = GetInclusionProofByHashRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofByHashRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofByHashRequest) ProtoMessage() {}

func (x *GetInclusionProofByHashRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofByHashRequest.ProtoReflect.Descriptor instead.
func (*GetInclusionProofByHashRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{5}
}

func (x *GetInclusionProofByHashRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetInclusionProofByHashRequest) GetLeafHash() []byte {
	if x != nil {
		return x.LeafHash
	}
	return nil
}

func (x *GetInclusionProofByHashRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetInclusionProofByHashRequest) GetOrderBySequence() bool {
	if x != nil {
		return x.OrderBySequence
	}
	return false
}

func (x *GetInclusionProofByHashRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetInclusionProofByHashResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logs can potentially contain leaves with duplicate hashes so it's possible
	// for this to return multiple proofs.  If the leaf index for a particular
	// instance of the requested Merkle leaf hash is beyond the requested tree
	// size, the corresponding proof entry will be missing.
	Proof         []*Proof       `protobuf:"bytes,2,rep,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetInclusionProofByHashResponse) Reset() {
	*x = GetInclusionProofByHashResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofByHashResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofByHashResponse) ProtoMessage() {}

func (x *GetInclusionProofByHashResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofByHashResponse.ProtoReflect.Descriptor instead.
func (*GetInclusionProofByHashResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{6}
}

func (x *GetInclusionProofByHashResponse) GetProof() []*Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetInclusionProofByHashResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetConsistencyProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId          int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	FirstTreeSize  int64     `protobuf:"varint,2,opt,name=first_tree_size,json=firstTreeSize,proto3" json:"first_tree_size,omitempty"`
	SecondTreeSize int64     `protobuf:"varint,3,opt,name=second_tree_size,json=secondTreeSize,proto3" json:"second_tree_size,omitempty"`
	ChargeTo       *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetConsistencyProofRequest) Reset() {
	*x = GetConsistencyProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsistencyProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsistencyProofRequest) ProtoMessage() {}

func (x *GetConsistencyProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsistencyProofRequest.ProtoReflect.Descriptor instead.
func (*GetConsistencyProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{7}
}

func (x *GetConsistencyProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetFirstTreeSize() int64 {
	if x != nil {
		return x.FirstTreeSize
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetSecondTreeSize() int64 {
	if x != nil {
		return x.SecondTreeSize
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetConsistencyProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The proof field may be empty if the requested tree_size was larger
	// than that available at the server (e.g. because there is skew between
	// server instances, and an earlier client request was processed by a
	// more up-to-date instance).  In this case, the signed_log_root
	// field will indicate the tree size that the server is aware of, and
	// the proof field will be empty.
	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetConsistencyProofResponse) Reset() {
	*x = GetConsistencyProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsistencyProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsistencyProofResponse) ProtoMessage() {}

func (x *GetConsistencyProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsistencyProofResponse.ProtoReflect.Descriptor instead.
func (*GetConsistencyProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetConsistencyProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetConsistencyProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetLatestSignedLogRootRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,2,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
	// If first_tree_size is non-zero, the response will include a consistency
	// proof between first_tree_size and the new tree size (if not smaller).
	FirstTreeSize int64 `protobuf:"varint,3,opt,name=first_tree_size,json=firstTreeSize,proto3" json:"first_tree_size,omitempty"`
}

func (x *GetLatestSignedLogRootRequest) Reset() {
	*x = GetLatestSignedLogRootRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestSignedLogRootRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestSignedLogRootRequest) ProtoMessage() {}

func (x *GetLatestSignedLogRootRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestSignedLogRootRequest.ProtoReflect.Descriptor instead.
func (*GetLatestSignedLogRootRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetLatestSignedLogRootRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLatestSignedLogRootRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

func (x *GetLatestSignedLogRootRequest) GetFirstTreeSize() int64 {
	if x != nil {
		return x.FirstTreeSize
	}
	return 0
}

type GetLatestSignedLogRootResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SignedLogRoot *SignedLogRoot `protobuf:"bytes,2,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
	// proof is filled in with a consistency proof if first_tree_size in
	// GetLatestSignedLogRootRequest is non-zero (and within the tree size
	// available at the server).
	Proof *Proof `protobuf:"bytes,3,opt,name=proof,proto3" json:"proof,omitempty"`
}

func (x *GetLatestSignedLogRootResponse) Reset() {
	*x = GetLatestSignedLogRootResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestSignedLogRootResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestSignedLogRootResponse) ProtoMessage() {}

func (x *GetLatestSignedLogRootResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestSignedLogRootResponse.ProtoReflect.Descriptor instead.
func (*GetLatestSignedLogRootResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{10}
}

func (x *GetLatestSignedLogRootResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

func (x *GetLatestSignedLogRootResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

type GetEntryAndProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId     int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	LeafIndex int64     `protobuf:"varint,2,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	TreeSize  int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	ChargeTo  *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetEntryAndProofRequest) Reset() {
	*x = GetEntryAndProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryAndProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryAndProofRequest) ProtoMessage() {}

func (x *GetEntryAndProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryAndProofRequest.ProtoReflect.Descriptor instead.
func (*GetEntryAndProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{11}
}

func (x *GetEntryAndProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetEntryAndProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	Leaf          *LogLeaf       `protobuf:"bytes,3,opt,name=leaf,proto3" json:"leaf,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,4,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetEntryAndProofResponse) Reset() {
	*x = GetEntryAndProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryAndProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryAndProofResponse) ProtoMessage() {}

func (x *GetEntryAndProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryAndProofResponse.ProtoReflect.Descriptor instead.
func (*GetEntryAndProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{12}
}

func (x *GetEntryAndProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetEntryAndProofResponse) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *GetEntryAndProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type InitLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,2,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *InitLogRequest) Reset() {
	*x = InitLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitLogRequest) ProtoMessage() {}

func (x *InitLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitLogRequest.ProtoReflect.Descriptor instead.
func (*InitLogRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{13}
}

func (x *InitLogRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *InitLogRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type InitLogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Created *SignedLogRoot `protobuf:"bytes,1,opt,name=created,proto3" json:"created,omitempty"`
}

func (x *InitLogResponse) Reset() {
	*x = InitLogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitLogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitLogResponse) ProtoMessage() {}

func (x *InitLogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitLogResponse.ProtoReflect.Descriptor instead.
func (*InitLogResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{14}
}

func (x *InitLogResponse) GetCreated() *SignedLogRoot {
	if x != nil {
		return x.Created
	}
	return nil
}

type AddSequencedLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64      `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaves   []*LogLeaf `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	ChargeTo *ChargeTo  `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *AddSequencedLeavesRequest) Reset() {
	*x = AddSequencedLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeavesRequest) ProtoMessage() {}

func (x *AddSequencedLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeavesRequest.ProtoReflect.Descriptor instead.
func (*AddSequencedLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{15}
}

func (x *AddSequencedLeavesRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *AddSequencedLeavesRequest) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *AddSequencedLeavesRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type AddSequencedLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Same number and order as in the corresponding request.
	Results []*QueuedLogLeaf `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *AddSequencedLeavesResponse) Reset() {
	*x = AddSequencedLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeavesResponse) ProtoMessage() {}

func (x *AddSequencedLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeavesResponse.ProtoReflect.Descriptor instead.
func (*AddSequencedLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{16}
}

func (x *AddSequencedLeavesResponse) GetResults() []*QueuedLogLeaf {
	if x != nil {
		return x.Results
	}
	return nil
}

type GetLeavesByRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId      int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	StartIndex int64     `protobuf:"varint,2,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	Count      int64     `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
	ChargeTo   *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetLeavesByRangeRequest) Reset() {
	*x = GetLeavesByRangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByRangeRequest) ProtoMessage() {}

func (x *GetLeavesByRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByRangeRequest.ProtoReflect.Descriptor instead.
func (*GetLeavesByRangeRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{17}
}

func (x *GetLeavesByRangeRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetLeavesByRangeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned log leaves starting from the `start_index` of the request, in
	// order. There may be fewer than `request.count` leaves returned, if the
	// requested range extended beyond the size of the tree or if the server opted
	// to return fewer leaves than requested.
	Leaves        []*LogLeaf     `protobuf:"bytes,1,rep,name=leaves,proto3" json:"leaves,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,2,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetLeavesByRangeResponse) Reset() {
	*x = GetLeavesByRangeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByRangeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByRangeResponse) ProtoMessage() {}

func (x *GetLeavesByRangeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByRangeResponse.ProtoReflect.Descriptor instead.
func (*GetLeavesByRangeResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{18}
}

func (x *GetLeavesByRangeResponse) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *GetLeavesByRangeResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

// QueuedLogLeaf provides the result of submitting an entry to the log.
// TODO(pavelkalinnikov): Consider renaming it to AddLogLeafResult or the like.
type QueuedLogLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The leaf as it was stored by Trillian. Empty unless `status.code` is:
	//   - `google.rpc.OK`: the `leaf` data is the same as in the request.
	//   - `google.rpc.ALREADY_EXISTS` or 'google.rpc.FAILED_PRECONDITION`: the
	//     `leaf` is the conflicting one already in the log.
	Leaf *LogLeaf `protobuf:"bytes,1,opt,name=leaf,proto3" json:"leaf,omitempty"`
	// The status of adding the leaf.
	//   - `google.rpc.OK`: successfully added.
	//   - `google.rpc.ALREADY_EXISTS`: the leaf is a duplicate of an already
	//     existing one. Either `leaf_identity_hash` is the same in the `LOG`
	//     mode, or `leaf_index` in the `PREORDERED_LOG`.
	//   - `google.rpc.FAILED_PRECONDITION`: A conflicting entry is already
	//     present in the log, e.g., same `leaf_index` but different `leaf_data`.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *QueuedLogLeaf) Reset() {
	*x = QueuedLogLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueuedLogLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueuedLogLeaf) ProtoMessage() {}

func (x *QueuedLogLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueuedLogLeaf.ProtoReflect.Descriptor instead.
func (*QueuedLogLeaf) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{19}
}

func (x *QueuedLogLeaf) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *QueuedLogLeaf) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// LogLeaf describes a leaf in the Log's Merkle tree, corresponding to a single log entry.
// Each leaf has a unique leaf index in the scope of this tree.  Clients submitting new
// leaf entries should only set the following fields:
//   - leaf_value
//   - extra_data (optionally)
//   - leaf_identity_hash (optionally)
//   - leaf_index (iff the log is a PREORDERED_LOG)
type LogLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// merkle_leaf_hash holds the Merkle leaf hash over leaf_value.  This is
	// calculated by the Trillian server when leaves are added to the tree, using
	// the defined hashing algorithm and strategy for the tree; as such, the client
	// does not need to set it on leaf submissions.
	MerkleLeafHash []byte `protobuf:"bytes,1,opt,name=merkle_leaf_hash,json=merkleLeafHash,proto3" json:"merkle_leaf_hash,omitempty"`
	// leaf_value holds the data that forms the value of the Merkle tree leaf.
	// The client should set this field on all leaf submissions, and is
	// responsible for ensuring its validity (the Trillian server treats it as an
	// opaque blob).
	LeafValue []byte `protobuf:"bytes,2,opt,name=leaf_value,json=leafValue,proto3" json:"leaf_value,omitempty"`
	// extra_data holds additional data associated with the Merkle tree leaf.
	// The client may set this data on leaf submissions, and the Trillian server
	// will return it on subsequent read operations. However, the contents of
	// this field are not covered by and do not affect the Merkle tree hash
	// calculations.
	ExtraData []byte `protobuf:"bytes,3,opt,name=extra_data,json=extraData,proto3" json:"extra_data,omitempty"`
	// leaf_index indicates the index of this leaf in the Merkle tree.
	// This field is returned on all read operations, but should only be
	// set for leaf submissions in PREORDERED_LOG mode (for a normal log
	// the leaf index is assigned by Trillian when the submitted leaf is
	// integrated into the Merkle tree).
	LeafIndex int64 `protobuf:"varint,4,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	// leaf_identity_hash provides a hash value that indicates the client's
	// concept of which leaf entries should be considered identical.
	//
	// This mechanism allows the client personality to indicate that two leaves
	// should be considered "duplicates" even though their `leaf_value`s differ.
	//
	// If this is not set on leaf submissions, the Trillian server will take its
	// value to be the same as merkle_leaf_hash (and thus only leaves with
	// identical leaf_value contents will be considered identical).
	//
	// For example, in Certificate Transparency each certificate submission is
	// associated with a submission timestamp, but subsequent submissions of the
	// same certificate should be considered identical.  This is achieved
	// by setting the leaf identity hash to a hash over (just) the certificate,
	// whereas the Merkle leaf hash encompasses both the certificate and its
	// submission time -- allowing duplicate certificates to be detected.
	//
	// Continuing the CT example, for a CT mirror personality (which must allow
	// dupes since the source log could contain them), the part of the
	// personality which fetches and submits the entries might set
	// `leaf_identity_hash` to `H(leaf_index||cert)`.
	//
	// TODO(pavelkalinnikov): Consider instead using `H(cert)` and allowing
	// identity hash dupes in `PREORDERED_LOG` mode, for it can later be
	// upgraded to `LOG` which will need to correctly detect duplicates with
	// older entries when new ones get queued.
	LeafIdentityHash []byte `protobuf:"bytes,5,opt,name=leaf_identity_hash,json=leafIdentityHash,proto3" json:"leaf_identity_hash,omitempty"`
	// queue_timestamp holds the time at which this leaf was queued for
	// inclusion in the Log, or zero if the entry was submitted without
	// queuing. Clients should not set this field on submissions.
	QueueTimestamp *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=queue_timestamp,json=queueTimestamp,proto3" json:"queue_timestamp,omitempty"`
	// integrate_timestamp holds the time at which this leaf was integrated into
	// the tree.  Clients should not set this field on submissions.
	IntegrateTimestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=integrate_timestamp,json=integrateTimestamp,proto3" json:"integrate_timestamp,omitempty"`
}

func (x *LogLeaf) Reset() {
	*x = LogLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeaf) ProtoMessage() {}

func (x *LogLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeaf.ProtoReflect.Descriptor instead.
func (*LogLeaf) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{20}
}

func (x *LogLeaf) GetMerkleLeafHash() []byte {
	if x != nil {
		return x.MerkleLeafHash
	}
	return nil
}

func (x *LogLeaf) GetLeafValue() []byte {
	if x != nil {
		return x.LeafValue
	}
	return nil
}

func (x *LogLeaf) GetExtraData() []byte {
	if x != nil {
		return x.ExtraData
	}
	return nil
}

func (x *LogLeaf) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *LogLeaf) GetLeafIdentityHash() []byte {
	if x != nil {
		return x.LeafIdentityHash
	}
	return nil
}

func (x *LogLeaf) GetQueueTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.QueueTimestamp
	}
	return nil
}

func (x *LogLeaf) GetIntegrateTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.IntegrateTimestamp
	}
	return nil
}

var File_trillian_log_api_proto protoreflect.FileDescriptor

var file_trillian_log_api_proto_rawDesc = []byte{
	0x0a, 0x16, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1e, 0x0a, 0x08,
	0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22, 0x81, 0x01, 0x0a,
	0x10, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12,
	0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68,
	0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f,
	0x22, 0x4d, 0x0a, 0x11, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f,
	0x6c, 0x65, 0x61, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c,
	0x65, 0x61, 0x66, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x22,
	0x9e, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06,
	0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f,
	0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68,
	0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f,
	0x22, 0x83, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05,
	0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f,
	0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0xce, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61,
	0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x6c, 0x65, 0x61, 0x66, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1b, 0x0a,
	0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x53, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x89, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48,
	0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x70,
	0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05, 0x70, 0x72, 0x6f,
	0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67,
	0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52,
	0x6f, 0x6f, 0x74, 0x22, 0xb6, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x74, 0x72, 0x65, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x54, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65,
	0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x85, 0x01, 0x0a,
	0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x05,
	0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05, 0x70, 0x72,
	0x6f, 0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f,
	0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x52, 0x6f, 0x6f, 0x74, 0x22, 0x8f, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x2f, 0x0a,
	0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72,
	0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x12, 0x26,
	0x0a, 0x0f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x54, 0x72,
	0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x72,
	0x6f, 0x6f, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f,
	0x66, 0x22, 0x9d, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e,
	0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a,
	0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c,
	0x6f, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54,
	0x6f, 0x22, 0xa9, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e,
	0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05,
	0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c,
	0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x3f, 0x0a, 0x0f,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x58, 0x0a,
	0x0e, 0x49, 0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x44, 0x0a, 0x0f, 0x49, 0x6e, 0x69, 0x74, 0x4c,
	0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x22, 0x8e, 0x01,
	0x0a, 0x19, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c,
	0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67,
	0x49, 0x64, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x2f, 0x0a,
	0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72,
	0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x4f,
	0x0a, 0x1a, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22,
	0x98, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c,
	0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67,
	0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f,
	0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x86, 0x01, 0x0a, 0x18, 0x47,
	0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67,
	0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52,
	0x6f, 0x6f, 0x74, 0x22, 0x62, 0x0a, 0x0d, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x4c, 0x65, 0x61, 0x66, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x2a, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xd0, 0x02, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x4c,
	0x65, 0x61, 0x66, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x65, 0x72, 0x6b, 0x6c, 0x65, 0x5f, 0x6c, 0x65,
	0x61, 0x66, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x6d,
	0x65, 0x72, 0x6b, 0x6c, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1d, 0x0a,
	0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x65, 0x78, 0x74, 0x72, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x6c,
	0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x65,
	0x61, 0x66, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x43, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4b, 0x0a,
	0x13, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x32, 0xdb, 0x06, 0x0a, 0x0b, 0x54,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x4c, 0x6f, 0x67, 0x12, 0x46, 0x0a, 0x09, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x1a, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x5e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x70, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x28, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x64, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x24, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x25, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6d, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x52, 0x6f, 0x6f, 0x74, 0x12, 0x27, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5b, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x21, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x07, 0x49, 0x6e, 0x69, 0x74, 0x4c, 0x6f,
	0x67, 0x12, 0x18, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x49, 0x6e, 0x69,
	0x74, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x61, 0x0a, 0x12, 0x41, 0x64, 0x64, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x23,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x41,
	0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5b, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x21, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x4e, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x13, 0x54, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x4c,
	0x6f, 0x67, 0x41, 0x70, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x1a, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_trillian_log_api_proto_rawDescOnce sync.Once
	file_trillian_log_api_proto_rawDescData = file_trillian_log_api_proto_rawDesc
)

func file_trillian_log_api_proto_rawDescGZIP() []byte {
	file_trillian_log_api_proto_rawDescOnce.Do(func() {
		file_trillian_log_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_trillian_log_api_proto_rawDescData)
	})
	return file_trillian_log_api_proto_rawDescData
}

var file_trillian_log_api_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_trillian_log_api_proto_goTypes = []any{
	(*ChargeTo)(nil),                        // 0: trillian.ChargeTo
	(*QueueLeafRequest)(nil),                // 1: trillian.QueueLeafRequest
	(*QueueLeafResponse)(nil),               // 2: trillian.QueueLeafResponse
	(*GetInclusionProofRequest)(nil),        // 3: trillian.GetInclusionProofRequest
	(*GetInclusionProofResponse)(nil),       // 4: trillian.GetInclusionProofResponse
	(*GetInclusionProofByHashRequest)(nil),  // 5: trillian.GetInclusionProofByHashRequest
	(*GetInclusionProofByHashResponse)(nil), // 6: trillian.GetInclusionProofByHashResponse
	(*GetConsistencyProofRequest)(nil),      // 7: trillian.GetConsistencyProofRequest
	(*GetConsistencyProofResponse)(nil),     // 8: trillian.GetConsistencyProofResponse
	(*GetLatestSignedLogRootRequest)(nil),   // 9: trillian.GetLatestSignedLogRootRequest
	(*GetLatestSignedLogRootResponse)(nil),  // 10: trillian.GetLatestSignedLogRootResponse
	(*GetEntryAndProofRequest)(nil),         // 11: trillian.GetEntryAndProofRequest
	(*GetEntryAndProofResponse)(nil),        // 12: trillian.GetEntryAndProofResponse
	(*InitLogRequest)(nil),                  // 13: trillian.InitLogRequest
	(*InitLogResponse)(nil),                 // 14: trillian.InitLogResponse
	(*AddSequencedLeavesRequest)(nil),       // 15: trillian.AddSequencedLeavesRequest
	(*AddSequencedLeavesResponse)(nil),      // 16: trillian.AddSequencedLeavesResponse
	(*GetLeavesByRangeRequest)(nil),         // 17: trillian.GetLeavesByRangeRequest
	(*GetLeavesByRangeResponse)(nil),        // 18: trillian.GetLeavesByRangeResponse
	(*QueuedLogLeaf)(nil),                   // 19: trillian.QueuedLogLeaf
	(*LogLeaf)(nil),                         // 20: trillian.LogLeaf
	(*Proof)(nil),                           // 21: trillian.Proof
	(*SignedLogRoot)(nil),                   // 22: trillian.SignedLogRoot
	(*status.Status)(nil),                   // 23: google.rpc.Status
	(*timestamppb.Timestamp)(nil),           // 24: google.protobuf.Timestamp
}
var file_trillian_log_api_proto_depIdxs = []int32{
	20, // 0: trillian.QueueLeafRequest.leaf:type_name -> trillian.LogLeaf
	0,  // 1: trillian.QueueLeafRequest.charge_to:type_name -> trillian.ChargeTo
	19, // 2: trillian.QueueLeafResponse.queued_leaf:type_name -> trillian.QueuedLogLeaf
	0,  // 3: trillian.GetInclusionProofRequest.charge_to:type_name -> trillian.ChargeTo
	21, // 4: trillian.GetInclusionProofResponse.proof:type_name -> trillian.Proof
	22, // 5: trillian.GetInclusionProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 6: trillian.GetInclusionProofByHashRequest.charge_to:type_name -> trillian.ChargeTo
	21, // 7: trillian.GetInclusionProofByHashResponse.proof:type_name -> trillian.Proof
	22, // 8: trillian.GetInclusionProofByHashResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 9: trillian.GetConsistencyProofRequest.charge_to:type_name -> trillian.ChargeTo
	21, // 10: trillian.GetConsistencyProofResponse.proof:type_name -> trillian.Proof
	22, // 11: trillian.GetConsistencyProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 12: trillian.GetLatestSignedLogRootRequest.charge_to:type_name -> trillian.ChargeTo
	22, // 13: trillian.GetLatestSignedLogRootResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	21, // 14: trillian.GetLatestSignedLogRootResponse.proof:type_name -> trillian.Proof
	0,  // 15: trillian.GetEntryAndProofRequest.charge_to:type_name -> trillian.ChargeTo
	21, // 16: trillian.GetEntryAndProofResponse.proof:type_name -> trillian.Proof
	20, // 17: trillian.GetEntryAndProofResponse.leaf:type_name -> trillian.LogLeaf
	22, // 18: trillian.GetEntryAndProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 19: trillian.InitLogRequest.charge_to:type_name -> trillian.ChargeTo
	22, // 20: trillian.InitLogResponse.created:type_name -> trillian.SignedLogRoot
	20, // 21: trillian.AddSequencedLeavesRequest.leaves:type_name -> trillian.LogLeaf
	0,  // 22: trillian.AddSequencedLeavesRequest.charge_to:type_name -> trillian.ChargeTo
	19, // 23: trillian.AddSequencedLeavesResponse.results:type_name -> trillian.QueuedLogLeaf
	0,  // 24: trillian.GetLeavesByRangeRequest.charge_to:type_name -> trillian.ChargeTo
	20, // 25: trillian.GetLeavesByRangeResponse.leaves:type_name -> trillian.LogLeaf
	22, // 26: trillian.GetLeavesByRangeResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	20, // 27: trillian.QueuedLogLeaf.leaf:type_name -> trillian.LogLeaf
	23, // 28: trillian.QueuedLogLeaf.status:type_name -> google.rpc.Status
	24, // 29: trillian.LogLeaf.queue_timestamp:type_name -> google.protobuf.Timestamp
	24, // 30: trillian.LogLeaf.integrate_timestamp:type_name -> google.protobuf.Timestamp
	1,  // 31: trillian.TrillianLog.QueueLeaf:input_type -> trillian.QueueLeafRequest
	3,  // 32: trillian.TrillianLog.GetInclusionProof:input_type -> trillian.GetInclusionProofRequest
	5,  // 33: trillian.TrillianLog.GetInclusionProofByHash:input_type -> trillian.GetInclusionProofByHashRequest
	7,  // 34: trillian.TrillianLog.GetConsistencyProof:input_type -> trillian.GetConsistencyProofRequest
	9,  // 35: trillian.TrillianLog.GetLatestSignedLogRoot:input_type -> trillian.GetLatestSignedLogRootRequest
	11, // 36: trillian.TrillianLog.GetEntryAndProof:input_type -> trillian.GetEntryAndProofRequest
	13, // 37: trillian.TrillianLog.InitLog:input_type -> trillian.InitLogRequest
	15, // 38: trillian.TrillianLog.AddSequencedLeaves:input_type -> trillian.AddSequencedLeavesRequest
	17, // 39: trillian.TrillianLog.GetLeavesByRange:input_type -> trillian.GetLeavesByRangeRequest
	2,  // 40: trillian.TrillianLog.QueueLeaf:output_type -> trillian.QueueLeafResponse
	4,  // 41: trillian.TrillianLog.GetInclusionProof:output_type -> trillian.GetInclusionProofResponse
	6,  // 42: trillian.TrillianLog.GetInclusionProofByHash:output_type -> trillian.GetInclusionProofByHashResponse
	8,  // 43: trillian.TrillianLog.GetConsistencyProof:output_type -> trillian.GetConsistencyProofResponse
	10, // 44: trillian.TrillianLog.GetLatestSignedLogRoot:output_type -> trillian.GetLatestSignedLogRootResponse
	12, // 45: trillian.TrillianLog.GetEntryAndProof:output_type -> trillian.GetEntryAndProofResponse
	14, // 46: trillian.TrillianLog.InitLog:output_type -> trillian.InitLogResponse
	16, // 47: trillian.TrillianLog.AddSequencedLeaves:output_type -> trillian.AddSequencedLeavesResponse
	18, // 48: trillian.TrillianLog.GetLeavesByRange:output_type -> trillian.GetLeavesByRangeResponse
	40, // [40:49] is the sub-list for method output_type
	31, // [31:40] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_trillian_log_api_proto_init() }
func file_trillian_log_api_proto_init() {
	if File_trillian_log_api_proto != nil {
		return
	}
	file_trillian_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_trillian_log_api_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ChargeTo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*QueueLeafRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*QueueLeafResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GetInclusionProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*GetInclusionProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*GetInclusionProofByHashRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GetInclusionProofByHashResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*GetConsistencyProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*GetConsistencyProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*GetLatestSignedLogRootRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*GetLatestSignedLogRootResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*GetEntryAndProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*GetEntryAndProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*InitLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*InitLogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*AddSequencedLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*AddSequencedLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*GetLeavesByRangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*GetLeavesByRangeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*QueuedLogLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*LogLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_trillian_log_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_trillian_log_api_proto_goTypes,
		DependencyIndexes: file_trillian_log_api_proto_depIdxs,
		MessageInfos:      file_trillian_log_api_proto_msgTypes,
	}.Build()
	File_trillian_log_api_proto = out.File
	file_trillian_log_api_proto_rawDesc = nil
	file_trillian_log_api_proto_goTypes = nil
	file_trillian_log_api_proto_depIdxs = nil
}
