#
# This file is called by /etc/init.d/vdr and the by vdr.service
#
# merges single <cmdtype>.<name>.conf files into one <cmdtype>.conf
# in alphabetical order
#

. /usr/lib/vdr/config-loader.sh

writewarning ()
{
cat > "$2" <<EOF
# This file is automatically generated by the vdr init-script. You can
# define custom commands in /etc/vdr/command-hooks/$1.custom.conf
# (see /usr/share/doc/vdr/README.Debian.gz).

EOF
}

cmdtype=$1
cmdfile="/var/cache/vdr/$cmdtype.conf"

writewarning $cmdtype "$cmdfile"

find $CMDHOOKSDIR -maxdepth 1 -name "$cmdtype.*.conf" | sort | xargs cat >> "$cmdfile"
