#!/usr/bin/env bash

#This is free and unencumbered software released into the public domain.
#Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.
#In jurisdictions that recognize copyright laws, the author or authors of this software dedicate any and all copyright interest in the software to the public domain. We make this dedication for the benefit of the public at large and to the detriment of our heirs and successors. We intend this dedication to be an overt act of relinquishment in perpetuity of all present and future rights to this software under copyright law.
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#For more information, please refer to <https://unlicense.org/>

echo "There is a long-ignored bug in CLang. https://bugs.llvm.org/show_bug.cgi?id=44594 . Have to work around."
HardeningClangWorkaroundLinker_qDhJsKjQn=$(cat HardeningClangWorkaroundLinker_qDhJsKjQn.txt);

$(
	echo $HardeningClangWorkaroundLinker_qDhJsKjQn
	i=0
	for el in $@; do
		if [ -e "$el" ]; then
			fn=$(basename $el);
			ext=${fn##*.}
			dn=$(dirname $el);
			if [[ $dn == *"/lib/gcc/"* ]]; then
				if [ "$ext" = "o" ]; then
					bn="${fn%.*}";
					newFulN="$dn/${bn}S.o";
					if [ -e "$newFulN" ]; then
						el=$newFulN;
					fi;
				fi;
			fi;
		fi;
		echo $el;
	done;
) | xargs
